/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "TaskBarBalloonMesh.h"
#include <wx/msgdlg.h>
#include "ENMApp.h"
#include "CustomStaticText.h"

const long TaskBarBalloonMesh::ID_STATICTEXT_SUCCTIP = wxNewId();
const long TaskBarBalloonMesh::ID_STATICTEXT_TYPETIP = wxNewId();
const long TaskBarBalloonMesh::ID_STATICTEXT_TYPE = wxNewId();
const long TaskBarBalloonMesh::ID_STATICTEXT_SPEEDTIP = wxNewId();
const long TaskBarBalloonMesh::ID_STATICTEXT_SPEED = wxNewId();
const long TaskBarBalloonMesh::ID_STATICTEXT_STATUSTIP = wxNewId();
const long TaskBarBalloonMesh::ID_STATICTEXT_STATUS = wxNewId();
const long TaskBarBalloonMesh::ID_STATICTEXT_SIGNALQUALITYTIP = wxNewId();
const long TaskBarBalloonMesh::ID_STATICBITMAP_SIGNALQUALITY = wxNewId();
const long TaskBarBalloonMesh::ID_STATICTEXT_SIGNALQUALITY = wxNewId();
const int WIDTH = 270;
const int HEIGHT = 140;

BEGIN_EVENT_TABLE(TaskBarBalloonMesh, wxBitmapDialog)
END_EVENT_TABLE()


TaskBarBalloonMesh::TaskBarBalloonMesh(wxBitmapDialog *dlg, const wxString &title)
    : wxBitmapDialog(wxBitmap(::wxGetApp().strAppPath + _T("pic/balloon_LAN.png"),wxBITMAP_TYPE_PNG),(wxWindow*)dlg, (wxWindowID)wxID_ANY, wxEmptyString)
{
    m_SuccTip = new CustomStaticText(this, ID_STATICTEXT_SUCCTIP, _T(""), wxPoint(35,18), wxSize(200,14), 0, _T("ID_STATICTEXT_SUCCTIP"));
	m_SuccTip->SetForegroundColour(wxColor(0, 0, 255));
	wxFont StaticText1Font(11, wxSWISS, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("Arial"), wxFONTENCODING_DEFAULT);
	m_SuccTip->SetFont(StaticText1Font);
	m_TypeTip = new CustomStaticText(this, ID_STATICTEXT_TYPETIP, _("Type:"), wxPoint(35,72), wxSize(90,14), 0, _T("ID_STATICTEXT_TYPETIP"));
	m_Type = new CustomStaticText(this, ID_STATICTEXT_TYPE, _T(""), wxPoint(150,72), wxSize(96,14), 0, _T("ID_STATICTEXT_TYPE"));
	m_NameTip = new CustomStaticText(this, ID_STATICTEXT_SPEEDTIP, _("Name:"), wxPoint(35,48), wxSize(90,14), 0, _T("ID_STATICTEXT_SPEEDTIP"));
	m_Name = new CustomStaticText(this, ID_STATICTEXT_SPEED, _T(""), wxPoint(150,48), wxSize(88,14), 0, _T("ID_STATICTEXT_SPEED"));
	m_StatusTip = new CustomStaticText(this, ID_STATICTEXT_STATUSTIP, _("Status:"), wxPoint(35,96), wxSize(90,14), 0, _T("ID_STATICTEXT_STATUSTIP"));
	m_Status = new CustomStaticText(this, ID_STATICTEXT_STATUS, _T(""), wxPoint(150,96), wxSize(88,14), 0, _T("ID_STATICTEXT_STATUS"));

	this->Center();

    const int miniLap = 15;
    wxRect clientRect = ::wxGetClientDisplayRect();
    wxPoint finalPos = wxPoint(clientRect.width - WIDTH - miniLap + clientRect.x, miniLap + clientRect.y);
    this->Move(finalPos);
}



void TaskBarBalloonMesh::OnPaint(wxPaintEvent& event)
{
    wxPaintDC dc(this);

    int iWidth = 0, iHeight = 0;
    this->GetClientSize( &iWidth, &iHeight );

    wxPen pen(this->GetForegroundColour());
    dc.SetPen(pen);

    wxBrush brush(this->GetBackgroundColour());
    dc.SetBrush(brush);

    dc.Clear();
    dc.DrawRectangle(0,0,iWidth,iHeight);
}

/** showing frame and running timer */
void TaskBarBalloonMesh::showBalloon()
{
    this->Show(false);
    this->Show(true);
    //this->timer->Start(iTimeout,wxTIMER_ONE_SHOT);
}

void TaskBarBalloonMesh::OnClick(wxMouseEvent&)
{
}

void TaskBarBalloonMesh::SetConnectionTip(wxString wxsSuccTip)
{
    m_SuccTip->SetLabel(wxsSuccTip);
}

void TaskBarBalloonMesh::SetConnectionType(wxString wxsType)
{
    m_Type->SetLabel(wxsType);
}

void TaskBarBalloonMesh::SetConnectionName(wxString wxsName)
{
    m_Name->SetLabel(wxsName);
}

void TaskBarBalloonMesh::SetConnectionStatus(wxString wxsStatus)
{
    m_Status->SetLabel(wxsStatus);
}

