/*
 * Enhanced Easy Network
 * Copyright (c) <2008>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "SchoolSettingImporter.h"
#include "FileTar.h"
#include <wx/filename.h>
#include <wx/dir.h>
#include <wx/msgdlg.h>
#include <wx/timer.h>

#include <sdk/ENMApi.h>
#include <ENMDef.h>
#include "ProfileVersion.h"
#include "ENMUtil.h"
#include "verify.h"

static wxString dcLogimporter(_T("/tmp/SchoolSettingImporter.log"));
const wxString SchoolSettingImporter::destDir = _T("/etc/Network Neighborhood");
const wxString SYSTEM_PROFOLE_DIR = wxT("/etc/Network Neighborhood/");
const wxString USER_PROFILE_DIR = ENMUtil::GetCurrentUserAppDataFolder() + _T("/Network Neighborhood/");

BEGIN_EVENT_TABLE(SchoolSettingImporter, wxEvtHandler)
END_EVENT_TABLE()

SchoolSettingImporter::SchoolSettingImporter()
        : wxEvtHandler(), m_iCount(::wxGetUTCTime())
{
    m_strTempDir = wxFileName::GetTempDir() + wxFileName::GetPathSeparator() + _T("enm");
    wxFileName::Mkdir(m_strTempDir, 0755, wxPATH_MKDIR_FULL);
}

SchoolSettingImporter::~SchoolSettingImporter()
{
    ClearTempDir(m_strTempDir);
}

void SchoolSettingImporter::ClearTempDir(const wxString& dir)
{
    if ( !wxFileName::DirExists(dir) )
        return;

    // remove all files
    wxArrayString as;
    size_t nCount = wxDir::GetAllFiles(dir, &as, wxEmptyString, wxDIR_FILES | wxDIR_HIDDEN);
    if ( nCount != (size_t)-1 )
    {
        for ( size_t i = 0; i < nCount; i++ )
        {
            ::wxRemoveFile(as.Item(i));
        }
    }

    // remove all subdirectories
    wxDir tempDir(dir);
    wxString subDir;
    bool found = tempDir.GetFirst(&subDir, wxEmptyString, wxDIR_DIRS);
    while ( found )
    {
        ClearTempDir(dir + wxFileName::GetPathSeparator() + subDir);
        found = tempDir.GetNext(&subDir);
    }

    // remove this directory
    wxFileName::Rmdir(dir);
}

int SchoolSettingImporter::ConfirmOverwrite(const wxString& strFileName)
{
    wxString suffix(_T(".profile"));
    if ( strFileName.Find(suffix) + suffix.Length() != strFileName.Length() )
        return wxID_YES;

    wxString message = strFileName + _(" already exists. \n\nAre you sure you want to overwrite it?");
    wxMessageDialog dlg(NULL, message, wxEmptyString, wxYES_NO | wxNO_DEFAULT | wxICON_EXCLAMATION);
    return dlg.ShowModal();
}

int SchoolSettingImporter::ImportSchoolSetting(const wxString& strTarFile, wxArrayString* pasFailed)
{
    int result = 1;
    // depress the tar file to a temp directory
    wxString strImportDir = m_strTempDir + wxFileName::GetPathSeparator() + wxString::Format(_T("%d"), m_iCount++);
    wxString strDirWithSep = strImportDir + wxFileName::GetPathSeparator();
    wxFileName::Mkdir(strImportDir, 0755, wxPATH_MKDIR_FULL);
    if ( FileTar::UnTar(strTarFile, strDirWithSep) == 0 )
    {
        if(!CheckServerCertification(strImportDir))
            return CAERROR;
        //remove profiles deployed before
        ProfileVersion profileversion;
        wxArrayString VersionInfo;
        profileversion.GetProfileVersion(VersionInfo);
        for ( size_t i = 2; i < VersionInfo.GetCount(); i++ )
        {
            wxString fileName = VersionInfo.Item(i);
            wxString filePath;
            filePath = SYSTEM_PROFOLE_DIR;
            filePath += fileName;

            ENM_StringW sFile;
            memset(&sFile, 0, sizeof(ENM_StringW));
            wcscpy((wchar_t*)sFile.dcsStringW, filePath.c_str());
            DCS_DeleteProfile(&sFile);
        }
        result = 0;
        // copy files from temp directory to the directory of global profiles
        wxArrayString as;
        wxDir::GetAllFiles(strImportDir, &as, wxEmptyString, wxDIR_FILES);
        for ( size_t i = 0; i < as.Count(); i++ )
        {
            wxString name, ext;
            wxFileName::SplitPath(as.Item(i), NULL, NULL, &name, &ext);
            wxString file = name + _T(".") + ext;
            if ( !wxFileName::FileExists(destDir + wxFileName::GetPathSeparator() + file) || ConfirmOverwrite(file) == wxID_YES )
            {
                ENM_StringW srcFile;
                memset(&srcFile, 0, sizeof(ENM_StringW));
                wcscpy((wchar_t*)srcFile.dcsStringW, as.Item(i).c_str());
                DCS_Return_Code dcsRet = DCS_ImportSchoolSettings(&srcFile);
                if ( dcsRet != DCS_SUCCESS )
                {
                    result = 1;
                    if ( pasFailed != NULL )
                        pasFailed->Add(file);
                }
            }
        }
    }
    ClearTempDir(strImportDir);
    return result;
}
bool SchoolSettingImporter::LoadSchoolSetting(const wxString& strTarFile, wxArrayString* pasFailed)
{
    bool result = false;
    // depress the tar file to a temp directory
    wxString strImportDir = m_strTempDir + wxFileName::GetPathSeparator() + wxString::Format(_T("%d"), m_iCount++);
    wxString strDirWithSep = strImportDir + wxFileName::GetPathSeparator();
    wxFileName::Mkdir(strImportDir, 0755, wxPATH_MKDIR_FULL);

    printf("LoadSchoolSetting\n");
    if ( FileTar::UnTar(strTarFile, strDirWithSep) == 0 )
    {
        if(!CheckServerCertification(strImportDir))
            return true;
        //remove profiles deployed before
        ProfileVersion profileversion;
        wxArrayString VersionInfo;
        profileversion.GetProfileVersion(VersionInfo);
        for ( size_t i = 2; i < VersionInfo.GetCount(); i++ )
        {
            wxString fileName = VersionInfo.Item(i);
            wxString filePath;
            filePath = SYSTEM_PROFOLE_DIR;
            filePath += fileName;

            ENM_StringW sFile;
            memset(&sFile, 0, sizeof(ENM_StringW));
            wcscpy((wchar_t*)sFile.dcsStringW, filePath.c_str());
            DCS_DeleteProfile(&sFile);
        }
        result = true;
        // copy files from temp directory to the directory of global profiles
        wxArrayString as;
        wxDir::GetAllFiles(strImportDir, &as, wxEmptyString, wxDIR_FILES);
        for ( size_t i = 0; i < as.Count(); i++ )
        {
            wxString name, ext;
            wxFileName::SplitPath(as.Item(i), NULL, NULL, &name, &ext);
            wxString file = name + _T(".") + ext;

                ENM_StringW srcFile;
                memset(&srcFile, 0, sizeof(ENM_StringW));
                wcscpy((wchar_t*)srcFile.dcsStringW, as.Item(i).c_str());

                DCS_Return_Code dcsRet = DCS_ImportSchoolSettings(&srcFile);
                if ( dcsRet != DCS_SUCCESS )
                {
                    result = false;
                    if ( pasFailed != NULL )
                        pasFailed->Add(file);
                }

        }
    }
    printf("FileTar::UnTar\n");
    ClearTempDir(strImportDir);
    wxString strImportSchoolSettings = wxFileName::GetTempDir() + wxFileName::GetPathSeparator() + wxT("SchoolSettings.tar");
    ::wxRemoveFile(strImportSchoolSettings);
    ENMUtil::Log(dcLogimporter, strImportSchoolSettings);
    return result;
}

bool SchoolSettingImporter::CheckServerCertification(wxString strImportDir)
{
    printf("enter CheckServerCertification\n");
    bool bTrust = true;
    wxString strCAPath = ENMUtil::m_appPath + wxT("cacert.pem");
    wxString strServerCertPath = strImportDir + wxFileName::GetPathSeparator() + wxT("sslservercert.pem");
    string szCACert,szServerCert;
    szCACert = ENMUtil::WxStringToString(strCAPath);
    szServerCert = ENMUtil::WxStringToString(strServerCertPath);
    char* p_cCacert;
    char* p_cServercert;
    try
    {
        p_cCacert = new char[szCACert.size() + 1];
        p_cServercert = new char[szServerCert.size() + 1];
    }
    catch (...)
    {
        printf("[SchoolSettingImporter]catch failed \n");
        bTrust = false;
    }
//    printf("try catch\n");
    memset(p_cCacert, 0, szCACert.size() + 1);
    memset(p_cServercert, 0, szServerCert.size() + 1);
    memcpy(p_cCacert, szCACert.c_str(), szCACert.size());
    memcpy(p_cServercert, szServerCert.c_str(), szServerCert.size());
//    printf("memset\n");
    char arrVerify[7] =
    { 'v', 'e', 'r', 'i', 'f', 'y', '\0' };
    char CAfile[8] =
    { '-', 'C', 'A', 'f', 'i', 'l', 'e', '\0' };
    const int iacArg1=4;
    char* acArg1[iacArg1] = { arrVerify, CAfile, p_cCacert, p_cServercert };
//    printf("char* acArg1[iacArg1]\n");
//    ENMUtil::Log(dcLogimporter, _T("0 == MyVerify(iacArg1, acArg1)"));
    int nResult = MyVerify(iacArg1, acArg1);
    printf("SchoolSettingImporter] cert verify result %d", nResult);
//    ENMUtil::Log(dcLogimporter, wxString::Format(_T("strCAPath = %d"),nResult));
    if (0 == nResult)
    {
        //iReturn = SES_API_FAILURE;
        ENMUtil::Log(dcLogimporter, _T("bTrust = false"));

        printf("[SchoolSettingImporter]verify failed \n");
        bTrust = false;
    }
    ENMUtil::Log(dcLogimporter, _T("bTrust = true"));
    delete p_cCacert;
    delete p_cServercert;
    printf("delete p_cServercert;\n");

    return bTrust;
}
