/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef __READHANDLER_H__
#define __READHANDLER_H__

#include <ace/Event_Handler.h>
#include <ace/SOCK_Stream.h>


#include <ace/SOCK_Stream.h>
#include <ace/SSL/SSL_SOCK_Connector.h>
/**
 * This read handler is created by the accept handler and handles all the data
 * exchange between client and server. The client makes two requests to the
 * server. The first asks the server to create a buffer which will hold the
 * data sent in the second call.
 */
class ReadHandler : public ACE_Event_Handler {

    private:

        /**
         * The stream socket used for data exchange.
         */
        ACE_SOCK_Stream mStream;
		//ACE_SSL_SOCK_STREAM mStream;

        /**
         * The size of the data array.
         */
        int mDataSize;

        /**
         * The array containing the client's data.
         */
        char *mData;

        /**
         * The call counter to distinguish between first and second call.
         */
        int mCallCounter;

        /**
         * Count the numer of invocations of handle_*(). According to the
         * docs, there should be only one invocation at any given time.
         */
        int mInvocationCounter;

		FILE * fw;

    public:

        /**
         * Initialization.
         */
        ReadHandler(void);

        /**
         * Clean up data.
         */
        virtual ~ReadHandler();

        /**
         * Provide access to the internal stream socket.
         */
        //ACE_SSL_SOCK_STREAM &getStream(void);
        ACE_SOCK_STREAM &getStream(void);

        /**
         * @name Overridden methods from the ACE_Event_Handler
         */
        // @{

        /**
         * Provides the handle of mStream;
         */
        virtual ACE_HANDLE get_handle(void) const;

        /**
         * Handles the data excahnge between client and server. On the first
         * invocation, mData is allocated to the requested size and on the
         * second invocation, that buffer is filled with the client's data.
         */
        virtual int handle_input(ACE_HANDLE = ACE_INVALID_HANDLE);

        /**
         * Deletes this instance of the read handler.
         */
        virtual int handle_close(ACE_HANDLE, ACE_Reactor_Mask);
        // @}
};

#endif /* __READHANDLER_H__ */

