/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include <ace/streams.h>
#include <ace/Time_Value.h>

#include "common.h"
#include "ReadHandler.h"
#include <string>
#include <wx/file.h>
#include <wx/string.h>
#include <wx/filename.h>
#include "ENMApp.h"
#include "ENMUtil.h"
#include "NNClientSubject.h"
using namespace std;
/**
 * This macro is used to increase the invocation counter by one when entering
 * handle_input(). It also checks wether the counter is greater than zero
 * indicating, that handle_input() has been called before.
 */
#define INVOCATION_ENTER() do { if (mInvocationCounter > 0) \
        ACE_ERROR((LM_ERROR, ACE_TEXT("Multiple invocations detected.\n"))); \
        mInvocationCounter++; } while (0)

/**
 * THis macro is the counter part to INVOCATION_ENTER(). It decreases the
 * invocation counter and then returns the given value. This macro is
 * here for convenience to decrease the invocation counter also when returning
 * due to errors.
 */
#define INVOCATION_RETURN(retval) do { mInvocationCounter--; \
                                    return retval; } while(0)
static wxString dcLogFileReadHandle(_T("C:\\Readhandle.log"));

ReadHandler::ReadHandler() : ACE_Event_Handler(), mStream(), mDataSize(0),
        mData(0), mCallCounter(0), mInvocationCounter(0)
{
    ACE_TRACE(ACE_TEXT("ReadHandler::ReadHandler()"));
}

ReadHandler::~ReadHandler() {
    ACE_TRACE(ACE_TEXT("ReadHandler::~ReadHandler()"));

    if (mStream.close() == -1)
      ACE_ERROR((LM_ERROR, ACE_TEXT("%N:%l: Failed to close socket. ")
                 ACE_TEXT ("(errno = %i: %m)\n"), errno));

    delete[] mData;



}

ACE_SOCK_STREAM &ReadHandler::getStream(void) {

    ACE_TRACE(ACE_TEXT("ReadHandler::getStream(void)"));
    return mStream;
}

ACE_HANDLE ReadHandler::get_handle(void) const {
    ACE_TRACE(ACE_TEXT("ReadHandler::get_handle(void)"));
    return mStream.get_handle();
}

int ReadHandler::handle_input(ACE_HANDLE) {
	printf("5 \n");
    ACE_TRACE(ACE_TEXT("ReadHandler::handle_input(ACE_HANDLE)"));
	 //cout<<"ReadHandler::handle_input";

    INVOCATION_ENTER();

    // the response sent to the client
    char response = 0;
	long lResult = 0;
    if (mCallCounter == 0) {
		//printf("5-1 \n");
        /*
         * This is the first request from the client.
         */

        // increase the call counter so the next client request goes to else-if
        mCallCounter++;

        // get the desired size from the client
        // Note: only use the sizeof and pointer to int on compatible
        //       platforms (i.e. little-endian/big-endian, data type size)
		/*if (mStream.recv_n(&lResult, sizeof(lResult), iTimeout) != sizeof(lResult))
		{
			ACE_ERROR((LM_ERROR, ACE_TEXT("%N:%l: Failed to receive ")
                     ACE_TEXT ("lResult. (errno = %i: %m)\n"), errno));
            INVOCATION_RETURN(-1);
		}
		printf("lResult = %d\n",lResult);
		if (mStream.send_n(&response, sizeof(response), &connTimeout) != 1) {
          ACE_ERROR((LM_ERROR, ACE_TEXT("%N:%l: Failed to send ")
                     ACE_TEXT ("response. (errno = %i: %m)\n"), errno));
            INVOCATION_RETURN(-1);
        }*/
        if (mStream.recv_n(&mDataSize, sizeof(mDataSize),&connTimeout) != sizeof(mDataSize)) {
          ACE_ERROR((LM_ERROR, ACE_TEXT("%N:%l: Failed to receive ")
                     ACE_TEXT ("request. (errno = %i: %m)\n"), errno));
            INVOCATION_RETURN(-1);
        }

        // The verbose debug output is replaced with some unintrusive dots.
        // This increases visibility of the desired effect.
        // ACE_DEBUG((LM_DEBUG, ACE_TEXT("%@: Data size: %i\n"), this, mDataSize));
        ACE_DEBUG((LM_DEBUG, ACE_TEXT(".")));

        // check mDataSize for plausability then allocate memory
        if (mDataSize > 0) {
            mData = new (std::nothrow) char[mDataSize];
            if (mData == 0)
              ACE_DEBUG((LM_DEBUG, ACE_TEXT("%N:%l: Failed to allocate ")
                         ACE_TEXT ("data buffer.\n")));
            else
                response = 'K';
        }

        // send the response to the client (which is still 0, if the
        // allocation did not succeed)
        if (mStream.send_n(&response, sizeof(response),&connTimeout) != 1) {
          ACE_ERROR((LM_ERROR, ACE_TEXT("%N:%l: Failed to send ")
                     ACE_TEXT ("response. (errno = %i: %m)\n"), errno));
            INVOCATION_RETURN(-1);
        }

        if (response == 'K')
            INVOCATION_RETURN(0); // get another request from the same client
        else
            INVOCATION_RETURN(-1); // the client will not send data if response != 'K'

    } else if (mCallCounter == 1) {

        /*
         * This is the second request from the client.
         */
		//printf("5-2 \n");
        // increase the call counter, this read handler should not be called
        // again
        mCallCounter++;

        wxString wxfilepath;
        wxfilepath = ::wxGetApp().strAppPath + wxT("cacert.pem");
        bool CAfile = wxFile::Exists(wxfilepath);

        if (CAfile)
        {
            #if defined(__UNIX__)
            wxfilepath = wxT("/tmp/SchoolSettings.tar");
            #endif
        }
        if((!CAfile)&&(mDataSize>5000|| mDataSize<500))
        {
            //exception
            INVOCATION_RETURN(-1);
        }
        FILE *fw = fopen(wxfilepath.char_str(wxConvUTF8), "wb");

        if (NULL == fw)
        {
            mStream.close();
            INVOCATION_RETURN(-1);
        }
        // receive the data from the client
        if (mStream.recv_n(mData, mDataSize,&connTimeout) != mDataSize) {
          ACE_ERROR((LM_ERROR, ACE_TEXT("%N:%l: Failed to receive data.")
                     ACE_TEXT ("(errno = %i: %m)\n"), errno));
            INVOCATION_RETURN(-1);
        }

		fwrite(mData, 1, mDataSize, fw);

        response = 'K';

        if (mStream.send_n(&response, 1,&connTimeout) != 1) {
          ACE_ERROR((LM_ERROR, ACE_TEXT("%N:%l: Failed to send ")
                     ACE_TEXT ("confirmation. (errno = %i: %m)\n"), errno));
            INVOCATION_RETURN(-1);
        }
        fclose(fw);

        NNClientSubject::GetInstance()->Publish();

        INVOCATION_RETURN(-1); // ask for removal, since client does not send any more data
    }

    // this is to find strange actions with the call counter
    ACE_ERROR((LM_ERROR, ACE_TEXT("%N:%l: We should not get here.")));
    INVOCATION_RETURN(-1);
}

int ReadHandler::handle_close(ACE_HANDLE, ACE_Reactor_Mask) {
  ACE_TRACE("ReadHandler::handle_close(ACE_HANDLE, ACE_Reactor_Mask)");

  //cout<<"ReadHandler::handle_close";
    delete this;
    return 0;
}

