/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef _PROFILE_MANAGER_DIALOG_H_
#define _PROFILE_MANAGER_DIALOG_H_

#include <wx/listctrl.h>
#include <wx/menu.h>
#include <wx/button.h>
#include <wx/frame.h>
#include <wx/wizard.h>

#include "ProfileGeneralSettings.h"
#include "ProfileEditor.h"
#include "ProfileManagementControl.h"
#include "ProfileEditor.h"
#include "checkedlistctrl.h"
#include "ProfileEvent.h"

class ProfileManagerDlg : public wxFrame
{
    public:
    ProfileManagerDlg(wxWindow* parent, wxWindowID id = wxID_ANY);
        virtual ~ProfileManagerDlg();
        void SaveProfile();
        virtual bool Destroy();

        bool Show(bool ifShow = true);
        bool IsProfileExist(const wxString& strNewName, const wxString& strOldName = wxEmptyString) const;
        void InsertNewProfile(const ProfileList_t& profile);
        void RefreshProfile();
        void ModifyProfileVersionInfo();
    private:
        bool m_bIfAdmin;
        void drawListCtrl(long ID);
        void CheckButtonStatus(long ID);
        wxCheckedListCtrl* m_lcProfile;
    wxImageList m_imageList;

    void OnButtonUpClick(wxCommandEvent& event);
    void OnButtonDownClick(wxCommandEvent& event);
    void OnButtonNewClick(wxCommandEvent& event);
    void OnButtonEditClick(wxCommandEvent& event);
    void OnButtonDeleteClick(wxCommandEvent& event);
    void OnButtonCancelClick(wxCommandEvent& event);
    void OnButtonOKClick(wxCommandEvent& event);
    void OnCheckboxSelectClick(wxCommandEvent& event);
        void Onm_lcProfileDeselected(wxCommandEvent& event);
        void Onm_lcProfileSelected(wxCommandEvent& event);
        void Onm_miNewSelected(wxCommandEvent& event);
        void Onm_miEditSelected(wxCommandEvent& event);
        void Onm_miDeleteSelected(wxCommandEvent& event);
        void Onm_miImportSelected(wxCommandEvent& event);
        void Onm_miExportSelected(wxCommandEvent& event);
        void Onm_miExitSelected(wxCommandEvent& event);
        void OnCloseClicked(wxCloseEvent& event);
        void OnProfileChanged(ProfileEvent& event);
        bool ChangePriority(int firstPriority, int secondPriority);
        bool RemoveProfile(int priority);
        void ModifyCheckFlag(int pos,bool bCheck);
        int Confirm();
        int ConfirmOverwrite();
        bool Save();
        void OnDoubleClick(wxListEvent& event);
        void MenuHelpContent(wxCommandEvent& event);
        void CheckModifyStatus();
        void ModifyAdminCount();
        int IsGuestExist();
        int SearchProfileList(const vector<ProfileList_t> &ProfileList, const wxString& ProfileName);

        static const long ID_PROFILELISTCTRL;
        static const long ID_NEWBUTTON;
        static const long ID_EDITBUTTON;
        static const long ID_DELETEBUTTON;
        static const long ID_OKBUTTON;
        static const long ID_CANCLEBUTTON;
        static const long ID_UPBITMAPBUTTON;
        static const long ID_DOWNBITMAPBUTTON;
        static const long ID_PROFILEPANEL;
        static const long ID_IMPORT;
        static const long ID_EXPORT;
        static const long ID_EXIT;
        static const long ID_NEWPROFILE;
        static const long ID_EDITPROFILE;
        static const long ID_DELETEPROFILE;
        static const long ID_HELP;
        static const long ID_SELECTCHECKBOX;

        wxMenuBar* m_menuProfile;
        wxMenu* m_menuFile;
        wxMenuItem* m_miExport;
        wxMenuItem* m_miImport;
        wxMenuItem* m_miNew;
        wxMenuItem* m_miEdit;
        wxMenuItem* m_miDelete;
        wxMenuItem* m_miExit;
        wxMenu* m_menuHelp;
        wxMenuItem* m_miHelp;

        wxButton* m_buttonEdit;
        wxPanel* m_panelProfile;
        wxBitmapButton* m_bbDown;
        wxButton* m_buttonDelete;
        wxButton* m_buttonOK;
        wxButton* m_buttonCancel;
        wxCheckBox* m_checkboxSelect;

        wxButton* m_buttonNew;
        wxBitmapButton* m_bbUp;

        vector<ProfileList_t> m_vProfileList;
    vector<ProfileList_t> m_vCurrentUserProfileList;
        vector<ProfileList_t> m_vOldProfileList;

        bool m_isModified;
        int m_iAdminCount;
        bool m_isDeselected;
        wxCriticalSection m_critsectDrawlist;
        DECLARE_EVENT_TABLE()
};

#endif // _PROFILE_MANAGER_DIALOG_H_
