/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _PROFILE_GENERAL_SETTING_H_
#define _PROFILE_GENERAL_SETTING_H_

#include <wx/wizard.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/statline.h>
#include <wx/statbmp.h>
#include <wx/combobox.h>
#include <wx/bmpcbox.h>
#include "ProfileOtherSettings.h"
#include "ProfileWirelessSettings.h"
#include "Profile.h"
#include "ProfileManagementControl.h"

class ProfileGeneralSettings : public wxWizard
{
public:
    ProfileGeneralSettings(wxWindow* parent);
    virtual ~ProfileGeneralSettings();

    bool ShowWizard();
    wxWizardPage *GetFirstPage() const;
    ProfileList_t GetProfile() const;



protected:
    static const long ID_NAMETEXTCTRL;
    static const long ID_CONTYPECOMBOBOX;
    static const long ID_NAMECOMBOBOX;

private:
    static const wxString STR_WIZARD_NEXT;
    static const wxString STR_WIZARD_BACK;
    static const wxString STR_WIZARD_FINISH;
    wxStaticLine* m_lineSt1;
    wxComboBox* m_cbbConType;
    wxTextCtrl* m_tcName;
    wxStaticText* m_textDes1;
    wxStaticText* m_textGs;
    wxStaticText* m_textPn;
    wxCheckBox* m_checkboxDisable;
    wxStaticBitmap* m_sbPic;
    wxBitmapComboBox* m_cbbName;
    wxStaticText* m_textConType;
    ProfileWirelessSettings *m_pagestep2;
    ProfileOtherSettings *m_pagestep3;
    wxWizardPageSimple *m_pagestep1;

    ProfileList_t m_profileInfo;
    void OnProfileTypeSelected(wxCommandEvent& event);
    void OnWizardChanging(wxWizardEvent& event);
    void OnWizardFinished(wxWizardEvent& event);
    void OnWizardCancel(wxWizardEvent& event);

    DECLARE_EVENT_TABLE()
};

#endif // _PROFILE_GENERAL_SETTING_H_
