/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef POPUPDIALOG_H
#define POPUPDIALOG_H

#include <wx/stattext.h>
#include <wx/bmpbuttn.h>
#include <wx/statbmp.h>
#include <wx/dialog.h>
#include <wx/bitmap.h>
#include <wx/dcmemory.h>
#include <wx/timer.h>

class PopupDialog: public wxDialog
{
	public:

		PopupDialog(wxWindow* parent, const wxBitmap& bitmap, wxWindowID id=wxID_ANY);
		virtual ~PopupDialog();
		void SetTitle(wxString strTitle);
    void SetContent(const wxString& strContent);
		int ShowModal();
		void EndModal(int retCode);

	private:
		static const long ID_BTN_OK;
		static const long ID_BTN_CANCEL;
		static const long ID_TIMER_TICK;

    int m_stxWidth;

    wxBitmapButton* m_btnYes;
    wxBitmapButton* m_btnNo;

    wxBitmap m_bitmap;
    bool m_hasShape;
    wxBitmap m_bmpMute;
    wxBitmap m_bmpNormal;
    wxBitmap m_bmpOver;
    wxBitmap m_bmpDown;
    wxBitmap m_bmpDisable;

    wxStaticText* m_pTitle;
    wxStaticText* m_pContent;
    wxStaticText* m_stxYes;
    wxStaticText* m_stxNo;

    wxTimer m_Timer;

    void OnInit(wxInitDialogEvent& event);
    void OnButtonClick(wxCommandEvent& event);
    void SetWindowShape();
    void OnEraseBkgnd(wxEraseEvent&  event);
    void OnPaint(wxPaintEvent& event);
    void OnWindowCreate(wxWindowCreateEvent& evt);
    void ButtonState(const wxString& text, wxBitmap* pBitmap, wxBitmap* bg, wxMemoryDC* pDC);
    void RedrawBitmapBtn(const wxString& text, wxBitmapButton* pBitmapBtn, wxBitmap* pBitmap, wxMemoryDC* pDC);
    void OnTimerTick(wxTimerEvent & event);


		DECLARE_EVENT_TABLE()
};

#endif
