/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "MeshUseOthersInternetDlg.h"
#include "ENMApp.h"

#include <wx/bitmap.h>
#include <wx/intl.h>
#include <wx/image.h>
#include <wx/string.h>

#include "MeshInfoManager.h"
#include "ENMUtil.h"
#include <wx/wx.h>
#include "ipv4.h"

const long MeshUseOthersInternetDlg::ID_STATICTEXT1 = wxNewId();
const long MeshUseOthersInternetDlg::ID_LISTCTRL1 = wxNewId();
const long MeshUseOthersInternetDlg::ID_BUTTON_REFRESH = wxNewId();
const long MeshUseOthersInternetDlg::ID_BUTTON_OK = wxNewId();
const long MeshUseOthersInternetDlg::ID_BUTTON_CANCEL = wxNewId();
const long MeshUseOthersInternetDlg::ID_STATICBITMAP1 = wxNewId();

const long MeshUseOthersInternetDlg::ID_TIMER_SEARCH = wxNewId();
BEGIN_EVENT_TABLE(MeshUseOthersInternetDlg,wxDialog)
	//(*EventTable(MeshUseOthersInternetDlg)
	//*)
	EVT_TIMER(ID_TIMER_SEARCH, MeshUseOthersInternetDlg::OnTimer)
	EVT_CLOSE(MeshUseOthersInternetDlg::OnCloseClicked)
END_EVENT_TABLE()

wxCriticalSection MeshUseOthersInternetDlg::m_critsectUseOthers;

MeshUseOthersInternetDlg::MeshUseOthersInternetDlg(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
    wxString strImagePath = ::wxGetApp().strAppPath + _T("pic/MeshClient48.png");
	//(*Initialize(MeshUseOthersInternetDlg)
	Create(parent, id, _("Mesh Client Mode"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	SetClientSize(wxSize(450,330));
	Move(wxDefaultPosition);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Select one Internet Sharing Server to connect or click \"Refresh\" to re-scan Internet Sharing Server."), wxPoint(70,10), wxSize(368,40), 0, _T("ID_STATICTEXT1"));
	m_list = new wxListCtrl(this, ID_LISTCTRL1, wxPoint(15,56), wxSize(420,216), wxLC_REPORT, wxDefaultValidator, _T("ID_LISTCTRL1"));
	ButtonRefresh = new wxButton(this, ID_BUTTON_REFRESH, _("Refresh"), wxPoint(15,285), wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON_REFRESH"));
	ButtonOK = new wxButton(this, ID_BUTTON_OK, _("OK"), wxPoint(260,285), wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON_OK"));
	ButtonCancel = new wxButton(this, ID_BUTTON_CANCEL, _("Cancel"), wxPoint(352,285), wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON_CANCEL"));
	StaticBitmap1 = new wxStaticBitmap(this, ID_STATICBITMAP1, wxBitmap(wxImage(strImagePath)), wxPoint(15,10), wxDefaultSize, 0, _T("ID_STATICBITMAP1"));

	Connect(ID_BUTTON_REFRESH,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&MeshUseOthersInternetDlg::OnButtonRefreshClick);
	Connect(ID_BUTTON_OK,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&MeshUseOthersInternetDlg::OnButtonOKClick);
	Connect(ID_BUTTON_CANCEL,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&MeshUseOthersInternetDlg::OnButtonCancelClick);
	//*)
	wxListItem itemCol;
    itemCol.SetText(_("Hostname"));
    m_list->InsertColumn(0, itemCol);
    m_list->SetColumnWidth(0, 130);

    itemCol.SetText(_("Channel"));
    m_list->InsertColumn(1, itemCol);
    m_list->SetColumnWidth(1, 80);

    itemCol.SetText(_("Signal Strength"));
    m_list->InsertColumn(2, itemCol);
    m_list->SetColumnWidth(2, 130);

    itemCol.SetText(_("Status"));
    m_list->InsertColumn(3, itemCol);
    m_list->SetColumnWidth(3, 80);

    itemCol.SetAlign(wxLIST_FORMAT_CENTRE);

    wxIcon icon;
    wxBitmap bitmap(wxImage(::wxGetApp().strAppPath + _T("pic/MeshClient48.png")));
    icon.CopyFromBitmap(bitmap);
    SetIcon(icon);

    Center();
    m_pGaugeDialog = new GaugeDialog(this);
    m_searchTimer.SetOwner(this, ID_TIMER_SEARCH);
}

MeshUseOthersInternetDlg::~MeshUseOthersInternetDlg()
{
	//(*Destroy(MeshUseOthersInternetDlg)
	//*)
    m_pGaugeDialog->Destroy();
    m_pGaugeDialog = NULL;
}


bool MeshUseOthersInternetDlg::Show(bool ifShow)
{
    wxDialog::Show(ifShow);
    if ( ifShow )
    {
        m_list->DeleteAllItems();
        BeginSearch();
    }
    return true;
}
void MeshUseOthersInternetDlg::OnCloseClicked(wxCloseEvent& event)
{
    SetReturnCode(wxID_CANCEL);
    Show(false);
}

void MeshUseOthersInternetDlg::OnButtonRefreshClick(wxCommandEvent& event)
{
    m_list->DeleteAllItems();
    BeginSearch();
}
void MeshUseOthersInternetDlg::OnButtonOKClick(wxCommandEvent& event)
{
    //if resume from suspend, mesh0 will dispear
    if ( !MeshInfoManager::GetInstance()->MeshHaveOpen() )
    {
        wxMessageBox(_("There is no mesh interface, please try again"));
        Show(false);
        return;
    }

    long itemId = -1;
    if (m_list->GetItemCount() == 0)
    {
        wxMessageBox(_("No Mesh Server detected!"));
        return;
    }
    else
    {
        itemId = m_list->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
        if ( itemId < 0 )
        {
            wxMessageBox(_("Please select a Mesh Server."));
            return;

        }
        else
        {
            wxMessageDialog dlg(this, _("Do you want to be Mesh Client?"), _("Confirm"), wxYES_NO | wxYES_DEFAULT | wxICON_QUESTION);
            if (wxID_YES != dlg.ShowModal())
                return;
        }
    }

    // ifconfig eth down
    DCS_SetMeshChannelOFFSET(1);
    // ifconfig ra0 up
    DCS_SetMeshChannelOFFSET(4);
    // ifconfig ra0 down
    DCS_SetMeshChannelOFFSET(2);
     //change mesh hostname
    if ( MESHSTATUS_MESHSERVER==::wxGetApp().m_nMeshStatus )
    {
        MeshInfoManager::GetInstance()->SetHostNameToClient();
    }

    wxString strMeshIP = m_MeshServerInfoList[itemId].GetMeshIPAddress();
    printf("[MeshUseOthersInternetDlg]selected server ip: %s\n", ENMUtil::WxStringToString(strMeshIP).c_str());
    wxString strDNS = m_MeshServerInfoList[itemId].GetDNS();
    printf("[MeshUseOthersInternetDlg]selected server DNS: %s\n", ENMUtil::WxStringToString(strDNS).c_str());
    wxString strDNS_back = m_MeshServerInfoList[itemId].GetDNS_back();
    printf("[MeshUseOthersInternetDlg]selected server DNS2: %s\n", ENMUtil::WxStringToString(strDNS_back).c_str());

    wxString strHostName = m_MeshServerInfoList[itemId].GetHostName();
    printf("[MeshUseOthersInternetDlg]selected server HostName: %s", ENMUtil::WxStringToString(strHostName).c_str());

    DCS_SetMeshChannel(m_MeshServerInfoList[itemId].GetChannel());
    //Enable Mesh Client
    MESH_GATEWAY_INFO gatewayinfo;
    memset(&gatewayinfo, 0, sizeof(MESH_GATEWAY_INFO));
    strcpy((char *)gatewayinfo.IPAddr, (ENMUtil::WxStringToString(strMeshIP)).c_str());
    strcpy((char *)gatewayinfo.DNS1, (ENMUtil::WxStringToString(strDNS)).c_str());
    strcpy((char *)gatewayinfo.DNS2, (ENMUtil::WxStringToString(strDNS_back)).c_str());
    strcpy((char *)gatewayinfo.HostName, (ENMUtil::WxStringToString(strHostName)).c_str());

    DCS_EnableMeshClient(&gatewayinfo);
    //register as mesh client
    ::wxGetApp().m_nMeshStatus = MESHSTATUS_MESHCLIENT;
    Show(false);

}
void MeshUseOthersInternetDlg::OnButtonCancelClick(wxCommandEvent& event)
{
    SetReturnCode(wxID_CANCEL);
    Show(false);
}

void MeshUseOthersInternetDlg::RefreshList()
{
    printf("[MeshUseOthersInternetDlg]RefreshList start\n");
    m_MeshServerInfoList.clear();

    MESH_NEIGHBOR_INFO meshNeighInfo;
    memset(&meshNeighInfo, 0, sizeof(MESH_NEIGHBOR_INFO));
    DCS_ListAllNeighborMPs(&meshNeighInfo);

    int iCount = meshNeighInfo.num;
    m_pGaugeDialog->Show(false);
    printf("[MeshUseOthersInternetDlg]Get list count= %d \n", iCount);
    if ( iCount > 0 )
    {
        wxString buf;
        buf = _T(" ");
        int dServerNumber = 0;
        for ( int i = 0; i < iCount; i++ )
        {
            MESH_NEIGHBOR_ENTRY_INFO mesh_entry = meshNeighInfo.Entry[i];
            MeshServerEntity meshserverentity;
            char* strServerNameAll = (char*)(mesh_entry.HostName);
            printf("[MeshUseOthersInternetDlg]All Server name: %s\n", (const char*)(mesh_entry.HostName));

            int iNameLen = strlen(strServerNameAll);
            if ( strServerNameAll[iNameLen-1] != '?')
            {
                printf("[MeshUseOthersInternetDlg]This is not a mesh server\n");
                continue;
            }
            printf("[MeshUseOthersInternetDlg]This is a mesh server\n");
            strServerNameAll += 12;
            //get mesh server info
            wxString wxServerName = ENMUtil::StringToWxString(strServerNameAll);
            meshserverentity.SetHostName(wxServerName);

            Inetv4Address ip;
            memcpy(&ip, (const char*)(mesh_entry.HostName), 4);
            //check ip == "0000"
            char strNOAddr[] = "0000";
            char tempIP[5] = {'\0'};
            memcpy(tempIP, (const char*)(mesh_entry.HostName), 4);
            if (memcmp(tempIP, strNOAddr, 4) == 0)
            {
                meshserverentity.SetIPAddress(wxT("0.0.0.0"));
            }
            else
            {
                char ipAddr[20] = {'\0'};
                IPv4AddressUtil::InetAddressToString(&ip, ipAddr);
                meshserverentity.SetIPAddress(ENMUtil::StringToWxString(ipAddr));
            }

            char* tempHostname = (char*)(mesh_entry.HostName);
            tempHostname += 4;
            Inetv4Address DNS1;
            memcpy(&DNS1, tempHostname, 4);
            char tempDNS1[5] = {'\0'};
            memcpy(tempDNS1, tempHostname, 4);
            if ( memcmp(tempDNS1, strNOAddr, 4) == 0)
            {
                meshserverentity.SetDNS(wxT("0.0.0.0"));
            }
            else
            {
                char DNS1Addr[20] = {'\0'};
                IPv4AddressUtil::InetAddressToString(&DNS1, DNS1Addr);
                meshserverentity.SetDNS(ENMUtil::StringToWxString(DNS1Addr));
            }

            tempHostname += 4;
            Inetv4Address DNS2;
            memcpy(&DNS2, tempHostname, 4);
            char tempDNS2[5] = {'\0'};
            memcpy(tempDNS2, tempHostname, 4);
            if ( memcmp(tempDNS2, strNOAddr, 4) == 0)
            {
                meshserverentity.SetDNS_back(wxT("0.0.0.0"));
            }
            else
            {
                char DNS2Addr[20] = {'\0'};
                IPv4AddressUtil::InetAddressToString(&DNS2, DNS2Addr);
                meshserverentity.SetDNS_back(ENMUtil::StringToWxString(DNS2Addr));
            }
            char sChannel[2];
            sprintf(sChannel, "%d", mesh_entry.Channel);
            wxString wxChannel = ENMUtil::StringToWxString((const char*)(sChannel));
            int dChannel = 0;
            wxChannel.ToLong((long int*)&dChannel, 10);
            meshserverentity.SetChannel(dChannel);
            char sStatus[2];
            sprintf(sStatus, "%d", mesh_entry.Status);

            wxString wxStates = ENMUtil::StringToWxString((const char*)(sStatus));
            meshserverentity.SetStatus(wxStates);

            m_list->InsertItem(dServerNumber, buf);
            m_list->SetItem(dServerNumber, 0, wxServerName.Left(wxServerName.Length()-1));
            m_list->SetItem(dServerNumber, 1, wxChannel);

            int nRSSI = 0;
            nRSSI = 2 * mesh_entry.Rssi + 200;
            if(nRSSI>100)
                nRSSI =100;
            if(nRSSI<0)
                nRSSI =0;

            m_list->SetItem(dServerNumber,2, wxString::Format(wxT("%d"), nRSSI));
            m_list->SetItem(dServerNumber, 3, wxStates);

            m_MeshServerInfoList.push_back(meshserverentity);
            dServerNumber++;
        }
        if ( 0==dServerNumber )
        {
            printf("[MeshUseOthersInternetDlg]Could not find mesh server\n");
            wxMessageDialog dlg(this, _("Could not find any Mesh Server!"), _("Message"), wxOK | wxICON_EXCLAMATION);
            dlg.ShowModal();
        }
    }
    else
    {
        printf("Could not find mesh server\n");
        wxMessageDialog dlg(this, _("Could not find any Mesh Server!"), _("Message"), wxOK | wxICON_EXCLAMATION);
        dlg.ShowModal();
    }
    printf("[MeshUseOthersInternetDlg]:RefreshList end\n");
}

void MeshUseOthersInternetDlg::BeginSearch()
{
    //start scan channel
    DCS_SetMeshChannelOFFSET(6);

    m_pGaugeDialog->SetProcessLabel(_("Searching for mesh servers..."));
    m_pGaugeDialog->Move(377, 270);
    m_pGaugeDialog->Show(true);
    m_searchTimer.Start(2000, true);
}

void MeshUseOthersInternetDlg::OnTimer(wxTimerEvent& event)
{
    RefreshList();
}
