/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "MeshConfigurationEntity.h"


/*=================================================================
 Function Name  : MeshConfigurationEntity::MeshConfigurationEntity
 Description    : Construction function
 Date           : 2008-9-17 14:44:37
 Return Code    : none
 Author         : Li Yang
 =================================================================*/
MeshConfigurationEntity::MeshConfigurationEntity()
:m_strMeshLocalHostName(wxEmptyString),m_nMeshChannel(1),
m_nMeshAdvertiseTime(10)
{
    //ctor
//    xmlOperator.ReadMeshLocalHostNameXmlFile(m_strMeshLocalHostName);
    //xmlOperator.ReadMeshChannelXmlFile(m_nMeshChannel);
    //xmlOperator.ReadMeshAdvertiseTimeXmlFile(m_nMeshAdvertiseTime);
}


/*=================================================================
 Function Name  : MeshConfigurationEntity::~MeshConfigurationEntity
 Description    : Destruction function
 Date           : 2008-9-17 14:44:56
 Return Code    : none
 Author         : Guo xixiu
 =================================================================*/
MeshConfigurationEntity::~MeshConfigurationEntity()
{
    //dtor
}


/*=================================================================
 Function Name  : PolicyEntity::GetMeshLocalHostName
 Description    : Get mesh local host name
 Date           : 2008-9-17 14:45:06
 Return Code    : bool
 Author         : Guo xixiu
 =================================================================*/
wxString MeshConfigurationEntity::GetMeshLocalHostName()
{
    return m_strMeshLocalHostName;
}

/*=================================================================
 Function Name  : PolicyEntity::SetMeshLocalHostName
 Description    : Set mesh local host name
 Date           : 2008-9-17 14:46:13
 Parameter      : string strMeshLocalHostName
 Return Code    : void
 Author         : Guo xixiu
 =================================================================*/
void MeshConfigurationEntity::SetMeshLocalHostName(wxString strMeshLocalHostName)
{
//    wxMessageBox(strMeshLocalHostName);
    m_strMeshLocalHostName = strMeshLocalHostName;
//    wxMessageBox(m_strMeshLocalHostName);
}


/*=================================================================
 Function Name  : PolicyEntity::GetMeshChannel
 Description    : Get mesh channel
 Date           : 2008-9-17 14:45:06
 Return Code    : int
 Author         : Guo xixiu
 =================================================================*/
int MeshConfigurationEntity::GetMeshChannel()
{
    return m_nMeshChannel;
}

/*=================================================================
 Function Name  : PolicyEntity::SetMeshChannel
 Description    : Set mesh channel
 Date           : 2008-9-17 14:46:13
 Parameter      : int nMeshChannel
 Return Code    : void
 Author         : Guo xixiu
 =================================================================*/
void MeshConfigurationEntity::SetMeshChannel(int nMeshChannel)
{
    m_nMeshChannel = nMeshChannel;
}

/*=================================================================
 Function Name  : PolicyEntity::GetMeshAdvertiseTime
 Description    : Get mesh advertise time
 Date           : 2008-9-17 14:45:06
 Return Code    : int
 Author         : Guo xixiu
 =================================================================*/
int MeshConfigurationEntity::GetMeshAdvertiseTime()
{
    return m_nMeshAdvertiseTime;
}

/*=================================================================
 Function Name  : PolicyEntity::SetMeshAdvertiseTime
 Description    : Set mesh advertise time
 Date           : 2008-9-17 14:46:13
 Parameter      : int nMeshAdvertiseTime
 Return Code    : void
 Author         : Guo xixiu
 =================================================================*/
void MeshConfigurationEntity::SetMeshAdvertiseTime(int nMeshAdvertiseTime)
{
    m_nMeshAdvertiseTime = nMeshAdvertiseTime;
}
