/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef MESHCONFIGURATIONDLG_H
#define MESHCONFIGURATIONDLG_H


#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/panel.h>
#include <wx/statbmp.h>
#include <wx/button.h>
#include <wx/dialog.h>
#include "MeshConfigurationEntity.h"
#include "XMLOperator.h"

class MeshConfigurationDlg: public wxDialog
{
	public:

		MeshConfigurationDlg(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~MeshConfigurationDlg();

		//(*Declarations(MeshConfigurationDlg)
		wxStaticText* StaticText6;
		wxStaticBitmap* StaticBitmap1;
		wxButton* ButtonOK;
		wxPanel* Panel1;
		wxStaticText* StaticText1;
		wxTextCtrl* TextCtrlMeshChannel;
		wxStaticText* StaticText3;
		wxTextCtrl* TextCtrlLocalHostName;
		wxButton* ButtonCancel;
		wxStaticText* StaticText5;
		wxStaticText* StaticText4;
		//*)
		MeshConfigurationEntity meshConfigurationEntity;
        XMLOperator xmlOperator;
	protected:

		//(*Identifiers(MeshConfigurationDlg)
		static const long ID_STATICTEXT1;
		static const long ID_STATICTEXT3;
		static const long ID_STATICTEXT4;
		static const long ID_STATICTEXT5;
		static const long ID_STATICTEXT6;
		static const long ID_TEXTCTRL_LOCAL_HOST_NAME;
		static const long ID_TEXTCTRL_MESH_CHANNEL;
		static const long ID_BUTTON_OK;
		static const long ID_BUTTON_CANCEL;
		static const long ID_STATICBITMAP1;
		static const long ID_PANEL1;
		//*)

	private:
        void OnCloseClicked(wxCloseEvent& event);
		//(*Handlers(MeshConfigurationDlg)
		void OnButtonOKClick(wxCommandEvent& event);
		void OnButtonCancelClick(wxCommandEvent& event);
		void OnInit(wxInitDialogEvent& event);
		//*)
        bool CheckMeshSettings();
        void RepublishIfMeshServer();
		DECLARE_EVENT_TABLE()
};

#endif
