/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef IPSETTINGS_H
#define IPSETTINGS_H

#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/button.h>
#include <wx/dialog.h>
#include "Profile.h"

class IPSettings: public wxDialog
{
	public:

		IPSettings(wxWindow* parent);
		virtual ~IPSettings();
    IPDNSSet_t GetIPSetting() const;
    void SetIPSetting(const IPDNSSet_t& set);

		//(*Declarations(IPSettings)
    wxTextCtrl* m_TcIP;
    wxTextCtrl* m_TcSm;
    wxTextCtrl* m_TcGa;
    wxTextCtrl* m_TcDns;

private:
		//(*Identifiers(IPSettings)
		static const long ID_TCIP;
		static const long ID_TCSM;
		static const long ID_TCGA;
		static const long ID_BUTTONCANCEL;
		static const long ID_BUTTONOK;
		static const long ID_TCDNS;

    wxButton* m_BtnOK;
    wxButton* m_BtnCancel;
    wxStaticText* m_StSm;
    wxStaticText* m_StIP;
    wxStaticText* m_StGa;
    wxStaticText* m_StDns;
    IPDNSSet_t m_ipSet;

    void OnButtonCancelClick(wxCommandEvent& event);
    void OnButtonOKClick(wxCommandEvent& event);
		void OnInit(wxInitDialogEvent& event);

		DECLARE_EVENT_TABLE()
};

#endif
