/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _EDIT_PROFILE_DIALOG_H_
#define _EDIT_PROFILE_DIALOG_H_

#include <wx/notebook.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/checkbox.h>
#include <wx/statbox.h>
#include <wx/panel.h>
#include <wx/button.h>
#include <wx/dialog.h>
#include <wx/combobox.h>
#include <wx/bmpcbox.h>
#include "Profile.h"
#include "net.h"

class EditProfileDialog : public wxDialog
{
public:
    EditProfileDialog(wxWindow* parent, const ProfileList_t& profile, bool create = false);
    virtual ~EditProfileDialog();

    ProfileList_t GetProfile() const;

private:
    wxStaticText* m_labelWirelessName;
    wxStaticText* m_labelConType;
    wxStaticText* m_textWirelessType;
    wxStaticText* m_textSecType;
    wxStaticText* m_labelName;
    wxStaticText* m_textKey;
    wxStaticText* m_textConfirmKey;
    wxStaticText* m_textTip;
    wxStaticText* m_textKeyIdx;

    wxNotebook* m_nbEdit;

    wxCheckBox* m_cbNetworkSecrity;
    wxCheckBox* m_cbApp;
    wxCheckBox* m_cbDefault;
    wxCheckBox* m_cbHomepage;
    wxCheckBox* m_cbProxy;
    wxComboBox* m_cbConType;
    wxComboBox* m_cbbIndex;
    wxComboBox* m_cbbSecType;
    wxComboBox* m_cbbWirelessType;
    wxBitmapComboBox* m_cbName;

    wxButton* m_buttonOK;
    wxButton* m_buttonCancel;
    wxButton* m_buttonScan;
    wxButton* m_buttonNs;
    wxButton* m_buttonApp;
    wxButton* m_buttonDefault;
    wxButton* m_buttonProxy;
    wxButton* m_buttonSTSettings;

    wxTextCtrl* m_textName;
    wxTextCtrl* m_textSSID;
    wxTextCtrl* m_tcKey;
    wxTextCtrl* m_tcConfirmKey;
    wxTextCtrl* m_textHomepage;

    wxPanel* m_generalPanel;
    wxPanel* m_wirelessPanel;
    wxPanel* m_othersPanel;

    wxStaticBox* m_stcBox;
//    wxStaticBox* m_buttonBrowser;

    ProfileList_t m_profile;
    vector<wxString> m_vAutoRunApp;

    string m_strForbidShareFileAndPrint;
    string m_strForbidShareInternet;
    string m_strStartWindowFirewall;

    wxString m_strIP;
    wxString m_strSubMask;
    wxString m_strGateWayAddr;
    wxString m_strDNS;
    wxString m_sWepKey;
    wxString m_sWpaKey;
        NetworkSecuritySet_t m_securitySet;
        IPDNSSet_t m_ipSet;
    wxString m_strProxy;
    wxString m_strUserName;
    wxString m_strPassword;
    wxString m_strPort;

    static const long ID_OKBUTTON;
    static const long ID_CANCLEBUTTON;
    static const long ID_NAMECOMBOBOX;
    static const long ID_CONTYPECOMBOBOX;
    static const long ID_GENERALPANEL;
    static const long ID_SSIDTEXTCTRL;
    static const long ID_SCANBUTTON;
    static const long ID_WIRELESSTYPECOMBOBOX;
    static const long ID_SECRITYTYPECOMBOBOX;
    static const long ID_WIRELESSPANEL;
    static const long ID_NETWORKSECRITYCHECKBOX;
    static const long ID_APPCHECKBOX;
    static const long ID_DEFAULTCHECKBOX;
    static const long ID_NSBUTTON;
    static const long ID_APPBUTTON;
    static const long ID_DEFAULTBUTTON;
    static const long ID_PROXYBUTTON;
    static const long ID_HOMEPAGECHECKBOX;
    static const long ID_PROXYCHECKBOX;
    static const long ID_HOMEPAGETEXTCTRL;
    static const long ID_OTHERSPANEL;
    static const long ID_EDITNOTEBOOK;
    static const long ID_EDITPANEL;
    static const long ID_KEYTEXTCTRL;
    static const long ID_CONFIRM_KEYTEXTCTRL;
    static const long ID_NAMETEXTCTRL;

    wxString m_strOldName;
    bool m_isForCreate;
    bool m_isExit;

    void Onm_buttonOKClick(wxCommandEvent& event);
    void Onm_buttonCancelClick(wxCommandEvent& event);
    void Onm_cbbSecTypeSelect(wxCommandEvent& event);
    void Onm_cbNetworkSecrityClick(wxCommandEvent& event);
    void Onm_cbAppClick(wxCommandEvent& event);
    void Onm_cbDefaultClick(wxCommandEvent& event);
    void Onm_cbHomePageClick(wxCommandEvent& event);
    void Onm_cbProxyClick(wxCommandEvent& event);
    void Onm_buttonNsClick(wxCommandEvent& event);
    void Onm_buttonAppClick(wxCommandEvent& event);
    void Onm_buttonDefaultClick(wxCommandEvent& event);
    void Onm_buttonProxyClick(wxCommandEvent& event);
    void Onm_buttonSnClick(wxCommandEvent& event);
    void OnInit(wxInitDialogEvent& event);
    void BeforeClose(wxCloseEvent& event);

    void UpdateSecurityUI(const WirelessSettings_t& set);
    void UpdateSecurityUI(const wxString& strType);

    DECLARE_EVENT_TABLE()
};

#endif // _EDIT_PROFILE_DIALOG_H_
