/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "ENMUtil.h"
#include "ENMApp.h"

#include <string>
#include <vector>
#include <iostream>
#include <fstream>

#include <wx/msgdlg.h>
#include <wx/utils.h>
#include <sdk/ENMApi.h>
#include <sys/types.h>
#include <errno.h>
#include <stdlib.h>
#include "DataCenter.h"
#include <wx/buffer.h>
#include <wx/file.h>
#include <wx/textfile.h>

#include "PopupDialog.h"
#include "PopupConfirmDialog.h"

static wxString logFile(_T("/tmp/ENMUtil.log"));

using namespace std;

const long START_FIREWALL = 1;
const long STOP_FIREWALL = 0;
const size_t REG801X_LENGTH = 104;

PopupConfirmDialog* ENMUtil::switchWiredSuccDlg = NULL;
PopupConfirmDialog* ENMUtil::switchWirelessSuccDlg = NULL;
PopupConfirmDialog* ENMUtil::noWirelessAdapterDlg = NULL;
PopupConfirmDialog* ENMUtil::wirelessOnOffDlg = NULL;
PopupConfirmDialog* ENMUtil::autoConnectionFailedDlg = NULL;
wxString ENMUtil::m_appPath = wxT("");
bool ENMUtil::FilenameEquals(const wxString& name1, const wxString& name2)
{
    return name1.Cmp(name2) == 0;

}

string ENMUtil::WxStringToString(wxString wxStringValue)
{
    string temp(wxStringValue.mb_str(wxConvUTF8));
    return temp;
}

wxString ENMUtil::StringToWxString(string stringValue)
{
    wxString temp(stringValue.c_str(), wxConvUTF8);
    return temp;
}

string& ENMUtil::StringToLowerCase(string& str)
{
    char d = 'a' - 'A';
    for ( string::size_type i = 0; i < str.size(); i++ )
    {
        if ( str[i] >= 'A' && str[i] <= 'Z' )
            str[i] += d;
    }
    return str;
}

bool ENMUtil::IsHexNumber(wxString str)
{
    bool result = true;
    for ( size_t i = 0; i < str.Length(); i++ )
    {
        result &= ( (str[i] >= '0' && str[i] <= '9') || (str[i] >= 'a' && str[i] <= 'f') || (str[i] >= 'A' && str[i] <= 'F') );
    }
    return result;
}

int ENMUtil::OnlyLetterAndNum(wxString str)
{
    string s = WxStringToString(str);
    for ( string::size_type i = 0; i < s.length(); i++)
    {
        if ((s[i] < 48 || s[i] > 57) && (s[i] < 97 || s[i] > 122))
        {
            return 1;
        }
    }
    return 0;
}

bool ENMUtil::IsOnlyNumber(wxString str)
{
    return str.IsNumber();
}

int ENMUtil::CheckValide(wxString str)
{
    str.Trim(true).Trim(false);
    if (str.Length() == 0)
    {
        return CHECK_EMPTY;
    }
    if (str.Find('<') >= 0)
    {
        return CHECK_ILLEGAL;
    }
    else if (str.Find('>') >= 0)
    {
        return CHECK_ILLEGAL;
    }
    else if (str.Find('"') >= 0)
    {
        return CHECK_ILLEGAL;
    }
    else if (str.Find('\\') >= 0)
    {
        return CHECK_ILLEGAL;
    }
//    else if (str.Find('\'') >=0)
//    {
//        return CHECK_ILLEGAL;
//    }
    else if (str.Find('*') >=0)
    {
        return CHECK_ILLEGAL;
    }
    else if (str.Find(':') >=0)
    {
        return CHECK_ILLEGAL;
    }
    else if (str.Find('?') >=0)
    {
        return CHECK_ILLEGAL;
    }
    else if (str.Find('|') >=0)
    {
        return CHECK_ILLEGAL;
    }
    else if (str.Find('/') >=0)
    {
        return CHECK_ILLEGAL;
    }
//    else if (str.Find('%') >=0)
//    {
//        return CHECK_ILLEGAL;
//    }
    return CHECK_OK;
}

bool ENMUtil::IsAdministrator()
{
#if defined(__UNIX__)
    wxString wxs = ::wxGetUserId();
    string s(wxs.mb_str(wxConvUTF8));
    return s == "root";
#endif
}

wxString ENMUtil::GetCurrentUserAppDataFolder()
{
#if defined(__UNIX__)
     return ::wxGetHomeDir();
#endif
}

bool ENMUtil::ChangeIPAddress(const wxString& ip, const wxString& mask, const wxString& gateway, const wxString& dns, int adapterType, const wxString& op)
{
//    ENMUtil::Log(logFile, wxString::Format(_T("Enter ENMUtil::ChangeIPAddress(\"%s\", \"%s\", \"%s\", \"%s\", %d, \"%s\")"), ip, mask, gateway, dns, adapterType, op));
    DataCenter* pDataCenter = DataCenter::GetInstance();
    if ( NULL == pDataCenter )
        return false;

    if ( adapterType == ADAPTER_NONE )
        return false;

    ENM_AddressInfo addrInfo;
    memset(&addrInfo, 0, sizeof(ENM_AddressInfo));
    string strIP = WxStringToString(ip);
    string strGateway = WxStringToString(gateway);
    string strMask = WxStringToString(mask);
    string strDns = WxStringToString(dns);
    strcpy((char*)addrInfo.ip.dcsString, (const char*)strIP.c_str());
    strcpy((char*)addrInfo.mask.dcsString, (const char*)strMask.c_str());
    strcpy((char*)addrInfo.gateway.dcsString, (const char*)strGateway.c_str());
    strcpy((char*)addrInfo.dns.dcsString, (const char*)strDns.c_str());

    bool result = (DCS_SetIPAddress(&addrInfo) == DCS_SUCCESS);
    ENMUtil::Log(logFile, wxString::Format(_T("Return ENMUtil::ChangeIPAddress: %d\n"), result));
    return result;
}

bool ENMUtil::GetIPAddress(wxString& ip, wxString& mask, wxString& gateway, wxString& dns, int adapterType)
{
    return false;

}
bool ENMUtil::DisableInternetSharing()
{
#if defined(__UNIX__)
    return true;
#endif
}

bool ENMUtil::EnableInternetSharing()
{
#if defined(__UNIX__)
    return true;
#endif
}

bool ENMUtil::AutoRunApp(wxString strAppPath)
{
#if defined(__UNIX__)
    string s = WxStringToString(strAppPath) + " &";
    system(s.c_str());
#endif
    return true;
}

bool ENMUtil::OverwriteHomePage(wxString strHomePage)
{
#if defined(__UNIX__)
    wxString wxstrHomePage = strHomePage;

    wxString prefsFile = GetFirefoxConfigFile();

    if ( prefsFile.Length() == 0 || !wxFile::Exists(prefsFile) )
        return false;
    bool homePageFound = false;
    wxTextFile tf;
    tf.Open(prefsFile);
    for ( size_t i = 0; i < tf.GetLineCount(); i++ )
    {
        if ( tf.GetLine(i).Contains(_T("user_pref(\"browser.startup.homepage\", \"")) )
        {
            homePageFound = true;
            tf.GetLine(i) = _T("user_pref(\"browser.startup.homepage\", \"") + wxstrHomePage + _T("\");");
        }
    }
    if ( !homePageFound )
    {
        tf.AddLine(_T("user_pref(\"browser.startup.homepage\", \"") + wxstrHomePage + _T("\");"));
    }
    tf.Write();
    tf.Close();

    return true;
#endif
}

bool ENMUtil::OverwriteProxy(wxString strProxy, wxString strPort)
{
#if defined(__UNIX__)
    wxString wxstrProxy = strProxy;
    wxString wxstrPort = strPort;

    wxString prefsFile = GetFirefoxConfigFile();
    if ( prefsFile.Length() == 0 || !wxFile::Exists(prefsFile) )
        return false;
    bool proxyFound = false;
    bool portFound = false;
    wxTextFile tf;
    tf.Open(prefsFile);
    for ( size_t i = 0; i < tf.GetLineCount(); i++ )
    {
        if ( tf.GetLine(i).Contains(_T("user_pref(\"network.proxy.http\", \"")) )
        {
            proxyFound = true;
            tf.GetLine(i) = _T("user_pref(\"network.proxy.http\", \"") + wxstrProxy + _T("\");");
        }
        else if ( tf.GetLine(i).Contains(_T("user_pref(\"network.proxy.http_port\", ")) )
        {
            portFound = true;
            tf.GetLine(i) = _T("user_pref(\"network.proxy.http_port\", ") + wxstrPort + _T(");");
        }
    }
    if ( !proxyFound )
    {
        tf.AddLine(_T("user_pref(\"network.proxy.http\", \"") + wxstrProxy + _T("\");"));
    }
    if ( !portFound )
    {
        tf.AddLine(_T("user_pref(\"network.proxy.http_port\", ") + wxstrPort + _T(");"));
    }
    tf.Write();
    tf.Close();

    return true;
#endif
}


bool ENMUtil::Enable8021xAuthentication(bool isEnable)
{
    return DCS_Enable8021xAuthentication(isEnable) == DCS_SUCCESS;
}

#if defined(__UNIX__)
wxString ENMUtil::GetFirefoxConfigFile()
{
    wxString firefoxDir = ::wxGetHomeDir() + _T("/.mozilla/firefox");
    wxString profile = firefoxDir + _T("/profiles.ini");
    if ( !wxFile::Exists(profile) )
        return _T("");

    ifstream fin(WxStringToString(profile).c_str());
    wxArrayString arrayString;
    while ( !fin.eof() )
    {
        char buf[256] = { 0 };
    //    getline(fin, buf);
        fin.getline(buf, 256);
        arrayString.Add(wxString::FromUTF8(buf));
    }
    fin.close();
    wxString pref;
    for ( size_t i = 0; i < arrayString.Count(); i++ )
    {
        wxString s = arrayString.Item(i);
        if ( s.StartsWith(_T("Path=")) )
        {
            pref = s.Mid(s.Find('=', false) + 1);
        }
    }
    return ::wxGetHomeDir() + _T("/.mozilla/firefox/") + pref + _T("/prefs.js");
}

bool ENMUtil::IsFirefoxRunning()
{
    system("ps -A|grep \"firefox\" > /tmp/_firefox.tmp");
    wxString tmpFile = _T("/tmp/_firefox.tmp");
    if ( !wxFile::Exists(tmpFile) )
        return false;

    wxFile file(tmpFile);
    bool result = file.Length() > 0;
    file.Close();
    return result;
}

wxString ENMUtil::GetLocaleFileName(int langCode)
{
//    wxString mapfile(_T("/usr/share/EnhancedEasyNetwork/resource/langs.conf"));
    wxString mapfile = ::wxGetApp().strAppPath + _T("resource/langs.conf");
    wxString fileName(_T("en"));
    wxTextFile in;
    if ( !wxFile::Exists(mapfile) || !in.Open(mapfile) )
    {
        return fileName;
    }

    wxString langCodeStr = wxString::Format(_T("%d:"), langCode);
    wxString line = in.GetFirstLine();
    while( !in.Eof() )
    {
        if ( line.StartsWith(langCodeStr, &fileName) )
        {
            break;
        }

        line = in.GetNextLine();
    }

    in.Close();
    return fileName;
}
#endif


bool ENMUtil::IsGuest()
{
#if defined(__UNIX__)
    return false;
#endif
}

void ENMUtil::Log(const wxString& file, const wxString& log)
{
#ifdef __USE_ENM_LOG__
    wxFile f(file, wxFile::write_append);
    f.Write(log + wxT("\n"));
    f.Close();
#endif
}

void ENMUtil::ShowSwitchWiredLANDlg()
{
    PopupDialog Dlg(NULL, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/balloon_background.png"))));
    Dlg.SetTitle(_("Confirm"));
    Dlg.SetContent(_("EN has found Wired LAN available, would you like to switch from Wireless to Wired LAN?"));
    if ( Dlg.ShowModal() == wxID_OK )
    {
        DataCenter::GetInstance()->SwitchAdapterParameter(ADAPTER_WIREDLESS,ADAPTER_WIRED,NULL);
        ShowSwitchWiredSuccDlg();
    }
    else
    {
        DataCenter::GetInstance()->SwitchAdapterParameter(ADAPTER_WIRED,(ADAPTER_TYPE)0,NULL);
    }
}


void ENMUtil::ShowSwitchWiredSuccDlg()
{
    if ( NULL == switchWiredSuccDlg )
    {

        #if defined(__UNIX__)
        switchWiredSuccDlg = new PopupConfirmDialog(NULL, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/balloon_background.png"))));
        #endif
    }
    switchWiredSuccDlg->SetTitle(_("Confirm"));
    switchWiredSuccDlg->SetContentLine1(_("EN has successfully switched from"));
    switchWiredSuccDlg->SetContentLine2(_("Wireless LAN to Wired LAN."));
    switchWiredSuccDlg->Show();
}

int ENMUtil::ShowSwitchWirelessLANDlg()
{
    PopupDialog Dlg(NULL, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/balloon_background.png"))));
    Dlg.SetTitle(_("Confirm"));
#if defined(__UNIX__)
    Dlg.SetContent(_("Wired LAN is disconnected. Would you like to switch to Wireless LAN?"));
#endif
    return Dlg.ShowModal();
}

void ENMUtil::ShowNoWirelessAdapterDlg()
{
    if ( NULL == noWirelessAdapterDlg )
    {
        #if defined(__UNIX__)
        noWirelessAdapterDlg = new PopupConfirmDialog(NULL, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/balloon_background.png"))));
        #endif
    }

    noWirelessAdapterDlg->SetTitle(_("Confirm"));
    noWirelessAdapterDlg->SetContentLine2(_("No Wireless Adapter was found!"));
    noWirelessAdapterDlg->Show();
}

void ENMUtil::ShowWirelessOnOffDlg(bool isEnable)
{
    if ( NULL == wirelessOnOffDlg )
    {

        #if defined(__UNIX__)
        wirelessOnOffDlg = new PopupConfirmDialog(NULL, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/balloon_background.png"))));
        #endif
    }

    wirelessOnOffDlg->SetTitle(_("Confirm"));
    if ( isEnable )
    {
        wirelessOnOffDlg->SetContentLine2(_("Turn on Wireless!"));
    }
    else
    {
        wirelessOnOffDlg->SetContentLine2(_("Turn off Wireless!"));
        wirelessOnOffDlg->SetContentLine3(_("Turn on Wired LAN!"));
    }

    wirelessOnOffDlg->Show();
}


void ENMUtil::ShowAutoConnectionFailedDlg()
{
    if ( NULL == autoConnectionFailedDlg )
    {
#if defined(__UNIX__)
        autoConnectionFailedDlg = new PopupConfirmDialog(NULL, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/balloon_background.png"))));
#endif
    }
    autoConnectionFailedDlg->SetTitle(_("Confirm"));
    autoConnectionFailedDlg->SetContentLine1(_("None of the pre-defined profiles"));
    autoConnectionFailedDlg->SetContentLine2(_("connected successfully!"));
    autoConnectionFailedDlg->Show();
}

bool ENMUtil::ShowContextHelp(const wxWindow* pWnd, const wxString& section)
{
    wxString strFileName = ::wxGetApp().strManualFileName;
    if ( !wxFile::Exists(strFileName) )
        return false;
#if defined(__UNIX__)
    wxString cmd = _T("evince ") + strFileName + _T(" --page-label=1");
    wxExecute(cmd);
    return true;
#endif
}

bool ENMUtil::ValidateIPSettings(const IPDNSSet_t& set)
{
    return set.IPvalue.Length() > 0 && set.NetGateway.Length() > 0
            && set.SubnetAddress.Length() > 0 && set.DNSvalue.Length() > 0;
}

