/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "ENMTaskTray.h"
#include "NetworkManagerDlg.h"
#include "ScanNetworkDlg.h"
#include "WirelessScanner.h"
#include <iostream>
#include <fstream>
#include <string>
#include <linux/types.h>
#include <linux/wireless.h>
#include <linux/ethtool.h>
#include <linux/sockios.h>
#include <errno.h>
#include "DataCenterLinux.h"
#include "ENMUtil.h"
#include "SwitchAdapterEvent.h"
#include <wx/longlong.h>
#include <wx/timer.h>
#include "ScanEvent.h"
#include "ProfileManagementControl.h"
#include "PolicyManager.h"
#include <sdk/PMApi.h>
#include <wx/file.h>
#include <wx/filefn.h>
#include "ENMApp.h"
#include <sys/socket.h>
#include <arpa/inet.h>/*inet_ntoa() to format IP address */
#include <netinet/in.h>/* in_addr structure */
#include <sys/ioctl.h>
#include "MeshInfoManager.h"
using namespace std;

static wxString logFile(_T("/tmp/DataCenterLinux.log"));

const long DataCenterLinux::ID_TIMER_READNETWORKSTATUS = wxNewId();
const long DataCenterLinux::ID_TIMER_SCAN = wxNewId();
const long DataCenterLinux::ID_TIMER_ALLOCATE = wxNewId();
const long DataCenterLinux::ID_TIMER_WPA = wxNewId();
const long DataCenterLinux::ID_TIMER_SUSPEND = wxNewId();
const long DataCenterLinux::ID_TIMER_SWITCHUSER = wxNewId();
const long DataCenterLinux::ID_TIMER_STARTTIMERAFTERRESUME = wxNewId();
const long DataCenterLinux::ID_TIMER_WAITFORRESUME = wxNewId();
const long DataCenterLinux::ID_TIMER_UPWIRELESS = wxNewId();
const long DataCenterLinux::ID_TIMER_FORROAMING = wxNewId();
const int NETSTATUS_TIMERINTERVAL = 10000 ;
const int ALLOCATE_TIMERINTERVAL = 10000 ;
const int TIMER_SCAN_DELAY = 6000 ;
const int WPA_DELAY = 20000;
const int SUSPENDPERIOD = 2000;
const int SWITCHUSERPERIOD = 1000;
const int STARTTIMERAFTERRESUME = 6000 ;
const int ROAMINGINTERVAL = 2000;
const wxString g_path = ENMUtil::GetCurrentUserAppDataFolder();
//const int FILESIZE = 1024;
//const int ORDERBUFSIZE = 128;
BEGIN_EVENT_TABLE(DataCenterLinux, wxEvtHandler)
    EVT_TIMER(ID_TIMER_READNETWORKSTATUS, DataCenterLinux::OnReadNetworkStatusTimer)
    EVT_TIMER(ID_TIMER_SCAN, DataCenterLinux::OnScanTimer)
    EVT_TIMER(ID_TIMER_ALLOCATE, DataCenterLinux::OnAllocatorTimer)
    EVT_TIMER(ID_TIMER_WPA, DataCenterLinux::OnWpaTimer)
    EVT_TIMER(ID_TIMER_SUSPEND, DataCenterLinux::OnSusPendTimer)
    EVT_TIMER(ID_TIMER_SWITCHUSER, DataCenterLinux::OnSwitchUserTimer)
    EVT_TIMER(ID_TIMER_STARTTIMERAFTERRESUME, DataCenterLinux::OnStartTimerAfterResume)
    EVT_TIMER(ID_TIMER_WAITFORRESUME, DataCenterLinux::OnWaitForResume)
    EVT_TIMER(ID_TIMER_UPWIRELESS, DataCenterLinux::OnUpWireless)
    EVT_TIMER(ID_TIMER_FORROAMING, DataCenterLinux::OnForRoaming)
    EVT_SCAN(ID_SCAN_OVER, DataCenterLinux::SearchAP)
END_EVENT_TABLE()

int DataCenterLinux::GetMeshIpHelper(char * ifname, char * ip)
{

    struct ifreq ifr;

    struct sockaddr_in sin;

    int socket_id;

    socket_id = socket(AF_INET, SOCK_DGRAM, 0);

    int ret = 0;

    if(socket_id < 0)

    {

        return 0;

    }

    memset(ip, 0 ,32);

    strncpy (ifr.ifr_name, ifname, IFNAMSIZ);

    if ( (ret=ioctl (socket_id, SIOCGIFADDR, &ifr)) == 0) {

        memcpy (&sin, &(ifr.ifr_addr), sizeof (sin));

        memcpy(ip, (char*)inet_ntoa (sin.sin_addr), strlen((char*)inet_ntoa (sin.sin_addr)));

        //Need check the IP address...

        return ret;

    }

    close(socket_id);

    return ret;

}



int DataCenterLinux::GetMeshIp(char* ifname, char* ip)

{

    //         struct iwreq wrq;

    int socket_id;

    struct if_nameindex *ifnames, *ifnm;

    //    struct ifreq ifr;

    int ret = 0;

    int affect_if = 0;

    if(!ip)

        return 0;

    socket_id = socket(AF_INET, SOCK_DGRAM, 0);

    if(socket_id < 0){

        return 0;

    }



    //find all the existing I/F

    ifnames = if_nameindex();

    for (ifnm = ifnames; ifnm && ifnm->if_name && ifnm->if_name[0]; ifnm++) {

        //          DEBUG_PRINT ("Index = %d: %s\n",ifnm->if_index, ifnm->if_name);

        if(strstr(ifnm->if_name, ifname)){

            ret += GetMeshIpHelper(ifnm->if_name, ip);

            affect_if++;

            break;

        }

    }



    if(!affect_if){

        ret--;

    }



    close(socket_id);

    return ret;

}



DataCenterLinux::DataCenterLinux()
{
     m_pAPStatus = NULL;
     m_pNetworkInfo = NULL;
     m_pCurrentWiredStatus = NULL;
     m_LastNetworkMode = NETWORK_MODE_DEFAULT ;
     m_CurrentNetworkMode = NETWORK_MODE_DEFAULT ;

     m_apList.nCount = 0;

     memset(m_apList.apList, 0, sizeof(m_apList.apList));

     m_pLinuxWlanScanner = NULL;

     m_isApplyProfile = false;
     m_bIgnorePolicy = false;

     m_isShowWiredLANDlg = false;
     m_isShowWirelessLANDlg = false;
     m_VerifyWiredConnected = 0;
     m_VerifyDisableWireless = 0;
     m_isAutoWireless = false;
     m_isShowWirelessOnOffDlg = false;
     m_isNetworkDlgTurnWireless = true;
     m_postEvent = false;
     m_wiredConnect = false;
     m_wirelessConnect = false;

     m_pScanThread = NULL;

}

DataCenterLinux::~DataCenterLinux()
{
    DestroyData();
    if( !m_pScanThread)
    {
        delete m_pScanThread;
        m_pScanThread = NULL ;
    }
}

void DataCenterLinux::InitData()
{
    DCS_RegisterLanChangedCallback(LanChangeCallBack);
    DCS_RegisterWLanChangedCallback(WlanChangeCallBack);
    DCS_RegisterDownInterfaceCallback(DisableAdapterCallBack);
    DataCenter::InitData();

    CreateNetTools();

    GetNetInfo();

    //DisableAllAdapters();

    m_NetStatusTimer.SetOwner(this, ID_TIMER_READNETWORKSTATUS);

    //m_NetStatusTimer.Start(NETSTATUS_TIMERINTERVAL);

    m_ScanTimer.SetOwner(this, ID_TIMER_SCAN);

    m_AlllcatorTimer.SetOwner(this, ID_TIMER_ALLOCATE);
    m_WaitForResume.SetOwner(this, ID_TIMER_WAITFORRESUME);
    m_UpWireless.SetOwner(this, ID_TIMER_UPWIRELESS);
    m_ForRoaming.SetOwner(this, ID_TIMER_FORROAMING);
    m_ForRoaming.Start(ROAMINGINTERVAL);

    m_WpaTimer.SetOwner(this, ID_TIMER_WPA);
    ENMUtil::Log(logFile, _T("m_SuspendTimer start begin"));
    m_SuspendTimer.SetOwner(this, ID_TIMER_SUSPEND);
    m_SuspendTimer.Start(SUSPENDPERIOD);
    ENMUtil::Log(logFile, _T("m_SuspendTimer start end"));
//    m_SwitchTimer.SetOwner(this, ID_TIMER_SWITCHUSER);
//    m_SwitchTimer.Start(SWITCHUSERPERIOD);
//    m_switchUser = false;

//    if ( outputFile.Exists() )
//    {
//        outputFile.Open(_T("/tmp/syspend.out"));
//    }
//    else
//    {
//        outputFile.Create(_T("/tmp/syspend.out"));
//    }
//    outputFile.Clear();

    m_pSwitchAdapterThread = new SwitchAdapterThread(this);
    if ( m_pSwitchAdapterThread->Create() == wxTHREAD_NO_ERROR )
    {
        m_pSwitchAdapterThread->Run();
    }

    m_pGetCurAPThread = new GetCurAPThread(this);
    if ( m_pGetCurAPThread->Create() == wxTHREAD_NO_ERROR )
    {
        m_pGetCurAPThread->Run();
    }

    times = 0;
    m_killDhclientCount = 0;

}
bool DataCenterLinux::IfConnect()
{
    BOOL existWirelessAdalpter;
    DCS_IsExistAdapter(DCS_ADAPTER_WIREDLESS, &existWirelessAdalpter);
    if ( !existWirelessAdalpter )
    {
        return false;
    }
    ENM_String* IP = new ENM_String();
    memset(IP, 0, sizeof(ENM_String));
    DCS_GetIPAddressLAN(IP);
    string strIP((const char*)IP->dcsString);
    delete IP;
//    string strIP = GetIPAddressHLAN(m_UsingWirelessAdpterName, ENMUtil::WxStringToString(g_path));
    ENMUtil::Log(wxT("/tmp/ENMLog.txt"), wxT("ip is ") + wxString::FromUTF8(strIP.c_str()));
    if ( (strIP == "127.0.0.1") || (strIP.empty()) )
    {
        return false;
    }
    else
    {
        return true;
    }
//    sockfd = socket(PF_INET,SOCK_DGRAM,0);
//    strncpy(ifr.ifr_name,m_UsingWirelessAdpterName.c_str(),IFNAMSIZ);
//
//    if(ioctl(sockfd,SIOCGIFADDR,&ifr) == -1)
//    {
//        perror("ioctl error");
//        close(sockfd);
//        return false;
//    }
//    else
//    {
//        close(sockfd);
//        addr = (struct sockaddr_in *)&(ifr.ifr_addr);
//        address = inet_ntoa(addr->sin_addr);
//        if (address == NULL)
//        {
//            return false;
//        }
//        else
//        {
//            if (!strcmp(address, "127.0.0.1"))
//            {
//                return false;
//            }
//            else
//            {
//                return true;
//            }
//        }
//    }
}

void DataCenterLinux::OnAllocatorTimer(wxTimerEvent& event)
{
    ENMUtil::Log(logFile, _T("Enter DataCenterLinux::OnAllocatorTimer"));
    if ( m_LastNetworkMode == NETWORK_MODE_WIRED_LAN_CONNECT )
    {
        ENMUtil::Log(logFile, _T("Enter DataCenterLinux::OnAllocatorTimer--failure because wired connected"));
        times = 0;
        ENM_StringW* sDhclient = new ENM_StringW();
        memset(sDhclient, 0, sizeof(ENM_StringW));
        wcscpy((wchar_t*)sDhclient->dcsStringW, L"killall");
        DCS_ImportSchoolSettings(sDhclient);
        delete sDhclient;

        if( m_pAPStatus )
        {
            delete m_pAPStatus;
            m_pAPStatus = NULL;
            //UpdateCurrentAP(&m_pAPStatus->ssid, false);
        }

        WlanAcmEvent event(ID_WLAN_ACM_CONNECT, WLAN_ACM_EVENT_CONNECT_FAILED);

        if ( m_isApplyProfile )
        {
            ::wxPostEvent(this->GetProfileController(), event);
        }
        else
        {
            ::wxPostEvent(this->GetScanNetworkDlgHandle(), event);
        }

        m_AlllcatorTimer.Stop();
    }
    else
    {
        if ( times < 4 )
        {
            if ( IfWirelessLink() && IfConnect() )
            {
                ENMUtil::Log(logFile, _T("Enter DataCenterLinux::OnAllocatorTimer--success begin"));
                times = 0;
                WirelessSwitchEvent switchAPevent;
                if( m_pAPStatus != NULL )
                {
                    ENMUtil::Log(logFile, _T("Enter DataCenterLinux::OnAllocatorTimer--SetOldSsid begin"));
                    switchAPevent.SetOldSsid(m_pAPStatus->ssid);
                    ENMUtil::Log(logFile, _T("Enter DataCenterLinux::OnAllocatorTimer--SetOldSsid end"));
                }
                if( m_pAPStatus )
                {
                    DCS_GetCurrentAP(m_pAPStatus);
//                   SetSsid(*m_pAPStatus);
//                   m_pLinuxWlanScanner->UpdateCurrentAP(*m_pAPStatus);
    //                UpdateCurrentAP(&m_pAPStatus->ssid, true);
                }
                if( m_pAPStatus != NULL )
                {
                    switchAPevent.SetNewSsid(m_pAPStatus->ssid);
                    ::wxPostEvent(GetProfileController(), switchAPevent);
                    ::wxPostEvent(GetNetworkManagerDlgHandle(), switchAPevent);
                    ::wxPostEvent(ENMTaskTray::GetInstance(), switchAPevent);
                    UI_NETWORK_STATUS_INFO  statusInfo;
                    statusInfo.IPAddress = _T("");
                    statusInfo.SignalQuality = 0;
                    statusInfo.Type = _T("");
                    statusInfo = GetWirelessedUIInfo(*m_pAPStatus);
                    if( m_pNetworkManagerDlg )
                    {
                        m_pNetworkManagerDlg->UI_UpdateNetworkStatusInfo(NETWORK_MODE_WIRELESS_LAN_CONNECT, statusInfo);
                    }
                }
                WlanAcmEvent event(ID_WLAN_ACM_CONNECT, WLAN_ACM_EVENT_CONNECT_SUCCESS);
                if ( m_isApplyProfile )
                {
                    ENMUtil::Log(logFile, _T("Enter DataCenterLinux::OnAllocatorTimer--post event to profilecontroller begin"));
                    ::wxPostEvent(this->GetProfileController(), event);
                    ENMUtil::Log(logFile, _T("Enter DataCenterLinux::OnAllocatorTimer--post event to profilecontroller end"));
                }
                else
                {
                    ::wxPostEvent(this->GetScanNetworkDlgHandle(), event);
                }
                m_AlllcatorTimer.Stop();
                ENM_StringW* sDhclient = new ENM_StringW();
                memset(sDhclient, 0, sizeof(ENM_StringW));
                wcscpy((wchar_t*)sDhclient->dcsStringW, L"killall");
                DCS_ImportSchoolSettings(sDhclient);
                delete sDhclient;
//                StartGlobalTimer();
                ENMUtil::Log(logFile, _T("Enter DataCenterLinux::OnAllocatorTimer--success end"));
            }
            else
            {
                times++;
            }
        }
        else
        {
            ENMUtil::Log(logFile, _T("Enter DataCenterLinux::OnAllocatorTimer--failure begin"));
            times = 0;
            ENM_StringW* sDhclient = new ENM_StringW();
            memset(sDhclient, 0, sizeof(ENM_StringW));
            wcscpy((wchar_t*)sDhclient->dcsStringW, L"killall");
            DCS_ImportSchoolSettings(sDhclient);
            delete sDhclient;

            if( m_pAPStatus )
            {
                delete m_pAPStatus;
                m_pAPStatus = NULL;
                //UpdateCurrentAP(&m_pAPStatus->ssid, false);
            }

            WlanAcmEvent event(ID_WLAN_ACM_CONNECT, WLAN_ACM_EVENT_CONNECT_FAILED);

            if ( m_isApplyProfile )
            {
                ::wxPostEvent(this->GetProfileController(), event);
            }
            else
            {
                ::wxPostEvent(this->GetScanNetworkDlgHandle(), event);
            }

            m_AlllcatorTimer.Stop();
//            StartGlobalTimer();
            ENMUtil::Log(logFile, _T("Enter DataCenterLinux::OnAllocatorTimer--failure end"));
        }
        ENMUtil::Log(logFile, _T("Leave DataCenterLinux::OnAllocatorTimer"));
    }

}
string DataCenterLinux::GetIPAddressHLAN(const string adapterName, const string userPath)
{
//    char cOrder[ORDERBUFSIZE];
//    sprintf(cOrder, "ifconfig %s > ~/ifc.txt", adapterName.c_str());
//    system(cOrder);
//    ifstream in;
//    string sPath = userPath + "/ifc.txt";
//    const char* cFileName = sPath.c_str();
//    in.open(cFileName,ios_base::in);
//    char cFileBuf[1024];
//    wxString IP;
//    while(in.getline(cFileBuf, sizeof(cFileBuf)))
//    {
//        wxString content = wxString::FromUTF8(cFileBuf);
//        if ((int) content.find(wxT("inet addr:")) > 0)
//        {
//            size_t posBegin = content.Find(wxT("inet addr:")) + 10;
//            size_t posEnd = content.Find(wxT("Bcast:")) - 1;
//            int len = posEnd - posBegin;
//            IP = content.Mid(posBegin, len);
//            break;
//        }
//    }
//    in.close();

    ENM_String* EnmIP = new ENM_String();
    memset(EnmIP, 0, sizeof(ENM_String));
    DCS_GetIPAddressLAN(EnmIP);
    wxString IP = ENMUtil::StringToWxString(string((const char*)EnmIP->dcsString));
    delete EnmIP;
	if ( !IP.Cmp(_T("127.0.0.1")) )
    {
        IP = _("Acquiring Network Address");
    }

    return ENMUtil::WxStringToString(IP);

}

wxString DataCenterLinux::GetConnectTypeHLAN()
{
    wxString strLan = GetConnectTypeHLAN(m_UsingWiredAdpterName, ENMUtil::WxStringToString(g_path));
//    ENMUtil::Log(logFile, _T("GetConnectTypeHLAN()")+strLan);
//    if ( strLan == _T("Wired LAN - 10Mbps") || strLan == _T("Wired LAN - 10Mb/s") )
//    {
//        strLan = _("Wired LAN - 10Mbps");
//    }
//    else
//    {
//        strLan = _("Wired LAN - 100Mbps");
//    }
//    ENMUtil::Log(logFile, _T("GetConnectTypeHLAN()")+strLan);
    return strLan;
}

wxString DataCenterLinux::GetConnectTypeHLAN(const string adapterName, const string userPath)
{
//    char cOrder[ORDERBUFSIZE];
//    sprintf(cOrder, "ethtool %s > ~/eth.txt", adapterName.c_str());
//    system(cOrder);
//    ifstream in;
//    string sPath = userPath + "/eth.txt";
//    const char* cFileName = sPath.c_str();
//    in.open(cFileName,ios_base::in);
//    char cFileBuf[1024];
//    wxString speed;
//    string strType;
//    while(in.getline(cFileBuf, sizeof(cFileBuf)))
//    {
//        wxString content = wxString::FromUTF8(cFileBuf);
//        if ((int) content.find(wxT("Speed:")) > 0)
//        {
//            size_t posBegin = content.Find(wxT("Speed:")) + 7;
//            speed = content.Mid(posBegin);
//            strType = "Wired LAN -" + ENMUtil::WxStringToString(speed);
//            break;
//        }
//    }
//    in.close();

    ENM_String* type = new ENM_String();
    memset(type, 0, sizeof(ENM_String));
    DCS_GetConnectTypeLAN(type);
    string strType((const char*)type->dcsString);
    wxString LANTpye;
    if ( strType == "Wired LAN - 10Mbps" || strType == "Wired LAN - 10Mb/s" )
    {
        LANTpye = _("Wired LAN - 10Mbps");
    }
    else
    {
        LANTpye = _("Wired LAN - 100Mbps");
    }
    return LANTpye;
}

void DataCenterLinux::DestroyData()
{

    m_NetStatusTimer.Stop();

    if ( NULL !=  m_pNetworkInfo )
    {
         delete m_pNetworkInfo ;
         m_pNetworkInfo = NULL;
    }

    if ( NULL !=  m_pCurrentWiredStatus )
    {
         delete m_pCurrentWiredStatus ;
         m_pCurrentWiredStatus = NULL;
    }

    if ( NULL !=  m_pLinuxWlanScanner )
    {
         delete m_pLinuxWlanScanner ;
         m_pLinuxWlanScanner = NULL;
    }

    if ( NULL !=  m_pSsid )
    {
         delete m_pSsid ;
         m_pSsid = NULL;
    }

}

void DataCenterLinux::CreateNetTools()
{
    if ( NULL == m_pNetworkInfo )
    {
        m_pNetworkInfo = new NETWORK_INFO();
    }

    if ( NULL == m_pCurrentWiredStatus )
    {
        m_pCurrentWiredStatus = new NETWORK_WIRED_STATUS_INFO();
    }

    if ( NULL == m_pLinuxWlanScanner )
    {
        m_pLinuxWlanScanner = new WirelessScanner();
    }

}

void DataCenterLinux::ReadNetworkStatus()
{
    GetNetInfo();

//    bool wiredAdapterIsUp = IfUp(ADAPTER_WIRED);
//
//    if ( !wiredAdapterIsUp )
//    {
//        m_pNetworkInfo->isWiredLANEnabled = false;
//    }
//    else
//    {
//        m_pNetworkInfo->isWiredLANEnabled = true;
//    }
//
//    bool wirelessAdapterIsUp = IfUp(ADAPTER_WIREDLESS);
//
//    if ( !wirelessAdapterIsUp )
//    {
//        m_pNetworkInfo->isWirelessEnabled = false;
//    }
//    else
//    {
//        m_pNetworkInfo->isWirelessEnabled = true;
//    }
//
//    if ( m_pNetworkInfo->isWiredLANEnabled )
//    {
//        m_pNetworkInfo->isWiredLANConnected = IfLink(ADAPTER_WIRED, m_UsingWiredAdpterName);
//    }
//    else
//    {
//        m_pNetworkInfo->isWiredLANConnected = false;
//    }
//
//    if ( m_pNetworkInfo->isWirelessEnabled )
//    {
//        m_pNetworkInfo->isWirelessConnected = IfLink(ADAPTER_WIREDLESS, m_UsingWirelessAdpterName);
//    }
//    else
//    {
//        m_pNetworkInfo->isWirelessConnected = false;
//    }
//
//    SetCurrentNetworkMode(*m_pNetworkInfo);

    if ( m_LastNetworkMode == NETWORK_MODE_DEFAULT )
    {
        BOOL IfWiredEnable;
        DCS_GetLANStatus(&IfWiredEnable);
        if ( IfWiredEnable )
        {
            m_LanIsEnable = true;
        }
        else
        {
            m_LanIsEnable = false;
        }
        BOOL IfWirelessEnable;
        DCS_GetWirelessStatus(&IfWirelessEnable);
        if ( IfWirelessEnable )
        {
            m_WlanIsEnable = true;
        }
        else
        {
            m_WlanIsEnable = false;
        }
    }

    if ( m_LanIsEnable )
    {
//        ENMUtil::Log(logFile, _T("in ReadNetworkStatus::wired enabled"));
        m_pNetworkInfo->isWiredLANEnabled = IfUp(ADAPTER_WIRED);
        if ( m_pNetworkInfo->isWiredLANEnabled )
        {
            m_pNetworkInfo->isWiredLANConnected = IfLink(ADAPTER_WIRED, m_UsingWiredAdpterName);
        }
        else
        {
            m_pNetworkInfo->isWiredLANConnected = false;
        }
    }
    else
    {
//        ENMUtil::Log(logFile, _T("in ReadNetworkStatus::wired disabled"));
        m_pNetworkInfo->isWiredLANEnabled = false;
        m_pNetworkInfo->isWiredLANConnected = false;
    }

    if ( m_WlanIsEnable )
    {
//        ENMUtil::Log(logFile, _T("in ReadNetworkStatus::wireless enabled"));
        m_pNetworkInfo->isWirelessEnabled = IfUp(ADAPTER_WIREDLESS);
        if ( m_pNetworkInfo->isWirelessEnabled )
        {
            m_pNetworkInfo->isWirelessConnected = IfLink(ADAPTER_WIREDLESS, m_UsingWirelessAdpterName);
        }
        else
        {
            m_pNetworkInfo->isWirelessConnected = false;
        }
    }
    else
    {
//        ENMUtil::Log(logFile, _T("in ReadNetworkStatus::wireless disabled"));
        m_pNetworkInfo->isWirelessEnabled = false;
        m_pNetworkInfo->isWirelessConnected = false;
    }

    SetCurrentNetworkMode(*m_pNetworkInfo);
}

bool DataCenterLinux::EnableConnection(wxString wszName, bool bEnable)
{
    bool result = false;

    return result;
}
void DataCenterLinux::OnReadNetworkStatusTimer(wxTimerEvent& event)
{
    ReadNetworkStatus();
}
void DataCenterLinux::OnScanTimer(wxTimerEvent& event)
{
//    WlanResult result = DataCenterLinux::SearchAP();

    //UpdateUI

//    if ( m_pScanNetworkDlg )
//        m_pScanNetworkDlg->UI_UpdateAPSatus(result,GetAPList());
}

//wxString DataCenterLinux::GetIPAddressHLAN()
//{
//    struct ifreq* pIfr = m_wiredInfo.GetIfr();
//    return m_wiredInfo.GetAddress(pIfr);
//
//}
//
//wxString DataCenterLinux::GetConnectTypeHLAN()
//{
//    wxString strNetSpeed = wxT("");
//
//    struct ifreq* pIfr = NULL;
//    if( m_pNetworkInfo->isWiredLANConnected )
//    {
//        pIfr = m_wiredInfo.GetIfr();
//
//        strNetSpeed = m_wiredInfo.GetSpeed(pIfr);
//
//    }
//    else{}
//
//    wxString strWiredType = strNetSpeed;
//
//    return strWiredType;
//
//}

NETWORK_MODE DataCenterLinux::GetCurrentNetworkMode()
{
    return m_CurrentNetworkMode;
}

void DataCenterLinux::SetMeshFlag(bool bMeshFlag)
{
    m_pNetworkInfo->isMeshEnable = bMeshFlag;
}

bool DataCenterLinux::GetMeshFlag()
{
    return m_pNetworkInfo->isMeshEnable;
}
void DataCenterLinux::SetNetworkMode(NETWORK_MODE networkmode)
{
    m_LastNetworkMode = NETWORK_MODE_MESH_CONNECT;
    m_CurrentNetworkMode = networkmode;
}

NETWORK_MODE DataCenterLinux::GetLastNetworkMode()
{
    return m_LastNetworkMode;
}

void DataCenterLinux::UpdateCurrentUI(const UI_NETWORK_STATUS_INFO& status)
{
    if( m_pNetworkManagerDlg )
    {
        m_pNetworkManagerDlg->UI_UpdateNetworkStatusInfo(m_CurrentNetworkMode, status);
    }

    ENMTaskTray::GetInstance()->SetTaskbarIcon(m_CurrentNetworkMode, status);
    //Update UI network status
    if( m_LastNetworkMode != m_CurrentNetworkMode || m_CurrentNetworkMode == NETWORK_MODE_DISCONNECTED)
    {
        GetProfileController()->NotifyModeChanged(m_CurrentNetworkMode);
        if ( m_pNetworkManagerDlg )
        {
            m_pNetworkManagerDlg->UI_UpdateNetworkMode(m_CurrentNetworkMode);
        }
    }
    if(m_CurrentNetworkMode == NETWORK_MODE_MESH_CONNECT )
    {
        GetProfileController()->NotifyModeChanged(m_CurrentNetworkMode);

        if ( m_pNetworkManagerDlg )
        {
            m_pNetworkManagerDlg->UI_UpdateNetworkMode(m_CurrentNetworkMode);
        }
    }
    if ( m_CurrentNetworkMode == NETWORK_MODE_WIRED_LAN_DISCONNECT && m_pAPStatus != NULL )
    {
        if ( m_pAPStatus != NULL )
        {
            delete m_pAPStatus;
            m_pAPStatus = NULL;
        }
    }

}

void DataCenterLinux::SetCurrentNetworkMode(NETWORK_INFO& networkInfo)
{
//    ENMUtil::Log(logFile, _T("Enter DataCenterWindows::SetCurrentNetworkMode"));
    UI_NETWORK_STATUS_INFO statusInfo = ChangeCurrentNetworkMode(networkInfo);
    if ( ::wxGetApp().m_nMeshStatus == MESHSTATUS_MESHSERVER )
    {
        statusInfo.IPAddress = _T("");
        statusInfo.SignalQuality = 0;
        statusInfo.Type = _T("");
        if ( networkInfo.isWirelessConnected )// Wireless connected
        {
            if ( !IfWirelessLink() )
            {
                CloseWlanConnection();

                return;
            }
            ::wxGetApp().m_MeshpopBalloon = true;
            if ( m_pAPStatus == NULL )
            {
                m_pAPStatus = new APStatus() ;
                DCS_GetCurrentAP(m_pAPStatus);
            }
            else
            {
                statusInfo = GetWirelessedUIInfo(*m_pAPStatus);
                system("iwconfig ra0 > /tmp/iwconfig.out");
                wxTextFile tf;
                tf.Open(_T("/tmp/iwconfig.out"));
                wxString str;
                for ( str = tf.GetLastLine(); tf.GetCurrentLine() > 0; str = tf.GetPrevLine() )
                {
                    if ( str.Find(_T("Link Quality")) != wxNOT_FOUND )
                    {
                        wxString quality = str.Mid(str.Find(_T("=")) + 1, str.Find(_T("/")) - str.Find(_T("=")) - 1);
                        long qual;
                        if ( quality.ToLong(&qual) )
                        {
                            statusInfo.SignalQuality = (int)qual;
                            if ( m_pAPStatus )
                            {
                                m_pAPStatus->signalQuality = (int)qual;
                            }
                        }
                        break;
                    }
                }
                tf.Close();
                system("rm /tmp/iwconfig.out");
            }
        }
        if ( networkInfo.isWiredLANConnected )
        {
            if ( !MeshInfoManager::GetInstance()->IsAdapterConnect(DCS_ADAPTER_WIRED))
            {
                return;
            }
            ::wxGetApp().m_MeshpopBalloon = true;
            m_wiredIP = GetIPAddressHLAN(m_UsingWiredAdpterName, ENMUtil::WxStringToString(g_path));
            m_pCurrentWiredStatus->IPAddress = ENMUtil::StringToWxString(m_wiredIP);
            m_pCurrentWiredStatus->Type = GetConnectTypeHLAN(m_UsingWiredAdpterName, ENMUtil::WxStringToString(g_path)).c_str();
            statusInfo = GetWiredUIInfo(*m_pCurrentWiredStatus);
        }


    }
    UpdateCurrentUI(statusInfo);
    m_LastNetworkMode = m_CurrentNetworkMode;
//    ENMUtil::Log(logFile, _T("Return DataCenterWindows::SetCurrentNetworkMode\n"));

}

UI_NETWORK_STATUS_INFO DataCenterLinux::ChangeCurrentNetworkMode(const NETWORK_INFO& networkInfo)
{
    bool bWiredEnable = networkInfo.isWiredLANEnabled;
    bool bWirelessEnable = networkInfo.isWirelessEnabled;
    bool bWiredConnected = networkInfo.isWiredLANConnected;
    bool bWirelessConnected = networkInfo.isWirelessConnected;
    printf(" Current network mode: wired able %d, wireless able %d,  wired connect %d, wireless connect %d \n", bWiredEnable, bWirelessEnable, bWiredConnected, bWirelessConnected);

    bool bMeshEnable = (::wxGetApp().m_nMeshStatus != MESHSTATUS_MESHCLOSE);//m_pNetworkInfo->isMeshEnable;

    UI_NETWORK_STATUS_INFO  statusInfo;
    statusInfo.IPAddress = _T("");
    statusInfo.SignalQuality = 0;
    statusInfo.Type = _T("");
    m_bIgnorePolicy = bWiredConnected;

     if (bMeshEnable) //bMeshEnable ( bWiredEnable && bWirelessEnable )
    {

        statusInfo = GetMeshUIInfo();

        if ( ::wxGetApp().m_nMeshStatus == MESHSTATUS_MESHONLY ||
            ::wxGetApp().m_nMeshStatus == MESHSTATUS_MESHCLIENT)
        {
            GetProfileController()->NotifyModeChanged(NETWORK_MODE_DISCONNECTED);
        }
        m_CurrentNetworkMode = NETWORK_MODE_MESH_CONNECT;
        return statusInfo;
    }


    if ( bWirelessConnected )
    {
        if ( !IfWirelessLink() )
        {
            CloseWlanConnection();
        }
        else
        {
            if ( m_pAPStatus == NULL )
            {
                m_pAPStatus = new APStatus() ;
                DCS_GetCurrentAP(m_pAPStatus);
            }
            else
            {
                statusInfo = GetWirelessedUIInfo(*m_pAPStatus);
                system("iwconfig ra0 > /tmp/iwconfig.out");
                wxTextFile tf;
                tf.Open(_T("/tmp/iwconfig.out"));
                wxString str;
                for ( str = tf.GetLastLine(); tf.GetCurrentLine() > 0; str = tf.GetPrevLine() )
                {
                    if ( str.Find(_T("Link Quality")) != wxNOT_FOUND )
                    {
                        wxString quality = str.Mid(str.Find(_T("=")) + 1, str.Find(_T("/")) - str.Find(_T("=")) - 1);
                        long qual;
                        if ( quality.ToLong(&qual) )
                        {
                            statusInfo.SignalQuality = (int)qual;
                            if ( m_pAPStatus )
                            {
                                m_pAPStatus->signalQuality = (int)qual;
                            }
                        }
                        break;
                    }
                }
                tf.Close();
                system("rm /tmp/iwconfig.out");
            }
        }

    }

    if ( bWiredConnected )
    {
        StartupInterface(ADAPTER_WIRED);
        m_wiredIP = GetIPAddressHLAN(m_UsingWiredAdpterName, ENMUtil::WxStringToString(g_path));
        m_pCurrentWiredStatus->IPAddress = ENMUtil::StringToWxString(m_wiredIP);
        if ( m_pCurrentWiredStatus->IPAddress.IsEmpty() && !DataCenter::GetInstance()->GetProfileController()->GetStaticFlag() )
        {
            if ( m_VerifyWiredConnected == 0 )
            {
                ENM_StringW* sDhclient = new ENM_StringW();
                memset(sDhclient, 0, sizeof(ENM_StringW));
                wcscpy((wchar_t*)sDhclient->dcsStringW, L"dhclient");
                DCS_ImportSchoolSettings(sDhclient);
                delete sDhclient;
            }
            m_VerifyWiredConnected++;
            m_VerifyDisableWireless = 0;
        }
        else
        {
            ENM_StringW* sDhclient = new ENM_StringW();
            memset(sDhclient, 0, sizeof(ENM_StringW));
            wcscpy((wchar_t*)sDhclient->dcsStringW, L"killall");
            DCS_ImportSchoolSettings(sDhclient);
            delete sDhclient;

            ShutdownInterface(ADAPTER_WIREDLESS);
            StartupInterface(ADAPTER_WIRED);

            m_VerifyWiredConnected = 0;
            if ( m_pAPStatus )
            {
                delete m_pAPStatus;
                m_pAPStatus = NULL;
            }

            m_CurrentNetworkMode = NETWORK_MODE_WIRED_LAN_CONNECT;
            ENMTaskTray* pTaskTray = ENMTaskTray::GetInstance();
            if ( !pTaskTray->GetApplyWirelessFlag() )
            {
                pTaskTray->StopApplyWirelessDlg();
            }

            if ( bWirelessEnable )
            {
                if ( m_VerifyDisableWireless == 1 )
                {
                    ShutdownInterface(ADAPTER_WIREDLESS);
                    m_VerifyDisableWireless = 0;

                    if ( m_pAPStatus != NULL )
                    {
                        delete m_pAPStatus;
                        m_pAPStatus = NULL;
                    }
                }
                else
                {
                    m_VerifyDisableWireless++;
                }
            }
            m_wiredIP = GetIPAddressHLAN(m_UsingWiredAdpterName, ENMUtil::WxStringToString(g_path));
            m_pCurrentWiredStatus->IPAddress = ENMUtil::StringToWxString(m_wiredIP);
            m_pCurrentWiredStatus->Type = GetConnectTypeHLAN(m_UsingWiredAdpterName, ENMUtil::WxStringToString(g_path)).c_str();
            statusInfo = GetWiredUIInfo(*m_pCurrentWiredStatus);
        }
    }

    if ( m_VerifyWiredConnected < 3 && m_VerifyWiredConnected > 0 )
    {
        if ( !bWirelessEnable )
        {
            StartupInterface(ADAPTER_WIRED);
            m_CurrentNetworkMode = NETWORK_MODE_WIRED_LAN_CONNECT;
            ENMTaskTray* pTaskTray = ENMTaskTray::GetInstance();
            if ( !pTaskTray->GetApplyWirelessFlag() )
            {
                m_pProfileController->StopApplying();
                pTaskTray->StopApplyWirelessDlg();
            }
            m_wiredIP = GetIPAddressHLAN(m_UsingWiredAdpterName, ENMUtil::WxStringToString(g_path));
            m_pCurrentWiredStatus->IPAddress = ENMUtil::StringToWxString(m_wiredIP);
            m_pCurrentWiredStatus->Type = GetConnectTypeHLAN(m_UsingWiredAdpterName, ENMUtil::WxStringToString(g_path)).c_str();
            statusInfo = GetWiredUIInfo(*m_pCurrentWiredStatus);
        }

        if ( bWirelessEnable && bWirelessConnected )
        {
            StartupInterface(ADAPTER_WIREDLESS);
            m_CurrentNetworkMode = NETWORK_MODE_WIRELESS_LAN_CONNECT;
            if( !m_pAPStatus)
            {
                m_pAPStatus = new APStatus() ;
            }
//            GetCurAPParameter();
            if ( m_pAPStatus != NULL )
            {
//                statusInfo = GetWirelessedUIInfo(*m_pAPStatus);
            }
        }

        if ( bWirelessEnable && !bWirelessConnected )
        {
            StartupInterface(ADAPTER_WIREDLESS);
            m_CurrentNetworkMode = NETWORK_MODE_WIRELESS_LAN_DISCONNECT;
        }
    }

    if ( !bWiredConnected || (bWiredConnected && m_VerifyWiredConnected >= 3) )
    {
        if ( m_VerifyWiredConnected >= 3 )
        {
            if ( ENMTaskTray::GetInstance()->GetApplyWirelessFlag() )
            {
                ENM_StringW* sDhclient = new ENM_StringW();
                memset(sDhclient, 0, sizeof(ENM_StringW));
                wcscpy((wchar_t*)sDhclient->dcsStringW, L"killall");
                DCS_ImportSchoolSettings(sDhclient);
                delete sDhclient;
            }

            m_VerifyWiredConnected = 0;
        }

        if ( !bWirelessEnable )
        {
            StartupInterface(ADAPTER_WIRED);
            m_CurrentNetworkMode = NETWORK_MODE_WIRED_LAN_DISCONNECT;
        }
        else if ( bWirelessConnected )
        {
            StartupInterface(ADAPTER_WIREDLESS);
            m_CurrentNetworkMode = NETWORK_MODE_WIRELESS_LAN_CONNECT;
            if( !m_pAPStatus)
            {
                m_pAPStatus = new APStatus() ;
            }
//            GetCurAPParameter();
            if ( m_pAPStatus != NULL )
            {
//                statusInfo = GetWirelessedUIInfo(*m_pAPStatus);
            }
        }
        else
        {
//            StartupInterface(ADAPTER_WIREDLESS);
            SwitchAdapterParameter(ADAPTER_TYPE(0),ADAPTER_WIREDLESS,NULL);
            m_CurrentNetworkMode = NETWORK_MODE_WIRELESS_LAN_DISCONNECT;
        }

        if ( m_LastNetworkMode == NETWORK_MODE_WIRED_LAN_CONNECT && !m_pNetworkManagerDlg->IsApplyingProfile() )
        {
//            StartupInterface(ADAPTER_WIREDLESS);
            SwitchAdapterParameter(ADAPTER_TYPE(0),ADAPTER_WIREDLESS,NULL);
        }
    }

    if ( IsInterfaceEnabled(ADAPTER_WIREDLESS) && (m_LastNetworkMode == NETWORK_MODE_WIRED_LAN_DISCONNECT || m_LastNetworkMode ==NETWORK_MODE_MESH_CONNECT ))
    {
        StartupInterface(ADAPTER_WIREDLESS);
        if ( !GetNetworkManagerDlgHandle()->IsApplyingProfile() && !GetScanNetworkDlgHandle()->IsShown() )
        {
            ENMTaskTray::GetInstance()->SetApplyWirelessFlag(false);
            ENMTaskTray::GetInstance()->ApplyWirelessProfile();
        }
    }

    return statusInfo;
}

WlanResult DataCenterLinux::BeginSearchAP()
{
    if( !m_pScanThread)
    {
        delete m_pScanThread;
        m_pScanThread = NULL ;
    }

    m_pScanThread = new ScanThread(this);
    if ( m_pScanThread->Create() == wxTHREAD_NO_ERROR )
    {
        m_pScanThread->Run();
        return WLAN_SUCCESS;
    }
    else
    {
        return WLAN_ERROR;
    }
}
void DataCenterLinux::SearchAP(ScanEvent& event)
{
    if ( m_apList.nCount != 0 )
    {
        if ( m_pScanNetworkDlg )
        {
            m_pScanNetworkDlg->UI_UpdateAPSatus(WLAN_SUCCESS, m_apList);
        }
    }
}
const APStatus* DataCenterLinux::GetAPStatusFromList(size_t iIndex)
{
//    if( iIndex >=0 && iIndex < m_apList.nCount )
//        return &m_apList.apList[iIndex];
//    else
//        return NULL;
    assert(false);
}
const AccessPointList& DataCenterLinux::GetAPList()
{
//     return m_apList ;
    assert(false);
}
void DataCenterLinux::UpdateCurrentAP(const  WlanSsid* pSsid, bool connected)
{
//   if(connected)
//   {
//       if( !m_pAPStatus)
//         m_pAPStatus = new APStatus() ;
//
//       m_pAPStatus->ssid =  *pSsid ;
//
//        if( m_pLinuxWlanScanner )
//        {
//            m_pLinuxWlanScanner->UpdateCurrentAP(*m_pAPStatus);
//        }
//
//   }
//   else
//   {
//       delete m_pAPStatus;
//       m_pAPStatus = NULL ;
//   }
}
UI_NETWORK_STATUS_INFO DataCenterLinux::GetWirelessedUIInfo(APStatus& apStatus)
{

    UI_NETWORK_STATUS_INFO  uiNetworkStatusInfo;

    //wxString strMac = MacAddressToString(m_apStatus->macAddress);
    uiNetworkStatusInfo.SignalQuality = apStatus.signalQuality;

    switch(apStatus.type)
    {
    case WLAN_802_11_B:
        uiNetworkStatusInfo.Type = _("Wireless LAN - 802.11b - 11 Mbps");
        break;
    case WLAN_802_11_G:
        uiNetworkStatusInfo.Type = _("Wireless LAN - 802.11g - 54 Mbps");
        break;
    case WLAN_802_11_N:
        uiNetworkStatusInfo.Type = _("Wireless LAN - 802.11n - 108 Mbps");
        break;
    default:
        break;
    }
    uiNetworkStatusInfo.IPAddress = ENMUtil::StringToWxString(GetIPAddressHLAN(m_UsingWirelessAdpterName, ENMUtil::WxStringToString(g_path)));
    return uiNetworkStatusInfo;
}

UI_NETWORK_STATUS_INFO DataCenterLinux::GetMeshUIInfo()
{
    // signalQuality
    // type
    // IPAddress
    UI_NETWORK_STATUS_INFO  uiNetworkStatusInfo;

    uiNetworkStatusInfo.SignalQuality = 0;

    switch(::wxGetApp().m_nMeshStatus)
    {
        case  MESHSTATUS_MESHCLOSE:
        uiNetworkStatusInfo.Type = wxT("Mesh Off");
        break;
        case MESHSTATUS_MESHONLY:
        uiNetworkStatusInfo.Type = wxT("Mesh Only");
        break;
        case MESHSTATUS_MESHSERVER:
        uiNetworkStatusInfo.Type = wxT("Mesh Server");
        break;
        case MESHSTATUS_MESHCLIENT:
        uiNetworkStatusInfo.Type = wxT("Mesh Client");
        break;
        default:
        uiNetworkStatusInfo.Type = wxT("Mesh Only");
        break;
    }

    char cIP[33] = {'\0'};
    int iResult =  GetMeshIp("mesh0", cIP);
//    if ( 0 < iResult )
//    {
        wxString wxIP(cIP, wxConvUTF8);
        uiNetworkStatusInfo.IPAddress = wxIP;
//    }
    printf("iReuslt = %d", iResult);
    printf("meshIP = %s", cIP);

    return uiNetworkStatusInfo;
}

UI_NETWORK_STATUS_INFO DataCenterLinux::GetWiredUIInfo( NETWORK_WIRED_STATUS_INFO& wiredStatus)
{

    UI_NETWORK_STATUS_INFO  uiNetworkStatusInfo;

    uiNetworkStatusInfo.SignalQuality = -1;
    uiNetworkStatusInfo.IPAddress = wiredStatus.IPAddress;
    uiNetworkStatusInfo.Type = wiredStatus.Type;

    return uiNetworkStatusInfo;
}
bool DataCenterLinux::EnableNetworkAdapter(ADAPTER_TYPE adapterType,bool bEnable)
{
    BOOL existUpAdapter;
    if ( bEnable )
    {
        if ( adapterType == ADAPTER_WIRED )
        {
            DCS_UpAdapter(DCS_ADAPTER_WIRED);
            DCS_IsExistUpAdapter(DCS_ADAPTER_WIRED, &existUpAdapter);
        }
        else
        {
            DCS_UpAdapter(DCS_ADAPTER_WIREDLESS);
            DCS_IsExistUpAdapter(DCS_ADAPTER_WIREDLESS, &existUpAdapter);
        }

        if ( existUpAdapter )
        {
            return true;
        }
        else
        {
            return false;
        }
    }
    else
    {
        if ( adapterType == ADAPTER_WIRED )
        {
            DCS_DownAdapter(DCS_ADAPTER_WIRED);
            DCS_IsExistUpAdapter(DCS_ADAPTER_WIRED, &existUpAdapter);
        }
        else
        {
            DCS_DownAdapter(DCS_ADAPTER_WIREDLESS);
            DCS_IsExistUpAdapter(DCS_ADAPTER_WIREDLESS, &existUpAdapter);
        }

        if ( !existUpAdapter )
        {
            return true;
        }
        else
        {
            return false;
        }
    }
//    if ( bEnable )
//    {
//        if ( adapterType == ADAPTER_WIRED )
//        {
//            m_UsingWiredAdpterName = StartupInterface(m_asWiredInterface);
//            if ( m_UsingWiredAdpterName == "" )
//            {
//                return false;
//            }
//            else
//            {
//                return true;
//            }
//        }
//        else
//        {
//            m_UsingWirelessAdpterName = StartupInterface(m_asWirelessInterface);
//            if ( m_UsingWirelessAdpterName == "" )
//            {
//                return false;
//            }
//            else
//            {
//                return true;
//            }
//        }
//
//
//
//    }
//    else
//    {
//        wxArrayString interfaceList;
//        if ( adapterType == ADAPTER_WIRED )
//        {
//            interfaceList = m_asWiredInterface;
//        }
//        else
//        {
//            interfaceList = m_asWirelessInterface;
//        }
//
//        return ShutdownInterface(interfaceList);
//    }
}
WlanResult DataCenterLinux::ConnectWlanNetwork(const APStatus& apStatus, wxString key, int keyIdx, bool applyProfile)
{
//    if ( NULL != m_pAPStatus )
//    {
//       delete m_pAPStatus;
//       m_pAPStatus = NULL ;
//    }
//    if ( IfUp(ADAPTER_WIRED) )
//    {
//        WlanAcmEvent event(ID_WLAN_ACM_CONNECT, WLAN_ACM_EVENT_CONNECT_FAILED);
//        if ( applyProfile )
//        {
//            ::wxPostEvent(this->GetProfileController(), event);
//        }
//        return WLAN_CONNECTION_ERROR;
//    }
    ENMUtil::Log(logFile, _T("Enter DataCenterLinux::ConnectWlanNetwork"));
    m_isApplyProfile = applyProfile;
//    StopGlobalTimer();
    memset(&m_connectInfo, 0 ,sizeof(ENM_ConnectAP));
    strcpy((char* )m_connectInfo.key.dcsString, ENMUtil::WxStringToString(key).c_str());
    memcpy((char* )m_connectInfo.ssid.dcsString, (const char*)apStatus.ssid.ucSsid, 32);
    m_connectInfo.auth = (keyIdx << 16) | apStatus.auth;
//    m_connectInfo.auth = apStatus.auth;

    ConnectAPThread *pGetCurAPThread = new ConnectAPThread(this);
    if ( pGetCurAPThread->Create() == wxTHREAD_NO_ERROR )
    {
        pGetCurAPThread->Run();
    }

//    wxLongLong wxLongBegin = ::wxGetLocalTimeMillis();
//    DCS_ConnectAP(m_connectInfo);
//    wxLongLong wxLongEnd = ::wxGetLocalTimeMillis();
//    ENMUtil::Log(::wxGetHomeDir() + wxT("/log.txt"), wxString::Format(wxT("connect AP need %d\n"), (wxLongEnd - wxLongBegin).ToLong()));
    if( !m_pAPStatus)
         m_pAPStatus = new APStatus() ;

//    *m_pAPStatus = apStatus;
    switch(apStatus.auth)
    {
        case WLAN_AUTH_WPAPSK_TKIP:
        case WLAN_AUTH_WPAPSK_AES :
        case WLAN_AUTH_WPA2PSK_TKIP:
        case WLAN_AUTH_WPA2PSK_AES:
        {
            ENMUtil::Log(logFile, _T("In DataCenterLinux::connect to AP with WPA password"));
//            m_WpaTimer.Start(WPA_DELAY, wxTIMER_ONE_SHOT);
            m_AlllcatorTimer.Start(ALLOCATE_TIMERINTERVAL);
        }
        break;
        case WLAN_AUTH_OPEN_WEP:
        {
            ENMUtil::Log(logFile, _T("In DataCenterLinux::connect to AP with WEP password"));
            m_AlllcatorTimer.Start(ALLOCATE_TIMERINTERVAL);
        }
        break;
        default:
        {
            ENMUtil::Log(logFile, _T("In DataCenterLinux::connect to AP without password"));
            m_AlllcatorTimer.Start(ALLOCATE_TIMERINTERVAL);
        }
        break;
    }
    ENMUtil::Log(logFile, _T("Leave DataCenterLinux::ConnectWlanNetwork"));
    return WLAN_SUCCESS;
}

void DataCenterLinux::OnWpaTimer(wxTimerEvent& event)
{
    ENMUtil::Log(logFile, _T("Enter DataCenterLinux::OnWpaTimer"));
    ENM_NEIGHBORS_INFO NeighbInfo;
    DCS_GetNeighborInfo(&NeighbInfo);
    wxSleep(2);
    if ( ParseWpaFile() )
    {
//        DCS_AllocateDhIP();
        ENM_StringW* sDhclient = new ENM_StringW();
        memset(sDhclient, 0, sizeof(ENM_StringW));
        wcscpy((wchar_t*)sDhclient->dcsStringW, L"connect");
        DCS_ImportSchoolSettings(sDhclient);
        delete sDhclient;
        m_AlllcatorTimer.Start(ALLOCATE_TIMERINTERVAL);
    }
    else
    {
        ENM_StringW* sDhclient = new ENM_StringW();
        memset(sDhclient, 0, sizeof(ENM_StringW));
        wcscpy((wchar_t*)sDhclient->dcsStringW, L"disconnect");
        DCS_ImportSchoolSettings(sDhclient);
        delete sDhclient;
        wxSleep(6);
        if( m_pAPStatus )
        {
            delete m_pAPStatus;
            m_pAPStatus = NULL;
        }

        WlanAcmEvent event(ID_WLAN_ACM_CONNECT, WLAN_ACM_EVENT_CONNECT_FAILED);

        if ( m_isApplyProfile )
        {
            ::wxPostEvent(this->GetProfileController(), event);
        }
        else
        {
            ::wxPostEvent(this->GetScanNetworkDlgHandle(), event);
        }

//        StartGlobalTimer();
    }
    ENMUtil::Log(logFile, _T("Leave DataCenterLinux::OnWpaTimer"));
}

void DataCenterLinux::OnSusPendTimer(wxTimerEvent& event)
{
//    ENMUtil::Log(logFile, _T("Enter OnSusPendTimer-->") + home);
//    if ( wxFile::Exists(home + _T("/suspend")) )
    if ( wxFile::Exists(_T("/tmp/.suspend")) )
    {
        ENMUtil::Log(logFile, _T("Enter OnSusPendTimer-->suspend"));
        StopGlobalTimer();
        ENMUtil::Log(logFile, _T("Enter OnSusPendTimer-->suspend:stop timer"));
//        string removeFile = "rm " + ENMUtil::WxStringToString(home) + "/suspend";
//        string removeFile = "rm /tmp/suspend";
//        system(removeFile.c_str());
        ENM_StringW sRmSuspend;
        memset(&sRmSuspend, 0, sizeof(ENM_StringW));
        wcscpy((wchar_t*)sRmSuspend.dcsStringW, L"rmSuspend");
        DCS_Return_Code ret = DCS_ImportSchoolSettings(&sRmSuspend);
        ENMUtil::Log(logFile, wxString::Format(_T("Enter OnSusPendTimer-->suspend:ret is %d"), ret));
        ENMUtil::Log(logFile, _T("Enter OnSusPendTimer-->suspend:remove suspend file"));

    }
//    if ( wxFile::Exists(home + _T("/resume")) )
    if ( wxFile::Exists(_T("/tmp/.resume")) )
    {
        ENMUtil::Log(logFile, _T("Enter OnSusPendTimer-->resume"));
        ENM_StringW sRmResume;
        memset(&sRmResume, 0, sizeof(ENM_StringW));
        wcscpy((wchar_t*)sRmResume.dcsStringW, L"rmResume");
        DCS_ImportSchoolSettings(&sRmResume);
//        m_WaitForResume.Start(20000, wxTIMER_ONE_SHOT);
        ProfileEvent profileEvent(ID_PROFILE_APPLY, PEVT_PROFILE_APPLY_REAPPLY);
        ::wxPostEvent(GetNetworkManagerDlgHandle(), profileEvent);
        ENMUtil::Log(logFile, _T("Enter OnWaitForResume-->resume:post event"));
        BOOL IfWiredEnable;
        DCS_GetLANStatus(&IfWiredEnable);
        if ( IfWiredEnable )
        {
            m_LanIsEnable = true;
        }
        else
        {
            m_LanIsEnable = false;
        }
        BOOL IfWirelessEnable;
        DCS_GetWirelessStatus(&IfWirelessEnable);
        if ( IfWirelessEnable )
        {
            m_WlanIsEnable = true;
        }
        else
        {
            m_WlanIsEnable = false;
        }
        m_StartTimerAfterResume.Start(STARTTIMERAFTERRESUME, true);

        if ( MESHSTATUS_MESHCLOSE != ::wxGetApp().m_nMeshStatus)
        {
            //turn off mesh
            MeshInfoManager::GetInstance()->TurnOffMesh();

            NETWORK_MODE NetworkMode = ::wxGetApp().m_BeforeMeshNetworkMode;

            if ( NETWORK_MODE_WIRELESS_LAN_CONNECT == NetworkMode ||
                      NETWORK_MODE_WIRELESS_LAN_DISCONNECT == NetworkMode)
            {
                printf("ADAPTER_WIRELESS\n");
                 DataCenter::GetInstance()->EnableNetworkAdapter(ADAPTER_WIREDLESS, true);
                 printf("ADAPTER_WIRELESS enabled \n");
            }
        }

        ENMUtil::Log(logFile, _T("Enter OnWaitForResume-->resume:start timer"));
        StartGlobalTimer();
        ENMUtil::Log(logFile, _T("Enter OnSusPendTimer-->resume:remove resume file"));
    }
//    ENMUtil::Log(logFile, _T("Leave OnSusPendTimer"));
    return;
}

void DataCenterLinux::OnWaitForResume(wxTimerEvent& event)
{
    ENMUtil::Log(logFile, _T("Enter OnWaitForResume"));
    ProfileEvent profileEvent(ID_PROFILE_APPLY, PEVT_PROFILE_APPLY_REAPPLY);
    ::wxPostEvent(GetNetworkManagerDlgHandle(), profileEvent);
    ENMUtil::Log(logFile, _T("Enter OnWaitForResume-->resume:post event"));
    m_StartTimerAfterResume.Start(STARTTIMERAFTERRESUME, true);
    ENMUtil::Log(logFile, _T("Enter OnWaitForResume-->resume:start timer"));
    StartGlobalTimer();
    ENMUtil::Log(logFile, _T("Leave OnWaitForResume"));
}

void DataCenterLinux::OnStartTimerAfterResume(wxTimerEvent& event)
{
    ENMUtil::Log(logFile, _T("Enter OnStartTimerAfterResume"));
    if ( (wxString::FromUTF8(GetIPAddressHLAN(m_UsingWiredAdpterName, ENMUtil::WxStringToString(g_path)).c_str()).IsEmpty()) && m_CurrentNetworkMode == NETWORK_MODE_WIRED_LAN_CONNECT )
    {
        m_killDhclientCount = 0;
        ENM_StringW* sDhclient = new ENM_StringW();
        memset(sDhclient, 0, sizeof(ENM_StringW));
        wcscpy((wchar_t*)sDhclient->dcsStringW, L"killall");
        DCS_ImportSchoolSettings(sDhclient);
        delete sDhclient;
    }
//    StartGlobalTimer();
    ENMUtil::Log(logFile, _T("Leave OnStartTimerAfterResume"));
}
void DataCenterLinux::OnSwitchUserTimer(wxTimerEvent& event)
{
    wxString homeDir = wxGetHomeDir();
    string order = "echo $USERNAME > " + ENMUtil::WxStringToString(homeDir) + "/ActiveUser.out";
    system(order.c_str());
    wxTextFile userFile(homeDir + _T("/ActiveUser.out"));
    userFile.Open();
    wxString firstLine = userFile.GetFirstLine();
    if ( m_activeUser.IsEmpty() )
    {
        ENMUtil::Log(logFile, _T("Enter OnSwitchUserTimer-->m_activeUser is empty"));
        m_activeUser = firstLine;
    }
    else
    {
        ENMUtil::Log(logFile, _T("Enter OnSwitchUserTimer-->m_activeUser is not empty, and it's ") + m_activeUser + _T(" firstLine is ") + firstLine + _T(" at ") + ::wxNow());
        if ( firstLine.Cmp(m_activeUser) != 0 )
        {
            ENMUtil::Log(logFile, _T("Enter OnSwitchUserTimer-->user changed"));
            if ( !m_switchUser )
            {
                ENMUtil::Log(logFile, _T("Enter OnSwitchUserTimer-->stop timer"));
                StopGlobalTimer();
                m_switchUser = true;
            }
        }
        else
        {
            ENMUtil::Log(logFile, _T("Enter OnSwitchUserTimer-->user doesn't changed"));
            if ( m_switchUser )
            {
                ENMUtil::Log(logFile, _T("Enter OnSwitchUserTimer-->post event"));
                ProfileEvent event(ID_PROFILE_APPLY, PEVT_PROFILE_APPLY_REAPPLY);
                ::wxPostEvent(GetNetworkManagerDlgHandle(), event);
                ENMUtil::Log(logFile, _T("Enter OnSwitchUserTimer-->start timer"));
                StartGlobalTimer();
                m_switchUser = false;
            }
        }
    }
    userFile.Close();
    string removeFile = "rm " + ENMUtil::WxStringToString(homeDir) + "/ActiveUser.out";
    system(removeFile.c_str());
    return;
}

bool DataCenterLinux::ParseWpaFile()
{
    ifstream wpaLog;
    string path = "/tmp/wpa.log";
    char wpaLogBuf[1024] = {0};
    wpaLog.open(path.c_str(), ios_base::in);
    ENMUtil::Log(wxT("/tmp/ENMLog.txt"), _T("parse file........"));
    while ( wpaLog.getline(wpaLogBuf, sizeof(wpaLogBuf)) )
    {
        wxString content = wxString::FromUTF8(wpaLogBuf);
        ENMUtil::Log(wxT("/tmp/ENMLog.txt"), _T("parse file........") + content);
        if ((int) content.find(wxT("pre-shared key may be incorrect")) > 0)
        {
            ENMUtil::Log(wxT("/tmp/ENMLog.txt"), _T("parse file........pre-shared key may be incorrect"));
            wpaLog.close();
            return false;
        }
        if ((int) content.find(wxT("EVENT-CONNECTED")) > 0)
        {
            ENMUtil::Log(wxT("/tmp/ENMLog.txt"), _T("parse file........CTRL-EVENT-CONNECTED"));
            wpaLog.close();
            return true;
        }
    }
    ENMUtil::Log(wxT("/tmp/ENMLog.txt"), _T("parse file........find nothing"));
    wpaLog.close();
    return false;
}

bool DataCenterLinux::DisableAllAdapters()
{
    ENMUtil::Log(wxT("/tmp/ENMLog.txt"), _T("line-------->1129"));
    SwitchAdapterParameter(ADAPTER_WIRED, (ADAPTER_TYPE)0, NULL);
    ENMUtil::Log(wxT("/tmp/ENMLog.txt"), _T("line-------->1131"));
    SwitchAdapterParameter(ADAPTER_WIREDLESS, (ADAPTER_TYPE)0, NULL);
//    EnableNetworkAdapter(ADAPTER_WIRED,false);
//
//    EnableNetworkAdapter(ADAPTER_WIREDLESS,false);

    return true;
}

int DataCenterLinux::OpenSockets()
{
	static const int families[] = {
		AF_INET, AF_IPX, AF_AX25, AF_APPLETALK
	};
	unsigned int i;
	int	sock;

	for(i = 0; i < sizeof(families)/sizeof(int); ++i)
	{
		sock = socket(families[i], SOCK_DGRAM, 0);
		if(sock >= 0)
        return sock;
	}

	return -1;
}

void DataCenterLinux::GetNetInfo()
{
    DCS_SearchAdapter();

}

bool DataCenterLinux::IfUp(ADAPTER_TYPE adapterType)
{
    BOOL IfWiredEnable;
    BOOL IfWirelessEnable;
    BOOL ifUp;
    if ( adapterType == ADAPTER_WIRED )
    {
        DCS_GetLANStatus(&IfWiredEnable);
        if ( IfWiredEnable )
        {
            DCS_IsExistUpAdapter(DCS_ADAPTER_WIRED, &ifUp);
        }
        else
        {
            return false;
        }

    }
    else
    {
        DCS_GetWirelessStatus(&IfWirelessEnable);
        if ( IfWirelessEnable )
        {
            DCS_IsExistUpAdapter(DCS_ADAPTER_WIREDLESS, &ifUp);
        }
        else
        {
            return false;
        }

    }
    if ( ifUp )
    {
        return true;
    }
    else
    {
        return false;
    }


}

bool DataCenterLinux::IfLink(ADAPTER_TYPE adapterType, string adapterName)
{
    BOOL bIfConnect;

    if ( ADAPTER_WIRED == adapterType )
    {
        DCS_IsExistConnectAdapter(DCS_ADAPTER_WIRED, &bIfConnect);
    }
    else
    {
        DCS_IsExistConnectAdapter(DCS_ADAPTER_WIREDLESS, &bIfConnect);
    }

    if ( bIfConnect )
    {
        return true;
    }
    else
    {
        return false;
    }

}



wxArrayString DataCenterLinux::GetInterface(int i)
{
//    if (i == 1)
//    {
//        return m_asWiredInterface;
//    }
//    else
//    {
//        return m_asWirelessInterface;
//    }
    wxArrayString strArray;
    return strArray;
}

bool DataCenterLinux::ShutdownInterface(ADAPTER_TYPE adapterType)
{
    BOOL existUpAdapter;
    BOOL IfEnable;
    if ( adapterType == ADAPTER_WIRED )
    {
        return true;
    }
    else
    {
        DCS_GetWirelessStatus(&IfEnable);
        if ( IfEnable )
        {
            DCS_DownAdapter(DCS_ADAPTER_WIREDLESS);
            DCS_IsExistUpAdapter(DCS_ADAPTER_WIREDLESS, &existUpAdapter);
        }
        else
        {
            return true;
        }
    }

    if ( existUpAdapter )
    {
        return false;
    }
    else
    {
        return true;
    }
}
//
bool DataCenterLinux::StartupInterface(ADAPTER_TYPE adapterType)
{
//    if( m_pAPStatus )
//    {
//        delete m_pAPStatus;
//        m_pAPStatus = NULL;
//    }
    BOOL IfEnable;
    BOOL existUpAdapter;
    if ( adapterType == ADAPTER_WIRED )
    {
        DCS_GetLANStatus(&IfEnable);
        if ( IfEnable )
        {
            DCS_UpAdapter(DCS_ADAPTER_WIRED);
            DCS_IsExistUpAdapter(DCS_ADAPTER_WIRED, &existUpAdapter);
        }
        else
        {
            return false;
        }
    }
    else
    {
        DCS_GetWirelessStatus(&IfEnable);
        if ( IfEnable )
        {
            DCS_UpAdapter(DCS_ADAPTER_WIREDLESS);
            DCS_IsExistUpAdapter(DCS_ADAPTER_WIREDLESS, &existUpAdapter);
        }
        else
        {
            return false;
        }
    }

    if ( !existUpAdapter )
    {
        return false;
    }
    else
    {
        return true;
    }
}

wxArrayString DataCenterLinux::GetNetworkAdapterName(ADAPTER_TYPE adapterType)
{
//    if ( ADAPTER_WIRED == adapterType )
//    {
//        return m_asWiredInterface;
//    }
//    else
//    {
//        return m_asWirelessInterface;
//    }
    wxArrayString strArray;
    return strArray;
}
wxString DataCenterLinux::GetUsingAdapterName(ADAPTER_TYPE adapterType)
{
//    if ( ADAPTER_WIRED == adapterType )
//    {
//        return wxString::FromUTF8(m_UsingWiredAdpterName.c_str());
//    }
//    else
//    {
//        return wxString::FromUTF8(m_UsingWirelessAdpterName.c_str());
//    }
    wxString strTemp;
    return strTemp;
}

void DataCenterLinux::StartGlobalTimer()
{
    m_NetStatusTimer.Start(NETSTATUS_TIMERINTERVAL);
}

void DataCenterLinux::StopGlobalTimer()
{
    m_NetStatusTimer.Stop();
}

bool DataCenterLinux::CloseWlanConnection(bool ifScanDlg)
{
    DCS_CloseWlanConnection();
    if ( ifScanDlg )
    {
        if ( m_CurrentNetworkMode = NETWORK_MODE_WIRELESS_LAN_CONNECT )
        {
            m_postEvent = true;
            GetProfileController()->NotifyModeChanged(NETWORK_MODE_WIRELESS_LAN_DISCONNECT);
            ENMUtil::Log(logFile, _T("*****change mode*****"));
//            m_LastNetworkMode = NETWORK_MODE_WIRELESS_LAN_CONNECT;
//            m_CurrentNetworkMode = NETWORK_MODE_WIRELESS_LAN_DISCONNECT;
//            GetProfileController()->NotifyModeChanged(m_CurrentNetworkMode);
        }
    }
    if ( NULL != m_pAPStatus )
    {
       delete m_pAPStatus;
       m_pAPStatus = NULL ;
    }
    if ( !ifScanDlg )
    {
//        SwitchAdapterParameter((ADAPTER_TYPE)0, ADAPTER_WIREDLESS, NULL);
        m_UpWireless.Start(500, true);
    }
//    SwitchAdapterParameter((ADAPTER_TYPE)0, ADAPTER_WIREDLESS, NULL);
//    if ( !IfUp(ADAPTER_WIREDLESS) )
//    {
//        StartupInterface(ADAPTER_WIREDLESS);
//    }
    WlanAcmEvent event(ID_WLAN_ACM_CONNECT, WLAN_ACM_EVENT_DISCONNECTED);
    ::wxPostEvent(m_pScanNetworkDlg, event);

    return true;
}

void DataCenterLinux::OnUpWireless(wxTimerEvent& event)
{
    ENMUtil::Log(logFile, _T("Enter OnUpWireless"));
    StartupInterface(ADAPTER_WIREDLESS);
    ENMUtil::Log(logFile, _T("Leave OnUpWireless"));
}

bool DataCenterLinux::IsWirelessConnected()
{
    return false ;
}

void DataCenterLinux::SetSsid(APStatus& apStatus)
{
;
}

bool DataCenterLinux::IsWiredInterfaceConnected()
{
    return IfLink(ADAPTER_WIRED, "");
}
WlanScanner* DataCenterLinux::GetScanner()
{
    return m_pLinuxWlanScanner;
}

bool DataCenterLinux::IsInterfaceEnabled(ADAPTER_TYPE adapterType)
{
    bool bRet = false;
//	wxArrayString arrayInterface = GetNetworkAdapterName(adapterType);
	bool bAdapterName = IfUp(adapterType);

	if ( bAdapterName )
	{
		bRet = true;
	}

    return bRet;

}

DataCenterLinux::SwitchAdapterThread::SwitchAdapterThread(DataCenterLinux* pDataCenterLinux) : wxThread()
{
    m_DataCenterLinux = pDataCenterLinux;
    m_continueFlag = true;
}

DataCenterLinux::SwitchAdapterThread::~SwitchAdapterThread()
{
}

void* DataCenterLinux::SwitchAdapterThread::Entry()
{
    while ( m_continueFlag )
    {
        if ( m_vParameter.empty() )
        {
            wxThread::Sleep(2000);
        }
        else
        {
            ENMUtil::Log(logFile, wxString::Format(wxT("In SwitchAdapterThread:there are %d times\n"), m_vParameter.size()));
            bool downResult = true;
            bool upResult = true;
            NetworkOperationResult opResult = OPERATION_FAILED;
            bool bAllowWireless = m_DataCenterLinux->IsWlanChangeAcceptable();
            if ( !bAllowWireless && m_DataCenterLinux->IfUp(ADAPTER_WIREDLESS) && ADAPTER_WIREDLESS == m_vParameter[0].adapterTypeUp )
            {
                bAllowWireless = true;
            }
            if ( !bAllowWireless && !m_DataCenterLinux->IfUp(ADAPTER_WIREDLESS) && ADAPTER_WIREDLESS == m_vParameter[0].adapterTypeDown )
            {
                bAllowWireless = true;
            }
            if ( !bAllowWireless && m_DataCenterLinux->IfLink(ADAPTER_WIRED) )
            {
                bAllowWireless = true;
            }
//            if ( bAllowWireless && ADAPTER_WIREDLESS == m_vParameter[0].adapterTypeUp && m_DataCenterLinux->IfLink(ADAPTER_WIRED) && !m_DataCenterLinux->m_pPolicyManager->IsAllowTurnOnWireless() )
//            {
//                bAllowWireless = false;
//            }
            if ( 0 != m_vParameter[0].adapterTypeDown )
            {
//                if ( !(ADAPTER_WIREDLESS == m_vParameter[0].adapterTypeDown && m_DataCenterLinux->IsWlanChangeAcceptable()) )
//                {
                if ( ADAPTER_WIREDLESS == m_vParameter[0].adapterTypeDown && bAllowWireless )
                {
                    if ( ADAPTER_WIREDLESS == m_vParameter[0].adapterTypeDown && m_DataCenterLinux->IfUp(ADAPTER_WIREDLESS) )
                    {
                        DCS_CloseWlanConnection();
                    }
    //                downResult = m_DataCenterLinux->ShutdownInterface(m_DataCenterLinux->GetNetworkAdapterName(m_vParameter[0].adapterTypeDown));
                    BOOL existAdapter;
                    DCS_IsExistAdapter((ENM_ADAPTER_TYPE)m_vParameter[0].adapterTypeDown, &existAdapter);
                    if ( existAdapter )
                    {
                        ENMUtil::Log(logFile, wxString::Format(wxT("In SwitchAdapterThread:shutdown %d\n"), m_vParameter[0].adapterTypeDown));
                        downResult = m_DataCenterLinux->ShutdownInterface(m_vParameter[0].adapterTypeDown);
                        ENMUtil::Log(logFile, wxString::Format(wxT("In SwitchAdapterThread:shutdown result is %d\n"), downResult));
                    }
                    else
                    {
                        downResult = true;
                    }
                }

                if ( ADAPTER_WIRED == m_vParameter[0].adapterTypeDown )
                {
                    BOOL existAdapter;
                    DCS_IsExistAdapter((ENM_ADAPTER_TYPE)m_vParameter[0].adapterTypeDown, &existAdapter);
                    if ( existAdapter )
                    {
                        ENMUtil::Log(logFile, wxString::Format(wxT("In SwitchAdapterThread:shutdown %d\n"), m_vParameter[0].adapterTypeDown));
                        downResult = m_DataCenterLinux->ShutdownInterface(m_vParameter[0].adapterTypeDown);
                        ENMUtil::Log(logFile, wxString::Format(wxT("In SwitchAdapterThread:shutdown result is %d\n"), downResult));
                    }
                    else
                    {
                        downResult = true;
                    }
                }

            }

            if ( downResult && 0 != m_vParameter[0].adapterTypeUp )
            {
//                m_DataCenterLinux->m_UsingWirelessAdpterName = m_DataCenterLinux->StartupInterface(m_DataCenterLinux->GetNetworkAdapterName(m_vParameter[0].adapterTypeUp));
//                upResult = (m_DataCenterLinux->m_UsingWirelessAdpterName != "");
                if ( ADAPTER_WIREDLESS == m_vParameter[0].adapterTypeUp && bAllowWireless )
                {
//                    if ( !m_DataCenterLinux->IfLink(ADAPTER_WIRED, m_DataCenterLinux->m_UsingWiredAdpterName) )
                    if ( m_DataCenterLinux->GetLastNetworkMode() != NETWORK_MODE_WIRED_LAN_CONNECT )
                    {
                        BOOL existAdapter;
                        DCS_IsExistAdapter((ENM_ADAPTER_TYPE)m_vParameter[0].adapterTypeUp, &existAdapter);
                        if ( existAdapter )
                        {
                            ENMUtil::Log(logFile, wxString::Format(wxT("In SwitchAdapterThread:startup %d\n"), m_vParameter[0].adapterTypeUp));
                            upResult = m_DataCenterLinux->StartupInterface(m_vParameter[0].adapterTypeUp);
                            ENMUtil::Log(logFile, wxString::Format(wxT("In SwitchAdapterThread:startup result is %d\n"), upResult));
    //                        if ( upResult )
    //                        {
    //                            DCS_CloseWlanConnection();
    //                        }
                        }
                        else
                        {
                            upResult = false;
                        }
                    }
                    else
                    {
                        upResult = false;
                    }

                }
                if ( ADAPTER_WIRED == m_vParameter[0].adapterTypeUp )
                {
                    BOOL existAdapter;
                    DCS_IsExistAdapter((ENM_ADAPTER_TYPE)m_vParameter[0].adapterTypeUp, &existAdapter);
                    if ( existAdapter )
                    {
                        ENMUtil::Log(logFile, wxString::Format(wxT("In SwitchAdapterThread:startup %d\n"), m_vParameter[0].adapterTypeUp));
                        upResult = m_DataCenterLinux->StartupInterface(m_vParameter[0].adapterTypeUp);
                        ENMUtil::Log(logFile, wxString::Format(wxT("In SwitchAdapterThread:startup result is %d\n"), upResult));
//                        if ( upResult )
//                        {
//                            DCS_CloseWlanConnection();
//                        }
                    }
                    else
                    {
                        upResult = false;
                    }
                }

            }

            if ( upResult )
            {
                opResult = OPERATION_SUCCESS;
            }
            else
            {
                opResult = OPERATION_FAILED;
            }

//            if ( ADAPTER_WIREDLESS == m_vParameter[0].adapterTypeUp && m_DataCenterLinux->IfLink(ADAPTER_WIRED, m_DataCenterLinux->m_UsingWiredAdpterName) )
            if ( ADAPTER_WIREDLESS == m_vParameter[0].adapterTypeUp && m_DataCenterLinux->GetLastNetworkMode() == NETWORK_MODE_WIRED_LAN_CONNECT )
            {
                opResult = OPERATION_DENINED;
            }
            if ( !bAllowWireless )
            {
                opResult = OPERATION_DENINED;
            }
//            if ( !IsWlanChangeAcceptable() )
//            {
//                opResult = OPERATION_DENINED;
//            }
            if ( NULL != m_vParameter[0].handler )
            {
                SwitchAdapterEvent event(m_vParameter[0].adapterTypeDown, m_vParameter[0].adapterTypeUp, opResult);
//                event.m_bSwitchResult = upResult;
                ::wxPostEvent(m_vParameter[0].handler, event);
            }

            m_vParameter.erase(m_vParameter.begin());
        }
    }

    return NULL;
}

void DataCenterLinux::SwitchAdapterThread::OnExit()
{

}

void DataCenterLinux::SwitchAdapterParameter(ADAPTER_TYPE adapterTypeDown, ADAPTER_TYPE adapterTypeUp, wxEvtHandler* handler)
{
    SwitchAdapterThread::SwitchAdapter switchAdapter;
    switchAdapter.adapterTypeDown = adapterTypeDown;
    switchAdapter.adapterTypeUp = adapterTypeUp;
    switchAdapter.handler = handler;
    m_pSwitchAdapterThread->m_vParameter.push_back(switchAdapter);
}

DataCenterLinux::GetCurAPThread::GetCurAPThread(DataCenterLinux* pDataCenterLinux) : wxThread()
{
    m_DataCenterLinuxForGetAP = pDataCenterLinux;
    m_getFlag = true;
    counter = 0;
}

DataCenterLinux::GetCurAPThread::~GetCurAPThread()
{
}

void* DataCenterLinux::GetCurAPThread::Entry()
{
    while ( m_getFlag )
    {
        if ( m_vGetAP.empty() )
        {
            wxThread::Sleep(500);
        }
        else
        {
            if ( counter >=6 )
            {
                if ( m_DataCenterLinuxForGetAP->m_pAPStatus == NULL )
                {
                    m_DataCenterLinuxForGetAP->m_pAPStatus = new APStatus();
                }
                DCS_GetCurrentAP(m_DataCenterLinuxForGetAP->m_pAPStatus);
                m_vGetAP.erase(m_vGetAP.begin());
                if ( m_DataCenterLinuxForGetAP->m_pAPStatus == NULL && 0 == m_DataCenterLinuxForGetAP->m_pAPStatus->signalQuality )
                {
                    m_DataCenterLinuxForGetAP->CloseWlanConnection();
    //                m_DataCenterLinuxForGetAP->m_pAPStatus = new APStatus();
                }
                counter = 0;
            }
            else
            {
                counter++;
            }
        }
    }
    return NULL;
}

void DataCenterLinux::GetCurAPThread::OnExit()
{

}

void DataCenterLinux::GetCurAPParameter()
{
    m_pGetCurAPThread->m_vGetAP.push_back(1);
}

DataCenterLinux::ConnectAPThread::ConnectAPThread(DataCenterLinux* pDataCenterLinux) : wxThread()
{
    m_DataCenterLinuxForConAP = pDataCenterLinux;
}

DataCenterLinux::ConnectAPThread::~ConnectAPThread()
{
}

void* DataCenterLinux::ConnectAPThread::Entry()
{
    ENMUtil::Log(logFile, _T("Enter ConnectAPThread::Entry"));
    if ( strlen((const char*)(m_DataCenterLinuxForConAP->m_connectInfo.ssid.dcsString)) != 0 )
    {
        ENMUtil::Log(logFile, _T("ConnectAPThread::Entry-->DCS_ConnectAP(m_DataCenterLinuxForConAP->m_connectInfo)"));
        DCS_ConnectAP(m_DataCenterLinuxForConAP->m_connectInfo);
    }
    ENMUtil::Log(logFile, _T("Leave ConnectAPThread::Entry"));
    return NULL;
}

void DataCenterLinux::ConnectAPThread::OnExit()
{

}

void DataCenterLinux::SetShowBalloonFlag(bool isShown)
{
    m_isNetworkDlgTurnWireless = isShown;
}

void DataCenterLinux::SetAutoWirelessFlag(bool m_isAutoWireless)
{
    m_isAutoWireless = m_isAutoWireless;
}

DataCenterLinux::ScanThread::ScanThread(DataCenterLinux* pDataCenterLinux) : wxThread()
{
    m_DataCenterLinuxForScanAP = pDataCenterLinux;
}

DataCenterLinux::ScanThread::~ScanThread()
{
}

void* DataCenterLinux::ScanThread::Entry()
{
    DCS_GetAPList(&(m_DataCenterLinuxForScanAP->m_apList));
    ScanEvent event(ID_SCAN_OVER);
    ::wxPostEvent(m_DataCenterLinuxForScanAP, event);
    return NULL;
}

void DataCenterLinux::ScanThread::OnExit()
{
}

void CALLBACK LanChangeCallBack(BOOL* LanChanged)
{
    ENMUtil::Log(logFile, _T("enter LanChangeCallBack"));
    if ( *LanChanged )
    {
        ENMUtil::Log(logFile, _T("enter LanChangeCallBack--->enable lan"));
        ((DataCenterLinux*) DataCenter::GetInstance())->m_LanIsEnable = true;
//        DCS_SearchAdapter();
//        DCS_UpAdapter(DCS_ADAPTER_WIRED);
    }
    else
    {
        ENMUtil::Log(logFile, _T("enter LanChangeCallBack--->disable lan"));
        ((DataCenterLinux*) (DataCenter::GetInstance()))->m_LanIsEnable = false;
    }
    ENMUtil::Log(logFile, _T("leave LanChangeCallBack"));
}

void CALLBACK WlanChangeCallBack(BOOL* WlanChanged)
{
    ENMUtil::Log(logFile, _T("enter WlanChangeCallBack"));
    bool isWlanEnable = ((DataCenterLinux*) DataCenter::GetInstance())->m_WlanIsEnable;
    bool isPolicyAllow = ((DataCenterLinux*) DataCenter::GetInstance())->m_pPolicyManager->IsAllowTurnOnWireless();
    if ( isWlanEnable != (*WlanChanged == 1) && !isPolicyAllow )
    {
        ENMUtil::Log(logFile, _T("in WlanChangeCallBack--->policy not allow"));
        if ( isWlanEnable )
        {
            ENMUtil::Log(logFile, _T("in WlanChangeCallBack--->power on"));
            DCS_SetWirelessStatus(TRUE);
//            DCS_UpAdapter(DCS_ADAPTER_WIREDLESS);
        }
        else
        {
            ENMUtil::Log(logFile, _T("in WlanChangeCallBack--->power off"));
            DCS_DownAdapter(DCS_ADAPTER_WIREDLESS);
            DCS_SetWirelessStatus(FALSE);
        }
    }
    else
    {
        ENMUtil::Log(logFile, _T("in WlanChangeCallBack--->disable wlan"));
        ((DataCenterLinux*) DataCenter::GetInstance())->m_WlanIsEnable = false;
    }
    ENMUtil::Log(logFile, _T("leave WlanChangeCallBack"));
}

void CALLBACK DisableAdapterCallBack(BOOL* DisableAdapter)
{
    ENMUtil::Log(logFile, _T("enter DisableAdapterCallBack"));
    if ( *DisableAdapter )
    {
        ENMUtil::Log(logFile, _T("in DisableAdapterCallBack--->disable wlan"));
        DCS_DispatchDisableEvent(DCS_ADAPTER_WIREDLESS);
    }
    else
    {
        ENMUtil::Log(logFile, _T("in DisableAdapterCallBack--->disable lan"));
        DCS_DispatchDisableEvent(DCS_ADAPTER_WIRED);
    }
    ENMUtil::Log(logFile, _T("leave DisableAdapterCallBack"));
}

bool DataCenterLinux::IsWlanChangeAcceptable()
{
    if ( m_pPolicyManager->IsAllowTurnOnWireless() )
        return true;

    if ( m_bIgnorePolicy )
        return true;

    return m_pPolicyManager->IsAllowTurnOnWireless();
}
bool DataCenterLinux::IfWirelessLink()
{
    FILE* fp;
    char buffer[128];
    fp = popen("iwpriv ra0 connStatus", "r");
    fgets(buffer, sizeof(buffer), fp);
    pclose(fp);
    const char* searchStr = "Disconnected";
    char* p;
    p = strstr(buffer, searchStr);
    return NULL == p;
}

void DataCenterLinux::OnForRoaming(wxTimerEvent& event)
{
    ENMUtil::Log(logFile, _T("Enter OnForRoaming"));

    if ( !IfWirelessLink() && !m_wiredIP.empty() )
    {
        ENMUtil::Log(logFile, _T("!IfWirelessLink() && !m_wiredIP.empty()"));
        BOOL bIfConnect;
        DCS_IsExistConnectAdapter(DCS_ADAPTER_WIRED, &bIfConnect);
        if ( !bIfConnect )
        {
            ENMUtil::Log(logFile, _T("Enter OnForRoaming--release IP"));
            ENM_StringW* sRelease = new ENM_StringW();
            memset(sRelease, 0, sizeof(ENM_StringW));
            wcscpy((wchar_t*)sRelease->dcsStringW, L"releaseip");
            DCS_ImportSchoolSettings(sRelease);
            delete sRelease;
            m_wiredIP = "";
        }
    }
    ENMUtil::Log(logFile, _T("Leave OnForRoaming"));
}
