/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "AboutDialog.h"
#include <wx/bitmap.h>
#include <wx/font.h>
#include <wx/string.h>
#include "ENMApp.h"

const int AboutDialog::ID_BTN_OK = ::wxNewId();
BEGIN_EVENT_TABLE(AboutDialog,wxDialog)
    EVT_BUTTON(ID_BTN_OK, AboutDialog::OnButtonOKClick)
END_EVENT_TABLE()

AboutDialog::AboutDialog(wxWindow* parent, wxWindowID id)
{
    wxBitmap background(wxImage(::wxGetApp().strAppPath + _T("pic/about_bg_with_icon.png")));

	Create(parent, wxID_ANY, _("Enhanced Easy Network"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE);
	SetClientSize(wxSize(350,230));
	m_bmpBackground = new wxStaticBitmap(this, wxID_ANY, background);
	m_stxModuleName = new wxStaticText(this, wxID_ANY,_("Enhanced Easy Network"), wxPoint(92,70), wxSize(200, 20));
	wxFont stxModuleNameFont(10, wxSWISS, wxFONTSTYLE_NORMAL, wxBOLD, false, wxEmptyString, wxFONTENCODING_DEFAULT);
	m_stxModuleName->SetFont(stxModuleNameFont);
	wxString ver = _("Version");
	m_stxVersion = new wxStaticText(this, wxID_ANY, ver + _T(" 2.0.0.190"), wxPoint(92,90));
	m_stxCopyright = new wxStaticText(this, wxID_ANY, _("Copyright(c) 2008 Intel Corporation."), wxPoint(92,130));
	m_stxRight = new wxStaticText(this, wxID_ANY, _("All rights reserved."), wxPoint(92,150));
#if defined(__UNIX__)
    m_btnOK = new wxButton(this, ID_BTN_OK, _("OK"), wxPoint(252,191), wxSize(80,30));
#endif
	m_btnOK->SetDefault();
	Center();

    //Set icon
    wxIcon icon_netclient(::wxGetApp().strAppPath + wxT("pic/enhanced-easy-network.ico"), wxBITMAP_TYPE_ICO, 16, 16);
    SetIcon(icon_netclient);
}

AboutDialog::~AboutDialog()
{
}

void AboutDialog::OnButtonOKClick(wxCommandEvent& event)
{
    Close();
}
