# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

"""
Locale helper functions
"""

import locale, platform

# "Sets the locale for all categories to the user's default setting
# (typically specified in the LANG environment variable)."
# quoted from Python's documentation:
# http://docs.python.org/lib/module-locale.html
#
# This is not thread-safe and does not need to be done more than once.
# FIXME: disabled on Windows to work around a bug likely to be located in
# pywin32; see: https://bugs.launchpad.net/elisa/+bug/255080
# Please re-enable that code on Windows when the new version of wmd is merged
# See https://bugs.launchpad.net/elisa/+bug/252876
if platform.system() != 'Windows':
    locale.setlocale(locale.LC_ALL, "")

def system_encoding():
    """
    Return the encoding used by the system.

    @rtype: string
    """
    # setlocale is done at import time; not doing it here allows
    # system_encoding to be thread-safe
    return locale.getpreferredencoding(do_setlocale=False)
