# -*- coding: utf-8 -*-
# from http://aspn.activestate.com/ASPN/Cookbook/Python/Recipe/87369
# Licensed under PSF: http://python.org/license

import Queue
import bisect
import sys


class PriorityQueue(Queue.Queue):

    def _init(self, maxsize):
        self.maxsize = maxsize
        self.queue = []

    def _put(self, item):
        data, priority = item
        self._insort_right((priority, data))

    def _get(self):
        return self.queue.pop(0)[1]

    def _insort_right(self, x):
        """Insert item x in list, and keep it sorted assuming a is sorted.

        If x is already in list, insert it to the right of the rightmost x.
        """
        a = self.queue
        lo = 0
        hi = len(a)

        while lo < hi:
            mid = (lo+hi)/2
            if x[0] < a[mid][0]:
                hi = mid
            else:
                lo = mid+1
        a.insert(lo, x)

    def top(self):
        "non-destructively return smallest element in pqueue"
        try:
            x = self.queue[0]
        except IndexError:
            x = None
        return x

    def contents(self):
        return self.queue

def test():
    pq = PriorityQueue()

    pq.put(('b', 1))
    pq.put(('a', 1))
    pq.put(('c', 1))
    pq.put(('z', 0))
    pq.put(('d', 2))

    while not pq.empty():
        print pq.get(),

if __name__ == '__main__':
    test() # prints z b a c d
