# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Author: Jesús Corrius i Llavina <jcorrius@fluendo.com>

from elisa.core.components.service_provider import ServiceProvider

from win32gui import SystemParametersInfo
from win32con import SPI_GETSCREENSAVEACTIVE, SPI_SETSCREENSAVEACTIVE

class WinScreenSaver(ServiceProvider):
    """
    Elisa service to automatically manage Microsoft Windows'
    screensaver activation and deactivation during runtime.
    """
    
    def start(self):
        self._active = SystemParametersInfo(SPI_GETSCREENSAVEACTIVE)
        if self._active:
            SystemParametersInfo(SPI_SETSCREENSAVEACTIVE, False)
            self.debug('Windows screensaver disabled.')

    def stop(self):
        if self._active:
            SystemParametersInfo(SPI_SETSCREENSAVEACTIVE, True)
            self.debug('Windows screensaver enabled.')
