# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.plugins.pigment.tests.widgets.test_widget import GenericTestWidget

from elisa.plugins.pigment.widgets.osk import Button, OnScreenKeyboard
from elisa.plugins.pigment import widgets

from twisted.trial.unittest import TestCase

import os.path

class GenericTestButton(GenericTestWidget):
    pass

class GenericTestButtonImpl(GenericTestButton, TestCase):
    tested_class = Button

class GenericTestOnScreenKeyboard(GenericTestWidget):
    def _create_instance(self):
        xml_file = os.path.join(os.path.dirname(widgets.__file__),
                                'data', 'osk_alphabetic.xml')
        return self.tested_class(xml_file)

class GenericTestOnScreenKeyboardImpl(GenericTestOnScreenKeyboard, TestCase):
    tested_class = OnScreenKeyboard

