import os
from setuptools import setup
from elisa.core.utils.dist import find_packages, TrialTest, Clean

packages, package_dir = find_packages(os.path.dirname(__file__))
cmdclass = dict(test=TrialTest, clean=Clean)

setup(name='elisa-plugin-pigment',
    version='0.1', 
    description='another pigment frontend',
    long_description='another pigment frontend',
    license='UNKNOWN', 
    author='Elisa Developers',
    author_email='elisa@lists.fluendo.com',
    keywords='',
    namespace_packages=['elisa', 'elisa.plugins'],
    packages=packages,
    package_dir=package_dir,
    package_data={'': ['*.png', '*.mo', '*.po', '*.conf']},
    entry_points="""\
    [distutils.setup_keywords]
    controller_mappings = elisa.core.utils.dist:assert_list_of_string_tuples_or_none
    decorator_mappings = elisa.core.utils.dist:assert_list_of_string_tuples_or_none

    [egg_info.writers]
    controller_mappings.txt = elisa.core.utils.dist:write_mappings
    decorator_mappings.txt = elisa.core.utils.dist:write_mappings
    """,
    cmdclass=cmdclass)
