# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Author: Philippe Normand <philippe@fluendo.com>

"""
UPnP Coherence Control-Point
"""

from twisted.internet import defer

from elisa.core.components.service_provider import ServiceProvider
from elisa.core import common, component
from coherence.base import Coherence
from coherence import __version_info__ as coherence_version

if coherence_version < (0, 5, 8):
    import louie
else:
    import coherence.extern.louie as louie

from elisa.plugins.coherence.coherence_device_message import \
        CoherenceDeviceMessage
from elisa.plugins.coherence.coherence_plugin_message import \
        CoherencePluginMessage

class CoherenceService(ServiceProvider):
    """
    This Service is in charge of starting the Coherence framework and
    register new Plugins to it, when other Elisa Components need UPnP
    related features.

    """

    def initialize(self):
        coherence_config = {'logmode':'none', 'controlpoint': 'yes', 'plugins':{}}
        try:
            coherence_instance = Coherence(coherence_config)
        except Exception, coherence_exception:
            error = "Coherence failed to start. Error: %s" % coherence_exception
            return defer.fail(error)
        self._coherence = coherence_instance
        common.application.bus.register(self._got_message,
                                        CoherencePluginMessage,
                                        CoherenceDeviceMessage)
        return defer.succeed(self)

    def _got_message(self, msg, sender):
        if isinstance(msg, CoherencePluginMessage):
            name = msg.name
            args = msg.args
            self.debug("Registering plugin %r", name)
            self._coherence.add_plugin(name, **args)
        else:
            self.debug("Connecting %r to Louie signal %r", msg.callback, msg.name)
            louie.connect(msg.callback, msg.name, msg.typ)

    def stop(self):
        self._coherence.shutdown()
