/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class MethodBinding
extends Binding
implements BaseTypes,
TypeConstants {
    public int modifiers;
    public char[] selector;
    public TypeBinding returnType;
    public TypeBinding[] parameters;
    public ReferenceBinding[] thrownExceptions;
    public ReferenceBinding declaringClass;
    public TypeVariableBinding[] typeVariables = NoTypeVariables;
    char[] signature;
    public long tagBits;

    protected MethodBinding() {
    }

    public MethodBinding(int modifiers, char[] selector, TypeBinding returnType, TypeBinding[] parameters, ReferenceBinding[] thrownExceptions, ReferenceBinding declaringClass) {
        this.modifiers = modifiers;
        this.selector = selector;
        this.returnType = returnType;
        this.parameters = parameters == null || parameters.length == 0 ? NoParameters : parameters;
        this.thrownExceptions = thrownExceptions == null || thrownExceptions.length == 0 ? NoExceptions : thrownExceptions;
        this.declaringClass = declaringClass;
        if (this.declaringClass != null && this.declaringClass.isStrictfp() && !this.isNative() && !this.isAbstract()) {
            this.modifiers |= 0x800;
        }
    }

    public MethodBinding(int modifiers, TypeBinding[] parameters, ReferenceBinding[] thrownExceptions, ReferenceBinding declaringClass) {
        this(modifiers, TypeConstants.INIT, VoidBinding, parameters, thrownExceptions, declaringClass);
    }

    public MethodBinding(MethodBinding initialMethodBinding, ReferenceBinding declaringClass) {
        this.modifiers = initialMethodBinding.modifiers;
        this.selector = initialMethodBinding.selector;
        this.returnType = initialMethodBinding.returnType;
        this.parameters = initialMethodBinding.parameters;
        this.thrownExceptions = initialMethodBinding.thrownExceptions;
        this.declaringClass = declaringClass;
    }

    public final boolean areParameterErasuresEqual(MethodBinding method) {
        TypeBinding[] args = method.parameters;
        if (this.parameters == args) {
            return true;
        }
        int length = this.parameters.length;
        if (length != args.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (this.parameters[i] != args[i] && this.parameters[i].erasure() != args[i].erasure()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final boolean areParametersEqual(MethodBinding method) {
        TypeBinding[] args = method.parameters;
        if (this.parameters == args) {
            return true;
        }
        int length = this.parameters.length;
        if (length != args.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (this.parameters[i] != args[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final boolean areParametersCompatibleWith(TypeBinding[] arguments) {
        int argLength;
        int paramLength = this.parameters.length;
        int lastIndex = argLength = arguments.length;
        if (this.isVarargs()) {
            TypeBinding varArgType;
            lastIndex = paramLength - 1;
            if (paramLength == argLength) {
                varArgType = this.parameters[lastIndex];
                TypeBinding lastArgument = arguments[lastIndex];
                if (varArgType != lastArgument && !lastArgument.isCompatibleWith(varArgType)) {
                    return false;
                }
            } else if (paramLength < argLength) {
                varArgType = ((ArrayBinding)this.parameters[lastIndex]).elementsType();
                int i = lastIndex;
                while (i < argLength) {
                    if (varArgType != arguments[i] && !arguments[i].isCompatibleWith(varArgType)) {
                        return false;
                    }
                    ++i;
                }
            } else if (lastIndex != argLength) {
                return false;
            }
        }
        int i = 0;
        while (i < lastIndex) {
            if (this.parameters[i] != arguments[i] && !arguments[i].isCompatibleWith(this.parameters[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final int kind() {
        return 8;
    }

    public final boolean canBeSeenBy(PackageBinding invocationPackage) {
        if (this.isPublic()) {
            return true;
        }
        if (this.isPrivate()) {
            return false;
        }
        return invocationPackage == this.declaringClass.getPackage();
    }

    public final boolean areTypeVariableErasuresEqual(MethodBinding method) {
        TypeVariableBinding[] vars = method.typeVariables;
        if (this.typeVariables == vars) {
            return true;
        }
        int length = this.typeVariables.length;
        if (length != vars.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (this.typeVariables[i] != vars[i] && this.typeVariables[i].erasure() != vars[i].erasure()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final boolean canBeSeenBy(InvocationSite invocationSite, Scope scope) {
        if (this.isPublic()) {
            return true;
        }
        SourceTypeBinding invocationType = scope.enclosingSourceType();
        if (invocationType == this.declaringClass) {
            return true;
        }
        if (this.isProtected()) {
            if (invocationType.fPackage == this.declaringClass.fPackage) {
                return true;
            }
            return invocationSite.isSuperAccess();
        }
        if (this.isPrivate()) {
            ReferenceBinding outerInvocationType = invocationType;
            ReferenceBinding temp = outerInvocationType.enclosingType();
            while (temp != null) {
                outerInvocationType = temp;
                temp = temp.enclosingType();
            }
            ReferenceBinding outerDeclaringClass = (ReferenceBinding)this.declaringClass.erasure();
            temp = outerDeclaringClass.enclosingType();
            while (temp != null) {
                outerDeclaringClass = temp;
                temp = temp.enclosingType();
            }
            return outerInvocationType == outerDeclaringClass;
        }
        return invocationType.fPackage == this.declaringClass.fPackage;
    }

    public final boolean canBeSeenBy(TypeBinding receiverType, InvocationSite invocationSite, Scope scope) {
        if (this.isPublic()) {
            return true;
        }
        SourceTypeBinding invocationType = scope.enclosingSourceType();
        if (invocationType == this.declaringClass && invocationType == receiverType) {
            return true;
        }
        if (this.isProtected()) {
            if (invocationType == this.declaringClass) {
                return true;
            }
            if (invocationType.fPackage == this.declaringClass.fPackage) {
                return true;
            }
            ReferenceBinding currentType = invocationType;
            TypeBinding receiverErasure = receiverType.erasure();
            ReferenceBinding declaringErasure = (ReferenceBinding)this.declaringClass.erasure();
            int depth = 0;
            do {
                if (currentType.findSuperTypeWithSameErasure(declaringErasure) != null) {
                    if (invocationSite.isSuperAccess()) {
                        return true;
                    }
                    if (receiverType instanceof ArrayBinding) {
                        return false;
                    }
                    if (this.isStatic()) {
                        if (depth > 0) {
                            invocationSite.setDepth(depth);
                        }
                        return true;
                    }
                    if (currentType == receiverErasure || ((ReferenceBinding)receiverErasure).findSuperTypeWithSameErasure(currentType) != null) {
                        if (depth > 0) {
                            invocationSite.setDepth(depth);
                        }
                        return true;
                    }
                }
                ++depth;
            } while ((currentType = currentType.enclosingType()) != null);
            return false;
        }
        if (this.isPrivate()) {
            if (!(receiverType == this.declaringClass || receiverType.isTypeVariable() && ((TypeVariableBinding)receiverType).isErasureBoundTo(this.declaringClass.erasure()))) {
                return false;
            }
            if (invocationType != this.declaringClass) {
                ReferenceBinding outerInvocationType = invocationType;
                ReferenceBinding temp = outerInvocationType.enclosingType();
                while (temp != null) {
                    outerInvocationType = temp;
                    temp = temp.enclosingType();
                }
                ReferenceBinding outerDeclaringClass = (ReferenceBinding)this.declaringClass.erasure();
                temp = outerDeclaringClass.enclosingType();
                while (temp != null) {
                    outerDeclaringClass = temp;
                    temp = temp.enclosingType();
                }
                if (outerInvocationType != outerDeclaringClass) {
                    return false;
                }
            }
            return true;
        }
        if (invocationType.fPackage != this.declaringClass.fPackage) {
            return false;
        }
        if (receiverType instanceof ArrayBinding) {
            return false;
        }
        ReferenceBinding type = (ReferenceBinding)receiverType;
        PackageBinding declaringPackage = this.declaringClass.fPackage;
        do {
            if (this.declaringClass == type) {
                return true;
            }
            if (declaringPackage == type.fPackage) continue;
            return false;
        } while ((type = type.superclass()) != null);
        return false;
    }

    MethodBinding computeSubstitutedMethod(MethodBinding method, LookupEnvironment env) {
        TypeBinding[] vars = this.typeVariables;
        TypeVariableBinding[] vars2 = method.typeVariables;
        if (vars.length != vars2.length) {
            return null;
        }
        int v = vars.length;
        while (--v >= 0) {
            if (vars[v].isInterchangeableWith(env, vars2[v])) continue;
            return null;
        }
        return new ParameterizedGenericMethodBinding(method, vars, env);
    }

    public char[] computeUniqueKey(boolean isLeaf) {
        return this.computeUniqueKey(this, isLeaf);
    }

    protected char[] computeUniqueKey(MethodBinding methodBinding, boolean isLeaf) {
        char[] declaringKey = this.declaringClass.computeUniqueKey(false);
        int declaringLength = declaringKey.length;
        int selectorLength = this.selector == TypeConstants.INIT ? 0 : this.selector.length;
        char[] sig = methodBinding.genericSignature();
        if (sig == null) {
            sig = methodBinding.signature();
        }
        int signatureLength = sig.length;
        char[] uniqueKey = new char[declaringLength + 1 + selectorLength + signatureLength];
        int index = 0;
        System.arraycopy(declaringKey, 0, uniqueKey, index, declaringLength);
        index = declaringLength;
        uniqueKey[index++] = 46;
        System.arraycopy(this.selector, 0, uniqueKey, index, selectorLength);
        System.arraycopy(sig, 0, uniqueKey, index += selectorLength, signatureLength);
        return uniqueKey;
    }

    public TypeBinding constantPoolDeclaringClass() {
        return this.declaringClass;
    }

    public final char[] constantPoolName() {
        return this.selector;
    }

    public char[] genericSignature() {
        int length;
        int i;
        if ((this.modifiers & 0x40000000) == 0) {
            return null;
        }
        StringBuffer sig = new StringBuffer(10);
        if (this.typeVariables != NoTypeVariables) {
            sig.append('<');
            i = 0;
            length = this.typeVariables.length;
            while (i < length) {
                sig.append(this.typeVariables[i].genericSignature());
                ++i;
            }
            sig.append('>');
        }
        sig.append('(');
        i = 0;
        length = this.parameters.length;
        while (i < length) {
            sig.append(this.parameters[i].genericTypeSignature());
            ++i;
        }
        sig.append(')');
        if (this.returnType != null) {
            sig.append(this.returnType.genericTypeSignature());
        }
        boolean needExceptionSignatures = false;
        length = this.thrownExceptions.length;
        int i2 = 0;
        while (i2 < length) {
            if ((this.thrownExceptions[i2].modifiers & 0x40000000) != 0) {
                needExceptionSignatures = true;
                break;
            }
            ++i2;
        }
        if (needExceptionSignatures) {
            i2 = 0;
            while (i2 < length) {
                sig.append('^');
                sig.append(this.thrownExceptions[i2].genericTypeSignature());
                ++i2;
            }
        }
        int sigLength = sig.length();
        char[] genericSignature = new char[sigLength];
        sig.getChars(0, sigLength, genericSignature, 0);
        return genericSignature;
    }

    public final int getAccessFlags() {
        return this.modifiers & 0xFFFF;
    }

    public long getAnnotationTagBits() {
        TypeDeclaration typeDecl;
        AbstractMethodDeclaration methodDecl;
        MethodBinding originalMethod = this.original();
        if ((originalMethod.tagBits & 0x200000000L) == 0L && originalMethod.declaringClass instanceof SourceTypeBinding && (methodDecl = (typeDecl = ((SourceTypeBinding)originalMethod.declaringClass).scope.referenceContext).declarationOf(originalMethod)) != null) {
            ASTNode.resolveAnnotations(methodDecl.scope, methodDecl.annotations, originalMethod);
        }
        return originalMethod.tagBits;
    }

    public TypeVariableBinding getTypeVariable(char[] variableName) {
        int i = this.typeVariables.length;
        while (--i >= 0) {
            if (!CharOperation.equals(this.typeVariables[i].sourceName, variableName)) continue;
            return this.typeVariables[i];
        }
        return null;
    }

    public boolean hasSubstitutedParameters() {
        return false;
    }

    public boolean hasSubstitutedReturnType() {
        return false;
    }

    public final boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public final boolean isBridge() {
        return (this.modifiers & 0x40) != 0;
    }

    public final boolean isConstructor() {
        return this.selector == TypeConstants.INIT;
    }

    public final boolean isDefault() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public final boolean isDefaultAbstract() {
        return (this.modifiers & 0x80000) != 0;
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x100000) != 0;
    }

    public final boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public final boolean isImplementing() {
        return (this.modifiers & 0x20000000) != 0;
    }

    public final boolean isNative() {
        return (this.modifiers & 0x100) != 0;
    }

    public final boolean isOverriding() {
        return (this.modifiers & 0x10000000) != 0;
    }

    public final boolean isMain() {
        TypeBinding paramType;
        return this.selector.length == 4 && CharOperation.equals(this.selector, MAIN) && (this.modifiers & 9) != 0 && VoidBinding == this.returnType && this.parameters.length == 1 && (paramType = this.parameters[0]).dimensions() == 1 && paramType.leafComponentType().id == 11;
    }

    public final boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isUsed() {
        return (this.modifiers & 0x8000000) != 0;
    }

    public final boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isRequiredToClearPrivateModifier() {
        return (this.modifiers & 0x4000000) != 0;
    }

    public final boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public final boolean isStrictfp() {
        return (this.modifiers & 0x800) != 0;
    }

    public final boolean isSynchronized() {
        return (this.modifiers & 0x20) != 0;
    }

    public final boolean isSynthetic() {
        return (this.modifiers & 0x1000) != 0;
    }

    public final boolean isVarargs() {
        return (this.modifiers & 0x80) != 0;
    }

    public final boolean isViewedAsDeprecated() {
        return (this.modifiers & 0x300000) != 0;
    }

    public MethodBinding original() {
        return this;
    }

    public char[] readableName() {
        StringBuffer buffer = new StringBuffer(this.parameters.length + 20);
        if (this.isConstructor()) {
            buffer.append(this.declaringClass.sourceName());
        } else {
            buffer.append(this.selector);
        }
        buffer.append('(');
        if (this.parameters != NoParameters) {
            int i = 0;
            int length = this.parameters.length;
            while (i < length) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(this.parameters[i].sourceName());
                ++i;
            }
        }
        buffer.append(')');
        return buffer.toString().toCharArray();
    }

    public char[] shortReadableName() {
        StringBuffer buffer = new StringBuffer(this.parameters.length + 20);
        if (this.isConstructor()) {
            buffer.append(this.declaringClass.shortReadableName());
        } else {
            buffer.append(this.selector);
        }
        buffer.append('(');
        if (this.parameters != NoParameters) {
            int i = 0;
            int length = this.parameters.length;
            while (i < length) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(this.parameters[i].shortReadableName());
                ++i;
            }
        }
        buffer.append(')');
        int nameLength = buffer.length();
        char[] shortReadableName = new char[nameLength];
        buffer.getChars(0, nameLength, shortReadableName, 0);
        return shortReadableName;
    }

    protected final void setSelector(char[] selector) {
        this.selector = selector;
        this.signature = null;
    }

    public final char[] signature() {
        int i;
        int count;
        boolean needSynthetics;
        if (this.signature != null) {
            return this.signature;
        }
        StringBuffer buffer = new StringBuffer(this.parameters.length + 20);
        buffer.append('(');
        TypeBinding[] targetParameters = this.parameters;
        boolean isConstructor = this.isConstructor();
        if (isConstructor && this.declaringClass.isEnum()) {
            buffer.append(ConstantPool.JavaLangStringSignature);
            buffer.append(BaseTypes.IntBinding.signature());
        }
        boolean bl = needSynthetics = isConstructor && this.declaringClass.isNestedType();
        if (needSynthetics) {
            ReferenceBinding[] syntheticArgumentTypes = this.declaringClass.syntheticEnclosingInstanceTypes();
            count = syntheticArgumentTypes == null ? 0 : syntheticArgumentTypes.length;
            i = 0;
            while (i < count) {
                buffer.append(syntheticArgumentTypes[i].signature());
                ++i;
            }
            if (this instanceof SyntheticMethodBinding) {
                targetParameters = ((SyntheticMethodBinding)this).targetMethod.parameters;
            }
        }
        if (targetParameters != NoParameters) {
            int i2 = 0;
            while (i2 < targetParameters.length) {
                buffer.append(targetParameters[i2].signature());
                ++i2;
            }
        }
        if (needSynthetics) {
            SyntheticArgumentBinding[] syntheticOuterArguments = this.declaringClass.syntheticOuterLocalVariables();
            count = syntheticOuterArguments == null ? 0 : syntheticOuterArguments.length;
            i = 0;
            while (i < count) {
                buffer.append(syntheticOuterArguments[i].type.signature());
                ++i;
            }
            i = targetParameters.length;
            int extraLength = this.parameters.length;
            while (i < extraLength) {
                buffer.append(this.parameters[i].signature());
                ++i;
            }
        }
        buffer.append(')');
        if (this.returnType != null) {
            buffer.append(this.returnType.signature());
        }
        int nameLength = buffer.length();
        this.signature = new char[nameLength];
        buffer.getChars(0, nameLength, this.signature, 0);
        return this.signature;
    }

    public final int sourceEnd() {
        AbstractMethodDeclaration method = this.sourceMethod();
        if (method == null) {
            if (this.declaringClass instanceof SourceTypeBinding) {
                return ((SourceTypeBinding)this.declaringClass).sourceEnd();
            }
            return 0;
        }
        return method.sourceEnd;
    }

    public AbstractMethodDeclaration sourceMethod() {
        SourceTypeBinding sourceType;
        try {
            sourceType = (SourceTypeBinding)this.declaringClass;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        AbstractMethodDeclaration[] methods = sourceType.scope.referenceContext.methods;
        int i = methods.length;
        while (--i >= 0) {
            if (this != methods[i].binding) continue;
            return methods[i];
        }
        return null;
    }

    public final int sourceStart() {
        AbstractMethodDeclaration method = this.sourceMethod();
        if (method == null) {
            if (this.declaringClass instanceof SourceTypeBinding) {
                return ((SourceTypeBinding)this.declaringClass).sourceStart();
            }
            return 0;
        }
        return method.sourceStart;
    }

    public final void tagForClearingPrivateModifier() {
        this.modifiers |= 0x4000000;
    }

    public String toString() {
        int length;
        int i;
        String s = this.returnType != null ? this.returnType.debugName() : "NULL TYPE";
        s = String.valueOf(s) + " ";
        s = String.valueOf(s) + (this.selector != null ? new String(this.selector) : "UNNAMED METHOD");
        s = String.valueOf(s) + "(";
        if (this.parameters != null) {
            if (this.parameters != NoParameters) {
                i = 0;
                length = this.parameters.length;
                while (i < length) {
                    if (i > 0) {
                        s = String.valueOf(s) + ", ";
                    }
                    s = String.valueOf(s) + (this.parameters[i] != null ? this.parameters[i].debugName() : "NULL TYPE");
                    ++i;
                }
            }
        } else {
            s = String.valueOf(s) + "NULL PARAMETERS";
        }
        s = String.valueOf(s) + ") ";
        if (this.thrownExceptions != null) {
            if (this.thrownExceptions != NoExceptions) {
                s = String.valueOf(s) + "throws ";
                i = 0;
                length = this.thrownExceptions.length;
                while (i < length) {
                    if (i > 0) {
                        s = String.valueOf(s) + ", ";
                    }
                    s = String.valueOf(s) + (this.thrownExceptions[i] != null ? this.thrownExceptions[i].debugName() : "NULL TYPE");
                    ++i;
                }
            }
        } else {
            s = String.valueOf(s) + "NULL THROWN EXCEPTIONS";
        }
        return s;
    }

    public MethodBinding tiebreakMethod() {
        return this;
    }

    public TypeVariableBinding[] typeVariables() {
        return this.typeVariables;
    }
}

