/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _IPV4_ADDRESS_H
#define _IPV4_ADDRESS_H

union Inetv4Address
{
	struct S_un_b
	{
		unsigned char ub[4];
	} un_b;
	struct S_un_w
	{
		unsigned short uw[2];
	} un_w;
	unsigned long addr_l;
};

struct AdapterAddress
{
    Inetv4Address ip;
    Inetv4Address mask;
    Inetv4Address gw;
};

enum InetResult
{
    INET_OK = 0,
    INET_INVALID_PARAMETER,
    INET_INVALID_HOST,
    INET_INVALID_MASK,
    INET_INVALID_GATEWAY,
    INET_INVALID_ADDRESS,
    INET_INVALID_ADDRESS_TYPE,
    INET_MULTICAST_ADDRESS,
    INET_RESERVED_ADDRESS,
    INET_LOOPBACK_ADDRESS,
    INET_NETWORK_HOST_ADDRESS,
    INET_NETWORK_GATEWAY_ADDRESS,
    INET_BROADCAST_HOST_ADDRESS,
    INET_BROADCAST_GATEWAY_ADDRESS,
    INET_ADDRESS_NOT_MATCH
};

class IPv4AddressUtil
{
    private:
        //ctor
        IPv4AddressUtil();
        //check validation of mask
        static bool ValidateMask(Inetv4Address mask);
        //broadcast address or not
        static bool IsBroadcastAddress(Inetv4Address inetAddr, Inetv4Address mask);
        //multicast address or not
        static bool IsMulticastAddress(Inetv4Address hostAddr);

    public:
        //dtor
        virtual ~IPv4AddressUtil();

        //check validation of hoset addr
        static InetResult ValidateHostAddress(const Inetv4Address& hostAddr);
        //check validation of hoset addr
        static InetResult ValidateHostAddress(const char* pszHostAddr);
        //convert string into inetaddr
        static InetResult StringToInetAddress(const char* pszIpAddr, Inetv4Address* pInetAddr);
        //convert inetaddr inro string
        static InetResult InetAddressToString(const Inetv4Address* pInetAddr, char* pszIpAddr);
        //check validation
        static InetResult ValidateAdapterAddress(const AdapterAddress* pAdptAddr, bool strictType = false);
        //check validation
        static InetResult ValidateAdapterAddress(const char* pszHost, const char* pszMask, const char* pszGateway, bool strictType = false);
};

#endif // _IPV4_ADDRESS_H
