/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef TASKBARBALLOONLAN_H_INCLUDED
#define TASKBARBALLOONLAN_H_INCLUDED

#include <wx/event.h>
#include <wx/timer.h>
#include <wx/frame.h>
#include <wx/sizer.h>
#include <wx/stattext.h>
#include <wx/dcprint.h>
#include <wx/dcclient.h>
#include <wx/image.h>
#include <wx/statbmp.h>
#include <wx/gbsizer.h>
#include <wx/bmpbuttn.h>
#include "BitmapDialog.h"

class TaskBarBalloonLAN : public wxBitmapDialog
{
    public:
        TaskBarBalloonLAN(wxBitmapDialog *dlg, const wxString& title);
        virtual ~TaskBarBalloonLAN();

        /** painting bg */
        void OnPaint(wxPaintEvent& event);
        /** click on the balloon */
        void OnClick(wxMouseEvent & event);

        void SetConnectionTip(wxString wxsSuccTip);
        void SetConnectionType(wxString wxsType);
        void SetConnectionSpeed(wxString wxsSpeed);
        void SetConnectionStatus(wxString wxsStatus);

		wxStaticText* m_TypeTip;
		wxStaticText* m_StatusTip;
		wxStaticText* m_SuccTip;
		wxStaticText* m_Type;
		wxStaticText* m_Speed;
		wxStaticText* m_Status;
		wxStaticText* m_SpeedTip;

    protected:
		static const long ID_STATICTEXT_SUCCTIP;
		static const long ID_STATICTEXT_TYPETIP;
		static const long ID_STATICTEXT_TYPE;
		static const long ID_STATICTEXT_SPEEDTIP;
		static const long ID_STATICTEXT_SPEED;
		static const long ID_STATICTEXT_STATUSTIP;
		static const long ID_STATICTEXT_STATUS;
		static const long ID_STATICTEXT_SIGNALQUALITYTIP;
		static const long ID_STATICBITMAP_SIGNALQUALITY;
		static const long ID_STATICTEXT_SIGNALQUALITY;

        DECLARE_EVENT_TABLE();

};

#endif // TASKBARBALLOONLAN_H_INCLUDED
