/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _SCHOOL_SETTING_IMPORTER_H_
#define _SCHOOL_SETTING_IMPORTER_H_

#include <wx/event.h>

class SchoolSettingImporter : public wxEvtHandler
{
    public:
        SchoolSettingImporter();
        virtual ~SchoolSettingImporter();

        bool ImportSchoolSetting(const wxString& strTarFile, wxArrayString* pasFailed);

    protected:
        static const wxString destDir;
        wxString m_strTempDir;
        long m_iCount;

        void ClearTempDir(const wxString& dir);
        int ConfirmOverwrite(const wxString& strFileName);

    DECLARE_EVENT_TABLE()
};

#endif // _SCHOOL_SETTING_IMPORTER_H_
