/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef SCANEVENT_H_INCLUDED
#define SCANEVENT_H_INCLUDED
#include <wx/event.h>
const unsigned int ID_SCAN_OVER = wxID_HIGHEST + 0x01000;
BEGIN_DECLARE_EVENT_TYPES()
    DECLARE_EVENT_TYPE(EVT_SCAN, -1)
END_DECLARE_EVENT_TYPES()

class ScanEvent : public wxEvent
{
    public:
        ScanEvent(unsigned int id = 0);
        virtual ~ScanEvent();
        virtual wxEvent* Clone() const;
        int index;
};

typedef void (wxEvtHandler::*wxScanEventFunction)(ScanEvent&);
#define EVT_SCAN(id, fn) DECLARE_EVENT_TABLE_ENTRY( EVT_SCAN, id, -1, \
    (wxObjectEventFunction) (wxEventFunction) (wxCommandEventFunction) (wxNotifyEventFunction) \
    wxStaticCastEvent( wxScanEventFunction, & fn ), (wxObject *) NULL ),

#endif // SCANEVENT_H_INCLUDED
