/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _PROFILE_WIRELESS_SETTINGS_H_
#define _PROFILE_WIRELESS_SETTINGS_H_

#include <wx/wizard.h>
#include <wx/stattext.h>
#include <wx/statline.h>
#include <wx/statbmp.h>
#include <wx/combobox.h>
#include <wx/button.h>
#include "CustomStaticText.h"
#include "wlan.h"

class ProfileWirelessSettings : public wxWizardPageSimple
{
public:
    ProfileWirelessSettings(wxWizard *wizard);
    virtual ~ProfileWirelessSettings();

    wxButton* m_buttonSn;
    wxTextCtrl* m_tcWNName;
    wxTextCtrl* m_tcKey;
    wxTextCtrl* m_tcConfirmKey;
    wxComboBox* m_cbbWt;
    wxComboBox* m_cbbSt;
    wxComboBox* m_cbbIndex;
    bool m_bNameChange;

private:
    static const long ID_WNNAMETEXTCTRL;
    static const long ID_SNBUTTON;
    static const long ID_STCOMBOBOX;
    static const long ID_WTCOMBOBOX;
    static const long ID_KEYTEXTCTRL;
    static const long ID_CONFIRM_KEYTEXTCTRL;

    wxString m_sWepKey;
    wxString m_sWpaKey;
    wxStaticText* m_textKey;
    wxStaticText* m_textConfirmKey;
    wxStaticText* m_textTip;
    wxStaticText* m_textKeyIdx;
    wxStaticText* m_textSt;
    wxStaticBitmap* m_sbPic2;
    wxStaticLine* m_lineSt2;
    wxStaticText* m_textPn;
    wxStaticText* m_textWirelessType;
    CustomStaticText* m_textWs;
    CustomStaticText* m_textDes2;

    wxWizardPageSimple *m_pagestep1;

    void InitButtonStatus();
    void SetApStatus(const APStatus& ap);

    void OnSecurityTypeSelected(wxCommandEvent& event);
    void OnButtonScanClicked(wxCommandEvent& event);
    void OnWirelessNetworkNameChanged(wxCommandEvent& event);

    DECLARE_EVENT_TABLE()

};

#endif // _PROFILE_WIRELESS_SETTINGS_H_
