/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "NetworkManagerDlg.h"
#include <wx/msgdlg.h>

#include <wx/settings.h>
#include <wx/font.h>
#include <wx/intl.h>
#include <wx/string.h>
#include "ENMApp.h"

#include "AboutDialog.h"
#include "pic/icon_manage.xpm"

#if defined(__UNIX__)
#include <arpa/inet.h>
//#include <net/if.h>
#include "DataCenterLinux.h"
#endif // defined(__UNIX__)

#if defined(__WXMSW__)
#include <wininet.h>
#include <Iphlpapi.h>
#include <wx/msw/registry.h>
#endif // defined(__WXMSW__)

#include "ENMUtil.h"
#include "FileTar.h"
#include "PolicyManager.h"
#include "ProfileManagerDlg.h"
#include "ProfileManagementControl.h"
//#include "CmpcBitmapButton.h"

#if defined(__WXMSW__)
static wxString logFile(_T("C:\\NetworkManagerDlg.log"));
#else
static wxString logFile(_T("/tmp/NetworkManagerDlg.log"));
#endif

const long NetworkManagerDlg::ID_CMBSWITCHPRFL = wxNewId();
const long NetworkManagerDlg::ID_BTNSCANNW = wxNewId();
const long NetworkManagerDlg::ID_BTNVIEWNGHBR = wxNewId();
const long NetworkManagerDlg::ID_BTNPRFLMGR = wxNewId();
const long NetworkManagerDlg::ID_BTNCTRLCONNECT = wxNewId();
const long NetworkManagerDlg::ID_BTNCTRLWRLS = wxNewId();
const long NetworkManagerDlg::ID_IMPORT = wxNewId();
const long NetworkManagerDlg::ID_EXIT = wxNewId();
const long NetworkManagerDlg::ID_CNCTPRFL = wxNewId();
const long NetworkManagerDlg::ID_SCANNW = wxNewId();
const long NetworkManagerDlg::ID_VIEWNGHBR = wxNewId();
const long NetworkManagerDlg::ID_PRFLMGR = wxNewId();
const long NetworkManagerDlg::ID_CTRLWRLS = wxNewId();
const long NetworkManagerDlg::ID_HLPCONT = wxNewId();
const long NetworkManagerDlg::ID_ABOUT = wxNewId();

const int NetworkManagerDlg::ID_TIMER_PROFILE = wxNewId();
const int NetworkManagerDlg::ID_TIMER_WIRELESS = wxNewId();

BEGIN_EVENT_TABLE(NetworkManagerDlg, wxFrame)
    EVT_COMBOBOX(ID_CMBSWITCHPRFL, NetworkManagerDlg::Onm_cmbSwitchPrflSelect)
    EVT_BUTTON(ID_BTNCTRLCONNECT, NetworkManagerDlg::OnButtonCtrlCnctClick)
    EVT_BUTTON(ID_BTNSCANNW, NetworkManagerDlg::OnButtonScanNwClick)
    EVT_BUTTON(ID_BTNVIEWNGHBR, NetworkManagerDlg::OnButtonViewNghbrClick)
    EVT_BUTTON(ID_BTNPRFLMGR, NetworkManagerDlg::OnButtonPrflMgrClick)
    EVT_BUTTON(ID_BTNCTRLWRLS, NetworkManagerDlg::OnButtonCtrlWrlsClick)
    EVT_MENU(ID_IMPORT, NetworkManagerDlg::ImportSchoolSetting)
    EVT_MENU(ID_EXIT, NetworkManagerDlg::Exit)
    EVT_MENU(ID_CNCTPRFL, NetworkManagerDlg::ConnectProfile)
    EVT_MENU(ID_SCANNW, NetworkManagerDlg::MenuScanNw)
    EVT_MENU(ID_VIEWNGHBR, NetworkManagerDlg::MenuViewNghbr)
    EVT_MENU(ID_PRFLMGR, NetworkManagerDlg::MenuProfileMgr)
    EVT_MENU(ID_CTRLWRLS, NetworkManagerDlg::MenuCtrlWrls)
    EVT_MENU(ID_HLPCONT, NetworkManagerDlg::MenuHelpContent)
    EVT_MENU(ID_ABOUT, NetworkManagerDlg::MenuAbout)
    EVT_WLAN_ACM(ID_WLAN_ACM_CONNECT, NetworkManagerDlg::OnWlanAcmEvent)
    EVT_PROFILE(ID_PROFILE_CHANGED, NetworkManagerDlg::OnProfileChangedEvent)
    EVT_PROFILE(ID_PROFILE_APPLY, NetworkManagerDlg::OnProfileChangedEvent)
    EVT_WIRELESS(ID_WIRELESS_NETWORK_SWITCH, NetworkManagerDlg::OnWirelessNetworkChanged)
    EVT_SWITCH_ADAPTER(ID_SWITCH_ADAPTER, NetworkManagerDlg::OnSwitchAdapterEvent)
    EVT_TIMER(ID_TIMER_PROFILE, NetworkManagerDlg::OnTimer)
    EVT_TIMER(ID_TIMER_WIRELESS, NetworkManagerDlg::OnTimer)
//#if defined(__WXMSW__)
    EVT_ACTIVATE(NetworkManagerDlg::OnActivate)
//#endif
END_EVENT_TABLE()

NetworkManagerDlg::NetworkManagerDlg(wxWindow* parent,wxWindowID id)
        : wxFrame(), m_importer(), m_pGaugeDialog(NULL)
        , m_timerProfile(this, ID_TIMER_PROFILE), m_timerWireless(this, ID_TIMER_WIRELESS)
{
    wxMenu* mbFile;
    wxMenu* mbTool;
    wxMenu* mbSetting;
    wxMenu* mbHelp;

    viewAPNeighborsDlg = new ViewAPNeighborsDlg(this);
    bConnectFinish = true;

    Create(parent, wxID_ANY, _("Network Manager"), wxDefaultPosition, wxDefaultSize, wxMINIMIZE_BOX | wxSYSTEM_MENU | wxCAPTION | wxCLOSE_BOX | wxCLIP_CHILDREN, _T("ENM_Network_Manager"));
    SetClientSize(wxSize(630,375));
    Move(wxPoint(-1,-1));

    m_pGaugeDialog = new GaugeDialog(this);

    //Panel
    m_pnlLeft = new wxPanel(this, wxID_ANY, wxPoint(0,0), wxSize(455,375), wxTAB_TRAVERSAL);
    m_pnlLeft->SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOW));
    m_pnlRight = new wxPanel(this, wxID_ANY, wxPoint(455,0), wxSize(175,375), wxTAB_TRAVERSAL);
//    m_pnlRight->SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_MENUBAR));

    //BitmapComboBox
    m_cmbSwitchPrfl = new wxBitmapComboBox(m_pnlLeft, ID_CMBSWITCHPRFL, _T(""), wxPoint(115,24), wxSize(219,27), 0, NULL, wxCB_READONLY | wxCB_DROPDOWN);
    m_cmbSwitchPrfl->SetPopupMaxHeight(200);

    //Control connect/disconnect profile button
    m_btnCtrlConnect = new wxButton(m_pnlLeft, ID_BTNCTRLCONNECT, _("Connect"), wxPoint(342,23), wxSize(106,29));

    //Static---Network profile
    m_stcNpTitle = new wxStaticText(m_pnlLeft, wxID_ANY, _("Network Profile:"), wxPoint(8,28), wxSize(100,20));

    //StaticBox
    m_stbNwInfo = new wxStaticBox(m_pnlLeft, wxID_ANY, _("Network Status"), wxPoint(8,68), wxSize(440,278));
    m_stbNwInfo->SetForegroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_HIGHLIGHT));
    m_stbNwInfo->SetFont(wxFont(10, wxSWISS, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("Arial"), wxFONTENCODING_DEFAULT));

    //Static---Curent connecting profile name
    m_stcCurrentPfle = new wxStaticText(m_pnlLeft, wxID_ANY, _T(""), wxPoint(24,178), wxSize(400,17));
    wxFont m_stcCurrentPfleFont(10, wxSWISS, wxFONTSTYLE_NORMAL, wxNORMAL, false, _T("Arial"), wxFONTENCODING_DEFAULT);
    m_stcCurrentPfle->SetFont(m_stcCurrentPfleFont);

#if defined(__WXMSW__)
    m_stcSQTitle = new wxStaticText(m_pnlLeft, wxID_ANY, _("Signal Quality:"), wxPoint(24,210), wxSize(130,24));
    m_gueSQ = new wxGauge(m_pnlLeft, wxID_ANY, 100, wxPoint(170,210), wxSize(158,16), wxGA_SMOOTH);
    m_gueSQ->SetShadowWidth(22);
    m_stcSQVal = new wxStaticText(m_pnlLeft, wxID_ANY, _T(""), wxPoint(338,210), wxSize(40,24));

    m_stcStatusTitle = new wxStaticText(m_pnlLeft, wxID_ANY, _("Status:"), wxPoint(24,240), wxSize(130,24));
    m_stcStatus = new wxStaticText(m_pnlLeft, wxID_ANY, _T(""), wxPoint(170,240), wxSize(216,24));

    m_stcTypeTitle = new wxStaticText(m_pnlLeft, wxD_ANY, _("Type:"), wxPoint(24,270), wxSize(130,24));
    m_stcType = new wxStaticText(m_pnlLeft, ID_STCTYPE, _T(""), wxPoint(170,270), wxSize(216,24));

    m_stcIPAddrTitle = new wxStaticText(m_pnlLeft, wxD_ANY,_("IP Address:"), wxPoint(24,300), wxSize(130,24));
    m_stcIPAddr = new wxStaticText(m_pnlLeft, wxD_ANY, _T(""), wxPoint(170,300), wxSize(216,24));
#endif
#if defined(__UNIX__)
    m_stcSQTitle = new wxStaticText(m_pnlLeft, wxID_ANY, _("Signal Quality:"), wxPoint(24,210), wxSize(140,24));
    m_gueSQ = new wxGauge(m_pnlLeft, wxID_ANY, 100, wxPoint(170,210), wxSize(158,16), wxGA_SMOOTH);
    m_gueSQ->SetShadowWidth(22);
    m_stcSQVal = new wxStaticText(m_pnlLeft, wxID_ANY, _T(""), wxPoint(328,210), wxSize(40,24));

    m_stcStatusTitle = new wxStaticText(m_pnlLeft, wxID_ANY, _("Status:"), wxPoint(24,240), wxSize(140,24));
    m_stcStatus = new wxStaticText(m_pnlLeft, wxID_ANY, _T(""), wxPoint(170,240), wxSize(216,24));

    m_stcTypeTitle = new wxStaticText(m_pnlLeft, wxID_ANY, _("Type:"), wxPoint(24,270), wxSize(140,24));
    m_stcType = new wxStaticText(m_pnlLeft, wxID_ANY, _T(""), wxPoint(170,270), wxSize(216,24));

    m_stcIPAddrTitle = new wxStaticText(m_pnlLeft, wxID_ANY,_("IP Address:"), wxPoint(24,300), wxSize(140,24));
    m_stcIPAddr = new wxStaticText(m_pnlLeft, wxID_ANY, _T(""), wxPoint(170,300), wxSize(216,24));
#endif

    m_mbFile = new wxMenuBar();
    mbFile = new wxMenu();
    m_menuImpSetting = new wxMenuItem(mbFile, ID_IMPORT, _("&Import School Settings ..."), wxEmptyString, wxITEM_NORMAL);
    mbFile->Append(m_menuImpSetting);
    mbFile->AppendSeparator();
    m_menuExitDlg = new wxMenuItem(mbFile, ID_EXIT, _("&Exit"), wxEmptyString, wxITEM_NORMAL);
    mbFile->Append(m_menuExitDlg);
    m_mbFile->Append(mbFile, _("&File"));
    mbTool = new wxMenu();
    m_menuCnctPrfl = new wxMenuItem(mbTool, ID_CNCTPRFL, _("&Connect"), wxEmptyString, wxITEM_NORMAL);
    mbTool->Append(m_menuCnctPrfl);
    mbTool->AppendSeparator();
    m_menuScanNW = new wxMenuItem(mbTool, ID_SCANNW, _("&Scan for Networks"), wxEmptyString, wxITEM_NORMAL);
    mbTool->Append(m_menuScanNW);
    m_menuViewNghbr = new wxMenuItem(mbTool, ID_VIEWNGHBR, _("&View Neighbors"), wxEmptyString, wxITEM_NORMAL);
    mbTool->Append(m_menuViewNghbr);
    m_mbFile->Append(mbTool, _("&Tools"));
    mbSetting = new wxMenu();
    m_menuPrflMgr = new wxMenuItem(mbSetting, ID_PRFLMGR, _("&Profile Manager"), wxEmptyString, wxITEM_NORMAL);
    mbSetting->Append(m_menuPrflMgr);

    mbSetting->AppendSeparator();

    m_menuCtrlWrls = new wxMenuItem(mbSetting, ID_CTRLWRLS, _("T&urn on wireless"), wxEmptyString, wxITEM_NORMAL);

    mbSetting->Append(m_menuCtrlWrls);
    m_mbFile->Append(mbSetting, _("&Settings"));
    mbHelp = new wxMenu();
    m_menuHelpContent = new wxMenuItem(mbHelp, ID_HLPCONT, _("Help &Contents  \tF1"), wxEmptyString, wxITEM_NORMAL);
    mbHelp->Append(m_menuHelpContent);
    m_menuAboutContent = new wxMenuItem(mbHelp, ID_ABOUT, _("&About"), wxEmptyString, wxITEM_NORMAL);
    mbHelp->Append(m_menuAboutContent);
    m_mbFile->Append(mbHelp, _("&Help"));
    SetMenuBar(m_mbFile);

    wxBitmap bitmapScanNw(wxImage(::wxGetApp().strImagePath + _T("Scannw.png")));
    wxBitmap bitmapNeighbors(wxImage(::wxGetApp().strImagePath + _T("Neighbors.png")));
    wxBitmap bitmapPrflMgr(wxImage(::wxGetApp().strImagePath + _T("NetManager.png")));
#if defined(__WXMSW__)
    wxBitmap bitmapScanDisabled(wxImage(::wxGetApp().strImagePath + _T("Scannw_d.png")));
    m_btnScanNetwork = new CmpcBitmapButton(m_pnlRight, ID_BTNSCANNW, 148, 80, _("Scan for Networks"), bitmapScanNw);
    m_btnScanNetwork->Move(10,24);
    m_btnScanNetwork->SetDisabledBitmap(bitmapScanDisabled);

    wxBitmap bitmapNeighborsDisabled(wxImage(::wxGetApp().strImagePath + _T("Neighbors_d.png")));
    m_btnViewNeighbor = new CmpcBitmapButton(m_pnlRight, ID_BTNVIEWNGHBR, 148, 80, _("Neighbors"), bitmapNeighbors);
    m_btnViewNeighbor->Move(10,120);
    m_btnViewNeighbor->SetDisabledBitmap(bitmapNeighborsDisabled);

    wxBitmap bitmapPrflMgrDisabled(wxImage(::wxGetApp().strImagePath + _T("NetManager_d.png")));
    m_btnProfileManager = new CmpcBitmapButton(m_pnlRight, ID_BTNPRFLMGR, 148, 80, _("Profile Manager"), bitmapPrflMgr);
    m_btnProfileManager->Move(10,216);
    m_btnProfileManager->SetDisabledBitmap(bitmapPrflMgrDisabled);

    m_btnCtrlWireless = new wxButton(m_pnlRight, ID_BTNCTRLWRLS, _("Turn off wireless"), wxPoint(10,314), wxSize(m_btnProfileManager->GetSize().GetWidth(), 32));
#endif
#if defined(__UNIX__)
    m_btnScanNetwork = new wxButton(m_pnlRight, ID_BTNSCANNW, wxEmptyString, wxPoint(16,24), wxSize(148,80));
    m_bmpScanNetwork = new wxStaticBitmap(m_pnlRight, wxID_ANY, bitmapScanNw, wxPoint(66,30), wxDefaultSize);
    ScanNtBtnText = new wxStaticText(m_pnlRight, wxID_ANY, _("Scan for Networks"), wxPoint(16,78), wxSize(148,26), wxALIGN_CENTER_VERTICAL | wxALIGN_CENTRE);

    m_btnViewNeighbor = new wxButton(m_pnlRight, ID_BTNVIEWNGHBR, wxEmptyString, wxPoint(16,120), wxSize(148,80));
    m_bmpViewNeighbor = new wxStaticBitmap(m_pnlRight, wxID_ANY, bitmapNeighbors, wxPoint(66,126), wxDefaultSize);
    NeightorText = new wxStaticText(m_pnlRight, wxID_ANY, _("Neighbors"), wxPoint(16,174), wxSize(148,26), wxALIGN_CENTER_VERTICAL | wxALIGN_CENTRE);

    m_btnProfileManager = new wxButton(m_pnlRight, ID_BTNPRFLMGR, wxEmptyString, wxPoint(16,216), wxSize(148,80));
    m_bmpProfileManager = new wxStaticBitmap(m_pnlRight, wxID_ANY, bitmapPrflMgr, wxPoint(66,222), wxDefaultSize);
    PrflMgrText = new wxStaticText(m_pnlRight, wxID_ANY, _("Profile Manager"), wxPoint(16,270), wxSize(148,26), wxALIGN_CENTER_VERTICAL | wxALIGN_CENTRE);

    m_btnCtrlWireless = new wxButton(m_pnlRight, ID_BTNCTRLWRLS, _("Turn off wireless"), wxPoint(16,314), wxSize(148,32));
#endif

    Center();

    m_NwInfoBmp = new wxStaticBitmap(m_pnlLeft, wxID_ANY, wxBitmap(wxImage(::wxGetApp().strImagePath + _T("cnctimage_wired.png"))), wxPoint(24,98), wxSize(370,70));

    m_isApplyingProfile = false;
    m_iSelectedToApply = -1;
    wxIcon icon_manager(icon_manage_xpm);
    SetIcon(icon_manager);
}

NetworkManagerDlg::~NetworkManagerDlg()
{
    m_pGaugeDialog->Destroy();
    m_pGaugeDialog = NULL;
}

void NetworkManagerDlg::OnActivate(wxActivateEvent& event)
{
    if ( !IsApplyingProfile() )
    {
        if ( event.GetActive() )
        {
            SetNetworkProfile();
//            Show(true);
//            Raise();
        }
        event.Skip();
    }

}

bool NetworkManagerDlg::Destroy()
{
    if ( ::wxGetApp().GetENMTaskTray()->IsProtocolSupported() )
    {
        Show(false);
    }
    else
    {
        ::wxExit();
    }
    return true;
}

bool NetworkManagerDlg::Show(bool show)
{
    if ( show )
    {
        SetNetworkProfile();
    }
    else
    {
        m_pGaugeDialog->Show(false);
    }
    return wxFrame::Show(show);
}

void NetworkManagerDlg::SetNetworkProfile()
{
    ProfileManagementControl* pController = DataCenter::GetInstance()->GetProfileController();
    wxString currentProfile = pController->GetCurrentProfile();
    ProfileList_t cp = pController->GetCurrentUsedProfile();
//    m_stcCurrentPfle->SetLabel(currentProfile);
    int iSelection = -1;
    if ( !pController->GetUserProfiles(m_profileVector, ENMUtil::IsAdministrator(), true) )
        return;

    unsigned int i;
    for ( i = 0; i < m_cmbSwitchPrfl->GetCount(); i++ )
    {
        int* pInt = static_cast<int*>(m_cmbSwitchPrfl->GetClientData(i));
        m_cmbSwitchPrfl->SetClientData(i, NULL);
        delete pInt;
    }
    m_cmbSwitchPrfl->Clear();
    if ( m_profileVector.size() == 0 )
    {
        m_btnCtrlConnect->Enable(false);
        m_menuCnctPrfl->Enable(false);
        return;
    }

    m_cmbSwitchPrfl->SetValue(currentProfile);
    if ( currentProfile.length() == 0 )
    {
        m_btnCtrlConnect->Enable(false);
        m_menuCnctPrfl->Enable(false);
    }
    i = 0;
    wxString strBmpName = wxT("");
    static const size_t PROFILE_ICON_COUNT = 8;
    for ( vector<ProfileList_t>::size_type index = 0; index < m_profileVector.size(); index++ )
    {
        ProfileList_t profile = m_profileVector.at(index);
        if ( profile.sShow != _T("1") )
            continue;

        long bmpNum = 0;
		profile.sProfileIcon.ToLong(&bmpNum);
#if defined(__WXMSW__)
        if ( bmpNum >=0 && bmpNum < PROFILE_ICON_COUNT )
        {
            strBmpName = wxString::Format(_T("pic\\pficon_%d.png"), bmpNum);
        }
        else
        {
            strBmpName = _T("pic\\empty_profile.png");
        }
#else
        if ( bmpNum >=0 && bmpNum < PROFILE_ICON_COUNT )
        {
            strBmpName = wxString::Format(_T("pic/pficon_%d.png"), bmpNum);
        }
        else
        {
            strBmpName = _T("pic/empty_profile.png");
        }
#endif
        wxBitmap iconBmp(::wxGetApp().strAppPath + strBmpName, wxBITMAP_TYPE_PNG);
        wxString profileName = profile.sProfileName;
        m_cmbSwitchPrfl->Append(profileName, iconBmp);
        m_cmbSwitchPrfl->SetClientData(i, new int(index));
        if ( profileName == currentProfile && profile.sPermission == cp.sPermission )
        {
            iSelection = i;
        }
        i++;
    }
    m_cmbSwitchPrfl->SetSelection(iSelection);
    m_iSelectedToApply = iSelection;
}

void NetworkManagerDlg::ImportSchoolSetting(wxCommandEvent& event)
{
    if ( DataCenter::GetInstance()->GetProfileManagerDlgHandle()->IsShown() )
    {
        wxMessageDialog msg(this, _("The Profile Manager dialog is already open. \nPlease close it before importing school settings."), wxEmptyString, wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        return;
    }

    wxFileDialog dialog(this, _("Please choose a file to import"), wxEmptyString, wxEmptyString, _T("*.tar|*.tar"), wxFD_OPEN | wxFD_FILE_MUST_EXIST);
    if ( dialog.ShowModal() == wxID_OK )
    {
        wxString strTarFile = dialog.GetPath();
        wxArrayString as;
        if ( m_importer.ImportSchoolSetting(strTarFile, &as) )
        {
            wxMessageDialog msg(this, _("Import successful."), wxEmptyString, wxOK | wxICON_INFORMATION);
            msg.ShowModal();
            SetNetworkProfile();
        }
        else
        {
            wxString message(_("Failed to import school settings.\n"));
            if ( as.GetCount() > 0 )
            {
                message += _("\nThe following files were not imported.");
                for ( size_t i = 0; i < as.Count(); i++ )
                {
                    message += (_T("\n") + as.Item(i));
                }
            }
            wxMessageDialog msg(this, message, wxEmptyString, wxOK | wxICON_INFORMATION);
            msg.ShowModal();
        }
        // import policy
        DataCenter::GetInstance()->ReloadSchoolPolicy();
    }
}

void NetworkManagerDlg::Exit(wxCommandEvent& event)
{
    Close();
}

void NetworkManagerDlg::ConnectProfile(wxCommandEvent& event)
{
    if ( !ENMTaskTray::GetInstance()->GetApplyWirelessFlag() )
    {
        return;
    }
//    DataCenter::GetInstance()->SetAutoWirelessFlag(false);
    OnConnectProfile();
}

void NetworkManagerDlg::MenuScanNw(wxCommandEvent& event)
{
    OnButtonScanNwClick(event);
}

void NetworkManagerDlg::MenuViewNghbr(wxCommandEvent& event)
{
    if ( !ENMTaskTray::GetInstance()->GetApplyWirelessFlag() )
    {
        return;
    }
	if ( NULL == viewAPNeighborsDlg )
    {
        viewAPNeighborsDlg = new ViewAPNeighborsDlg(NULL);
    }
    viewAPNeighborsDlg->ShowModal();
}

void NetworkManagerDlg::MenuProfileMgr(wxCommandEvent& event)
{
    OnButtonPrflMgrClick(event);
}

void NetworkManagerDlg::MenuCtrlWrls(wxCommandEvent& event)
{
    OnButtonCtrlWrlsClick(event);
}

void NetworkManagerDlg::MenuHelpContent(wxCommandEvent& event)
{
	ENMUtil::ShowContextHelp(this, _T("ProfileManager"));
}

void NetworkManagerDlg::MenuAbout(wxCommandEvent& event)
{
    AboutDialog dlg(this);
    dlg.ShowModal();
}

void NetworkManagerDlg::OnButtonCtrlCnctClick(wxCommandEvent& event)
{
    if ( !ENMTaskTray::GetInstance()->GetApplyWirelessFlag() )
    {
        return;
    }
    if ( IsApplyingProfile() )
    {
        return;
    }

    ScanNetworkDlg* pScanNetworkDlg = DataCenter::GetInstance()->GetScanNetworkDlgHandle();
    if ( pScanNetworkDlg->IsShown() )
    {
        pScanNetworkDlg->CloseDialog(wxID_CANCEL);
    }

//    DataCenter::GetInstance()->SetAutoWirelessFlag(false);
    OnConnectProfile();
}

void NetworkManagerDlg::OnButtonScanNwClick(wxCommandEvent& event)
{
    PolicyManager* p = DataCenter::GetInstance()->GetPolicyManager();
    if ( !p->IsScanEnable() )
    {
        wxMessageDialog dlg(this, _("The current policy forbids scanning for wireless networks."), wxEmptyString, wxOK | wxICON_INFORMATION);
        dlg.ShowModal();
        return;
    }

    if ( !ENMTaskTray::GetInstance()->GetApplyWirelessFlag() )
    {
        return;
    }
    if ( IsApplyingProfile() )
    {
        return;
    }

    ScanNetworkDlg* pScanNetworkDialog = DataCenter::GetInstance()->GetScanNetworkDlgHandle();
    pScanNetworkDialog->SetDialogMode(true);
    pScanNetworkDialog->ShowModal();
}

void NetworkManagerDlg::OnButtonViewNghbrClick(wxCommandEvent& event)
{
    if ( !ENMTaskTray::GetInstance()->GetApplyWirelessFlag() )
    {
        return;
    }
    if ( NULL == viewAPNeighborsDlg )
    {
        viewAPNeighborsDlg = new ViewAPNeighborsDlg(NULL);
    }
//    viewAPNeighborsDlg->Move(257, 110);
    viewAPNeighborsDlg->ShowModal();
}

void NetworkManagerDlg::OnButtonPrflMgrClick(wxCommandEvent& event)
{
    if ( IsApplyingProfile() )
    {
        return;
    }

    if ( !ENMTaskTray::GetInstance()->GetApplyWirelessFlag() )
    {
        return;
    }

    PolicyManager* p = DataCenter::GetInstance()->GetPolicyManager();
    if ( !p->IsAllowOwnerProfile() )
    {
        wxMessageDialog dlg(this, _("The current policy forbids maintaining profiles."), wxEmptyString, wxOK | wxICON_INFORMATION);
        dlg.ShowModal();
        return;
    }

    ScanNetworkDlg* pScanNetworkDlg = DataCenter::GetInstance()->GetScanNetworkDlgHandle();
    if ( pScanNetworkDlg != NULL && pScanNetworkDlg->IsShown() )
        pScanNetworkDlg->CloseDialog(wxID_CANCEL);

    ProfileManagerDlg* pProfileManagerDlg = DataCenter::GetInstance()->GetProfileManagerDlgHandle();
    if( pProfileManagerDlg == NULL )
    {
        return;
    }

    ENMTaskTray::GetInstance()->HideShownBalloon();
    pProfileManagerDlg->Iconize(false);
    pProfileManagerDlg->Show(true);
    pProfileManagerDlg->Raise();
}

void NetworkManagerDlg::Onm_cmbSwitchPrflSelect(wxCommandEvent& event)
{
    if ( m_cmbSwitchPrfl->GetCount() == 0 )
        return;
    m_iSelectedToApply = event.GetSelection();
    if ( m_iSelectedToApply == wxNOT_FOUND )
        return;

    int* pInt = static_cast<int*>(m_cmbSwitchPrfl->GetClientData(m_iSelectedToApply));
    ProfileList_t cp = m_profileVector.at(*pInt);
    ProfileList_t profile = DataCenter::GetInstance()->GetProfileController()->GetCurrentUsedProfile();

    if ( cp.sProfileName == profile.sProfileName && cp.sPermission == profile.sPermission )
    {
        m_btnCtrlConnect->SetLabel(_("Disconnect"));
        m_menuCnctPrfl->SetText(_("&Disconnect"));
    }
    else
    {
        m_btnCtrlConnect->SetLabel(_("Connect"));
        m_menuCnctPrfl->SetText(_("&Connect"));
    }

    m_btnCtrlConnect->Enable(true);
    m_menuCnctPrfl->Enable(true);
}

void NetworkManagerDlg::OnButtonCtrlWrlsClick(wxCommandEvent& event)
{
    PolicyManager* p = DataCenter::GetInstance()->GetPolicyManager();
    if ( !p->IsAllowTurnOnWireless() )
    {
        wxMessageDialog dlg(this, _("The current policy forbids turning on/off wireless."), wxEmptyString, wxOK | wxICON_INFORMATION);
        dlg.ShowModal();
        return;
    }

    bool wlanFoundAdapter = false;
#if defined(__WXMSW__)
    wxArrayString array = DataCenter::GetInstance()->GetNetworkAdapterName(ADAPTER_WIREDLESS);
    wlanFoundAdapter = array.GetCount() > 0;
#endif
#if defined(__UNIX__)
    BOOL existWirelessAdapter;
    DCS_IsExistAdapter(DCS_ADAPTER_WIREDLESS, &existWirelessAdapter);
    wlanFoundAdapter = existWirelessAdapter ? true : false;
#endif
    if ( !wlanFoundAdapter )
    {
        wxMessageDialog msg(this, _("Cannot find wireless adapter!"), wxEmptyString, wxOK | wxICON_INFORMATION);
        msg.ShowModal();
    }
    else
    {
        SetWirelessSwitch();
    }
}

void NetworkManagerDlg::SetWirelessSwitch()
{
    if ( !ENMTaskTray::GetInstance()->GetApplyWirelessFlag() )
    {
        return;
    }

    if ( IsApplyingProfile() )
    {
        return;
    }

    m_btnCtrlWireless->Enable(false);
    m_timerWireless.Start(30000, wxTIMER_ONE_SHOT);

    DataCenter* pDataCenter = DataCenter::GetInstance();
    NETWORK_MODE networkMode = pDataCenter->GetCurrentNetworkMode();
    switch ( networkMode )
    {
    case NETWORK_MODE_WIRED_LAN_CONNECT:
    case NETWORK_MODE_WIRED_LAN_DISCONNECT:
        pDataCenter->SwitchAdapterParameter(ADAPTER_WIRED, ADAPTER_WIREDLESS, this);
        pDataCenter->SetShowBalloonFlag(false);
//        pDataCenter->EnableNetworkAdapter(ADAPTER_WIRED,false);
//        pDataCenter->EnableNetworkAdapter(ADAPTER_WIREDLESS,true);
        break;

    case NETWORK_MODE_WIRELESS_LAN_CONNECT:
    case NETWORK_MODE_WIRELESS_LAN_DISCONNECT:
        ENMTaskTray::GetInstance()->SetWaitingForSwitch(true);
        pDataCenter->SwitchAdapterParameter(ADAPTER_WIREDLESS, ADAPTER_WIRED, this);
//        pDataCenter->EnableNetworkAdapter(ADAPTER_WIREDLESS,false);
//        pDataCenter->EnableNetworkAdapter(ADAPTER_WIRED,true);
        break;

    case NETWORK_MODE_DISCONNECTED:
        pDataCenter->SwitchAdapterParameter(ADAPTER_NONE, ADAPTER_WIREDLESS, this);
//        pDataCenter->EnableNetworkAdapter(ADAPTER_WIREDLESS,true);
        break;

    default:
        break;
    }
}

void NetworkManagerDlg::EnableSQInfo(bool enable)
{
    if ( !enable )
    {
        m_gueSQ->SetValue(0);
    }
    m_gueSQ->Enable(enable);
    m_stcSQTitle->Enable(enable);
    m_stcSQVal->Show(enable);
}

void NetworkManagerDlg::EnableScanNTandViewNb(bool enable)
{
    m_btnScanNetwork->Enable(enable);
    m_menuScanNW->Enable(enable);
    m_btnViewNeighbor->Enable(enable);
    m_menuViewNghbr->Enable(enable);
#if defined(__UNIX__)
    ScanNtBtnText->Enable(enable);
    m_bmpScanNetwork->Enable(enable);
    NeightorText->Enable(enable);
    m_bmpViewNeighbor->Enable(enable);
#endif
}

void NetworkManagerDlg::UI_UpdateNetworkMode(NETWORK_MODE networkMode)
{
    if ( !m_cmbSwitchPrfl->GetValue().Cmp(_T("")) )
    {
         m_btnCtrlConnect->Enable(false);
         m_menuCnctPrfl->Enable(false);
         m_btnCtrlConnect->SetLabel(_("Connect"));
         m_menuCnctPrfl->SetText(_("&Connect"));
    }
    else
    {
        m_btnCtrlConnect->Enable(true);
        m_menuCnctPrfl->Enable(true);
    }

    wxBitmap bitmap ;
    switch ( networkMode )
    {
        case NETWORK_MODE_WIRED_LAN_CONNECT:
        {
#if defined(__WXMSW__)
            bitmap = wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\cnctimage_wired.png")));
#endif
#if defined(__UNIX__)
            bitmap = wxBitmap(wxImage(::wxGetApp().strImagePath + _T("cnctimage_wired.png")));
#endif
            EnableSQInfo(false);
            EnableScanNTandViewNb(false);

            m_btnCtrlWireless->SetLabel(_("Turn on wireless"));
            m_menuCtrlWrls->SetText(_("T&urn on wireless"));
            if ( m_cmbSwitchPrfl->GetValue().Cmp(_T("")) && DataCenter::GetInstance()->GetProfileController()->GetCurrentProfile().length() != 0 )
            {
	            m_btnCtrlConnect->SetLabel(_("Disconnect"));
	            m_menuCnctPrfl->SetText(_("&Disconnect"));
            }
            else
            {
                m_btnCtrlConnect->SetLabel(_("Connect"));
	            m_menuCnctPrfl->SetText(_("&Connect"));
            }

        }
        break;
        case NETWORK_MODE_WIRED_LAN_DISCONNECT:
        {
#if defined(__WXMSW__)
            bitmap = wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\cnctimage_disconnect.png")));
#endif
#if defined(__UNIX__)
            bitmap = wxBitmap(wxImage(::wxGetApp().strImagePath + _T("cnctimage_disconnect.png")));
#endif
            EnableSQInfo(false);
            EnableScanNTandViewNb(false);

            m_btnCtrlWireless->SetLabel(_("Turn on wireless"));
            m_menuCtrlWrls->SetText(_("T&urn on wireless"));

            if ( m_cmbSwitchPrfl->GetValue().Cmp(_T("")) )
            {
	            m_btnCtrlConnect->SetLabel(_("Connect"));
	            m_menuCnctPrfl->SetText(_("&Connect"));
            }
        }
        break;
        case NETWORK_MODE_WIRELESS_LAN_CONNECT:
        {
#if defined(__WXMSW__)
            bitmap = wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\cnctimage.png")));
#endif
#if defined(__UNIX__)
            bitmap = wxBitmap(wxImage(::wxGetApp().strImagePath + _T("cnctimage.png")));
#endif
            EnableSQInfo(true);
            EnableScanNTandViewNb(true);

            m_btnCtrlWireless->SetLabel(_("Turn off wireless"));
            m_menuCtrlWrls->SetText(_("T&urn off wireless"));

            if ( m_cmbSwitchPrfl->GetValue().Cmp(_T("")) && DataCenter::GetInstance()->GetProfileController()->GetCurrentProfile().length() != 0 )
            {
	            m_btnCtrlConnect->SetLabel(_("Disconnect"));
	            m_menuCnctPrfl->SetText(_("&Disconnect"));
            }
            else
            {
                m_btnCtrlConnect->SetLabel(_("Connect"));
	            m_menuCnctPrfl->SetText(_("&Connect"));
            }
        }
        break;
        case NETWORK_MODE_WIRELESS_LAN_DISCONNECT:
        {
#if defined(__WXMSW__)
            bitmap = wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\cnctimage_disconnect.png")));
#endif
#if defined(__UNIX__)
            bitmap = wxBitmap(wxImage(::wxGetApp().strImagePath + _T("cnctimage_disconnect.png")));
#endif
            EnableSQInfo(true);
            EnableScanNTandViewNb(true);

            m_btnCtrlWireless->SetLabel(_("Turn off wireless"));
            m_menuCtrlWrls->SetText(_("T&urn off wireless"));

            if ( m_cmbSwitchPrfl->GetValue().Cmp(_T("")) )
            {
	            m_btnCtrlConnect->SetLabel(_("Connect"));
	            m_menuCnctPrfl->SetText(_("&Connect"));
            }
        }
        break;

        case NETWORK_MODE_DISCONNECTED:
        {
#if defined(__WXMSW__)
            bitmap = wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\cnctimage_disconnect.png")));
#endif
#if defined(__UNIX__)
            bitmap = wxBitmap(wxImage(::wxGetApp().strImagePath + _T("cnctimage_disconnect.png")));
#endif
            m_btnCtrlWireless->SetLabel(_("Turn on wireless"));
            m_menuCtrlWrls->SetText(_("T&urn on wireless"));

            if ( m_cmbSwitchPrfl->GetValue().Cmp(_T("")) )
            {
	            m_btnCtrlConnect->SetLabel(_("Connect"));
	            m_menuCnctPrfl->SetText(_("&Connect"));
            }
            EnableSQInfo(false);
            EnableScanNTandViewNb(false);
        }
        break;
        default:
        break;
    }

    m_NwInfoBmp->SetBitmap(bitmap);
    m_NwInfoBmp->Refresh();
//    m_btnCtrlWireless->Enable(true);
//    RefreshProfileName();
}

void NetworkManagerDlg::UI_UpdateNetworkStatusInfo(NETWORK_MODE networkMode, UI_NETWORK_STATUS_INFO& statusInfo)
{
     wxString strCurrentSelection = m_cmbSwitchPrfl->GetValue().Trim(false);
     wxString strCurrentProfile = DataCenter::GetInstance()->GetProfileController()->GetCurrentProfile();
     switch ( networkMode )
     {
        case NETWORK_MODE_WIRED_LAN_CONNECT:
            m_stcStatus->SetLabel(_("Connected"));
            m_stcType->SetLabel(statusInfo.Type);
            m_stcIPAddr->SetLabel(statusInfo.IPAddress);
            break;
        case NETWORK_MODE_WIRED_LAN_DISCONNECT:
            m_stcStatus->SetLabel(_("Disconnected"));
            m_stcType->SetLabel(_T(""));
            //m_stcIPAddr->SetLabel(statusInfo.IPAddress);
            m_stcIPAddr->SetLabel(_T(""));
            break;
        case NETWORK_MODE_WIRELESS_LAN_CONNECT:
            m_gueSQ->SetValue(statusInfo.SignalQuality);
            m_stcSQVal->SetLabel(wxString::Format(_T("%d"),statusInfo.SignalQuality) + _T("%"));
            m_stcStatus->SetLabel(_("Connected"));
            m_stcType->SetLabel(statusInfo.Type);
            m_stcIPAddr->SetLabel(statusInfo.IPAddress);
//            m_stcIPAddr->SetLabel(_T(""));
            break;
        case NETWORK_MODE_WIRELESS_LAN_DISCONNECT:
            m_gueSQ->SetValue(0);
            m_stcSQVal->SetLabel(_T(""));
            m_stcStatus->SetLabel(_("Disconnected"));
            m_stcType->SetLabel(_T(""));
            m_stcIPAddr->SetLabel(_T(""));
            break;
        case NETWORK_MODE_DISCONNECTED:
            m_stcStatus->SetLabel(_T(""));
            m_stcType->SetLabel(_T(""));
            m_stcIPAddr->SetLabel(_T(""));
            break;
        default:
            break;
     }
     RefreshProfileName();
}

void NetworkManagerDlg::ShowApplyingProcessDialog(const wxString& profileName, bool show)
{
    m_isApplyingProfile = show;
    wxString label = _("Applying profile ") + profileName.Mid(0, 10) + _T("...");
    label.Replace(_T("&"), _T("&&"));
    m_pGaugeDialog->SetProcessLabel(label);
    m_pGaugeDialog->Show(show);
#if defined(__UNIX__)
    m_pGaugeDialog->Move(377, 270);
#endif
}

void NetworkManagerDlg::SetComboxCurrentProfileName()
{
    m_cmbSwitchPrfl->SetValue(DataCenter::GetInstance()->GetProfileController()->GetCurrentProfile());
}

void NetworkManagerDlg::OnWlanAcmEvent(WlanAcmEvent& event)
{
    wxString strName = DataCenter::GetInstance()->GetProfileController()->GetCurrentProfile();
    strName.Replace(_T("&"), _T("&&"));
    m_stcCurrentPfle->SetLabel(strName);
}

void NetworkManagerDlg::OnTimer(wxTimerEvent& event)
{
    int id = event.GetId();
    if ( id == ID_TIMER_PROFILE )
    {
        wxString strProfile = m_cmbSwitchPrfl->GetValue();
        if ( strProfile.Length() != 0 )
        {
            m_btnCtrlConnect->Enable(true);
            m_menuCnctPrfl->Enable(true);
        }
    }
    else if ( id == ID_TIMER_WIRELESS )
    {
        m_btnCtrlWireless->Enable(true);
    }
}

void NetworkManagerDlg::OnConnectProfile()
{
//    wxString profileName = m_cmbSwitchPrfl->GetValue();
//    if ( profileName.Cmp(_T("")) == 0 )
//        return;

    ProfileManagementControl* pController = DataCenter::GetInstance()->GetProfileController();
    bConnectFinish = false;
    if ( !m_btnCtrlConnect->GetLabel().Cmp(_("Connect")) )
    {
        DataCenter::GetInstance()->SetShowBalloonFlag(false);
        if ( m_iSelectedToApply == wxNOT_FOUND )
            return;
        int* pProfileIndex = static_cast<int*>(m_cmbSwitchPrfl->GetClientData(m_iSelectedToApply));
        ProfileList_t profile = m_profileVector.at(*pProfileIndex);
        wxString profileName = profile.sProfileName;
        ShowApplyingProcessDialog(profileName, true);
        pController->ApplyProfile(profile);
    }
    else
    {
        DataCenter::GetInstance()->SetShowBalloonFlag(true);
        pController->DisconnectCurrentProfile();
        bConnectFinish = true;
    }
    m_timerProfile.Start(20000, wxTIMER_ONE_SHOT);
    m_btnCtrlConnect->Enable(false);
    m_menuCnctPrfl->Enable(false);
}

void NetworkManagerDlg::OnProfileChangedEvent(ProfileEvent& event)
{
    ENMUtil::Log(logFile, _T("Enter NetworkManagerDlg::OnProfileChangedEvent"));
    SetNetworkProfile();
    unsigned int id = event.GetId();
    unsigned long code = event.GetEventCode();
    if ( id == ID_PROFILE_APPLY )
    {
        ENMUtil::Log(logFile, _T("\t Apply profile"));
    //    if ( code != PEVT_PROFILE_APPLY_DISCONNECT )
    //    {
    //        m_btnCtrlConnect->Enable(true);
    //    }
        switch ( code )
        {
        case PEVT_PROFILE_APPLY_SUCCESS:
            m_btnCtrlConnect->Enable(true);
            m_menuCnctPrfl->Enable(true);
            m_btnCtrlConnect->SetLabel(_("Disconnect"));
            m_menuCnctPrfl->SetText(_("&Disconnect"));
            // continue going through, no break
        case PEVT_PROFILE_APPLY_FAILED:
            ShowApplyingProcessDialog(wxEmptyString, false);
            break;
        case PEVT_PROFILE_APPLY_REAPPLY:
        {
            ENMUtil::Log(logFile, _T("\t Reapply profile"));
            ProfileList_t profile = DataCenter::GetInstance()->GetProfileController()->GetCurrentUsedProfile();
            wxString strProfileName = profile.sProfileName;
            ENMUtil::Log(logFile, _T("\t re-apply profile: \"") + strProfileName + _T("\""));
            ENMUtil::Log(logFile, wxString::Format(_T("NETWORK_MODE is %d"), DataCenter::GetInstance()->GetCurrentNetworkMode()));
            if ( profile.sProfileName.length() == 0 )
            {
                ENMUtil::Log(logFile, _T("length is 0"));
//                if ( profile.stGenernalSet.ConnecType == "wireless" )
                NETWORK_MODE mode = DataCenter::GetInstance()->GetCurrentNetworkMode();
                if ( mode == NETWORK_MODE_WIRELESS_LAN_CONNECT || mode == NETWORK_MODE_WIRELESS_LAN_DISCONNECT )
                {
//                    DataCenter::GetInstance()->SetAutoWirelessFlag(false);
                    DataCenter::GetInstance()->EnableNetworkAdapter(ADAPTER_WIREDLESS, true);
                    ENMTaskTray::GetInstance()->SetApplyWirelessFlag(false);
                    ENMTaskTray::GetInstance()->ApplyWirelessProfile();
                }
                else if ( mode == NETWORK_MODE_WIRED_LAN_CONNECT || mode == NETWORK_MODE_WIRED_LAN_DISCONNECT )
                {
                    ENMTaskTray::GetInstance()->SetApplyWiredFlag(false);
                    ENMTaskTray::GetInstance()->ApplyWiredProfile();
                }
            }
            else
            {
                ENMUtil::Log(logFile, _T("length is not 0"));
                DataCenter::GetInstance()->GetProfileController()->ApplyProfile(profile);
//                DataCenter::GetInstance()->StartGlobalTimer();
            }
        }
            break;
        default:
            break;
        }
    }
    else if ( (unsigned int)id == ID_PROFILE_CHANGED )
    {
        ENMUtil::Log(logFile, _T("\t Profile changed"));
        ProfileEvent profileEvent(ID_PROFILE_CHANGED, PEVT_CURRENT_PROFILE_CHANGED);
        ::wxPostEvent(DataCenter::GetInstance()->GetProfileManagerDlgHandle(), profileEvent);
    }
    ENMUtil::Log(logFile, _T("Return NetworkManagerDlg::OnProfileChangedEvent\n"));
}

void NetworkManagerDlg::OnSwitchAdapterEvent(SwitchAdapterEvent& event)
{
    m_btnCtrlWireless->Enable(true);
    m_timerWireless.Stop();
    if ( event.GetEnabledAdapterType() == ADAPTER_WIREDLESS && event.IsSuccess() )
    {
//        DataCenter::GetInstance()->SetAutoWirelessFlag(false);
//        ENMTaskTray::GetInstance()->SetApplyWirelessFlag(false);
//        ENMTaskTray::GetInstance()->ApplyWirelessProfile();
    }
}

void NetworkManagerDlg::RefreshProfileName()
{
    wxString strProfile = DataCenter::GetInstance()->GetProfileController()->GetCurrentProfile();
    APStatus* pAP = DataCenter::GetInstance()->GetCurrentAPStatus();
    if ( strProfile.Length() == 0 && pAP != NULL )
    {
        strProfile = wxString::FromUTF8((const char*)pAP->ssid.ucSsid, pAP->ssid.length);
    }
    if ( strProfile.Length() == 0 && DataCenter::GetInstance()->IsInterfaceEnabled(ADAPTER_WIRED) )
    {
        strProfile = _("Wired LAN");
    }
    strProfile.Replace(_T("&"), _T("&&"));
    m_stcCurrentPfle->SetLabel(strProfile);
}

void NetworkManagerDlg::OnWirelessNetworkChanged(const WirelessSwitchEvent& event)
{
    RefreshProfileName();
}

bool NetworkManagerDlg::IsApplyingProfile() const
{
    return m_isApplyingProfile;
}
