/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _ENM_APP_H_
#define _ENM_APP_H_

#ifndef WX_PRECOMP
    #include <wx/wx.h>
#endif

#include <wx/app.h>
#include "ENMTaskTray.h"
#include <wx/snglinst.h>
#include <fcntl.h>
#include "ENExistBalloon.h"

class ENMApp : public wxApp
{
public:
    ENMApp();
    virtual bool OnInit();
    virtual int OnExit();

    bool SetImage(char* image);
    ENMTaskTray* GetENMTaskTray();

    wxString strAppPath;
    wxString strResourcePath;
    wxString strImagePath;
    wxString strManualPath;
    wxString strManualFileName;

    wxLocale m_locale;
    bool m_popBalloon;

private:
    static const int ID_TIMER_INIT;
    static const int ID_TIMER_NOTIFY;

    wxTimer m_timerInit;
    wxTimer m_notificationtimer;
    ENMTaskTray* m_taskBarIcon;
    ENExistBalloon* m_notificationDlg;
    wxSingleInstanceChecker* m_checker;
    bool m_ifExit;
    bool GetLock();
    bool ShowMainFrame();
    bool InitializeDCS();
    bool IsProtocolSupported();
    bool LoadResource();

    void OnTimerInit(wxTimerEvent& event);
    void PopupNotification();
    void CloseNotificationHandler();
    void CloseNotification(wxTimerEvent& event);

    DECLARE_EVENT_TABLE()
};

DECLARE_APP(ENMApp)

void CALLBACK DCSAbortHandler();

#endif // _ENM_APP_H_
