/*
 * Copyright (C) 2009 Jason Smith, Benjamin Welton
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Jason Smith <jason.smith@canonical.com>
 *             Benjamin Welton <benjamin.r.welton@wmich.edu>
 */

#ifndef _NM_DOCKLET_H_
#define _NM_DOCKLET_H_

#include <glib-object.h>
#include <glib.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>

G_BEGIN_DECLS

#define NM_TYPE_DOCKLET (nm_docklet_get_type ())

#define NM_DOCKLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
        NM_TYPE_DOCKLET, NMDocklet))
        
#define NM_DOCKLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), \
        NM_TYPE_DOCKLET, NMDockletClass))
        
#define NM_IS_DOCKLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
        NM_TYPE_DOCKLET))
        
#define NM_IS_DOCKLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), \
        NM_TYPE_DOCKLET))
        
#define NM_DOCKLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), \
        NM_TYPE_DOCKLET, NMDockletClass))

typedef struct _NMDocklet NMDocklet;
typedef struct _NMDockletClass NMDockletClass;
typedef struct _NMDockletPrivate NMDockletPrivate;

struct _NMDockletClass
{
  GObjectClass parent_class;
};


struct _NMDocklet
{
  GObject parent_instance;

  /* Private */
  NMDockletPrivate *priv;
};

GType nm_docklet_get_type (void);

NMDocklet * nm_docklet_get_default (void);

gchar* nm_docklet_get_title (NMDocklet *docklet);

void   nm_docklet_set_title (NMDocklet *docklet, gchar* title);

gchar* nm_docklet_get_icon (NMDocklet *docklet);

void   nm_docklet_set_icon (NMDocklet *docklet, gchar* icon);

gchar* nm_docklet_get_emblem (NMDocklet *docklet);

void   nm_docklet_set_emblem (NMDocklet *docklet, gchar* emblem);

void   nm_docklet_set_attention (NMDocklet *docklet);

void   nm_docklet_unset_attention (NMDocklet *docklet);

void   nm_docklet_set_wait (NMDocklet *docklet);

void   nm_docklet_unset_wait (NMDocklet *docklet);

G_END_DECLS

#endif /* _NM_DOCKLET_H_ */
