/*
 * Copyright (C) 2009 Jason Smith, Benjamin Welton
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Jason Smith <jason.smith@canonical.com>
 *             Benjamin Welton <benjamin.r.welton@wmich.edu>
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include "docklet.h"

enum
{
  ACTIVATED,

  LAST_SIGNAL
};

static guint docklet_signals[LAST_SIGNAL] = { 0 };

G_DEFINE_TYPE (NMDocklet, nm_docklet, G_TYPE_OBJECT);
#define NM_DOCKLET_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE(obj, \
NM_TYPE_DOCKLET, NMDockletPrivate))

#define DOCKY_BUS "org.gnome.Docky"
#define DOCKY_PATH "/org/gnome/Docky"
#define DOCKY_IFACE "org.gnome.Docky"
#define ITEM_IFACE "org.gnome.Docky.Item"

struct _NMDockletPrivate
{
  DBusGConnection *connection;
  DBusGProxy *docky;
  DBusGProxy *dock_docklet;
};

gchar*
nm_docklet_get_title (NMDocklet *docklet)
{
  g_return_val_if_fail (NM_IS_DOCKLET (docklet), "");
  
  return "";
}

void
nm_docklet_set_title (NMDocklet *docklet, gchar* title)
{
  NMDockletPrivate *priv;
  GError *error = NULL;

  g_return_if_fail (NM_IS_DOCKLET (docklet));
  
  priv = docklet->priv;

  g_return_if_fail (priv->dock_docklet);
  
  if (!dbus_g_proxy_call (priv->dock_docklet, "SetText", &error,
                          G_TYPE_STRING, g_strdup (title),
                          G_TYPE_INVALID,
                          G_TYPE_INVALID))
  {
    g_printerr ("%s\n", error->message);
    return;
  }
}

gchar*
nm_docklet_get_icon (NMDocklet *docklet)
{
  g_return_val_if_fail (NM_IS_DOCKLET (docklet), "");
  
  return "";
}

void
nm_docklet_set_icon (NMDocklet *docklet, gchar* icon)
{
  NMDockletPrivate *priv;
  GError *error = NULL;

  g_return_if_fail (NM_IS_DOCKLET (docklet));
  
  priv = docklet->priv;

  g_return_if_fail (priv->dock_docklet);
  
  if (!dbus_g_proxy_call (priv->dock_docklet, "SetIcon", &error,
                          G_TYPE_STRING, g_strdup (icon),
                          G_TYPE_INVALID,
                          G_TYPE_INVALID))
  {
    g_printerr ("%s\n", error->message);
    return;
  }
}

gchar*
nm_docklet_get_emblem (NMDocklet *docklet)
{
  g_return_val_if_fail (NM_IS_DOCKLET (docklet), "");
  
  return "";
}

void
nm_docklet_set_emblem (NMDocklet *docklet, gchar* emblem)
{
  NMDockletPrivate *priv;
  //GError *error = NULL;

  g_return_if_fail (NM_IS_DOCKLET (docklet));
  
  priv = docklet->priv;

  g_return_if_fail (priv->dock_docklet);
  /*
  if (!dbus_g_proxy_call (priv->dock_docklet, "SetEmblem", &error,
                          G_TYPE_STRING, g_strdup (emblem),
                          G_TYPE_INVALID,
                          G_TYPE_INVALID))
  {
    g_printerr ("%s\n", error->message);
    return;
  }*/
}

void
nm_docklet_set_attention (NMDocklet *docklet)
{

}

void
nm_docklet_unset_attention (NMDocklet *docklet)
{

}

void
nm_docklet_set_wait (NMDocklet *docklet)
{

}

void
nm_docklet_unset_wait (NMDocklet *docklet)
{

}

static void
nm_docklet_activated (DBusGProxy *proxy,
                      guint       button,
                      NMDocklet  *docklet)
{
  g_signal_emit (docklet, docklet_signals[ACTIVATED], 0);
}

static void
nm_docklet_init_dock_docklet (NMDocklet *docklet)
{
  NMDockletPrivate *priv;
  DBusGProxy *proxy;
  GError *error = NULL;
  gchar **name_list;
  gchar **name_list_ptr;
  gchar *name;
  
  g_return_if_fail (NM_IS_DOCKLET (docklet));
  
  priv = docklet->priv;
  
  if (!dbus_g_proxy_call (priv->docky, "DockItemPaths", &error, 
                          G_TYPE_INVALID, 
                          G_TYPE_STRV, &name_list, 
                          G_TYPE_INVALID))
  {
    g_printerr ("%s\n", error->message);
  }
  
  error = NULL;
  
  for (name_list_ptr = name_list; *name_list_ptr; name_list_ptr++)
  {
    proxy = dbus_g_proxy_new_for_name (priv->connection, DOCKY_BUS, *name_list_ptr, ITEM_IFACE);
    
    error = NULL;
    if (!dbus_g_proxy_call (proxy, "GetName", &error,
                            G_TYPE_INVALID,
                            G_TYPE_STRING, &name,
                            G_TYPE_INVALID))
    {
      g_printerr ("%s\n", error->message);
      continue;
    }
    
    if (g_str_equal (name, "Network Manager"))
    {
      g_print ("%s\n", *name_list_ptr);
      priv->dock_docklet = proxy;
      break;
    }
    else
    {
      g_object_unref (proxy);
    }
  }
  
  g_return_if_fail (priv->dock_docklet);
  
  dbus_g_proxy_add_signal (priv->dock_docklet,
                           "ItemActivated",
                           G_TYPE_UINT,
                           G_TYPE_INVALID);
                           
  dbus_g_proxy_connect_signal (priv->dock_docklet,
                               "ItemActivated",
                               G_CALLBACK (nm_docklet_activated),
                               docklet,
                               NULL);
}

static void
nm_docklet_init_connections (NMDocklet *docklet)
{
  GError *error = NULL;
  NMDockletPrivate *priv;
  
  g_return_if_fail (NM_IS_DOCKLET (docklet));
  
  priv = docklet->priv;  
  
  priv->connection = dbus_g_bus_get (DBUS_BUS_SESSION, &error);
  
  if (!priv->connection)
  {
    g_printerr ("Could not establish dbus connection: %s\n", error->message);
    g_error_free (error);
  }
  
  error = NULL;
  
  priv->docky = dbus_g_proxy_new_for_name (priv->connection, DOCKY_BUS, DOCKY_PATH, DOCKY_IFACE);

  nm_docklet_init_dock_docklet (docklet);
}

static void
nm_docklet_init (NMDocklet *object)
{
  NMDockletPrivate *priv;
  
  priv = object->priv = NM_DOCKLET_GET_PRIVATE (object);  
  nm_docklet_init_connections (object);
}

static void
nm_docklet_finalize (GObject *object)
{
  NMDockletPrivate *priv;
  
  priv = NM_DOCKLET_GET_PRIVATE (object);
  
  G_OBJECT_CLASS (nm_docklet_parent_class)->finalize (object);
}

static void
nm_docklet_class_init (NMDockletClass *klass)
{
  GObjectClass* object_class = G_OBJECT_CLASS (klass);
  
  object_class->finalize = nm_docklet_finalize;

  g_type_class_add_private (object_class, sizeof (NMDockletPrivate));
  
  docklet_signals[ACTIVATED] =
      g_signal_newv ("activated",
                     G_TYPE_FROM_CLASS (klass),
                     G_SIGNAL_RUN_LAST | G_SIGNAL_NO_RECURSE | G_SIGNAL_NO_HOOKS,
                     NULL,
                     NULL, 
                     NULL,
                     g_cclosure_marshal_VOID__VOID,
                     G_TYPE_NONE, 
                     0,
                     NULL);
}

/* 
 * Constructors 
 */

NMDocklet *
nm_docklet_get_default (void)
{
  static NMDocklet *docklet;

  if (docklet)
    return docklet;

  docklet = g_object_new (NM_TYPE_DOCKLET,
                                 NULL);
    
  return docklet;
}
