/****************************************************************************

 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

File Name:          PMDriverMgmt.cpp

Description:

    This file implements the class PMDriverMgmt.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Deng Jing 2008-8-15

  =====================================================================

****************************************************************************/

#include "PMDriverMgmt.h"

PMDriverMgmt* PMDriverMgmt::m_pPMDriverMgmt = NULL;
char PMDriverMgmt::m_pDriverPath[ACPI_MAX_STRING] = {'\0'};

PMDriverMgmt::PMDriverMgmt()
{

}

PMDriverMgmt::~PMDriverMgmt()
{
    close(m_fd);
}

PMDriverMgmt* PMDriverMgmt::Getinstance()
{
    if (NULL == m_pPMDriverMgmt)
    {
        m_pPMDriverMgmt = new PMDriverMgmt();
        if (m_pPMDriverMgmt->InitializeDriverPath() < 0)
        {
            delete m_pPMDriverMgmt;
            m_pPMDriverMgmt = NULL;
        }
    }

    return m_pPMDriverMgmt;
}

int PMDriverMgmt::InitializeDriverPath()
{
 //   if(0 == strcmp(m_pDriverPath, '\0'))
  //  {
        //int	fd;
        int	entries[ACPI_MAX_STRING] = {0};

        memset(m_pDriverPath, 0, ACPI_MAX_STRING);

        m_fd = open(DEVICE, O_RDONLY);

        if (m_fd < 0)
        {
            return -1;
        }

        get_path(m_fd, NULL, entries, 1, m_pDriverPath);
        if (strlen(m_pDriverPath) <= 0)
        {
            return -1;
        }

//        close(fd);
   // }
}

int PMDriverMgmt::GetBrightness()
{
    if (strlen(m_pDriverPath) <= 0 || m_fd < 0)
    {
        return -1;
    }

//    int	fd = open(DEVICE, O_RDONLY);
//    if (fd < 0)
//    {
//        return -1;
//    }

    int value = get_brightness(m_fd, m_pDriverPath);

//    FILE *pm_log=fopen("/home/pm_driver_log.txt", "w");
//    fprintf(pm_log, "Get lcd bright is %d. \n", value);
//    fflush(pm_log);
//    fclose(pm_log);

  //  close(fd);

    if (value < 0)
    {
        value = 0;
    }

    if (value > 7)
    {
        value = 7;
    }

    return value;
}

int PMDriverMgmt::SetBrightness(int value)
{
    if ((strlen(m_pDriverPath) <= 0) || m_fd < 0 ||
        (value < 0) || (value > 7))
    {
        return -1;
    }

//    int	fd = open(DEVICE, O_RDONLY);
//    if (fd < 0)
//    {
//        return -1;
//    }

    set_brightness(m_fd, m_pDriverPath, value);

//    close(fd);
    return 0;
}

int PMDriverMgmt::GetWireless()
{
//    int	fd = open(DEVICE, O_RDONLY);
    if ((strlen(m_pDriverPath) <= 0) ||m_fd < 0)
    {
        return -1;
    }

    int value = get_wireless(m_fd, m_pDriverPath);

//    close(fd);

    if (value < 0)
    {
        value = 0;
    }

    if (value > 1)
    {
        value = 1;
    }

    return value;
}

int PMDriverMgmt::SetWireless(int value)
{
    if ((strlen(m_pDriverPath) <= 0) || m_fd < 0 ||
        ((0 != value) && (1 != value)))
    {
        return -1;
    }

//    int	fd = open(DEVICE, O_RDONLY);
//    if (fd < 0)
//    {
//        return -1;
//    }

    set_wireless(m_fd, m_pDriverPath, value);

//    close(fd);
    return 0;
}

int PMDriverMgmt::GetLan()
{
    if (strlen(m_pDriverPath) <= 0 || m_fd < 0)
    {
        return -1;
    }

//    int	fd = open(DEVICE, O_RDONLY);
//    if (fd < 0)
//    {
//        return -1;
//    }

    int value = get_landevice(m_fd, m_pDriverPath);

//    close(fd);

     if (value < 0)
    {
        value = 0;
    }

    if (value > 1)
    {
        value = 1;
    }

    return value;
}

int PMDriverMgmt::SetLan(int value)
{
    if ((strlen(m_pDriverPath) <= 0) || m_fd < 0 ||
        (0 != value) && (1 != value))
    {
        return -1;
    }

//    int	fd = open(DEVICE, O_RDONLY);
//    if (fd < 0)
//    {
//        return -1;
//    }

    set_landevice(m_fd, m_pDriverPath, value);

//    close(fd);

    return 0;
}

