/*
 * Easy Network Plugin API
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */
#ifndef ENMUTIL_H_INCLUDED
#define ENMUTIL_H_INCLUDED
#include "wx/string.h"
#include <string>

using namespace std;
class ENMUtil
{
    public:
        static const int CHECK_OK = 0;
        static const int CHECK_ILLEGAL = 1;
        static const int CHECK_EMPTY = 2;
        static const int MAX_IP_ADDRESS = 15;
        static const int MAX_PART_IP = 3;

        static void Log(const wxString& file, const wxString& log);

//        static int CheckParticular(wxString str);
        static string WxStringToString(wxString wxStringValue);
        static wxString StringToWxString(string stringValue);
        static int CheckWep(wxString str);
        static int OnlyLetterAndNum(wxString str);
        static int NoChineseCharacter(wxString str);
        static int CheckValide(wxString str);
        static int IfIp(wxString str);
        static int IfMask(wxString str);
        static bool IsAdministrator();
        static wxString GetCurrentUserAppDataFolder();
        static string& StringToLowerCase(string& str);
        static bool ChangeIPAddress(const wxString& ip, const wxString& mask, const wxString& gateway, const wxString& dns,const wxString& adpter);
        static bool DisableInternetSharing();
        static bool EnableInternetSharing();
        static bool AutoRunApp(string strAppPath);
        static bool OverwriteHomePage(string strHomePage);
        static bool OverwriteProxy(string strProxy, string strPort);
        static bool IsOnlyNumber(wxString str);
        static bool Enable8021xAuthentication(bool isEnable);
        static bool IsGuest();
#if defined(__WXMSW__)
        static wxString GetAllUserAppDataFolder();
        static bool StartupWindowsFirewallService();
        static bool StartupWindowsFirewall();
        static bool StopWindowsFirewall();
        static bool EnableFileAndPrint();
        static bool DisableFileAndPrint();
#endif
#if defined(__UNIX__)
        static bool IsFirefoxRunning();
        static wxString GetFirefoxConfigFile();
#endif
};

#endif // ENMUTIL_H_INCLUDED
