/*
* Copyright (C) 2008  Intel Corporation
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License, version 2, as
* published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
* In addition, as a special exception, Intel gives permission to link
* the code of portions of this program with the OpenSSL project's
* "OpenSSL" library (or with modified versions of it that use the same
* license as the "OpenSSL" library), and distribute the linked
* executables.  You must obey the GNU General Public License in all
* respects for all of the code used other than "OpenSSL".  If you modify
* this file, you may extend this exception to your version of the file,
* but you are not obligated to do so.  If you do not wish to do so,
* delete this exception statement from your version.
*/

#ifndef DISPLAY_TOGGLE_H
#define DISPLAY_TOGGLE_H

#include <X11/Xlib.h>
#include <X11/extensions/Xrandr.h>

/**
 * @class DisplayToggle
 *
 * Control the internal, external and dual display.
 */
class DisplayToggle
{
public:

	static const int DISPLAY_NONE; /**< status of no display */
	static const int DISPLAY_INTERNAL; /**< status of internal only */ 
	static const int DISPLAY_EXTERNAL; /**< status of external only */
	static const int DISPLAY_DUAL; /**< status of dual display */

	static const char *VGA; /**< name of VGA output */
	static const char *LVDS; /**< name of LVDS output */

	static const char *XRANDR_VGA; /**< xrandr command to set VGA only */
	static const char *XRANDR_LVDS; /**< xrandr command to set LVDS only */
	static const char *XRANDR_DUAL; /**< xrandr command to set Dual display */

	DisplayToggle();
	~DisplayToggle();
	
	int GetDisplayStatus();
	int SetDisplayStatus(int desired, int current);
	int ToggleDisplay();

private:

	Display *m_pDisplay; /**< connection to X server */
	Window m_RootWindow; /**< root window of X server */
	XRRScreenResources *m_pSR; /**< screen resouces */

	XRROutputInfo *m_pLvdsInfo; /**< LVDS output info */
	XRROutputInfo *m_pVgaInfo; /**< VGA output info */

	void RenewInfo();
};

#endif /* DISPLAY_TOGGLE_H */
