#ifdef WIN32
#include <afxwin.h>
#endif
#include <stdio.h>              /* for convenience */
#include <stdlib.h>             /* for convenience */
#include <stddef.h>             /* for offsetof */
#include <string.h>             /* for convenience */
//#include <unistd.h>             /* for convenience */
#include <signal.h>             /* for SIG_ERR */
//#include <sys/socket.h>
//#include "stdafx.h"

#include "FnKeyApi.h"
#include "ConnMgmt.h"
#include "ReqMgmt.h"
#include "AccelApi.h"
#include "DCSApi.h"
#include"TabletApi.h"
#include "PolicyApi.h"
#include "PMApi.h"


FILE* accel_log = NULL;

FILE* fnkey_log = NULL;

FILE* tablet_log = NULL;

FILE* pm_log = NULL;

FILE* policy_log = NULL;

/* Call back function for Accelerometer*/

   void CALLBACK  DCS_Accel_handler (PDCS_Accel_Data  pData)

{
	if (pData == NULL) return;
	
	printf("accel data: (%d, %d, %d) \n", pData->AccelX,pData->AccelY,pData->AccelZ);

	fprintf(accel_log, "accel data: (%d, %d, %d)\n",pData->AccelX,pData->AccelY,pData->AccelZ);
	fflush(accel_log);
}


void CALLBACK  DCS_SystemOrientation_handler (DCS_SystemOrientation *pData)

{
	
	printf("SystemOrientation data: %d \n", *pData);
	fprintf(accel_log, "SystemOrientation data: %d \n",*pData);
	fflush(accel_log);

	switch (*pData)
	{
	case DCS_SYSTEM_ORIENTATION_NORMAL:
		     printf(" DCS_SYSTEM_ORIENTATION_NORMAL\n");
			 break;

	case DCS_SYSTEM_ORIENTATION_CW90:
		    printf(" DCS_SYSTEM_ORIENTATION_CW90\n");
			 break;

	case DCS_SYSTEM_ORIENTATION_CW180:
		    printf(" DCS_SYSTEM_ORIENTATION_CW180\n");
			 break;

	case DCS_SYSTEM_ORIENTATION_CW270:
		    printf(" DCS_SYSTEM_ORIENTATION_CW270\n");
			 break;
    default:
			printf("input system orientation data is %d \n", *pData);
			break;
	
	}
}



/* Call back function for Fn Key*/

void CALLBACK DCS_FnKey_handler (DCS_VKbd_Data *pData)
{
    

    printf("DCS_VKbd_Data data: %d \n", *pData);
	fprintf(fnkey_log , "DCS_VKbd_Data data: %d \n",*pData);
	fflush(fnkey_log );

      switch (*pData)	

	  {	

		   
	  case FN_WLAN_SWITCH:	
		   printf("FN_WLAN_SWITCH\n");
		   break;

	  case FN_DISPLAY_SWITCH:	
		    printf("FN_DISPLAY_SWITCH\n");
			break;

	  case FN_BRIGHTNESS_DOWN:	
		   printf("FN_BRIGHTNESS_DOWN\n");
		   break;

	  case FN_BRIGHTNESS_UP:
		    printf("FN_BRIGHTNESS_UP\n");
			break;

          case BEZELBUTTON_SINGLE_CLICK:	
		    printf("BEZELBUTTON_SINGLE_CLICK\n");
			break;

	  case BEZELBUTTON_DOUBLE_CLICK:	
		    printf("BEZELBUTTON_DOUBLE_CLICK\n");
			break;

	 default:
			printf("input fn key data is %d \n", *pData);
			break;

	 	 
	  }  


	
	
	
}


/* Call back function for Tablet Sensor */

void CALLBACK DCS_TabletSensor_handler (DCS_Tablet_Sensor_Data *pData)
{
    if (pData == NULL) return;
	
	printf("tablet data: %d \n", *pData);
	fprintf(tablet_log , "tablet data: %d \n",*pData);
	fflush(tablet_log  );

     switch (*pData)
	{
	case DCS_CLAMSHELL_MODE:
                printf("DCS_CLAMSHELL_MODE\n");
				break;
		
	case DCS_TABLET_MODE:
		 printf("DCS_TABLET_MODE\n");
		 break;
	
	default:
			printf("input tablet data is %d \n", *pData);
			break;
	}
	   
}




int main(int argc, char *argv[])
{

	int ret = 0;

	int i;

	int use_accel=0;
	int use_tablet=0;
	int use_fnkey=0;
	int use_policy=0;
	int use_pm=0;
	int use_enable=0;
    int use_disable=0;
    int use_undisable=0;

	char c0;

	
	if(!accel_log)
	{ 
		
		accel_log=fopen("accel_log.txt", "w"); 
	
	}

	if(!fnkey_log)
	{ 
		
		fnkey_log=fopen("fnkey_log.txt", "w"); 
	
	}

	if(!tablet_log)
	{ 
		
		tablet_log=fopen("tablet_log.txt", "w"); 
	
	}
   
	if(!pm_log)
	{ 
		
		pm_log=fopen("pm_log.txt", "w"); 
	
	}

	if(!policy_log)
	{ 
		
		policy_log=fopen("policy_log.txt", "w"); 
	
	}

	
	#ifdef WIN32
	// initialize MFC and print and error on failure
	if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
	{
		// TODO: change error code to suit your needs
		_tprintf(_T("Fatal Error: MFC initialization failed\n"));
		ret = 1;
		return ret;
	}
#endif	

/*****************************************************************************
 * Command line parsing
 ****************************************************************************/

	

	for (i=1; i< argc; i++) {
 
		if (strcmp("-accel", argv[i]) == 0 ) {
			use_accel = 1;
		} else if (strcmp("-tablet", argv[i]) == 0) {
			use_tablet = 1;
		} else if (strcmp("-fnkey", argv[i]) == 0 ) {
			use_fnkey = 1;
		} else if (strcmp("-policy", argv[i]) == 0) {
			use_policy = 1;
		} else if (strcmp("-pm", argv[i]) == 0) {
			use_pm = 1;
		} else if (strcmp("-enable", argv[i]) == 0) {
			use_enable = 1;
		} else if (strcmp("-disable", argv[i]) == 0) {
			use_disable = 1;
		} else if (strcmp("-undisable", argv[i]) == 0) {
			use_undisable = 1;
		} 
	}
	
	/*initialize the DCS*/
	ret = DCS_Initialize();
	
	 if(ret==0)
	{
		printf("DCS_initialize SUCCESS\n"); 

//		fprintf(debug_info, "DCS_initialize SUCCESS\n");
//	    fflush(debug_info);

		
	}else 	
	{	
	
	printf("DCS_initialize Fail\n"); 

//	fprintf(debug_info, "DCS_initialize Fail\n");
//	fflush(debug_info);
	
	return ret;
	
	}
	
	/*
	******************************
	For the Accelerometer Interface
	******************************
	*/
    if (use_accel==1)
	{
	CHAR gravity;
	DCS_Response response;
	DCS_Accel_Data data;
	
	DCS_RegisterAccelCallback( DCS_Accel_handler);
		
	
	DCS_RegisterSystemOrientationCallback(DCS_SystemOrientation_handler);
	
	

	DCS_GetAccelForGravity(&gravity);

	printf(" gravity:%d\n", gravity);

	fprintf(accel_log, "gravity=%d\n",gravity);
    fflush(accel_log);
	
	printf("begin to DCS_GetAccelData\n");

	DCS_GetAccelData(&data);

	printf("X=%d, Y=%d, Z=%d\n", data.AccelX,  data.AccelY,  data.AccelZ);

	fprintf(accel_log, "X=%d,Y=%d,Z=%d\n",data.AccelX,  data.AccelY,  data.AccelZ);
	fflush(accel_log);

	int enable;

	if(use_enable==1)
	{
       DCS_EnableDesktopAutoRotation();

	   DCS_GetDesktopAutoRotationStatus(&enable);

	   printf("autorotation status: %d\n",enable);
	}

	if(use_disable==1)
	{
       DCS_DisableDesktopAutoRotation();

		DCS_GetDesktopAutoRotationStatus(&enable);

		printf("autorotation status: %d\n",enable);
	}

	if(use_undisable==1)
	{
        DCS_EnableDesktopAutoRotation();
		
		DCS_DisableDesktopAutoRotation();

	   DCS_UnDisableDesktopAutoRotation();

		DCS_GetDesktopAutoRotationStatus(&enable);

		printf("autorotation status: %d\n",enable);
	}
	
	
	}

        /*
	******************************
	For the Tablet Sensor Interface
	******************************
	*/

    if(use_tablet==1)

	{
	
	DCS_RegisterTabletSensorCallback(DCS_TabletSensor_handler);

	}
       	
	
	/*
	******************************
	For the Fn Key & Button Interface
	******************************
	*/
    if(use_fnkey==1)
	{
	
	DCS_RegisterFnKeyCallback(DCS_FnKey_handler );

	}
	
	
	
	/*
	******************************
	For the Policy Control Interface
	******************************
	*/

	if(use_policy==1)
	{

		
	int moduleid;

	int opid;

	int policyaccess;

	DCS_Policy_Access ACCESS;

	
                     //this is for policy control module
	    moduleid=0;

		for(opid=0;opid<=3;opid++)

			{

			  		             					
					 DCS_SetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
				     DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
					 printf(" ADMINISTRATOR and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
				    // ACCESS=0;

				    DCS_RemovePolicy(DCS_ADMINISTRATOR_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				     printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;
					 

					 
					 DCS_SetPolicy( DCS_PARENT_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
				     DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				     printf(" PARENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;

				    DCS_RemovePolicy(DCS_PARENT_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				     printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				    // ACCESS=0;
					 
					 
					 DCS_SetPolicy( DCS_STUDENT_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
				     DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				      printf(" STUDENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
				    // ACCESS=0;

				    DCS_RemovePolicy(DCS_STUDENT_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				      printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				    // ACCESS=0;
					 

                    
					 DCS_SetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
				     DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				      printf(" ADMINISTRATOR and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS); 
				    // ACCESS=0;

				    DCS_RemovePolicy(DCS_ADMINISTRATOR_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				    printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				   //  ACCESS=0;
					 

					 
					 DCS_SetPolicy( DCS_PARENT_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
				     DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				     printf(" PARENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);

				     //ACCESS=0;

				    DCS_RemovePolicy(DCS_PARENT_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				     printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				    // ACCESS=0;
					


					 
					 DCS_SetPolicy( DCS_STUDENT_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
				     DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				     printf(" STUDENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
				   //  ACCESS=0;

				    DCS_RemovePolicy(DCS_STUDENT_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				     printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				//     ACCESS=0;
					

			}


		 //this is for tablet sensor module
		 moduleid=1;

		for(opid=0;opid<1;opid++)

			{

			  

		               
					 DCS_SetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
				     DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				    printf(" ADMINISTRATOR and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS); 
				    // ACCESS=0;

				    DCS_RemovePolicy(DCS_ADMINISTRATOR_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				     printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;
					

					 
					 DCS_SetPolicy( DCS_PARENT_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
				     DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				   printf(" PARENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;

				    DCS_RemovePolicy(DCS_PARENT_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				    printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				    // ACCESS=0;
					 


					 
					 DCS_SetPolicy( DCS_STUDENT_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
				     DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				      printf(" STUDENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
				    // ACCESS=0;

				    DCS_RemovePolicy(DCS_STUDENT_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				    printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				    // ACCESS=0;
					 

                    
					 DCS_SetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
				     DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				     printf(" ADMINISTRATOR and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS); 
				    // ACCESS=0;

				    DCS_RemovePolicy(DCS_ADMINISTRATOR_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				    printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				   //  ACCESS=0;
					 

					 
					 DCS_SetPolicy( DCS_PARENT_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
				     DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				       printf(" PARENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);

				     //ACCESS=0;

				    DCS_RemovePolicy(DCS_PARENT_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				     printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				    // ACCESS=0;
					


					  
					 DCS_SetPolicy( DCS_STUDENT_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
				     DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				    printf(" STUDENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
				   //  ACCESS=0;

				    DCS_RemovePolicy(DCS_STUDENT_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				    printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				//     ACCESS=0;
					


			}



		//this is for  ACCELEROMETER module
		 moduleid=2;

		for(opid=0;opid<=6;opid++)

			{

			  	               
					 DCS_SetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
				     DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				     printf(" ADMINISTRATOR and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS); 
				    // ACCESS=0;

				    DCS_RemovePolicy(DCS_ADMINISTRATOR_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				   printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;
					 

					 
					 DCS_SetPolicy( DCS_PARENT_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
				     DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				     printf(" PARENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;

				    DCS_RemovePolicy(DCS_PARENT_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				    printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				    // ACCESS=0;
					


					  
					 DCS_SetPolicy( DCS_STUDENT_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
				     DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				    printf(" STUDENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
				    // ACCESS=0;

				    DCS_RemovePolicy(DCS_STUDENT_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				      printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				    // ACCESS=0;
					 

                    
					 DCS_SetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
				     DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				     printf(" ADMINISTRATOR and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS); 
				    // ACCESS=0;

				    DCS_RemovePolicy(DCS_ADMINISTRATOR_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				   printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				   //  ACCESS=0;
					 

					 
					 DCS_SetPolicy( DCS_PARENT_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
				     DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				     printf(" PARENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);

				     //ACCESS=0;

				    DCS_RemovePolicy(DCS_PARENT_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				     printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				    // ACCESS=0;
					


					  
					 DCS_SetPolicy( DCS_STUDENT_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
				     DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				     printf(" ADMINISTRATOR and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS); 
				   //  ACCESS=0;

				    DCS_RemovePolicy(DCS_STUDENT_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				     printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				//     ACCESS=0;
					



			  	

			}

                       
		    for(opid=100;opid<=101;opid++)

			{

			  

		                   
					 DCS_SetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
				     DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				    printf(" ADMINISTRATOR and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS); 
				    // ACCESS=0;

				    DCS_RemovePolicy(DCS_ADMINISTRATOR_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				     printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;
					
					 DCS_SetPolicy( DCS_PARENT_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
				     DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				     printf(" PARENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;

				    DCS_RemovePolicy(DCS_PARENT_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				    printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);

				    // ACCESS=0;
					 
					 DCS_SetPolicy( DCS_STUDENT_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
				     DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				      printf(" STUDENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
				    // ACCESS=0;

				    DCS_RemovePolicy(DCS_STUDENT_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				     printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				    // ACCESS=0;
					 
					 DCS_SetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
				     DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				      printf(" ADMINISTRATOR and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS); 
				    // ACCESS=0;

				    DCS_RemovePolicy(DCS_ADMINISTRATOR_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				     printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				   //  ACCESS=0;
					 
					 DCS_SetPolicy( DCS_PARENT_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
				     DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				      printf(" PARENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;

				    DCS_RemovePolicy(DCS_PARENT_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				    printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				    // ACCESS=0;
					 
					 DCS_SetPolicy( DCS_STUDENT_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
				     DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				    printf(" STUDENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);

				   //  ACCESS=0;

				    DCS_RemovePolicy(DCS_STUDENT_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				     printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				//     ACCESS=0;
					 

			}



		//this is for  power management module
		 moduleid=3;

		for(opid=0;opid<=14;opid++)

			{

			  
					 DCS_SetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
				     DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				    printf(" ADMINISTRATOR and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS); 
				    // ACCESS=0;

				    DCS_RemovePolicy(DCS_ADMINISTRATOR_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				     printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;
					 
					 DCS_SetPolicy( DCS_PARENT_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
				     DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				    printf(" PARENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;

				    DCS_RemovePolicy(DCS_PARENT_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				    printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				    // ACCESS=0;
					 
					 DCS_SetPolicy( DCS_STUDENT_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
				     DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				     printf(" STUDENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
				    // ACCESS=0;

				    DCS_RemovePolicy(DCS_STUDENT_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				    printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				    // ACCESS=0;
					
					 DCS_SetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
				     DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				     printf(" ADMINISTRATOR and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS); 
				    // ACCESS=0;

				    DCS_RemovePolicy(DCS_ADMINISTRATOR_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				     printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				   //  ACCESS=0;
					
					 DCS_SetPolicy( DCS_PARENT_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
				     DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				      printf(" PARENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;

				    DCS_RemovePolicy(DCS_PARENT_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				    printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				    // ACCESS=0;
					 
					 DCS_SetPolicy( DCS_STUDENT_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
				     DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				    printf(" STUDENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
				   //  ACCESS=0;

				    DCS_RemovePolicy(DCS_STUDENT_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				     printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				//     ACCESS=0;
					 

			}
					
                      
		      for(opid=100;opid<=102;opid++)

			{

			  
					 DCS_SetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
				     DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				      printf(" ADMINISTRATOR and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS); 

				    // ACCESS=0;

				    DCS_RemovePolicy(DCS_ADMINISTRATOR_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				     printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;
					 
					 DCS_SetPolicy( DCS_PARENT_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
				     DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				    printf(" PARENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;

				    DCS_RemovePolicy(DCS_PARENT_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				     printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				    // ACCESS=0;
					 
					 DCS_SetPolicy( DCS_STUDENT_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
				     DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				    printf(" STUDENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
				    // ACCESS=0;

				    DCS_RemovePolicy(DCS_STUDENT_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				    printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				    // ACCESS=0;
					 
					 DCS_SetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
				     DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				     printf(" ADMINISTRATOR and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS); 
				    // ACCESS=0;

				    DCS_RemovePolicy(DCS_ADMINISTRATOR_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				    printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				   //  ACCESS=0;
					
					 DCS_SetPolicy( DCS_PARENT_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
				     DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				       printf(" PARENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);

				     //ACCESS=0;

				    DCS_RemovePolicy(DCS_PARENT_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				    printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
				    // ACCESS=0;
					 
					 DCS_SetPolicy( DCS_STUDENT_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
				     DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				    printf(" STUDENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
				   //  ACCESS=0;

				    DCS_RemovePolicy(DCS_STUDENT_GROUP, moduleid, opid);
				    DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				     printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);

				//     ACCESS=0;
					

			}

		


		//test the default policy
	   printf("begin to test default policy\n");
		
	   for(policyaccess=0;policyaccess<=1;policyaccess++)

	   {
		   printf("policyaccess=%d\n",policyaccess);
         
			 if (policyaccess==0)
			 {
		   DCS_SetDefaultPolicy(DCS_POLICY_ALLOWED);
			 }

            if (policyaccess==1)
			 {
		   DCS_SetDefaultPolicy(DCS_POLICY_REJECTED);
			 }

	
                     //this is for policy control module
		 moduleid=0;

		for(opid=0;opid<=3;opid++)

			{
                   
				  
			  	                    
				     DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				     printf(" DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;

					
			  	                    
				     DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				     printf(" DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;

					
			  	                    
				     DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				     printf(" DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;

					

			}


		 //this is for tablet sensor module
		 moduleid=1;

		for(opid=0;opid<1;opid++)

			{

			    
			  	                    
				     DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				     printf(" DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;

					 
			  	                    
				     DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				     printf(" DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;

					
			  	                    
				     DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				     printf(" DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;

					

			}



		//this is for  ACCELEROMETER module
		 moduleid=2;

		for(opid=0;opid<=6;opid++)

			{

			  
			  	                    
				     DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				     printf(" DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;

					 
			  	                    
				     DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				     printf(" DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;

					
			  	                    
				     DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				     printf(" DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;

		}

                       
		    for(opid=100;opid<=101;opid++)

			{

			   
			  	                    
				     DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				     printf(" DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;

					 
			  	                    
				     DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				     printf(" DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;

					
			  	                    
				     DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				     printf(" DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;

					
			}



		//this is for  power management module
		 moduleid=3;

		for(opid=0;opid<=14;opid++)

			{

			  
			  	                    
				     DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				     printf(" DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;

					
			  	                    
				     DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				     printf(" DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;

					 
			  	                    
				     DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				     printf(" DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;

				
			}
					
                      
		      for(opid=100;opid<=102;opid++)

			{

			 
			  	                    
				     DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				     printf(" DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;

					
			  	                    
				     DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				     printf(" DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;

					

				    
			  	                    
				     DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				     printf(" DCS_GetPolicy:%d\n", ACCESS);
				     //ACCESS=0;

					
			}

		



		}


}

	
	/*
	******************************
	For the Power Management Interface
	******************************
	*/

    if(use_pm==1)
	{
	

     DCS_CPUSpeed cpuspeed;
      

	DCS_SetCPUSpeed(DCS_CPUSPEED_LOWEST);
	
	DCS_GetCPUSpeed(&cpuspeed);

	printf(" CPU speed is set as LOWEST and get the CPUSpeed is:%d\n", cpuspeed);
	fprintf(pm_log , "CPU speed is set as LOWEST and get the CPUSpeed is:%d\n", cpuspeed);
	fflush(pm_log );



	DCS_SetCPUSpeed(DCS_CPUSPEED_LOW);
	
	DCS_GetCPUSpeed(&cpuspeed);

	printf(" CPU speed is set as LOW and get the CPUSpeed is:%d\n", cpuspeed);
	fprintf(pm_log , "CPU speed is set as LOW and get the CPUSpeed is:%d\n", cpuspeed);
	fflush(pm_log );


	DCS_SetCPUSpeed(DCS_CPUSPEED_ADAPTIVE);
	
	DCS_GetCPUSpeed(&cpuspeed);

	printf(" CPU speed is set as ADAPTIVE and get the CPUSpeed is:%d\n", cpuspeed);
	fprintf(pm_log , "CPU speed is set as ADAPTIVE and get the CPUSpeed is:%d\n", cpuspeed);
	fflush(pm_log );


	DCS_SetCPUSpeed(DCS_CPUSPEED_HIGHEST);
	
	DCS_GetCPUSpeed(&cpuspeed);

	printf(" CPU speed is set as HIGHEST and get the CPUSpeed is:%d\n", cpuspeed);
	fprintf(pm_log , "CPU speed is set as HIGHEST and get the CPUSpeed is:%d\n", cpuspeed);
	fflush(pm_log );

       


       int lcdlight;
       int i=0;

       for(i=0;i<=100;i++)

       {

        DCS_SetLCDBrightness(i);

        DCS_GetLCDBrightness(&lcdlight);

		printf(" LCD is set as: %d, and get the LCD light as :%d\n", i, lcdlight);
		fprintf(pm_log , " LCD is set as: %d, and get the LCD light as :%d\n", i, lcdlight);
	   fflush(pm_log );

       	}


       BOOL enablewireless;
       i=0;

       for(i=0;i<=1;i++)

       	{

         DCS_SetWirelessStatus(i);

       DCS_GetWirelessStatus(&enablewireless);

	   printf(" wireless is set as: %d and get the wireless status :%d\n", i, enablewireless);
	   fprintf(pm_log , " wireless is set as: %d and get the wireless status :%d\n", i, enablewireless);
	   fflush(pm_log );

       	}


      BOOL enablelan;
       i=0;

       for(i=0;i<=1;i++)

       	{

         DCS_SetLANStatus(i);

       DCS_GetLANStatus(&enablelan);

	   printf(" lan is set as: %d and the get the lan status :%d\n", i, enablelan);
	   fprintf(pm_log , " lan is set as: %d and get the lan status :%d\n", i, enablelan);
	   fflush(pm_log );

       	}


       DCS_Lan_Speed  lanspeed;
        
       DCS_SetLANSpeed(DCS_LAN_SPEED_10M_HALF_DUPLEX);

       DCS_GetLANSpeed(&lanspeed);

      printf(" Lan speed is set as DCS_LAN_SPEED_10M_HALF_DUPLEX and get the Lan speed is:%d\n", lanspeed);
	  fprintf(pm_log , "Lan speed is set as DCS_LAN_SPEED_10M_HALF_DUPLEX and get the  Lan speed is:%d\n", lanspeed);
	 fflush(pm_log );


	   DCS_SetLANSpeed(DCS_LAN_SPEED_10M_FULL_DUPLEX);

       DCS_GetLANSpeed(&lanspeed);

       printf(" Lan speed is set as DCS_LAN_SPEED_10M_FULL_DUPLEX and get the Lan speed is:%d\n", lanspeed);
	  fprintf(pm_log , "Lan speed is set as DCS_LAN_SPEED_10M_FULL_DUPLEX and get the  Lan speed is:%d\n", lanspeed);
	 fflush(pm_log );


	    DCS_SetLANSpeed(DCS_LAN_SPEED_100M_HALF_DUPLEX);

       DCS_GetLANSpeed(&lanspeed);

         printf(" Lan speed is set as DCS_LAN_SPEED_100M_HALF_DUPLEX and get the Lan speed is:%d\n", lanspeed);
	  fprintf(pm_log , "Lan speed is set as DCS_LAN_SPEED_100M_HALF_DUPLEX and get the  Lan speed is:%d\n", lanspeed);
	 fflush(pm_log );

	   DCS_SetLANSpeed(DCS_LAN_SPEED_100M_FULL_DUPLEX);

       DCS_GetLANSpeed(&lanspeed);

      printf(" Lan speed is set as DCS_LAN_SPEED_100M_FULL_DUPLEX and get the Lan speed is:%d\n", lanspeed);
	  fprintf(pm_log , "Lan speed is set as DCS_LAN_SPEED_100M_FULL_DUPLEX and get the  Lan speed is:%d\n", lanspeed);
	 fflush(pm_log );

	   DCS_SetLANSpeed(DCS_LAN_SPEED_1000M_AUTO_NEGOTIATE);

       DCS_GetLANSpeed(&lanspeed);

      printf(" Lan speed is set as DCS_LAN_SPEED_1000M_AUTO_NEGOTIATE and get the Lan speed is:%d\n", lanspeed);
	  fprintf(pm_log , "Lan speed is set as DCS_LAN_SPEED_1000M_AUTO_NEGOTIATE and get the  Lan speed is:%d\n", lanspeed);
	  fflush(pm_log );


       


      
       DCS_DPST  dpstlevel;
      
        DCS_SetDPSTLevel(HIGHEST_POWER_SAVING);

       DCS_GetDPSTLevel(&dpstlevel);

      printf(" dpst level is set as HIGHEST_POWER_SAVING and get the dpst level  is:%d\n", dpstlevel);
	  fprintf(pm_log , " dpst level is set as HIGHEST_POWER_SAVING and get the dpst level  is:%d\n", dpstlevel);
	  fflush(pm_log );



	   DCS_SetDPSTLevel(MEDIUM_POWER_SAVING);

       DCS_GetDPSTLevel(&dpstlevel);

       printf(" dpst level is set as MEDIUM_POWER_SAVING and get the dpst level  is:%d\n", dpstlevel);
	  fprintf(pm_log , " dpst level is set as MEDIUM_POWER_SAVING and get the dpst level  is:%d\n", dpstlevel);
	  fflush(pm_log );

	    DCS_SetDPSTLevel(LOWER_POWER_SAVING);

       DCS_GetDPSTLevel(&dpstlevel);

       printf(" dpst level is set as LOWER_POWER_SAVING and get the dpst level  is:%d\n", dpstlevel);
	  fprintf(pm_log , " dpst level is set as LOWER_POWER_SAVING and get the dpst level  is:%d\n", dpstlevel);
	  fflush(pm_log );


	   DCS_SetDPSTLevel(DISABLED_POWER_SAVING);

       DCS_GetDPSTLevel(&dpstlevel);

       printf(" dpst level is set as DISABLED_POWER_SAVING and get the dpst level  is:%d\n", dpstlevel);
	  fprintf(pm_log , " dpst level is set as DISABLED_POWER_SAVING and get the dpst level  is:%d\n", dpstlevel);
	  fflush(pm_log );

       
	

      DCS_Battery_Info battery;

      DCS_GetBatteryInfo( &battery);

	 
      printf("battary's Status :%d\n", battery.Status);
	  fprintf(pm_log , "battary's Status :%d\n", battery.Status);
	  fflush(pm_log );

      printf("battary's RemainPercent :%d\n", battery.RemainPercent);
	  fprintf(pm_log , "battary's RemainPercent :%d\n", battery.RemainPercent);
	  fflush(pm_log );

      printf("battary's RemainTime :%d\n", battery.RemainTime);
	  fprintf(pm_log , "battary's RemainTime :%d\n", battery.RemainTime);
	  fflush(pm_log );

      printf("battary's Capabilities :%d\n", battery.Capabilities);
	  fprintf(pm_log , "battary's Capabilities :%d\n", battery.Capabilities);
	  fflush(pm_log );

      printf("battary's DesignedCapacity :%d\n", battery.DesignedCapacity);
	  fprintf(pm_log , "battary's DesignedCapacity :%d\n", battery.DesignedCapacity);
	  fflush(pm_log );

      printf("battary's FullChargedCapacity :%d\n", battery.FullChargedCapacity);
	  fprintf(pm_log , "battary's FullChargedCapacity :%d\n", battery.FullChargedCapacity);
	  fflush(pm_log );

      printf("battary's Technology :%d\n", battery.Technology);
	  fprintf(pm_log , "battary's Technology :%d\n", battery.Technology);
	  fflush(pm_log );

       printf("battary's Chemistry :%c\n", battery.Chemistry);
	    fprintf(pm_log , "battary's Chemistry :%c\n", battery.Chemistry);
	  fflush(pm_log );

        printf("battary's DefaultAlert1 :%d\n", battery.DefaultAlert1);
	    fprintf(pm_log , "battary's DefaultAlert1 :%d\n", battery.DefaultAlert1);
	   fflush(pm_log );

      printf("battary's DefaultAlert2 :%d\n", battery.DefaultAlert2);
	   fprintf(pm_log , "battary's DefaultAlert2 :%d\n", battery.DefaultAlert2);
	  fflush(pm_log );

        printf("battary's CriticalBias :%d\n", battery.CriticalBias);
		 fprintf(pm_log , "battary's CriticalBias :%d\n", battery.CriticalBias);
	  fflush(pm_log );

      printf("battary's CycleCount :%d\n", battery.CycleCount);
	   fprintf(pm_log , "battary's CycleCount :%d\n", battery.CycleCount);
	  fflush(pm_log );

        printf("battary's Current :%d\n", battery.Current);
		 fprintf(pm_log , "battary's Current :%d\n", battery.Current);
	  fflush(pm_log );

      printf("battary's Voltage :%d\n", battery.Voltage);
	   fprintf(pm_log , "battary's Voltage :%d\n", battery.Voltage);
	  fflush(pm_log );

        printf("battary's Temperature :%d\n", battery.Temperature);
		 fprintf(pm_log , "battary's Temperature :%d\n", battery.Temperature);
	  fflush(pm_log );

    
   
/*The following 5 API will only be tested in Linux

DCSAPI DCS_Return_Code DCS_SetActivePwrScheme(int schemeId);



DCSAPI DCS_Return_Code DCS_AddPwrScheme(char *pName, char *pDesc, int copyFrom, int *schemeId);



DCSAPI DCS_Return_Code DCS_DeletePwrScheme(int schemeId);



DCSAPI DCS_Return_Code DCS_SetPwrVariable(int schemeId, BOOL isAC, const char *pVarName, int value);
DCS_SetPwrVariable(0,1,"cpuspeed", 100);


 
DCSAPI DCS_Return_Code DCS_GetPwrVariable(int schemeId, BOOL isAC, const char *pVarName, int *pValue);
*/

       
}
       /*uninitialize the DCS*/
    
   if((use_accel==1)||(use_tablet==1)||(use_fnkey==1))
   {
   while(1);
   }

    DCS_Uninitialize();

	DCS_UnregisterAccelCallback();

	DCS_UnregisterSystemOrientationCallback();

	DCS_UnregisterTabletSensorCallback();

	DCS_UnregisterFnKeyCallback();
       
       if(ret==0)
	{
		printf("DCS_Uninitialize SUCCESS\n"); 

		return 0;
	}else 	
	{	
	
	printf("DCS_Uninitialize Fail\n"); 
	
	return ret;
	
	}

	fclose(accel_log);
	fclose(fnkey_log);
	fclose(tablet_log);
	fclose(pm_log);
	fclose(policy_log);
	

	
	
}

