/*
 * Device Control Service API  
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "DCSCommon.h"
#include "DCSApi.h"
#include "ConnMgmt.h"
#include <pthread.h>
#include "ReqMgmt.h"
#include <sys/signal.h>
#include "errno.h"
#include <sys/stat.h>
#include <deque>
#include "PMPlugin.h"

pthread_t abortThread = 1; /* thread id for running user's abort callback
							* set it to 1 here and to 0 in Initialize
							* to prevent uninitialized situation
							*/

static	pthread_t dispatchThread=0;
static	pthread_t dispatchCallbackThread=0;
extern void DebugString(char* format, ...);

pthread_mutex_t mutex= PTHREAD_MUTEX_INITIALIZER;
pthread_cond_t cond = PTHREAD_COND_INITIALIZER;

pthread_mutex_t callback_mutex = PTHREAD_MUTEX_INITIALIZER;
pthread_cond_t callback_cond = PTHREAD_COND_INITIALIZER;
int exitFlag = 0;

//pthread_mutex_t callbackMutex = PTHREAD_MUTEX_INITIALIZER;

pthread_mutex_t func_mutex = PTHREAD_MUTEX_INITIALIZER;

static DCS_Response funcResponse;
int availableresponse=0;
static std::deque<DCS_Response> m_Responses;

//int callbacktimes=0;
int functimes=0;
pthread_mutex_t dcsMutex= PTHREAD_MUTEX_INITIALIZER;
DCS_Abort_Callback abortHandler = NULL;

int DCS_Lock()
{
    pthread_mutex_lock(&dcsMutex);
	return 0;
}

int DCS_Unlock()
{
	// release the mutex object
	pthread_mutex_unlock(&dcsMutex);
	return 0;
}

int CopyResponse(DCS_Response* pDestResponse, DCS_Response* pSrcResponse)
{
	if (pSrcResponse == NULL || pDestResponse==NULL) return -1;
#if 0
	memcpy(pDestResponse,pSrcResponse, sizeof(DCS_Response)-sizeof(char*));
	if (pSrcResponse->dataLen > 0 && pSrcResponse->dataLen <= MAX_RETURN_DATA_LEN)
	{
		if (pDestResponse->data != NULL) delete []pDestResponse->data;
		pDestResponse->data = new char[pSrcResponse->dataLen];
		memcpy(pDestResponse->data, pSrcResponse->data, pSrcResponse->dataLen);
	}
#endif
	*pDestResponse = *pSrcResponse;
	return 0;
}

int DCS_WaitResponse(DCS_Response* pResponse, int moduleID, int opID)
{
	BOOL correctResponse = FALSE;
	while(1)
	{
	pthread_mutex_lock(&mutex);
	while (availableresponse<=0)
		pthread_cond_wait(&cond, &mutex);
	availableresponse--;
	pthread_mutex_unlock(&mutex);

	pthread_mutex_lock(&func_mutex);
	if (funcResponse.moduleID == moduleID && funcResponse.opID == opID)
	{
		CopyResponse(pResponse, &(funcResponse));
		correctResponse=TRUE;
	}
	pthread_mutex_unlock(&func_mutex);
	if (correctResponse) break;
	}
	return 0; 
    
}

int DCS_SignalResponse(DCS_Response* pResponse)
{
	if (pResponse == NULL) return -1;
	pthread_mutex_lock(&func_mutex);
	//save the response
	CopyResponse( &(funcResponse), pResponse);
	pthread_mutex_unlock(&func_mutex);

	pthread_mutex_lock(&mutex);
	if (availableresponse>=0)	pthread_cond_signal (&cond);
	availableresponse++;
	pthread_mutex_unlock(&mutex);

	return 0;
}

void * CallbackDispatcher(void *)
{
	ReqMgmt *pReqMgmt = ReqMgmt::Instance(); 

	DCS_Response callbackResponse;


	pthread_mutex_lock(&callback_mutex);
	while (1 != exitFlag){
		pthread_cond_wait(&callback_cond, &callback_mutex);
		if (1 == exitFlag) {
			pthread_mutex_unlock(&callback_mutex);	
			break; //exit signal
		}

		while (!m_Responses.empty())
		{
			callbackResponse = m_Responses.front();
			m_Responses.pop_front();
			pthread_mutex_unlock(&callback_mutex);
			pReqMgmt->DispatchEvent(&callbackResponse);
			pthread_mutex_lock(&callback_mutex);
		}
	}

	pthread_exit(NULL);
}


DCS_Return_Code DCS_Initialize()
{
	pthread_t dispatchCallbackThread=NULL;
	m_Responses.clear();
	availableresponse = 0;
	ConnMgmt *pConnMgmt = ConnMgmt::Instance(); 
	int ret = 0;
	if (pConnMgmt == NULL) return DCS_FAIL_OPERATION;
	ret = pConnMgmt->Connect();
	if (ret < 0)/** connect to server failed*/
		return DCS_FAIL_OPERATION;
	 struct   stat   s;  
	 if(lstat("/usr/bin/dcs/genpasswd",   &s)   >=   0)
		system("/usr/bin/dcs/genpasswd");	
	
//	m_Responses.clear();
//	availableresponse=0;
	dispatchThread = NULL;
	dispatchCallbackThread = NULL;

//	callbacktimes=0;
	exitFlag = 0;
	pthread_create(&dispatchCallbackThread,NULL,CallbackDispatcher, NULL);

	abortThread = 0;

	return DCS_SUCCESS;
}

void *AbortHelper(void *)
{
	abortHandler();
	return 0;
}

void * EventDispatcher(void *)
{
	DCS_Response response;
	ReqMgmt *pReqMgmt = ReqMgmt::Instance(); 
	ConnMgmt *pConnMgmt = ConnMgmt::Instance(); 
  
	while(1)
	{
		if ( pConnMgmt->Recv(&response) )
		{
			printf("socket break\n");
			goto EventDispatcher_RETURN;
		}

		//new one thread to handle function response, the other to handle event response
		if (response.opID >= DCS_EVENT_NUM_START)
		{
			if (response.moduleID == DCS_POWER_MANAGER && (response.opID == PM_CPU_SPEED_CHANGED || response.opID == PM_LAN_SPEED_CHANGED || response.opID == PM_APPLY_SCHEME))//it's function 
				pReqMgmt->DispatchEvent(&response);	
			else{
				pthread_mutex_lock(&callback_mutex);
				m_Responses.push_back(response);
//				callbacktimes++;	
				pthread_mutex_unlock(&callback_mutex);	
				pthread_cond_signal(&callback_cond);
			}
		
		}
		else
		{
			pReqMgmt->DispatchEvent(&response);	
		}
		if (response.dataLen >0)
			delete [] response.data;
		
		sleep(0);
	}
EventDispatcher_RETURN:
	/* signal the waiting thread if there is any */
	response.returnCode = DCS_CONNECTION_ABORT;
	response.dataLen = 0;
	response.data = NULL;
	DCS_SignalResponse(&response);
	

    if (abortHandler != NULL)
		if (0 == abortThread)
			pthread_create(&abortThread, NULL, AbortHelper, NULL);
	/* set the thread ID to 0 since it is going to exit */
	dispatchThread = 0;

	pthread_exit(NULL);
}

DCS_Return_Code DCS_DispatchEvent()
{
	DCS_Return_Code ret = DCS_SUCCESS;
	if (dispatchThread == 0)
	if( pthread_create(&dispatchThread,NULL,EventDispatcher, NULL) < 0 )
        	printf("pthread_create DCS_DispatchEvent Failed \n");

	return ret;
}

DCS_Return_Code DCS_Uninitialize()
{
	ConnMgmt *pConnMgmt = ConnMgmt::Instance();
	if (pConnMgmt != NULL){
		pConnMgmt->ShutdownClient();//close the socket
		delete pConnMgmt;
    	}

	ReqMgmt* pReqManager = ReqMgmt::Instance();
	if (pReqManager != NULL) 
		delete pReqManager;

    DCS_Unlock();
	pthread_mutex_unlock(&mutex);
	pthread_cond_signal (&cond);

	//exit the two threads, callbackDispatcher
	pthread_mutex_lock(&callback_mutex);
	exitFlag = 1;
	pthread_mutex_unlock(&callback_mutex);
	pthread_cond_signal (&callback_cond);

	pthread_mutex_unlock(&func_mutex);

	if (dispatchThread != 0)
		pthread_join(dispatchThread, NULL);
	dispatchThread = 0;

	
	if (dispatchCallbackThread != 0)
		pthread_join(dispatchCallbackThread, NULL);
	dispatchCallbackThread = 0;

	m_Responses.clear();
	availableresponse = 0;
	abortHandler = NULL;
	return DCS_SUCCESS;
}


DCSAPI DCS_Return_Code DCS_GetVersion(UINT *version)
{
    *version = DCS_VERSION;
	return DCS_SUCCESS;
}

/* Set the callback handler to be notified when dcs aborts. */
DCSAPI DCS_Return_Code DCS_SetAbortHandler(DCS_Abort_Callback callback)
{
    abortHandler = callback;
    return DCS_SUCCESS;
}
