/****************************************************************************

Copyright (c) Intel Corporation (2008).

DISCLAIMER OF WARRANTY
NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR
CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY
OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS
EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR
FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT
THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL
BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON
ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.
SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL
NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,
TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY
UPDATES, ENHANCEMENTS OR EXTENSIONS.

File Name:          PMPluginApi.h

Description:

    This file definds class PMPlugin.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Deng Jing 2008-8-15

  =====================================================================

****************************************************************************/

#ifndef DCS_POWERMANAGEMENT_PLUGINAPI_H
#define DCS_POWERMANAGEMENT_PLUGINAPI_H

#include "./inc/DCSCommon.h"
#include "./inc/pm/PMDef.h"
#include "./inc/DcsPlugin.h"
#include "PMBatteryMgmt.h"

#include <sys/ioctl.h>
#include <linux/types.h>
#include <linux/ethtool.h>
#include <linux/sockios.h>
#include <net/if.h>
#include <arpa/inet.h>
#include <linux/wireless.h>

#include <string>
using namespace std;

class PMPlugin
{
public:
    PMPlugin();
     ~PMPlugin();
    void InitializeDCS_Funcs(DCS_Funcs* pFuncs);

public:
    /** Gets the LCD maximum brightness. */
    DCSAPI DCS_Return_Code PP_GetLCDMaxBrightness(int* bright);

    /** Gets the LCD brightness, bright is (0, max LCD brightness). */
    DCSAPI DCS_Return_Code PP_GetLCDBrightness(int* bright);

    /** Sets the LCD brightness, bright is (0, max LCD brightness). */
    DCSAPI DCS_Return_Code PP_SetLCDBrightness(int bright);

    /** Gets wireless status. */
    DCSAPI DCS_Return_Code PP_GetWirelessStatus(BOOL* pEnabled);

    /** Turns on/off wireless. */
    DCSAPI DCS_Return_Code PP_SetWirelessStatus(BOOL enable);

    /** Gets LAN status. */
    DCSAPI DCS_Return_Code PP_GetLANStatus(BOOL* pEnabled);

    /** Turns on/off LAN. */
    DCSAPI DCS_Return_Code PP_SetLANStatus(BOOL enable);

    /** Sets LAN speed. */
    DCSAPI DCS_Return_Code PP_SetLANSpeed(DCS_Lan_Speed speed);

    /** Gets LAN speed. */
    DCSAPI DCS_Return_Code PP_GetLANSpeed(DCS_Lan_Speed* pSpeed);

    /** Gets the battery count. */
    DCSAPI DCS_Return_Code PP_GetBatteryCount(ULONG * batCount);

    /** Gets the battery information. */
    DCSAPI DCS_Return_Code PP_GetBatteryInfo(PDCS_Battery_Info battery, int batIndex);

    /**
     * Applies a power scheme.
     *
     * @param schemeId	the ID of the power scheme to set active
     */
    DCSAPI DCS_Return_Code PP_SetActivePwrScheme(int schemeId);

    /**
     * Applies a power scheme.
     *
     * @param pSchemeId	the pointer to the value got.
     */
    DCSAPI DCS_Return_Code PP_GetActivePwrScheme(int * pSchemeId);

    /**
     * Adds a new power scheme.
     *
     * @param pName		the power scheme name
     * @param pDesc		the description of power scheme
     * @param copyFrom	the index of the power scheme copied
     * @param schemeId	pointer to the newly added power scheme ID
     */
    DCSAPI DCS_Return_Code PP_AddPwrScheme(char *pName, char *pDesc, int copyFrom, int *schemeId);

    /**
     * Deletes a power scheme.
     *
     * @param schemeId	the power scheme ID
     */
    DCSAPI DCS_Return_Code PP_DeletePwrScheme(int schemeId);

    /**
     * Sets a variable value in a power scheme.
     *
     * @param schemeId	the power scheme ID
     * @param isAC      \c TRUE if AC; \c FALSE if DC
     * @param pVarName	the variable name
     * @param value		the variable value to be set
     */
    DCSAPI DCS_Return_Code PP_SetPwrVariable(int schemeId, BOOL isAC, const char *pVarName, int value);

    /**
     * Gets the value of the variable.
     *
     * @param schemeId	the power scheme ID
     * @param isAC      \c TRUE if AC; \c FALSE if DC
     * @param pVarName	the variable name
     * @param pValue	the pointer to the value got
     */
    DCSAPI DCS_Return_Code PP_GetPwrVariable(int schemeId, BOOL isAC, const char *pVarName, int *pValue);

    /**
     * Gets the value of the variable.
     *
     * @param schemeId		the power scheme ID
     * @param pSchemeName	the buffer to receive scheme name.
     * @param nameSize		the buffer size of scheme name
     * @param pSchemeDesc	the buffer to receive scheme short description.
     * @param descSize		the buffer size of scheme description
     */
    DCSAPI DCS_Return_Code PP_GetPwrSchemeNameDesc(int schemeId, string &schemeName, string &schemeDesc);

    /** get current user's home dir*/
    DCSAPI DCS_Return_Code SetUserHomeDir(char * dirPath);

    DCSAPI DCS_Return_Code PP_PostDownInterfaceReq(int networkType);

private:
    ifreq* GetIfreq(int socketfd);
    int GetSpeed(ifreq* ifr);
    int OpenSockets();
    DCSAPI DCS_Return_Code GetLCDMaxBrightness();

private:
    DCS_Funcs *m_pFuncs;
    int m_MaxLCDBrightness;
    string m_UserHomeDir;
};
#endif /* DCS_POWERMANAGEMENT_PLUGINAPI_H */
