/*
 * Enhanced Easy Network Plugin API
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */
#ifndef DCS_ENMDATAMANAGER_H
#define DCS_ENMDATAMANAGER_H

#include "ENMDef.h"
#include "./inc/DCSCommon.h"
#include <DcsPlugin.h>
#include "wx/arrstr.h"
#include "LinuxNetworkAPI.h"
class ENMDataManager
{

public:
    ~ENMDataManager() ;

    static ENMDataManager* GetInstance();

    void InitializeDCS_Funcs(DCS_Funcs* pFuncs);

    DCS_Return_Code InitUserInfo(ENM_InitUserInfo& userInfo);

    DCS_Return_Code SearchAdapter();

    DCS_Return_Code IsExistUpAdapter(ENM_ADAPTER_TYPE adapterType,BOOL* pOutIsUp);

    DCS_Return_Code IsExistConnectAdapter(ENM_ADAPTER_TYPE adapterType,BOOL* pOutIsConnect);

    DCS_Return_Code UpAdapter(ENM_ADAPTER_TYPE adapterType);

    DCS_Return_Code DispatchDisableEvent(ENM_ADAPTER_TYPE adapterType);

    DCS_Return_Code DownAdapter(ENM_ADAPTER_TYPE adapterType);

    DCS_Return_Code ConnectAP(ENM_ConnectAP& apInfo);

    DCS_Return_Code GetAPList(AccessPointList* pOutAPList);

    DCS_Return_Code GetCurrentAP(APStatus* pOutCurrentAP);

    DCS_Return_Code GetIPAddressHLAN(ENM_String* pOutIpAddress);

    DCS_Return_Code GetConnectTypeHLAN(ENM_String* pOutConnectType);

    DCS_Return_Code AllocateDhIP();

    DCS_Return_Code CloseWlanConnection();

    DCS_Return_Code Enable8021xAuthentication(bool* pEnable);

    DCS_Return_Code EnableInternetSharing(bool* pEnable);

    DCS_Return_Code OverwriteHomePage(ENM_String* pStrHomePage);

    DCS_Return_Code OverwriteProxy(ENM_ProxyInfo* pProxyInfo);

//    DCS_Return_Code GetNeighborsInfo(PENM_NEIGHBORS_INFO* pNeighborsInfo);

    DCS_Return_Code ChangeAddress(ENM_AddressInfo* pAddressInfo);

    DCS_Return_Code EnableFileAndPrint(bool* pEnable);

    DCS_Return_Code EnableWindowsFirewall(bool* pEnable);

    DCS_Return_Code IsExistAdapter(ENM_ADAPTER_TYPE adapterType,BOOL* pOutIsExist);

    DCS_Return_Code ExecSmbtree();

    DCS_Return_Code ExecNmblookup(ENM_StringW* strHostName);

    DCS_Return_Code DeleteProfile(ENM_StringW* pstrFileName);

    //mesh functiohs
    DCS_Return_Code SetMeshChannel(int channel);
    DCS_Return_Code GetMeshChannel(int *channel);
    DCS_Return_Code SetMeshHostname(ENM_String *hostname);
    DCS_Return_Code GetMeshHostname(ENM_String *hostname);
    DCS_Return_Code SwitchMesh(bool flag);
    DCS_Return_Code ExecCommand(ENM_String *cmd);
    DCS_Return_Code GetMeshNeighbor(PMESH_NEIGHBOR_INFO* nb);
    DCS_Return_Code EnableClient(PMESH_GATEWAY_INFO meshGatewayInfo);
    DCS_Return_Code EnableGateway(ENM_String *exif);
    DCS_Return_Code GetGatewayInfo(PMESH_GATEWAY_INFO meshGatewayInfo);
    DCS_Return_Code SetMeshID();
    DCS_Return_Code SetMeshChannelOFFSET(int channel);

private:

    ENMDataManager() ;

    static ENMDataManager* m_pENMDataManager;

    ENM_InitUserInfo m_InitUserInfo;

    wxArrayString m_WirelessAdapterList;
    wxArrayString m_WiredAdapterList;

    LinuxNetworkAPI m_LinuxNetworkApi;

    string m_currentAdapter;

    APStatus m_CurrentAP;

    DCS_Funcs *m_pFuncs;



};

#endif /* DCS_ENMDATAMANAGER_H */
