/*
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifdef WIN32
#include <afxwin.h>
#include "winsock2.h"
#else
#include <stdio.h>              /* for convenience */
#include <stdlib.h>             /* for convenience */
#include <stddef.h>             /* for offsetof */
#include <unistd.h>             /* for convenience */
#include <signal.h>             /* for SIG_ERR */
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/un.h>
#include <time.h>
#include <errno.h>
#endif

#include "ConnMgmt.h"
#include <stdio.h>              /* for convenience */
#include <string.h>             /* for convenience */
#include "Crypto.h"
#include "assert.h"

#ifdef DCS_SERVER
#include "SupplierManager.h"
#endif


extern void DebugString(const char* format, ...);
ConnMgmt* ConnMgmt::pInstance;
int ConnMgmt::err=0;

#ifdef WIN32
int m_Port = 8001;
#else
#define STALE 30 /* client's name can't be older than this (sec) */
#define QLEN 10
const char* sockName = "/tmp/HawkPeak_DCS";
const char* CLI_PATH = "/tmp/dcs";
#define CLI_PERM S_IRWXU /**<rwx for user only*/

#endif

ConnMgmt* ConnMgmt::Instance()
{
	if (pInstance == NULL)
	{
		pInstance = new ConnMgmt();

#ifdef WIN32
	//	if (WSAGetLastError())
#else
		if (err < 0)
			return NULL;
#endif

	}
	return pInstance;
}

ConnMgmt::ConnMgmt()
{
	listenfd = 0;
	fd = 0;
	err = 0;

#ifdef WIN32
	InitializeCriticalSection(&m_clifdsLock);
#else
	pthread_mutex_init(&m_clifdsLock, NULL);
#endif

#ifdef WIN32
	m_hMutex = NULL;
#ifdef DCS_SERVER
	// create the mutex object
	while ((m_hMutex = CreateMutex(NULL, FALSE, NULL))== NULL)
	{
		Sleep(5000);
		DebugString("Error at CreateMutex()\n");
	}
#endif
	// Initialize Winsock
	WSADATA wsaData;
	int iResult = 0;
	while( (iResult = WSAStartup(MAKEWORD(2,2), &wsaData)) != NO_ERROR)
	{
		DebugString("Error at WSAStartup()\n");
		Sleep(5);
	}
#ifdef DCS_SERVER
	Listen();
#endif
#else
#ifdef DCS_SERVER
	err = Listen();
#endif

#endif

	{
		LockHelper helper(m_clifdsLock);
		m_clifds.clear();
	}
}


ConnMgmt::~ConnMgmt()
{
#ifdef DCS_SERVER
	Unlock();

	std::set<DCS_Socket>::iterator i;
	{
		LockHelper helper(m_clifdsLock);
		for   (i=m_clifds.begin();i!=m_clifds.end();i++)
			closesocket(*i);
	}
    closesocket(listenfd);
#else
 //   closesocket(fd);
#endif

#ifdef WIN32
	DeleteCriticalSection(&m_clifdsLock);
#else
	pthread_mutex_destroy(&m_clifdsLock);
#endif

#ifdef WIN32
	WSACleanup();
	m_hMutex = NULL;
#endif
	if (pInstance != NULL)
		pInstance = NULL;
}

#ifdef WIN32
/*
* Create a server endpoint of a connection.
* Returns fd if all OK, <0 on error.
*/
DCS_Socket ConnMgmt::Listen()
{
//	int  rval;
	struct sockaddr_in saServer;

	/* create a  socket */
	while ((listenfd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0)
	{
		DebugString("listen socket fail to construct");
		Sleep(5000);
	//	return(-1);
	}

    BOOL   val = TRUE;
    //SO_REUSEADDRѡǿʵֶ˿ذ󶨵
    while (setsockopt(listenfd,SOL_SOCKET,SO_REUSEADDR,(char *)&val,sizeof(val))!=0)
    {
        DebugString("error!setsockopt failed!\n");
		Sleep(5000);
       // return -1;
    }

	/* fill in socket address structure */
	memset(&saServer, 0, sizeof(saServer));

	// Set up the sockaddr structure
	saServer.sin_family = AF_INET;
	saServer.sin_addr.s_addr = inet_addr( "127.0.0.1" );
	saServer.sin_port = htons(m_Port);
    BOOL bDontLinger = FALSE;
    setsockopt(listenfd,SOL_SOCKET,SO_DONTLINGER,(const char*)&bDontLinger,sizeof(BOOL));


	/* bind the name to the descriptor */
	while (bind(listenfd,(SOCKADDR*) &saServer, sizeof(saServer)) < 0) {
		//rval = -2;
		//goto errout;
		DebugString("listen socket fail to bind");
		Sleep(5000);

	}

	while (listen(listenfd, SOMAXCONN ) == SOCKET_ERROR) {	/* tell kernel we're a server */
		//rval = -3;
		//goto errout;
		DebugString("listen socket fail to bind");
		Sleep(5000);
	}

	// ջ
//	int nRecvBuf=32*1024;//Ϊ32K
//	setsockopt(listenfd,SOL_SOCKET,SO_RCVBUF,(const char*)&nRecvBuf,sizeof(int));

	//BOOL enabled = TRUE;
	//setsockopt(listenfd,IPPROTO_TCP,TCP_NODELAY,(const char*)&enabled,sizeof(BOOL));

	//ݵʱϣϵͳsocketĿӰ
	//int nZero=0;
	//setsockopt(listenfd,SOL_SOCKET,SO_SNDBUF,(char *)&nZero,sizeof(nZero));

//	setsockopt(listenfd,SOL_SOCKET,SO_RCVBUF,(char *)&nZero,sizeof(int));

	return(listenfd);

//errout:
//	err = errno;
//	closesocket(listenfd);
//	errno = err;
//	return(rval);
}

/*
* Wait for a client connection to arrive, and accept it.
* We also obtain the client's user ID from the pathname
* that it must bind before calling us.
* Returns new fd if all OK, <0 on error
*/
DCS_Socket ConnMgmt::AcceptConnection()
{
	DCS_Socket clifd;
	//if (cliNum >= MAX_CONN_NUM)
	//{
	//	DebugString("exceed the maximun number of connection to DCS.");
	//	return(INVALID_SOCKET);
	//}
	if ((clifd = accept(listenfd, NULL, NULL) )== INVALID_SOCKET)
	{
		DebugString("accept fail.");
		return(INVALID_SOCKET);		/* often errno=EINTR, if signal caught */
	}

		// ջ
	//int nRecvBuf=32*1024;//Ϊ32K
	//setsockopt(clifd,SOL_SOCKET,SO_RCVBUF,(const char*)&nRecvBuf,sizeof(int));
        BOOL   val = TRUE;
    //SO_REUSEADDRѡǿʵֶ˿ذ󶨵
    if(setsockopt(clifd,SOL_SOCKET,SO_REUSEADDR,(char *)&val,sizeof(val))!=0)
    {
        DebugString("error!setsockopt failed!\n");
        return -1;
    }

    BOOL bDontLinger = FALSE;
    setsockopt(clifd,SOL_SOCKET,SO_DONTLINGER,(const char*)&bDontLinger,sizeof(BOOL));


	BOOL enabled = TRUE;
	setsockopt(clifd,IPPROTO_TCP,TCP_NODELAY,(const char*)&enabled,sizeof(BOOL));

	//ݵʱϣϵͳsocketĿӰ
	//int nZero=0;
	//setsockopt(clifd,SOL_SOCKET,SO_SNDBUF,(char *)&nZero,sizeof(nZero));
	//
	//setsockopt(clifd,SOL_SOCKET,SO_RCVBUF,(char *)&nZero,sizeof(int));
	{
		LockHelper helper(m_clifdsLock);
		m_clifds.insert(clifd);
	}

	return(clifd);

}


/*
* Create a client endpoint and connect to a server.
* Returns fd if all OK, <0 on error.
*/
int ConnMgmt::Connect()
{
	int err, rval;

	/* create a tcp socket */
	if ((fd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP))== INVALID_SOCKET)
		return(-1);


	/* fill socket address structure with our address */
	sockaddr_in clientService;
	memset(&clientService, 0, sizeof(clientService));
	clientService.sin_family = AF_INET;
	clientService.sin_addr.s_addr = inet_addr( "127.0.0.1" );
	clientService.sin_port = htons( m_Port );

    BOOL   val = TRUE;
    //SO_REUSEADDRѡǿʵֶ˿ذ󶨵
    if(setsockopt(fd,SOL_SOCKET,SO_REUSEADDR,(char *)&val,sizeof(val))!=0)
    {
        DebugString("error!setsockopt failed!\n");
        return -1;
    }

    BOOL bDontLinger = FALSE;
    setsockopt(fd,SOL_SOCKET,SO_DONTLINGER,(const char*)&bDontLinger,sizeof(BOOL));
	if (connect(fd,(SOCKADDR*) &clientService, sizeof(clientService)) == SOCKET_ERROR) {
		rval = -2;
		goto errout;
	}

	BOOL enabled = TRUE;
	setsockopt(fd,IPPROTO_TCP,TCP_NODELAY,(const char*)&enabled,sizeof(BOOL));

	return(0);

errout:
	err = errno;
	closesocket(fd);
	errno = err;
	return(rval);
}

int ConnMgmt::Lock()
{
    WaitForSingleObject(m_hMutex, INFINITE);
	return 0;
}

int ConnMgmt::Unlock()
{
	// ͷŻ
    ReleaseMutex(m_hMutex);

	return 0;
}


#else
/*
* Create a server endpoint of a connection.
* Returns fd if all OK, <0 on error.
*/
int ConnMgmt::Listen()
{
	int	len, rval;
	struct sockaddr_un	un;

	/* create a UNIX domain stream socket */
	if ((listenfd = socket(AF_UNIX, SOCK_STREAM, 0)) < 0)
		return(-1);

	unlink(sockName);	/* in case it already exists */

	/* fill in socket address structure */
	memset(&un, 0, sizeof(un));
	un.sun_family = AF_UNIX;
	strcpy(un.sun_path, sockName);
	len = offsetof(struct sockaddr_un, sun_path) + strlen(sockName);

	/* bind the name to the descriptor */
	if (bind(listenfd, (struct sockaddr *)&un, len) < 0) {
		rval = -2;
		goto errout;
	}

	if (listen(listenfd, QLEN) < 0) {	/* tell kernel we're a server */
		rval = -3;
		goto errout;
	}
	return(listenfd);

errout:
	DebugString("listen error: %s", strerror(errno));
	err = errno;
	close(listenfd);
	errno = err;
	return(rval);
}

/*
* Wait for a client connection to arrive, and accept it.
* We also obtain the client's user ID from the pathname
* that it must bind before calling us.
* Returns new fd if all OK, <0 on error
*/
SOCKET_TYPE ConnMgmt::AcceptConnection()
{
	int					 len, rval;
	//time_t				staletime;
	struct sockaddr_un	un;
	struct stat			statbuf;
	int clifd;

	len = sizeof(un);
	if ((clifd = accept(listenfd, (struct sockaddr *)&un, (socklen_t*)&len)) < 0)
		return(-1);		/* often errno=EINTR, if signal caught */

	/* obtain the client's uid from its calling address */
	len -= offsetof(struct sockaddr_un, sun_path); /* len of pathname */
	un.sun_path[len] = 0;			/* null terminate */

	if (stat(un.sun_path, &statbuf) < 0) {
		rval = -2;
		goto errout;
	}
#ifdef	S_ISSOCK	/* not defined for SVR4 */
	if (S_ISSOCK(statbuf.st_mode) == 0) {
		rval = -3;		/* not a socket */
		goto errout;
	}
#endif
	if ((statbuf.st_mode & (S_IRWXG | S_IRWXO)) ||
		(statbuf.st_mode & S_IRWXU) != S_IRWXU) {
			rval = -4;	/* is not rwx------ */
			goto errout;
	}

	//staletime = time(NULL) - STALE;
	/*if (statbuf.st_atime < staletime ||
	statbuf.st_ctime < staletime ||
	statbuf.st_mtime < staletime) {
	rval = -5;	// i-node is too old
	goto errout;
	}
	*/
	//if (uidptr != NULL)
	//memcpy(&uid, &(statbuf.st_uid), sizeof(uid_t));	/* return uid of caller */
	unlink(un.sun_path);		/* we're done with pathname now */

	{
		LockHelper helper(m_clifdsLock);
		m_clifds.insert(clifd);
	}
	return(clifd);

errout:
	DebugString("accept error: %s", strerror(errno));
	err = errno;
	close(clifd);
	errno = err;
	return(rval);
}
/*
DCS_UserID ConnMgmt::GetUserID()
{
return uid;
}
*/
/*
* Create a client endpoint and connect to a server.
* Returns fd if all OK, <0 on error.
*/
int ConnMgmt::Connect()
{
	int	 len, err, rval;
	struct sockaddr_un	un;

	/* create a UNIX domain stream socket */
	if ((fd = socket(AF_UNIX, SOCK_STREAM, 0)) < 0)
		return(-1);

	/* fill socket address structure with our address */
	memset(&un, 0, sizeof(un));
	un.sun_family = AF_UNIX;
	sprintf(un.sun_path, "%s%05d", CLI_PATH, getpid());
	len = offsetof(struct sockaddr_un, sun_path) + strlen(un.sun_path);

	unlink(un.sun_path);		/* in case it already exists */
	if (bind(fd, (struct sockaddr *)&un, len) < 0) {
		rval = -2;
		goto errout;
	}
	if (chmod(un.sun_path, CLI_PERM) < 0) {
		rval = -3;
		goto errout;
	}

	/* fill socket address structure with server's address */
	memset(&un, 0, sizeof(un));
	un.sun_family = AF_UNIX;
	strcpy(un.sun_path, sockName);
	len = offsetof(struct sockaddr_un, sun_path) + strlen(sockName);
	if (connect(fd, (struct sockaddr *)&un, len) < 0) {
		rval = -4;
		goto errout;
	}
	return(fd);

errout:
	DebugString("connect error: %s", strerror(errno));
	err = errno;
	close(fd);
	errno = err;
	return(rval);
}
static pthread_mutex_t dcsResponseMutex= PTHREAD_MUTEX_INITIALIZER;

int ConnMgmt::Lock()
{
	pthread_mutex_lock(&dcsResponseMutex);
	return 0;
}

int ConnMgmt::Unlock()
{
	// release the mutex object
	pthread_mutex_unlock(&dcsResponseMutex);

	return 0;
}

#endif

int ConnMgmt::ShutdownServer()
{
	DebugString("ConnMgmt::ShutdownServer()");
    shutdown(listenfd, 2);
	closesocket(listenfd);

	return 0;
}

int ConnMgmt::ShutdownClient()
{
	DebugString("ConnMgmt::ShutdownClient()");

    shutdown(fd, 2);
	closesocket(fd);

	return 0;
}

int ConnMgmt::Disconnect(DCS_Socket clifd)
{
	DebugString("ConnMgmt::Disconnect()");
	{
		LockHelper helper(m_clifdsLock);
		m_clifds.erase(clifd);
	}
#ifdef DCS_SERVER
	SupplierManager* pSupplierManager=SupplierManager::Instance();
	pSupplierManager->RemoveClient(clifd);
#endif
//	Unlock();
#ifdef WIN32
	closesocket(clifd);
#else
	close(clifd);
#endif
	return 0;
}


int SEND(DCS_Socket fd, char* buf, int len, int flags)
{
	int ret = 0;
	int tmp = 0;
	ret = send(fd, buf, len, flags);
	if (ret == -1) return -1;
//	if (ret == 0 ) return 0; //socket close
	while (ret < len)
	{
		tmp= send(fd, buf+ret, len-ret, flags);
		if (tmp == -1) return -1;
	//	if (tmp == 0) return 0; //socket close
		assert(ret + tmp <= len);
		ret += tmp;
	}
	assert(ret == len);
	return ret;
}
int RECV(DCS_Socket t_fd, char* buf, int len, int flags)
{
	int ret = 0;
	int tmp = 0;
	ret = recv(t_fd, buf, len, flags);
	if (ret == -1) return -1;
	if (ret == 0 ) return 0; //socket close
	while (ret < len)
	{
		tmp= recv(t_fd, buf+ret, len-ret, flags);
		if (tmp == -1) return -1;
		if (tmp == 0) return 0; //socket close
		assert(ret + tmp <= len);
		ret += tmp;
	}
	assert(ret == len);
	return ret;
}

int ConnMgmt::Recv(DCS_Socket clifd, DCS_Request* pRequest)
{
	int msgLen = 0;
	int ret=0;
	unsigned char* serializedReq = NULL; // = new unsigned char[MAX_COMM_LEN];
	//int serializedLen = 0;

#ifdef WIN32
	int tlen1 = sizeof(pRequest->header) - sizeof(char*);

	if ((ret = RECV(clifd, ( char*)&(pRequest->header), tlen1,0)) <=0)
	{
		if (ret == 0)
		{
			DebugString("recv request closed");
			ret = DCS_CONNECTION_ABORT;
		}
		else
		{
			DebugString("recv request header 1 for length %d err", tlen1);
			ret = DCS_FAIL_OPERATION;
		}
		//	Disconnect(clifd);
		return ret;
	}
	int tlen2 = pRequest->header.userIdLen;

	if (pRequest->header.userIdLen < 0 || pRequest->header.userIdLen > MAX_COMM_LEN)
	{
		DebugString("recv request len err");
		ret = DCS_FAIL_OPERATION;
		return ret;
	}

	pRequest->header.userID = new char[tlen2];
	memset(pRequest->header.userID, 0, tlen2);
	if (( ret = RECV(clifd, pRequest->header.userID, tlen2,0)) <=0)
	{
		if (ret == 0)
		{
			DebugString("recv request closed");
			ret = DCS_CONNECTION_ABORT;
		}
		else
		{
		DebugString("recv request header 2 for length %d err", tlen2);
		ret = DCS_FAIL_OPERATION;
		}
		//	Disconnect(clifd);
		return ret;
	}
	DebugString("user id is: %s", pRequest->header.userID);
#else
	if (RECV(clifd, ( char*)&(pRequest->header), sizeof(pRequest->header),0) == -1)
	{
		DebugString("recv request header err");
		ret = DCS_FAIL_OPERATION;
		Disconnect(clifd);
		return ret;
	}
#endif
	if (pRequest->header.dataLen < 0 || pRequest->header.dataLen > MAX_COMM_LEN)
	{
		DebugString("recv request len err");
		ret = DCS_FAIL_OPERATION;
		return ret;
	}

	int len = (pRequest->header.dataLen+7)/8*8;

	serializedReq = (unsigned char*)alloca(len);

	if (!serializedReq)
	{
		DebugString("serialize alloca failed");
		ret = DCS_FAIL_OPERATION;
		return ret;
	}
	if ((ret = RECV(clifd, (char*)serializedReq, len ,0)) <= 0)
	{
		if (ret == 0)
		{
			DebugString("recv request closed");
			ret = DCS_CONNECTION_ABORT;
		}
		else
		{
			DebugString("recv request failed");
			ret = DCS_FAIL_OPERATION;
		}
		//	Disconnect(clifd);
		return ret;
	}

	Crypto crypto(pRequest->header.userID);

	int decryptedLen = len;
	ret = crypto.DecryptMessage(serializedReq, pRequest->header.dataLen, serializedReq, &decryptedLen);
	if (ret <0)
	{
		DebugString("crypto.DecryptMessage failed");
		return DCS_FAIL_OPERATION;
	}
	msgLen = pRequest->header.dataLen;

	if (pRequest->header.msgType == DCS_EVENT_REQUEST  || pRequest->header.msgType == DCS_UNREGISTER_EVENT_REQUEST)
	{
		memcpy(&(pRequest->request.evt), serializedReq, sizeof(Event_Request));
	}
	else
	{
		int len1 = sizeof(Func_Request) - sizeof(PVOID);
		memcpy(&(pRequest->request.func), serializedReq, len1);
		int len2 = pRequest->request.func.paramLen;
		if (len2 < 0 || len2 > MAX_COMM_LEN)
		{
			DebugString("recv request len err");
			ret = DCS_FAIL_OPERATION;
			return ret;
		}

		pRequest->request.func.params = new char[len2];
		memcpy(pRequest->request.func.params, serializedReq + len1, len2);
	}

	ret = DCS_SUCCESS;
	return ret;

}

int ConnMgmt::Send( DCS_Request* pRequest)
{
	int ret = 0;
	//static int msgID = 0;
	if (pRequest == NULL) return DCS_FAIL_OPERATION;

	unsigned char* serializedReq=NULL;// = new unsigned char[MAX_COMM_LEN];
	int serializedLen = 0;

	Crypto crypto(pRequest->header.userID);

	int encryptedLen = 0;//MAX_COMM_LEN;
	if (pRequest->header.msgType == DCS_EVENT_REQUEST || pRequest->header.msgType == DCS_UNREGISTER_EVENT_REQUEST)
	{
		serializedLen = sizeof(Event_Request);
		encryptedLen = (serializedLen+7)/8*8;
		serializedReq = (unsigned char*)alloca(encryptedLen);
		if (serializedReq != NULL)
		{
			memset(serializedReq, 0, encryptedLen);
			memcpy(serializedReq, &(pRequest->request.evt), serializedLen);
		}

	}
	else
	{
		int len1 = sizeof(Func_Request) - sizeof(PVOID);
		int len2 = pRequest->request.func.paramLen;
		if (len2 < 0 || len2 > MAX_COMM_LEN)
		{
			DebugString("send request len err");
			ret = DCS_FAIL_OPERATION;
			return ret;
		}
		serializedLen = len1 + len2;
		encryptedLen = (serializedLen+7)/8*8;
		serializedReq = (unsigned char*)alloca(encryptedLen);
		memset(serializedReq, 0, encryptedLen);
		memcpy(serializedReq, &(pRequest->request.func), len1);
		memcpy(serializedReq + len1, pRequest->request.func.params, len2);
	}

	ret = crypto.EncryptMessage(serializedReq, serializedLen, serializedReq, &encryptedLen);

	if (ret <0)
	{
		DebugString("crypto.EncryptMessage failed");
		return DCS_FAIL_OPERATION;
	}

	pRequest->header.dataLen = serializedLen;
	//int len = (encryptedLen+7)/8*8;
#ifdef WIN32
	int tlen1 = sizeof(pRequest->header) - sizeof(char*);
	int tlen2 = pRequest->header.userIdLen;

	if (SEND(fd, (char*)&(pRequest->header), tlen1,0) == -1)
	{
		DebugString("send request header failed");

		ret = DCS_FAIL_OPERATION;
		goto DCS_API_Send_Return;
	}
	if (SEND(fd, (char*)(pRequest->header.userID), tlen2,0) == -1)
	{
		DebugString("send request header failed");

		ret = DCS_FAIL_OPERATION;
		goto DCS_API_Send_Return;
	}

#else
	if (SEND(fd, (char*)&(pRequest->header), sizeof(pRequest->header),0) == -1)
	{
		DebugString("send DCS_Request  err");
		ret = DCS_FAIL_OPERATION;
		goto DCS_API_Send_Return;
	}

#endif
	if (SEND(fd, (char*)serializedReq,encryptedLen ,0) == -1)
	{
		DebugString("send DCS_Request  err");
		ret = DCS_FAIL_OPERATION;
	}

DCS_API_Send_Return:
	//dcsClose(fd);
	return ret;

}

int ConnMgmt::dcsClose(DCS_Socket fd)
{
	shutdown(fd, 2);
    closesocket(fd);
	return 0;
}
int ConnMgmt::Recv(DCS_Response* pResponse)
{
	int ret=0;

	if ((ret = RECV(fd, (char*)pResponse, sizeof(DCS_Response) - sizeof(char*),0)) <= 0)
	{
		if (ret == 0)
		{
			DebugString("recv DCS_Response closed");
			ret = DCS_CONNECTION_ABORT;
		}
		else
		{
			DebugString("recv DCS_Response  err");
			ret = DCS_FAIL_OPERATION;
		}
		//	dcsClose(fd);
		return ret;
	}
	if (pResponse->dataLen < 0 || pResponse->dataLen > MAX_COMM_LEN)
	{
		DebugString("recv DCS_Response len err");
		ret = DCS_FAIL_OPERATION;
		return ret;
	}
	if (pResponse->dataLen > 0)
	{
		pResponse->data = (char*)new char[pResponse->dataLen];
		if ((ret=RECV(fd,  pResponse->data, pResponse->dataLen ,0)) <=0 )
		{
			if (ret == 0)
			{
				DebugString("recv DCS_Response closed");
				ret = DCS_CONNECTION_ABORT;
			}
			else
			{
				DebugString("recv DCS_Response  err");
				ret = DCS_FAIL_OPERATION;
			}
			return ret;
		}
		if (pResponse->moduleID<=0 || pResponse->moduleID >= MAX_MODULE_NUM) {ret = DCS_FAIL_OPERATION;return ret;}
	}
	return 0;

}
#ifdef DCS_SERVER
int ConnMgmt::SendToAll(DCS_Response* pResponse)
{
	DebugString("SendToAll entering");
	if (pResponse==NULL) return -1;
	SupplierManager* pSupplierManager = SupplierManager::Instance();

	DebugString("SendToAll SupplierManager::Instance");
	std::set<DCS_Socket>::iterator i;
	int ret=0;

     std: set<DCS_Socket> clifds;
	{
        LockHelper helper(m_clifdsLock);
        clifds = m_clifds;
    }
	DebugString("SendToAll copied after clifds");

	for   (i=clifds.begin();i!=clifds.end();i++)   
	{
   //     {LockHelper helper(m_clifdsLock);
//	for   (i=m_clifds.begin();i!=m_clifds.end();i++)
	//{
//#ifdef _WIN32
		if ((pSupplierManager->CheckEvent(*i, pResponse->moduleID, pResponse->opID)))
//#endif
		{
		//	Lock();
				DebugString("SendToAll Send begin");

			ret = Send(*i,pResponse);
			DebugString("Send(clifd, pResponse) return %d", ret);
		//	Unlock();
			//	return;
		}
		else
			DebugString("check event fail: moduleID: %d, eventID: %d, happened",pResponse->moduleID, pResponse->opID);

	}
	//}
	return 0;
}
#else
int ConnMgmt::SendToAll(DCS_Response* )
{
	return 0;
}
#endif

int ConnMgmt::Send(DCS_Socket clifd, DCS_Response* pResponse)
{
	if (pResponse == NULL) return -1;

	int ret = 0;
	//unsigned char* req=NULL;// = new unsigned char[MAX_COMM_LEN];
	int len1 = sizeof(DCS_Response) - sizeof(char*);
	int len2 = pResponse->dataLen;
	//int len = len1 + len2;

	if (len2 < 0 || len2 > MAX_COMM_LEN)
	{
		DebugString("send DCS_Response len err");
		ret = DCS_FAIL_OPERATION;
		//		Disconnect(clifd);
		return ret;
	}


	if (SEND(clifd, (char*)pResponse,len1 ,0) == -1)
	{
#ifdef LINUX
		DebugString("%d %s\n", errno, strerror(errno));
		if (errno == 32) Disconnect(clifd);
#endif
		DebugString("send DCS_Response  err");
		ret = DCS_FAIL_OPERATION;
		//	Disconnect(clifd);
		return ret;
	}

	if (len2 > 0 && pResponse->data != NULL)
{
	if (SEND(clifd, pResponse->data,len2 ,0) == -1)
	{
#ifdef LINUX
			DebugString("%d %s\n", errno, strerror(errno));
			if (errno ==32) Disconnect(clifd);
#endif
			DebugString("send DCS_Response  err");
			ret = DCS_FAIL_OPERATION;
		}
}
		return ret;

}
