#!/bin/sh
#
# Device Control Service uninstall script
# Copyright (C) 2008  Intel Corporation
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License, version 2, as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#

err=0

echo "Check user privilege..."
user=`whoami`
if [ "$user" != "root" ] ; then
	echo "You must have root privilege for uninstallation"
	exit 1
fi

echo "Stop Device Control Service..."
echo "Kill TSController"
killall -s KILL tscontroller

echo "Kill Fn Key Monitor"
killall -s KILL FnKeyMon

echo "Kill Device Control Service"
killall -s KILL dcs

echo "Stop Device Control finished successfully"
echo ""

echo "Uninstall auto start script..."

xinit_file=/etc/xdg/autostart/tscontroller.desktop
echo "Delete X-Window auto start script in $xinit_file"
if [ -f $xinit_file ] ; then
	rm -rf $xinit_file
	if [ $? -ne 0 ] ; then
		echo "Can't delete X-Window auto start script!"
		err=1
	fi
fi

echo "Delete symbol link for auto start script in /etc/rc2.d/S199dcs"
if [ -f /etc/rc2.d/S199dcs ] ; then
	rm -rf /etc/rc2.d/S199dcs
	if [ $? -ne 0 ] ; then
		echo "Can't delete symbol link!"
		err=1
	fi
fi

init_file=/etc/init.d/dcs
echo "Delete auto start script in $init_file"
if [ -f $init_file ] ; then
	rm -rf $init_file
	if [ $? -ne 0 ] ; then
		echo "Can't delete auto start script!"
		err=1
	fi
fi

tscontroller_xinit=/etc/xdg/autostart/tscontroller.desktop
echo "Delete X-Windows auto start scripts in $tscontroller_xinit"
if [ -f $tscontroller_xinit ] ; then
	rm -rf $tscontroller_xinit
	if [ $? -ne 0 ] ; then
		echo "Can't delete X-Window uto start script!"
		err=1
	fi
fi

FnKeyMon_xinit=/etc/xdg/autostart/FnKeyMon.desktop
echo "Delete X-Windows auto start scripts in $FnKeyMon_xinit"
if [ -f $FnKeyMon_xinit ] ; then
	rm -rf $FnKeyMon_xinit
	if [ $? -ne 0 ] ; then
		echo "Can't delete X-Window uto start script!"
		err=1
	fi
fi

echo "Uninstall auto start script finished successfully"
echo ""

echo "Uninstall Device Control Service..."
echo "Delete libDcsSdk.so in /usr/lib"
if [ -f /usr/lib/libDcsSdk.so ] ; then
	rm -rf /usr/lib/libDcsSdk.so
	if [ $? -ne 0 ] ; then
		echo "Can't delete libDcsSdk.so!"
		err=1
	fi
fi

echo "Delete accel_plugin.so in /usr/lib/dcs"
if [ -f /usr/lib/dcs/accel_plugin.so ] ; then
	rm -rf /usr/lib/dcs/accel_plugin.so
	if [ $? -ne 0 ] ; then
		echo "Can't delete accel_plugin.so!"
		err=1
	fi
fi

echo "Delete tablet_plugin.so in /usr/lib/dcs"
if [ -f /usr/lib/dcs/tablet_plugin.so ] ; then
	rm -rf /usr/lib/dcs/tablet_plugin.so
	if [ $? -ne 0 ] ; then
		echo "Can't delete tablet_plugin.so!"
		err=1
	fi
fi

echo "Delete VKD_plugin.so in /usr/lib/dcs"
if [ -f /usr/lib/dcs/VKD_plugin.so ] ; then
	rm -rf /usr/lib/dcs/VKD_plugin.so
	if [ $? -ne 0 ] ; then
		echo "Can't delete VKD_plugin.so!"
		err=1
	fi
fi

echo "Delete DCS folder of /etc/dcs"
if [ -d /etc/dcs ] ; then
	rm -rf /etc/dcs
	if [ $? -ne 0 ] ; then
		echo "Can't delete /etc/dcs!"
		err=1
	fi
fi

echo "Delete DCS folder of /usr/bin/dcs"
if [ -d /usr/bin/dcs ] ; then
	rm -rf /usr/bin/dcs
	if [ $? -ne 0 ] ; then
		echo "Can't delete /usr/bin/dcs!"
		err=1
	fi
fi

echo "Uninstall drivers..."
echo "Unload driver modules"
modprobe -r accel
if [ $? -ne 0 ] ; then
	echo "Can't unload accelerometer driver!"
	err=1
fi

modprobe -r tablet
if [ $? -ne 0 ] ; then
	echo "Can't unload tablet sensor driver!"
	err=1
fi

modprobe -r cmpc_vkd
if [ $? -ne 0 ] ; then
	echo "Can't unload virtual keyboard driver!"
	err=1
fi

echo "Delete driver modules"
mod_dir=/lib/modules/`uname -r`
drv_dir=$mod_dir/kernel/drivers/misc
if [ -f $drv_dir/accel.ko ] ; then
	rm -rf $drv_dir/accel.ko
	if [ $? -ne 0 ] ; then
		echo "Can't delete accelerometer driver!"
		err=1
	fi
fi

if [ -f $drv_dir/tablet.ko ] ; then
	rm -rf $drv_dir/tablet.ko
	if [ $? -ne 0 ] ; then
		echo "Can't delete tablet driver!"
		err=1
	fi
fi

if [ -f $drv_dir/cmpc_vkd.ko ] ; then
	rm -rf $drv_dir/cmpc_vkd.ko
	if [ $? -ne 0 ] ; then
		echo "Can't delete Fn Key driver!"
		err=1
	fi
fi

echo "Remove driver modules from $mod_dir/modules.dep"
unamer=`uname -r`
sed -i "/\/lib\/modules\/$unamer\/kernel\/drivers\/misc\/accel.ko/d" $mod_dir/modules.dep
sed -i "/\/lib\/modules\/$unamer\/kernel\/drivers\/misc\/cmpc_vkd.ko/d" $mod_dir/modules.dep
sed -i "/\/lib\/modules\/$unamer\/kernel\/drivers\/misc\/tablet.ko/d" $mod_dir/modules.dep

echo "Uninstall drivers finished successfully"
echo ""

case $err in
0)
	echo "Uninstall finished successfully"
	;;
1)
	echo "Uninstall finished but there are some files can't be deleted"
	;;
*)
	echo "Uninstall finished but there are unknown error"
	;;
esac
