/*
 * Copyright (C) 2008 Dell Inc.
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _HAVE_LAUNCHER_MENU_CATEGORY_H
#define _HAVE_LAUNCHER_MENU_CATEGORY_H

#include <glib.h>
#include <gtk/gtk.h>

#include <gmenu-tree.h>

#include <libwnck/window.h>

typedef struct
{
  GList *applications;
  GdkPixbuf *pixbuf;

  gchar *name;
  gchar *comment;
  gchar *icon;
  gchar *id;
  gchar *path;

  gboolean is_new;

} LauncherMenuCategory;

const gchar * launcher_menu_category_get_name         (LauncherMenuCategory *category);

const gchar * launcher_menu_category_get_comment      (LauncherMenuCategory *category);

GdkPixbuf   * launcher_menu_category_get_icon         (LauncherMenuCategory *category);

const gchar * launcher_menu_category_get_icon_name    (LauncherMenuCategory *category);

GList       * launcher_menu_category_get_applications (LauncherMenuCategory *category);

GdkPixbuf   * launcher_menu_category_get_pixbuf       (LauncherMenuCategory *category, 
                                                       guint size);

#endif /* _HAVE_LAUNCHER_MENU_CATEGORY_H */
