/*
 * Copyright (C) 2008 Dell Inc.
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _LAUNCHER_ICON_H_
#define _LAUNCHER_ICON_H_

#include <glib-object.h>
#include <clutter/clutter.h>

#include "launcher-menu.h"


#define LAUNCHER_TYPE_ICON (launcher_icon_get_type ())

#define LAUNCHER_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	LAUNCHER_TYPE_ICON, LauncherIcon))

#define LAUNCHER_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	LAUNCHER_TYPE_ICON, LauncherIconClass))

#define LAUNCHER_IS_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	LAUNCHER_TYPE_ICON))

#define LAUNCHER_IS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	LAUNCHER_TYPE_ICON))

#define LAUNCHER_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	LAUNCHER_TYPE_ICON, LauncherIconClass))

typedef struct _LauncherIcon        LauncherIcon;
typedef struct _LauncherIconClass   LauncherIconClass;
typedef struct _LauncherIconPrivate LauncherIconPrivate;
 
struct _LauncherIcon
{
  ClutterGroup        parent;	

  LauncherIconPrivate *priv;
};

struct _LauncherIconClass
{
  ClutterGroupClass   parent_class;

  /*< signals />*/
  void (*flipped) (LauncherIcon *icon);
};

GType launcher_icon_get_type (void) G_GNUC_CONST;

ClutterActor * launcher_icon_new (void);

void                      launcher_icon_set_application (LauncherIcon *icon, 
                                              LauncherMenuApplication *app);

LauncherMenuApplication * launcher_icon_get_application (LauncherIcon *icon);

void                      launcher_icon_set_flipped     (LauncherIcon *icon, 
                                                         gboolean      flipped);

void                      launcher_icon_set_focus       (LauncherIcon *icon, 
                                                         gboolean      isfocus);
void                      launcher_icon_launch          (LauncherIcon *icon);

void                      launcher_icon_set_show_target (LauncherIcon *icon, 
                                                 ClutterCrossingEvent *event,
                                                         gboolean show);

void                      launcher_icon_reset_after_drag (LauncherIcon *icon);

void                      launcher_icon_set_position     (LauncherIcon *icon,
                                                          gint          pos);

#endif /* _LAUNCHER_ICON_H_ */

