/*
 * Copyright (C) 2008 Dell Inc.
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _LAUNCHER_DEFINES_H_
#define _LAUNCHER_DEFINES_H_

#define CSW() (CLUTTER_STAGE_WIDTH ())
#define CSH() (CLUTTER_STAGE_HEIGHT ())

#define CAW(obj) (clutter_actor_get_width(CLUTTER_ACTOR (obj)))
#define CAH(obj) (clutter_actor_get_height(CLUTTER_ACTOR (obj)))

#define PANEL_HEIGHT 24

#define FAVCATNAME "emblem-favorite"

#define XDG_OPEN "gnome-open"

#define CONFIG_DIR          ".config/dell-launcher"
#define DESKTOP_FILE_PATH   CONFIG_DIR "/applications"
#define DIRECTORY_FILE_PATH CONFIG_DIR "/desktop-directories"
#define MENU_FILE_PATH      CONFIG_DIR "/menus"
#define LINK_WATCH_DIR      "/tmp/webfav"

/* OLD */

#define CAT_ICON_SIZE() (cat_height*0.5)

#endif /* _LAUNCHER_DEFINES_H_ */
