/*
 * Copyright (C) 2008 Dell Inc.
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _LAUNCHER_APPLICATION_CHOOSER_H_
#define _LAUNCHER_APPLICATION_CHOOSER_H_

#include <glib-object.h>
#include <gtk/gtk.h>

#include "launcher-menu.h"


#define LAUNCHER_TYPE_APPLICATION_CHOOSER (launcher_application_chooser_get_type ())

#define LAUNCHER_APPLICATION_CHOOSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	LAUNCHER_TYPE_APPLICATION_CHOOSER, LauncherApplicationChooser))

#define LAUNCHER_APPLICATION_CHOOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	LAUNCHER_TYPE_APPLICATION_CHOOSER, LauncherApplicationChooserClass))

#define LAUNCHER_IS_APPLICATION_CHOOSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	LAUNCHER_TYPE_APPLICATION_CHOOSER))

#define LAUNCHER_IS_APPLICATION_CHOOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	LAUNCHER_TYPE_APPLICATION_CHOOSER))

#define LAUNCHER_APPLICATION_CHOOSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	LAUNCHER_TYPE_APPLICATION_CHOOSER, LauncherApplicationChooserClass))

typedef struct _LauncherApplicationChooser        LauncherApplicationChooser;
typedef struct _LauncherApplicationChooserClass   LauncherApplicationChooserClass;
typedef struct _LauncherApplicationChooserPrivate LauncherApplicationChooserPrivate;
 
struct _LauncherApplicationChooser
{
  GtkDialog        parent;	

  LauncherApplicationChooserPrivate *priv;
};

struct _LauncherApplicationChooserClass
{
  GtkDialogClass   parent_class;
};

GType       launcher_application_chooser_get_type (void) G_GNUC_CONST;

GtkWidget * launcher_application_chooser_new      ();

gboolean    launcher_application_chooser_get_selected 
                                          (LauncherApplicationChooser  *chooser,
                                           gchar                      **name,
                                           gchar                      **exec,
                                           gchar                      **icon);
                                    

#endif /* _LAUNCHER_APPLICATION_CHOOSER_H_ */

