/*
 * Copyright (C) 2008 Dell Inc.
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _LAUNCHER_ADD_H_
#define _LAUNCHER_ADD_H_

#include <glib-object.h>
#include <clutter/clutter.h>

#include "launcher-menu.h"


#define LAUNCHER_TYPE_ADD (launcher_add_get_type ())

#define LAUNCHER_ADD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	LAUNCHER_TYPE_ADD, LauncherAdd))

#define LAUNCHER_ADD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	LAUNCHER_TYPE_ADD, LauncherAddClass))

#define LAUNCHER_IS_ADD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	LAUNCHER_TYPE_ADD))

#define LAUNCHER_IS_ADD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	LAUNCHER_TYPE_ADD))

#define LAUNCHER_ADD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	LAUNCHER_TYPE_ADD, LauncherAddClass))

typedef struct _LauncherAdd        LauncherAdd;
typedef struct _LauncherAddClass   LauncherAddClass;
typedef struct _LauncherAddPrivate LauncherAddPrivate;
 
struct _LauncherAdd
{
  ClutterTexture        parent;	

  LauncherAddPrivate *priv;
};

struct _LauncherAddClass
{
  ClutterTextureClass   parent_class;

  void (*clicked) (LauncherAdd *add);
};

GType launcher_add_get_type (void) G_GNUC_CONST;

ClutterActor * launcher_add_new (void);
void launcher_set_enabled (LauncherAdd *add, gboolean enabled);


#endif /* _LAUNCHER_ADD_H_ */

