/* BackendS3.c generated by valac, the Vala compiler
 * generated from BackendS3.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    Déjà Dup
    © 2008,2009 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gconf/gconf-client.h>
#include <glib/gi18n-lib.h>
#include <gnome-keyring.h>
#include <libgnomeui/libgnomeui.h>


#define DEJA_DUP_TYPE_BACKEND (deja_dup_backend_get_type ())
#define DEJA_DUP_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackend))
#define DEJA_DUP_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))
#define DEJA_DUP_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))

typedef struct _DejaDupBackend DejaDupBackend;
typedef struct _DejaDupBackendClass DejaDupBackendClass;
typedef struct _DejaDupBackendPrivate DejaDupBackendPrivate;

#define DEJA_DUP_OPERATION_TYPE_MODE (deja_dup_operation_mode_get_type ())

#define DEJA_DUP_TYPE_BACKEND_S3 (deja_dup_backend_s3_get_type ())
#define DEJA_DUP_BACKEND_S3(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND_S3, DejaDupBackendS3))
#define DEJA_DUP_BACKEND_S3_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND_S3, DejaDupBackendS3Class))
#define DEJA_DUP_IS_BACKEND_S3(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND_S3))
#define DEJA_DUP_IS_BACKEND_S3_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND_S3))
#define DEJA_DUP_BACKEND_S3_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND_S3, DejaDupBackendS3Class))

typedef struct _DejaDupBackendS3 DejaDupBackendS3;
typedef struct _DejaDupBackendS3Class DejaDupBackendS3Class;
typedef struct _DejaDupBackendS3Private DejaDupBackendS3Private;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_free (var), NULL)))

typedef enum  {
	DEJA_DUP_OPERATION_MODE_INVALID,
	DEJA_DUP_OPERATION_MODE_BACKUP,
	DEJA_DUP_OPERATION_MODE_RESTORE,
	DEJA_DUP_OPERATION_MODE_STATUS
} DejaDupOperationMode;

struct _DejaDupBackend {
	GObject parent_instance;
	DejaDupBackendPrivate * priv;
};

struct _DejaDupBackendClass {
	GObjectClass parent_class;
	char* (*get_location) (DejaDupBackend* self, GError** error);
	char* (*get_location_pretty) (DejaDupBackend* self, GError** error);
	void (*get_envp) (DejaDupBackend* self, GError** error);
	void (*add_argv) (DejaDupBackend* self, DejaDupOperationMode mode, GList** argv);
	void (*ask_password) (DejaDupBackend* self);
	DejaDupBackend* (*clone) (DejaDupBackend* self);
};

struct _DejaDupBackendS3 {
	DejaDupBackend parent_instance;
	DejaDupBackendS3Private * priv;
};

struct _DejaDupBackendS3Class {
	DejaDupBackendClass parent_class;
};

struct _DejaDupBackendS3Private {
	char* gconf_id;
	char* id;
	char* secret_key;
};


static gpointer deja_dup_backend_s3_parent_class = NULL;

#define DEJA_DUP_S3_ID_KEY "/apps/deja-dup/s3/id"
#define DEJA_DUP_S3_BUCKET_KEY "/apps/deja-dup/s3/bucket"
#define DEJA_DUP_S3_FOLDER_KEY "/apps/deja-dup/s3/folder"
#define DEJA_DUP_S3_SERVER "s3.amazonaws.com"
GType deja_dup_backend_get_type (void);
GType deja_dup_operation_mode_get_type (void);
GType deja_dup_backend_s3_get_type (void);
#define DEJA_DUP_BACKEND_S3_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_BACKEND_S3, DejaDupBackendS3Private))
enum  {
	DEJA_DUP_BACKEND_S3_DUMMY_PROPERTY
};
static void deja_dup_backend_set_toplevel (DejaDupBackend* self, GtkWindow* value);
DejaDupBackendS3* deja_dup_backend_s3_new (GtkWindow* win);
DejaDupBackendS3* deja_dup_backend_s3_construct (GType object_type, GtkWindow* win);
GtkWindow* deja_dup_backend_get_toplevel (DejaDupBackend* self);
static DejaDupBackend* deja_dup_backend_s3_real_clone (DejaDupBackend* base);
static void deja_dup_backend_s3_real_add_argv (DejaDupBackend* base, DejaDupOperationMode mode, GList** argv);
static char* deja_dup_backend_s3_get_default_bucket (DejaDupBackendS3* self);
GConfClient* deja_dup_get_gconf_client (void);
static char* deja_dup_backend_s3_real_get_location (DejaDupBackend* base, GError** error);
gboolean deja_dup_backend_s3_bump_bucket (DejaDupBackendS3* self);
static char* deja_dup_backend_s3_real_get_location_pretty (DejaDupBackend* base, GError** error);
static void deja_dup_backend_s3_got_secret_key (DejaDupBackendS3* self);
static void deja_dup_backend_s3_found_password (DejaDupBackendS3* self, GnomeKeyringResult _result_, GList* list);
static void _deja_dup_backend_s3_found_password_gnome_keyring_operation_get_list_callback (GnomeKeyringResult _result_, GList* list, gpointer self);
static void deja_dup_backend_s3_real_get_envp (DejaDupBackend* base, GError** error);
static void deja_dup_backend_s3_save_password_callback (DejaDupBackendS3* self, GnomeKeyringResult _result_, guint32 val);
static void _g_list_free_g_free (GList* self);
static void _deja_dup_backend_s3_save_password_callback_gnome_keyring_operation_get_int_callback (GnomeKeyringResult _result_, guint32 val, gpointer self);
static void deja_dup_backend_s3_real_ask_password (DejaDupBackend* base);
static void deja_dup_backend_s3_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



DejaDupBackendS3* deja_dup_backend_s3_construct (GType object_type, GtkWindow* win) {
	GParameter * __params;
	GParameter * __params_it;
	DejaDupBackendS3 * self;
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "toplevel";
	g_value_init (&__params_it->value, GTK_TYPE_WINDOW);
	g_value_set_object (&__params_it->value, win);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DejaDupBackendS3* deja_dup_backend_s3_new (GtkWindow* win) {
	return deja_dup_backend_s3_construct (DEJA_DUP_TYPE_BACKEND_S3, win);
}


static DejaDupBackend* deja_dup_backend_s3_real_clone (DejaDupBackend* base) {
	DejaDupBackendS3 * self;
	DejaDupBackend* result;
	self = (DejaDupBackendS3*) base;
	result = (DejaDupBackend*) deja_dup_backend_s3_new (deja_dup_backend_get_toplevel ((DejaDupBackend*) self));
	return result;
}


static void deja_dup_backend_s3_real_add_argv (DejaDupBackend* base, DejaDupOperationMode mode, GList** argv) {
	DejaDupBackendS3 * self;
	self = (DejaDupBackendS3*) base;
	if (mode == DEJA_DUP_OPERATION_MODE_INVALID) {
		*argv = g_list_append (*argv, g_strdup ("--s3-use-new-style"));
	}
}


static char* deja_dup_backend_s3_get_default_bucket (DejaDupBackendS3* self) {
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	result = (_tmp1_ = g_strdup_printf ("deja-dup-auto-%s", _tmp0_ = g_utf8_strdown (self->priv->id, -1)), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


static char* deja_dup_backend_s3_real_get_location (DejaDupBackend* base, GError** error) {
	DejaDupBackendS3 * self;
	char* result;
	GError * _inner_error_;
	GConfClient* client;
	char* bucket;
	char* default_bucket;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	char* folder;
	gboolean _tmp4_ = FALSE;
	self = (DejaDupBackendS3*) base;
	_inner_error_ = NULL;
	client = deja_dup_get_gconf_client ();
	bucket = g_strdup (gconf_client_get_string (client, DEJA_DUP_S3_BUCKET_KEY, &_inner_error_));
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (client);
		return NULL;
	}
	default_bucket = deja_dup_backend_s3_get_default_bucket (self);
	if (bucket == NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = _vala_strcmp0 (bucket, "") == 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (g_str_has_prefix (bucket, "deja-dup-auto-")) {
			_tmp2_ = !g_str_has_prefix (bucket, default_bucket);
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		char* _tmp3_;
		bucket = (_tmp3_ = g_strdup (default_bucket), _g_free0 (bucket), _tmp3_);
		gconf_client_set_string (client, DEJA_DUP_S3_BUCKET_KEY, bucket, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (client);
			_g_free0 (bucket);
			_g_free0 (default_bucket);
			return NULL;
		}
	}
	folder = g_strdup (gconf_client_get_string (client, DEJA_DUP_S3_FOLDER_KEY, &_inner_error_));
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (client);
		_g_free0 (bucket);
		_g_free0 (default_bucket);
		return NULL;
	}
	if (folder != NULL) {
		_tmp4_ = _vala_strcmp0 (folder, "") != 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		if (g_utf8_get_char (g_utf8_offset_to_pointer (folder, 0)) != '/') {
			char* _tmp5_;
			bucket = (_tmp5_ = g_strdup_printf ("%s/%s", bucket, folder), _g_free0 (bucket), _tmp5_);
		} else {
			char* _tmp6_;
			bucket = (_tmp6_ = g_strdup_printf ("%s%s", bucket, folder), _g_free0 (bucket), _tmp6_);
		}
	}
	result = g_strdup_printf ("s3+http://%s", bucket);
	_g_object_unref0 (client);
	_g_free0 (bucket);
	_g_free0 (default_bucket);
	_g_free0 (folder);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gboolean deja_dup_backend_s3_bump_bucket (DejaDupBackendS3* self) {
	gboolean result;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	{
		GConfClient* client;
		char* bucket;
		char** _tmp2_;
		gint bits_size;
		gint bits_length1;
		char** _tmp1_;
		char** bits;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		client = _g_object_ref0 (gconf_client_get_default ());
		bucket = g_strdup (gconf_client_get_string (client, DEJA_DUP_S3_BUCKET_KEY, &_inner_error_));
		if (_inner_error_ != NULL) {
			_g_object_unref0 (client);
			goto __catch5_g_error;
			goto __finally5;
		}
		if (_vala_strcmp0 (bucket, "deja-dup") == 0) {
			char* _tmp0_;
			bucket = (_tmp0_ = deja_dup_backend_s3_get_default_bucket (self), _g_free0 (bucket), _tmp0_);
			gconf_client_set_string (client, DEJA_DUP_S3_BUCKET_KEY, bucket, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (client);
				_g_free0 (bucket);
				goto __catch5_g_error;
				goto __finally5;
			}
			result = TRUE;
			_g_object_unref0 (client);
			_g_free0 (bucket);
			return result;
		}
		if (!g_str_has_prefix (bucket, "deja-dup-auto-")) {
			result = FALSE;
			_g_object_unref0 (client);
			_g_free0 (bucket);
			return result;
		}
		bits = (_tmp2_ = _tmp1_ = g_strsplit (bucket, "-", 0), bits_length1 = _vala_array_length (_tmp1_), bits_size = bits_length1, _tmp2_);
		if (bits == NULL) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = bits[0] == NULL;
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = bits[1] == NULL;
		}
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = bits[2] == NULL;
		}
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = bits[3] == NULL;
		}
		if (_tmp3_) {
			result = FALSE;
			_g_object_unref0 (client);
			_g_free0 (bucket);
			bits = (_vala_array_free (bits, bits_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		if (bits[4] == NULL) {
			char* _tmp7_;
			bucket = (_tmp7_ = g_strconcat (bucket, "-2", NULL), _g_free0 (bucket), _tmp7_);
		} else {
			glong num;
			char* _tmp8_;
			char* _tmp9_;
			num = atol (bits[4]);
			bits[4] = (_tmp8_ = g_strdup_printf ("%li", num + 1), _g_free0 (bits[4]), _tmp8_);
			bucket = (_tmp9_ = g_strjoinv ("-", bits), _g_free0 (bucket), _tmp9_);
		}
		gconf_client_set_string (client, DEJA_DUP_S3_BUCKET_KEY, bucket, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (client);
			_g_free0 (bucket);
			bits = (_vala_array_free (bits, bits_length1, (GDestroyNotify) g_free), NULL);
			goto __catch5_g_error;
			goto __finally5;
		}
		result = TRUE;
		_g_object_unref0 (client);
		_g_free0 (bucket);
		bits = (_vala_array_free (bits, bits_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			result = FALSE;
			_g_error_free0 (e);
			return result;
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
}


static char* deja_dup_backend_s3_real_get_location_pretty (DejaDupBackend* base, GError** error) {
	DejaDupBackendS3 * self;
	char* result;
	GError * _inner_error_;
	GConfClient* client;
	char* folder;
	gboolean _tmp0_ = FALSE;
	self = (DejaDupBackendS3*) base;
	_inner_error_ = NULL;
	client = deja_dup_get_gconf_client ();
	folder = g_strdup (gconf_client_get_string (client, DEJA_DUP_S3_FOLDER_KEY, &_inner_error_));
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (client);
		return NULL;
	}
	if (folder == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _vala_strcmp0 (folder, "") == 0;
	}
	if (_tmp0_) {
		char* _tmp1_;
		folder = (_tmp1_ = g_strdup ("/"), _g_free0 (folder), _tmp1_);
	}
	result = g_strdup_printf (_ ("Folder %s on Amazon S3"), folder);
	_g_object_unref0 (client);
	_g_free0 (folder);
	return result;
}


static void _deja_dup_backend_s3_found_password_gnome_keyring_operation_get_list_callback (GnomeKeyringResult _result_, GList* list, gpointer self) {
	deja_dup_backend_s3_found_password (self, _result_, list);
}


static void deja_dup_backend_s3_real_get_envp (DejaDupBackend* base, GError** error) {
	DejaDupBackendS3 * self;
	GError * _inner_error_;
	GConfClient* client;
	const char* _tmp0_;
	char* _tmp1_;
	const char* _tmp2_;
	char* _tmp3_;
	gboolean _tmp4_ = FALSE;
	self = (DejaDupBackendS3*) base;
	_inner_error_ = NULL;
	client = deja_dup_get_gconf_client ();
	_tmp0_ = gconf_client_get_string (client, DEJA_DUP_S3_ID_KEY, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (client);
		return;
	}
	self->priv->gconf_id = (_tmp1_ = g_strdup (_tmp0_), _g_free0 (self->priv->gconf_id), _tmp1_);
	_tmp2_ = NULL;
	if (self->priv->gconf_id == NULL) {
		_tmp2_ = "";
	} else {
		_tmp2_ = self->priv->gconf_id;
	}
	self->priv->id = (_tmp3_ = g_strdup (_tmp2_), _g_free0 (self->priv->id), _tmp3_);
	if (_vala_strcmp0 (self->priv->id, "") != 0) {
		_tmp4_ = self->priv->secret_key != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		deja_dup_backend_s3_got_secret_key (self);
		_g_object_unref0 (client);
		return;
	}
	if (_vala_strcmp0 (self->priv->id, "") != 0) {
		char* _tmp5_;
		self->priv->secret_key = (_tmp5_ = NULL, _g_free0 (self->priv->secret_key), _tmp5_);
		gnome_keyring_find_network_password (self->priv->id, NULL, DEJA_DUP_S3_SERVER, NULL, "https", NULL, (guint32) 0, _deja_dup_backend_s3_found_password_gnome_keyring_operation_get_list_callback, g_object_ref (self), g_object_unref);
	} else {
		g_signal_emit_by_name ((DejaDupBackend*) self, "need-password");
	}
	_g_object_unref0 (client);
}


static void deja_dup_backend_s3_found_password (DejaDupBackendS3* self, GnomeKeyringResult _result_, GList* list) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (_result_ == GNOME_KEYRING_RESULT_OK) {
		_tmp0_ = list != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		char* _tmp1_;
		self->priv->secret_key = (_tmp1_ = g_strdup (((GnomeKeyringNetworkPasswordData*) list->data)->password), _g_free0 (self->priv->secret_key), _tmp1_);
		deja_dup_backend_s3_got_secret_key (self);
	} else {
		g_signal_emit_by_name ((DejaDupBackend*) self, "need-password");
	}
}


static void deja_dup_backend_s3_save_password_callback (DejaDupBackendS3* self, GnomeKeyringResult _result_, guint32 val) {
	g_return_if_fail (self != NULL);
}


static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


static char* string_strip (const char* self) {
	char* result;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static void _deja_dup_backend_s3_save_password_callback_gnome_keyring_operation_get_int_callback (GnomeKeyringResult _result_, guint32 val, gpointer self) {
	deja_dup_backend_s3_save_password_callback (self, _result_, val);
}


static void deja_dup_backend_s3_real_ask_password (DejaDupBackend* base) {
	DejaDupBackendS3 * self;
	GnomePasswordDialog* dlg;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	GnomePasswordDialogRemember remember;
	self = (DejaDupBackendS3*) base;
	dlg = g_object_ref_sink ((GnomePasswordDialog*) gnome_password_dialog_new (_ ("Amazon S3 Password"), _ ("Enter your Amazon Web Services user ID and secret key.  This is not the same as your amazon.com username and password."), self->priv->id, "", FALSE));
	((GtkWindow*) dlg)->transient_parent = deja_dup_backend_get_toplevel ((DejaDupBackend*) self);
	g_object_set (dlg, "show-remember", TRUE, NULL);
	if (!gnome_password_dialog_run_and_block (dlg)) {
		GList* _tmp0_;
		g_signal_emit_by_name ((DejaDupBackend*) self, "envp-ready", FALSE, _tmp0_ = NULL, NULL);
		__g_list_free_g_free0 (_tmp0_);
		_g_object_unref0 (dlg);
		return;
	}
	self->priv->id = (_tmp1_ = g_strdup (gnome_password_dialog_get_username (dlg)), _g_free0 (self->priv->id), _tmp1_);
	self->priv->secret_key = (_tmp2_ = g_strdup (gnome_password_dialog_get_password (dlg)), _g_free0 (self->priv->secret_key), _tmp2_);
	self->priv->secret_key = (_tmp3_ = string_strip (self->priv->secret_key), _g_free0 (self->priv->secret_key), _tmp3_);
	remember = gnome_password_dialog_get_remember (dlg);
	if (remember != GNOME_PASSWORD_DIALOG_REMEMBER_NOTHING) {
		const char* _tmp4_;
		char* where;
		_tmp4_ = NULL;
		if (remember == GNOME_PASSWORD_DIALOG_REMEMBER_SESSION) {
			_tmp4_ = "session";
		} else {
			_tmp4_ = GNOME_KEYRING_DEFAULT;
		}
		where = g_strdup (_tmp4_);
		gnome_keyring_set_network_password (where, self->priv->id, NULL, DEJA_DUP_S3_SERVER, NULL, "https", NULL, (guint32) 0, self->priv->secret_key, _deja_dup_backend_s3_save_password_callback_gnome_keyring_operation_get_int_callback, g_object_ref (self), g_object_unref);
		_g_free0 (where);
	}
	deja_dup_backend_s3_got_secret_key (self);
	_g_object_unref0 (dlg);
}


static void deja_dup_backend_s3_got_secret_key (DejaDupBackendS3* self) {
	GError * _inner_error_;
	GConfClient* client;
	GList* envp;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	client = deja_dup_get_gconf_client ();
	if (_vala_strcmp0 (self->priv->id, self->priv->gconf_id) != 0) {
		{
			gconf_client_set_string (client, DEJA_DUP_S3_ID_KEY, self->priv->id, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch6_g_error;
				goto __finally6;
			}
		}
		goto __finally6;
		__catch6_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("BackendS3.vala:200: %s\n", e->message);
				_g_error_free0 (e);
			}
		}
		__finally6:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (client);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	envp = NULL;
	envp = g_list_append (envp, g_strdup_printf ("AWS_ACCESS_KEY_ID=%s", self->priv->id));
	envp = g_list_append (envp, g_strdup_printf ("AWS_SECRET_ACCESS_KEY=%s", self->priv->secret_key));
	g_signal_emit_by_name ((DejaDupBackend*) self, "envp-ready", TRUE, envp, NULL);
	_g_object_unref0 (client);
	__g_list_free_g_free0 (envp);
}


static void deja_dup_backend_s3_class_init (DejaDupBackendS3Class * klass) {
	deja_dup_backend_s3_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupBackendS3Private));
	DEJA_DUP_BACKEND_CLASS (klass)->clone = deja_dup_backend_s3_real_clone;
	DEJA_DUP_BACKEND_CLASS (klass)->add_argv = deja_dup_backend_s3_real_add_argv;
	DEJA_DUP_BACKEND_CLASS (klass)->get_location = deja_dup_backend_s3_real_get_location;
	DEJA_DUP_BACKEND_CLASS (klass)->get_location_pretty = deja_dup_backend_s3_real_get_location_pretty;
	DEJA_DUP_BACKEND_CLASS (klass)->get_envp = deja_dup_backend_s3_real_get_envp;
	DEJA_DUP_BACKEND_CLASS (klass)->ask_password = deja_dup_backend_s3_real_ask_password;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_backend_s3_finalize;
}


static void deja_dup_backend_s3_instance_init (DejaDupBackendS3 * self) {
	self->priv = DEJA_DUP_BACKEND_S3_GET_PRIVATE (self);
}


static void deja_dup_backend_s3_finalize (GObject* obj) {
	DejaDupBackendS3 * self;
	self = DEJA_DUP_BACKEND_S3 (obj);
	_g_free0 (self->priv->gconf_id);
	_g_free0 (self->priv->id);
	_g_free0 (self->priv->secret_key);
	G_OBJECT_CLASS (deja_dup_backend_s3_parent_class)->finalize (obj);
}


GType deja_dup_backend_s3_get_type (void) {
	static GType deja_dup_backend_s3_type_id = 0;
	if (deja_dup_backend_s3_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupBackendS3Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_backend_s3_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupBackendS3), 0, (GInstanceInitFunc) deja_dup_backend_s3_instance_init, NULL };
		deja_dup_backend_s3_type_id = g_type_register_static (DEJA_DUP_TYPE_BACKEND, "DejaDupBackendS3", &g_define_type_info, 0);
	}
	return deja_dup_backend_s3_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




