/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <time.h>
#include <glib.h>
#include <glib-object.h>

#include <dbusmodel/dbusmodel.h>

static gboolean
add_ (DbusModel *model)
{
  dbus_model_add (model,
                     0, 10,
                     1, "Rooney",
                     -1);
  return TRUE;
}

static void
on_row_added (DbusModel *self, DbusModelIter *iter)
{
  gint i = 0;
  gchar *s = NULL;

  dbus_model_get (self, iter, 0, &i, 1, &s, -1);

  if (!g_str_equal (s, "Rooney"))
    g_debug ("Mastr: Row Added: %d %s", i, s);

  g_free (s);
}

gint
main (gint argc, gchar *argv[])
{
  GMainLoop *loop;
  DbusModel *model;
  
  g_type_init (); 
  g_thread_init (NULL);

  model = dbus_model_new ("com.canonical.Dbus.Model.Example",
                          2,
                          G_TYPE_INT,
                          G_TYPE_STRING);
  g_assert (DBUS_IS_MODEL (model));

  g_signal_connect (model, "row-added",
                    G_CALLBACK (on_row_added), NULL);

  dbus_peer_connect (DBUS_PEER (model));

  g_timeout_add_seconds (2, (GSourceFunc)add_, model);

  loop = g_main_loop_new (g_main_context_default (), TRUE);
  g_main_loop_run (loop);

  return 0;
}
