/*
 * Copyright 2009 Canonical Ltd.
 * 
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the 
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by 
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the applicable version of the GNU Lesser General Public 
 * License for more details.
 * 
 * You should have received a copy of both the GNU Lesser General Public 
 * License version 3 and version 2.1 along with this program.  If not, see 
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _CTK_ICON_VIEW_H_
#define _CTK_ICON_VIEW_H_

#include <glib.h>
#include <clutter/clutter.h>
#include <ctk/ctk-actor.h>

G_BEGIN_DECLS

#define CTK_TYPE_ICON_VIEW (ctk_icon_view_get_type ())

#define CTK_ICON_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	CTK_TYPE_ICON_VIEW, CtkIconView))

#define CTK_ICON_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	CTK_TYPE_ICON_VIEW, CtkIconViewClass))

#define CTK_IS_ICON_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	CTK_TYPE_ICON_VIEW))

#define CTK_IS_ICON_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	CTK_TYPE_ICON_VIEW))

#define CTK_ICON_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	CTK_TYPE_ICON_VIEW, CtkIconViewClass))

typedef struct _CtkIconView        CtkIconView;
typedef struct _CtkIconViewClass   CtkIconViewClass;
typedef struct _CtkIconViewPrivate CtkIconViewPrivate;
 
struct _CtkIconView
{
  CtkActor        parent;	

  CtkIconViewPrivate *priv;
};

struct _CtkIconViewClass
{
  /*< private >*/
  CtkActorClass   parent_class;

  void (*_view_padding1) (void);
  void (*_view_padding2) (void);
  void (*_view_padding3) (void);
  void (*_view_padding4) (void);
  void (*_view_padding5) (void);
  void (*_view_padding6) (void);
};

GType          ctk_icon_view_get_type    (void) G_GNUC_CONST;

ClutterActor * ctk_icon_view_new         (void);

void           ctk_icon_view_set_spacing (CtkIconView  *icon_view,
                                          gint          spacing);

gint           ctk_icon_view_get_spacing (CtkIconView  *icon_view);

G_END_DECLS

#endif /* _CTK_ICON_VIEW_H_ */

