/*
 * Copyright 2009 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the applicable version of the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of both the GNU Lesser General Public
 * License version 3 and version 2.1 along with this program.  If not, see
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include "ctk-hbox.h"

G_DEFINE_TYPE (CtkHBox, ctk_hbox, CTK_TYPE_BOX);

#define CTK_HBOX_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj),\
  CTK_TYPE_HBOX, \
  CtkHBoxPrivate))

/* GObject stuff */
static void
ctk_hbox_class_init (CtkHBoxClass *klass)
{
}

static void
ctk_hbox_init (CtkHBox *hbox)
{
}

/*
 * Public methods
 */
ClutterActor *
ctk_hbox_new (guint spacing)

{
  ClutterActor *hbox = NULL;

  hbox = g_object_new (CTK_TYPE_HBOX,
                       "spacing", spacing,
                       "homogeneous", FALSE,
                       "orientation", CTK_ORIENTATION_HORIZONTAL,
                       NULL);
  return hbox;
}

