/***************************************************************************
 *     Copyright (c) 1999-2009, Broadcom Corporation
 *
 **********************************************************************
 * This file is part of the crystalhd device driver.
 *
 * This driver is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This driver is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this driver.  If not, see <http://www.gnu.org/licenses/>.
 **********************************************************************
 *
 * $brcm_Workfile: bchp_sun_gisb_arb.h $
 * $brcm_Revision: Hydra_Software_Devel/1 $
 * $brcm_Date: 7/17/09 8:19p $
 *
 * Module Description:
 *                     DO NOT EDIT THIS FILE DIRECTLY
 *
 * This module was generated magically with RDB from a source description
 * file. You must edit the source file for changes to be made to this file.
 *
 *
 * Date:           Generated on         Fri Jul 17 19:42:30 2009
 *                 MD5 Checksum         2914699efc3fb3edefca5cb4f4f38b34
 *
 * Compiled with:  RDB Utility          combo_header.pl
 *                 RDB Parser           3.0
 *                 unknown              unknown
 *                 Perl Interpreter     5.008008
 *                 Operating System     linux
 *
 * Revision History:
 *
 * $brcm_Log: /magnum/basemodules/chp/70015/rdb/a0/bchp_sun_gisb_arb.h $
 * 
 * Hydra_Software_Devel/1   7/17/09 8:19p albertl
 * PR56880: Initial revision.
 *
 ***************************************************************************/

#ifndef BCHP_SUN_GISB_ARB_H__
#define BCHP_SUN_GISB_ARB_H__

/***************************************************************************
 *SUN_GISB_ARB - GISB Arbiter registers
 ***************************************************************************/
#define BCHP_SUN_GISB_ARB_REVISION               0x00400000 /* GISB ARBITER REVISION */
#define BCHP_SUN_GISB_ARB_SCRATCH                0x00400004 /* GISB ARBITER Scratch Register */
#define BCHP_SUN_GISB_ARB_REQ_MASK               0x00400008 /* GISB ARBITER Master Request Mask Register */
#define BCHP_SUN_GISB_ARB_TIMER                  0x0040000c /* GISB ARBITER Timer Value Register */
#define BCHP_SUN_GISB_ARB_BP_CTRL                0x00400010 /* GISB ARBITER Breakpoint Control Register */
#define BCHP_SUN_GISB_ARB_BP_CAP_CLR             0x00400014 /* GISB ARBITER Breakpoint Capture Clear Register */
#define BCHP_SUN_GISB_ARB_BP_START_ADDR_0        0x00400018 /* GISB ARBITER Breakpoint Start Address 0 Register */
#define BCHP_SUN_GISB_ARB_BP_END_ADDR_0          0x0040001c /* GISB ARBITER Breakpoint End Address 0 Register */
#define BCHP_SUN_GISB_ARB_BP_READ_0              0x00400020 /* GISB ARBITER Breakpoint Master Read Control 0 Register */
#define BCHP_SUN_GISB_ARB_BP_WRITE_0             0x00400024 /* GISB ARBITER Breakpoint Master Write Control 0 Register */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_0            0x00400028 /* GISB ARBITER Breakpoint Enable 0 Register */
#define BCHP_SUN_GISB_ARB_BP_START_ADDR_1        0x0040002c /* GISB ARBITER Breakpoint Start Address 1 Register */
#define BCHP_SUN_GISB_ARB_BP_END_ADDR_1          0x00400030 /* GISB ARBITER Breakpoint End Address 1 Register */
#define BCHP_SUN_GISB_ARB_BP_READ_1              0x00400034 /* GISB ARBITER Breakpoint Master Read Control 1 Register */
#define BCHP_SUN_GISB_ARB_BP_WRITE_1             0x00400038 /* GISB ARBITER Breakpoint Master Write Control 1 Register */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_1            0x0040003c /* GISB ARBITER Breakpoint Enable 1 Register */
#define BCHP_SUN_GISB_ARB_BP_START_ADDR_2        0x00400040 /* GISB ARBITER Breakpoint Start Address 2 Register */
#define BCHP_SUN_GISB_ARB_BP_END_ADDR_2          0x00400044 /* GISB ARBITER Breakpoint End Address 2 Register */
#define BCHP_SUN_GISB_ARB_BP_READ_2              0x00400048 /* GISB ARBITER Breakpoint Master Read Control 2 Register */
#define BCHP_SUN_GISB_ARB_BP_WRITE_2             0x0040004c /* GISB ARBITER Breakpoint Master Write Control 2 Register */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_2            0x00400050 /* GISB ARBITER Breakpoint Enable 2 Register */
#define BCHP_SUN_GISB_ARB_BP_START_ADDR_3        0x00400054 /* GISB ARBITER Breakpoint Start Address 3 Register */
#define BCHP_SUN_GISB_ARB_BP_END_ADDR_3          0x00400058 /* GISB ARBITER Breakpoint End Address 3 Register */
#define BCHP_SUN_GISB_ARB_BP_READ_3              0x0040005c /* GISB ARBITER Breakpoint Master Read Control 3 Register */
#define BCHP_SUN_GISB_ARB_BP_WRITE_3             0x00400060 /* GISB ARBITER Breakpoint Master Write Control 3 Register */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_3            0x00400064 /* GISB ARBITER Breakpoint Enable 3 Register */
#define BCHP_SUN_GISB_ARB_BP_START_ADDR_4        0x00400068 /* GISB ARBITER Breakpoint Start Address 4 Register */
#define BCHP_SUN_GISB_ARB_BP_END_ADDR_4          0x0040006c /* GISB ARBITER Breakpoint End Address 4 Register */
#define BCHP_SUN_GISB_ARB_BP_READ_4              0x00400070 /* GISB ARBITER Breakpoint Master Read Control 4 Register */
#define BCHP_SUN_GISB_ARB_BP_WRITE_4             0x00400074 /* GISB ARBITER Breakpoint Master Write Control 4 Register */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_4            0x00400078 /* GISB ARBITER Breakpoint Enable 4 Register */
#define BCHP_SUN_GISB_ARB_BP_START_ADDR_5        0x0040007c /* GISB ARBITER Breakpoint Start Address 5 Register */
#define BCHP_SUN_GISB_ARB_BP_END_ADDR_5          0x00400080 /* GISB ARBITER Breakpoint End Address 5 Register */
#define BCHP_SUN_GISB_ARB_BP_READ_5              0x00400084 /* GISB ARBITER Breakpoint Master Read Control 5 Register */
#define BCHP_SUN_GISB_ARB_BP_WRITE_5             0x00400088 /* GISB ARBITER Breakpoint Master Write Control 5 Register */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_5            0x0040008c /* GISB ARBITER Breakpoint Enable 5 Register */
#define BCHP_SUN_GISB_ARB_BP_START_ADDR_6        0x00400090 /* GISB ARBITER Breakpoint Start Address 6 Register */
#define BCHP_SUN_GISB_ARB_BP_END_ADDR_6          0x00400094 /* GISB ARBITER Breakpoint End Address 6 Register */
#define BCHP_SUN_GISB_ARB_BP_READ_6              0x00400098 /* GISB ARBITER Breakpoint Master Read Control 6 Register */
#define BCHP_SUN_GISB_ARB_BP_WRITE_6             0x0040009c /* GISB ARBITER Breakpoint Master Write Control 6 Register */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_6            0x004000a0 /* GISB ARBITER Breakpoint Enable 6 Register */
#define BCHP_SUN_GISB_ARB_BP_START_ADDR_7        0x004000a4 /* GISB ARBITER Breakpoint Start Address 7 Register */
#define BCHP_SUN_GISB_ARB_BP_END_ADDR_7          0x004000a8 /* GISB ARBITER Breakpoint End Address 7 Register */
#define BCHP_SUN_GISB_ARB_BP_READ_7              0x004000ac /* GISB ARBITER Breakpoint Master Read Control 7 Register */
#define BCHP_SUN_GISB_ARB_BP_WRITE_7             0x004000b0 /* GISB ARBITER Breakpoint Master Write Control 7 Register */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_7            0x004000b4 /* GISB ARBITER Breakpoint Enable 7 Register */
#define BCHP_SUN_GISB_ARB_BP_CAP_ADDR            0x004000b8 /* GISB ARBITER Breakpoint Capture Address Register */
#define BCHP_SUN_GISB_ARB_BP_CAP_DATA            0x004000bc /* GISB ARBITER Breakpoint Capture Data Register */
#define BCHP_SUN_GISB_ARB_BP_CAP_STATUS          0x004000c0 /* GISB ARBITER Breakpoint Capture Status Register */
#define BCHP_SUN_GISB_ARB_BP_CAP_MASTER          0x004000c4 /* GISB ARBITER Breakpoint Capture GISB MASTER Register */
#define BCHP_SUN_GISB_ARB_ERR_CAP_CLR            0x004000c8 /* GISB ARBITER Error Capture Clear Register */
#define BCHP_SUN_GISB_ARB_ERR_CAP_ADDR           0x004000cc /* GISB ARBITER Error Capture Address Register */
#define BCHP_SUN_GISB_ARB_ERR_CAP_DATA           0x004000d0 /* GISB ARBITER Error Capture Data Register */
#define BCHP_SUN_GISB_ARB_ERR_CAP_STATUS         0x004000d4 /* GISB ARBITER Error Capture Status Register */
#define BCHP_SUN_GISB_ARB_ERR_CAP_MASTER         0x004000d8 /* GISB ARBITER Error Capture GISB MASTER Register */

/***************************************************************************
 *REVISION - GISB ARBITER REVISION
 ***************************************************************************/
/* SUN_GISB_ARB :: REVISION :: reserved0 [31:16] */
#define BCHP_SUN_GISB_ARB_REVISION_reserved0_MASK                  0xffff0000
#define BCHP_SUN_GISB_ARB_REVISION_reserved0_SHIFT                 16

/* SUN_GISB_ARB :: REVISION :: MAJOR [15:08] */
#define BCHP_SUN_GISB_ARB_REVISION_MAJOR_MASK                      0x0000ff00
#define BCHP_SUN_GISB_ARB_REVISION_MAJOR_SHIFT                     8

/* SUN_GISB_ARB :: REVISION :: MINOR [07:00] */
#define BCHP_SUN_GISB_ARB_REVISION_MINOR_MASK                      0x000000ff
#define BCHP_SUN_GISB_ARB_REVISION_MINOR_SHIFT                     0

/***************************************************************************
 *SCRATCH - GISB ARBITER Scratch Register
 ***************************************************************************/
/* SUN_GISB_ARB :: SCRATCH :: scratch_bit [31:00] */
#define BCHP_SUN_GISB_ARB_SCRATCH_scratch_bit_MASK                 0xffffffff
#define BCHP_SUN_GISB_ARB_SCRATCH_scratch_bit_SHIFT                0

/***************************************************************************
 *REQ_MASK - GISB ARBITER Master Request Mask Register
 ***************************************************************************/
/* SUN_GISB_ARB :: REQ_MASK :: reserved0 [31:12] */
#define BCHP_SUN_GISB_ARB_REQ_MASK_reserved0_MASK                  0xfffff000
#define BCHP_SUN_GISB_ARB_REQ_MASK_reserved0_SHIFT                 12

/* SUN_GISB_ARB :: REQ_MASK :: trb [11:11] */
#define BCHP_SUN_GISB_ARB_REQ_MASK_trb_MASK                        0x00000800
#define BCHP_SUN_GISB_ARB_REQ_MASK_trb_SHIFT                       11
#define BCHP_SUN_GISB_ARB_REQ_MASK_trb_UNMASK                      0

/* SUN_GISB_ARB :: REQ_MASK :: jtag [10:10] */
#define BCHP_SUN_GISB_ARB_REQ_MASK_jtag_MASK                       0x00000400
#define BCHP_SUN_GISB_ARB_REQ_MASK_jtag_SHIFT                      10
#define BCHP_SUN_GISB_ARB_REQ_MASK_jtag_UNMASK                     0

/* SUN_GISB_ARB :: REQ_MASK :: reserved1 [09:08] */
#define BCHP_SUN_GISB_ARB_REQ_MASK_reserved1_MASK                  0x00000300
#define BCHP_SUN_GISB_ARB_REQ_MASK_reserved1_SHIFT                 8

/* SUN_GISB_ARB :: REQ_MASK :: avd0 [07:07] */
#define BCHP_SUN_GISB_ARB_REQ_MASK_avd0_MASK                       0x00000080
#define BCHP_SUN_GISB_ARB_REQ_MASK_avd0_SHIFT                      7
#define BCHP_SUN_GISB_ARB_REQ_MASK_avd0_UNMASK                     0

/* SUN_GISB_ARB :: REQ_MASK :: reserved2 [06:05] */
#define BCHP_SUN_GISB_ARB_REQ_MASK_reserved2_MASK                  0x00000060
#define BCHP_SUN_GISB_ARB_REQ_MASK_reserved2_SHIFT                 5

/* SUN_GISB_ARB :: REQ_MASK :: bsp [04:04] */
#define BCHP_SUN_GISB_ARB_REQ_MASK_bsp_MASK                        0x00000010
#define BCHP_SUN_GISB_ARB_REQ_MASK_bsp_SHIFT                       4
#define BCHP_SUN_GISB_ARB_REQ_MASK_bsp_UNMASK                      0

/* SUN_GISB_ARB :: REQ_MASK :: cce [03:03] */
#define BCHP_SUN_GISB_ARB_REQ_MASK_cce_MASK                        0x00000008
#define BCHP_SUN_GISB_ARB_REQ_MASK_cce_SHIFT                       3
#define BCHP_SUN_GISB_ARB_REQ_MASK_cce_UNMASK                      0

/* SUN_GISB_ARB :: REQ_MASK :: pcie [02:02] */
#define BCHP_SUN_GISB_ARB_REQ_MASK_pcie_MASK                       0x00000004
#define BCHP_SUN_GISB_ARB_REQ_MASK_pcie_SHIFT                      2
#define BCHP_SUN_GISB_ARB_REQ_MASK_pcie_UNMASK                     0

/* SUN_GISB_ARB :: REQ_MASK :: arm [01:01] */
#define BCHP_SUN_GISB_ARB_REQ_MASK_arm_MASK                        0x00000002
#define BCHP_SUN_GISB_ARB_REQ_MASK_arm_SHIFT                       1
#define BCHP_SUN_GISB_ARB_REQ_MASK_arm_UNMASK                      0

/* SUN_GISB_ARB :: REQ_MASK :: ssp [00:00] */
#define BCHP_SUN_GISB_ARB_REQ_MASK_ssp_MASK                        0x00000001
#define BCHP_SUN_GISB_ARB_REQ_MASK_ssp_SHIFT                       0
#define BCHP_SUN_GISB_ARB_REQ_MASK_ssp_UNMASK                      0

/***************************************************************************
 *TIMER - GISB ARBITER Timer Value Register
 ***************************************************************************/
/* SUN_GISB_ARB :: TIMER :: hi_count [31:16] */
#define BCHP_SUN_GISB_ARB_TIMER_hi_count_MASK                      0xffff0000
#define BCHP_SUN_GISB_ARB_TIMER_hi_count_SHIFT                     16

/* SUN_GISB_ARB :: TIMER :: lo_count [15:00] */
#define BCHP_SUN_GISB_ARB_TIMER_lo_count_MASK                      0x0000ffff
#define BCHP_SUN_GISB_ARB_TIMER_lo_count_SHIFT                     0

/***************************************************************************
 *BP_CTRL - GISB ARBITER Breakpoint Control Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_CTRL :: reserved0 [31:02] */
#define BCHP_SUN_GISB_ARB_BP_CTRL_reserved0_MASK                   0xfffffffc
#define BCHP_SUN_GISB_ARB_BP_CTRL_reserved0_SHIFT                  2

/* SUN_GISB_ARB :: BP_CTRL :: breakpoint_tea [01:01] */
#define BCHP_SUN_GISB_ARB_BP_CTRL_breakpoint_tea_MASK              0x00000002
#define BCHP_SUN_GISB_ARB_BP_CTRL_breakpoint_tea_SHIFT             1
#define BCHP_SUN_GISB_ARB_BP_CTRL_breakpoint_tea_DISABLE           0
#define BCHP_SUN_GISB_ARB_BP_CTRL_breakpoint_tea_ENABLE            1

/* SUN_GISB_ARB :: BP_CTRL :: repeat_capture [00:00] */
#define BCHP_SUN_GISB_ARB_BP_CTRL_repeat_capture_MASK              0x00000001
#define BCHP_SUN_GISB_ARB_BP_CTRL_repeat_capture_SHIFT             0
#define BCHP_SUN_GISB_ARB_BP_CTRL_repeat_capture_DISABLE           0
#define BCHP_SUN_GISB_ARB_BP_CTRL_repeat_capture_ENABLE            1

/***************************************************************************
 *BP_CAP_CLR - GISB ARBITER Breakpoint Capture Clear Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_CAP_CLR :: reserved0 [31:01] */
#define BCHP_SUN_GISB_ARB_BP_CAP_CLR_reserved0_MASK                0xfffffffe
#define BCHP_SUN_GISB_ARB_BP_CAP_CLR_reserved0_SHIFT               1

/* SUN_GISB_ARB :: BP_CAP_CLR :: clear [00:00] */
#define BCHP_SUN_GISB_ARB_BP_CAP_CLR_clear_MASK                    0x00000001
#define BCHP_SUN_GISB_ARB_BP_CAP_CLR_clear_SHIFT                   0

/***************************************************************************
 *BP_START_ADDR_0 - GISB ARBITER Breakpoint Start Address 0 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_START_ADDR_0 :: start [31:00] */
#define BCHP_SUN_GISB_ARB_BP_START_ADDR_0_start_MASK               0xffffffff
#define BCHP_SUN_GISB_ARB_BP_START_ADDR_0_start_SHIFT              0

/***************************************************************************
 *BP_END_ADDR_0 - GISB ARBITER Breakpoint End Address 0 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_END_ADDR_0 :: end [31:00] */
#define BCHP_SUN_GISB_ARB_BP_END_ADDR_0_end_MASK                   0xffffffff
#define BCHP_SUN_GISB_ARB_BP_END_ADDR_0_end_SHIFT                  0

/***************************************************************************
 *BP_READ_0 - GISB ARBITER Breakpoint Master Read Control 0 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_READ_0 :: reserved0 [31:12] */
#define BCHP_SUN_GISB_ARB_BP_READ_0_reserved0_MASK                 0xfffff000
#define BCHP_SUN_GISB_ARB_BP_READ_0_reserved0_SHIFT                12

/* SUN_GISB_ARB :: BP_READ_0 :: trb [11:11] */
#define BCHP_SUN_GISB_ARB_BP_READ_0_trb_MASK                       0x00000800
#define BCHP_SUN_GISB_ARB_BP_READ_0_trb_SHIFT                      11
#define BCHP_SUN_GISB_ARB_BP_READ_0_trb_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_0_trb_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_0 :: jtag [10:10] */
#define BCHP_SUN_GISB_ARB_BP_READ_0_jtag_MASK                      0x00000400
#define BCHP_SUN_GISB_ARB_BP_READ_0_jtag_SHIFT                     10
#define BCHP_SUN_GISB_ARB_BP_READ_0_jtag_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_READ_0_jtag_ENABLE                    1

/* SUN_GISB_ARB :: BP_READ_0 :: reserved1 [09:08] */
#define BCHP_SUN_GISB_ARB_BP_READ_0_reserved1_MASK                 0x00000300
#define BCHP_SUN_GISB_ARB_BP_READ_0_reserved1_SHIFT                8

/* SUN_GISB_ARB :: BP_READ_0 :: avd0 [07:07] */
#define BCHP_SUN_GISB_ARB_BP_READ_0_avd0_MASK                      0x00000080
#define BCHP_SUN_GISB_ARB_BP_READ_0_avd0_SHIFT                     7
#define BCHP_SUN_GISB_ARB_BP_READ_0_avd0_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_READ_0_avd0_ENABLE                    1

/* SUN_GISB_ARB :: BP_READ_0 :: reserved2 [06:05] */
#define BCHP_SUN_GISB_ARB_BP_READ_0_reserved2_MASK                 0x00000060
#define BCHP_SUN_GISB_ARB_BP_READ_0_reserved2_SHIFT                5

/* SUN_GISB_ARB :: BP_READ_0 :: bsp [04:04] */
#define BCHP_SUN_GISB_ARB_BP_READ_0_bsp_MASK                       0x00000010
#define BCHP_SUN_GISB_ARB_BP_READ_0_bsp_SHIFT                      4
#define BCHP_SUN_GISB_ARB_BP_READ_0_bsp_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_0_bsp_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_0 :: cce [03:03] */
#define BCHP_SUN_GISB_ARB_BP_READ_0_cce_MASK                       0x00000008
#define BCHP_SUN_GISB_ARB_BP_READ_0_cce_SHIFT                      3
#define BCHP_SUN_GISB_ARB_BP_READ_0_cce_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_0_cce_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_0 :: pcie [02:02] */
#define BCHP_SUN_GISB_ARB_BP_READ_0_pcie_MASK                      0x00000004
#define BCHP_SUN_GISB_ARB_BP_READ_0_pcie_SHIFT                     2
#define BCHP_SUN_GISB_ARB_BP_READ_0_pcie_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_READ_0_pcie_ENABLE                    1

/* SUN_GISB_ARB :: BP_READ_0 :: arm [01:01] */
#define BCHP_SUN_GISB_ARB_BP_READ_0_arm_MASK                       0x00000002
#define BCHP_SUN_GISB_ARB_BP_READ_0_arm_SHIFT                      1
#define BCHP_SUN_GISB_ARB_BP_READ_0_arm_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_0_arm_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_0 :: ssp [00:00] */
#define BCHP_SUN_GISB_ARB_BP_READ_0_ssp_MASK                       0x00000001
#define BCHP_SUN_GISB_ARB_BP_READ_0_ssp_SHIFT                      0
#define BCHP_SUN_GISB_ARB_BP_READ_0_ssp_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_0_ssp_ENABLE                     1

/***************************************************************************
 *BP_WRITE_0 - GISB ARBITER Breakpoint Master Write Control 0 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_WRITE_0 :: reserved0 [31:12] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_reserved0_MASK                0xfffff000
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_reserved0_SHIFT               12

/* SUN_GISB_ARB :: BP_WRITE_0 :: trb [11:11] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_trb_MASK                      0x00000800
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_trb_SHIFT                     11
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_trb_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_trb_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_0 :: jtag [10:10] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_jtag_MASK                     0x00000400
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_jtag_SHIFT                    10
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_jtag_DISABLE                  0
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_jtag_ENABLE                   1

/* SUN_GISB_ARB :: BP_WRITE_0 :: reserved1 [09:08] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_reserved1_MASK                0x00000300
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_reserved1_SHIFT               8

/* SUN_GISB_ARB :: BP_WRITE_0 :: avd0 [07:07] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_avd0_MASK                     0x00000080
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_avd0_SHIFT                    7
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_avd0_DISABLE                  0
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_avd0_ENABLE                   1

/* SUN_GISB_ARB :: BP_WRITE_0 :: reserved2 [06:05] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_reserved2_MASK                0x00000060
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_reserved2_SHIFT               5

/* SUN_GISB_ARB :: BP_WRITE_0 :: bsp [04:04] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_bsp_MASK                      0x00000010
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_bsp_SHIFT                     4
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_bsp_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_bsp_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_0 :: cce [03:03] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_cce_MASK                      0x00000008
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_cce_SHIFT                     3
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_cce_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_cce_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_0 :: pcie [02:02] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_pcie_MASK                     0x00000004
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_pcie_SHIFT                    2
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_pcie_DISABLE                  0
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_pcie_ENABLE                   1

/* SUN_GISB_ARB :: BP_WRITE_0 :: arm [01:01] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_arm_MASK                      0x00000002
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_arm_SHIFT                     1
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_arm_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_arm_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_0 :: ssp [00:00] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_ssp_MASK                      0x00000001
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_ssp_SHIFT                     0
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_ssp_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_0_ssp_ENABLE                    1

/***************************************************************************
 *BP_ENABLE_0 - GISB ARBITER Breakpoint Enable 0 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_ENABLE_0 :: reserved0 [31:03] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_0_reserved0_MASK               0xfffffff8
#define BCHP_SUN_GISB_ARB_BP_ENABLE_0_reserved0_SHIFT              3

/* SUN_GISB_ARB :: BP_ENABLE_0 :: block [02:02] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_0_block_MASK                   0x00000004
#define BCHP_SUN_GISB_ARB_BP_ENABLE_0_block_SHIFT                  2
#define BCHP_SUN_GISB_ARB_BP_ENABLE_0_block_DISABLE                0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_0_block_ENABLE                 1

/* SUN_GISB_ARB :: BP_ENABLE_0 :: address [01:01] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_0_address_MASK                 0x00000002
#define BCHP_SUN_GISB_ARB_BP_ENABLE_0_address_SHIFT                1
#define BCHP_SUN_GISB_ARB_BP_ENABLE_0_address_DISABLE              0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_0_address_ENABLE               1

/* SUN_GISB_ARB :: BP_ENABLE_0 :: access [00:00] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_0_access_MASK                  0x00000001
#define BCHP_SUN_GISB_ARB_BP_ENABLE_0_access_SHIFT                 0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_0_access_DISABLE               0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_0_access_ENABLE                1

/***************************************************************************
 *BP_START_ADDR_1 - GISB ARBITER Breakpoint Start Address 1 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_START_ADDR_1 :: start [31:00] */
#define BCHP_SUN_GISB_ARB_BP_START_ADDR_1_start_MASK               0xffffffff
#define BCHP_SUN_GISB_ARB_BP_START_ADDR_1_start_SHIFT              0

/***************************************************************************
 *BP_END_ADDR_1 - GISB ARBITER Breakpoint End Address 1 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_END_ADDR_1 :: end [31:00] */
#define BCHP_SUN_GISB_ARB_BP_END_ADDR_1_end_MASK                   0xffffffff
#define BCHP_SUN_GISB_ARB_BP_END_ADDR_1_end_SHIFT                  0

/***************************************************************************
 *BP_READ_1 - GISB ARBITER Breakpoint Master Read Control 1 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_READ_1 :: reserved0 [31:12] */
#define BCHP_SUN_GISB_ARB_BP_READ_1_reserved0_MASK                 0xfffff000
#define BCHP_SUN_GISB_ARB_BP_READ_1_reserved0_SHIFT                12

/* SUN_GISB_ARB :: BP_READ_1 :: trb [11:11] */
#define BCHP_SUN_GISB_ARB_BP_READ_1_trb_MASK                       0x00000800
#define BCHP_SUN_GISB_ARB_BP_READ_1_trb_SHIFT                      11
#define BCHP_SUN_GISB_ARB_BP_READ_1_trb_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_1_trb_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_1 :: jtag [10:10] */
#define BCHP_SUN_GISB_ARB_BP_READ_1_jtag_MASK                      0x00000400
#define BCHP_SUN_GISB_ARB_BP_READ_1_jtag_SHIFT                     10
#define BCHP_SUN_GISB_ARB_BP_READ_1_jtag_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_READ_1_jtag_ENABLE                    1

/* SUN_GISB_ARB :: BP_READ_1 :: reserved1 [09:08] */
#define BCHP_SUN_GISB_ARB_BP_READ_1_reserved1_MASK                 0x00000300
#define BCHP_SUN_GISB_ARB_BP_READ_1_reserved1_SHIFT                8

/* SUN_GISB_ARB :: BP_READ_1 :: avd0 [07:07] */
#define BCHP_SUN_GISB_ARB_BP_READ_1_avd0_MASK                      0x00000080
#define BCHP_SUN_GISB_ARB_BP_READ_1_avd0_SHIFT                     7
#define BCHP_SUN_GISB_ARB_BP_READ_1_avd0_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_READ_1_avd0_ENABLE                    1

/* SUN_GISB_ARB :: BP_READ_1 :: reserved2 [06:05] */
#define BCHP_SUN_GISB_ARB_BP_READ_1_reserved2_MASK                 0x00000060
#define BCHP_SUN_GISB_ARB_BP_READ_1_reserved2_SHIFT                5

/* SUN_GISB_ARB :: BP_READ_1 :: bsp [04:04] */
#define BCHP_SUN_GISB_ARB_BP_READ_1_bsp_MASK                       0x00000010
#define BCHP_SUN_GISB_ARB_BP_READ_1_bsp_SHIFT                      4
#define BCHP_SUN_GISB_ARB_BP_READ_1_bsp_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_1_bsp_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_1 :: cce [03:03] */
#define BCHP_SUN_GISB_ARB_BP_READ_1_cce_MASK                       0x00000008
#define BCHP_SUN_GISB_ARB_BP_READ_1_cce_SHIFT                      3
#define BCHP_SUN_GISB_ARB_BP_READ_1_cce_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_1_cce_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_1 :: pcie [02:02] */
#define BCHP_SUN_GISB_ARB_BP_READ_1_pcie_MASK                      0x00000004
#define BCHP_SUN_GISB_ARB_BP_READ_1_pcie_SHIFT                     2
#define BCHP_SUN_GISB_ARB_BP_READ_1_pcie_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_READ_1_pcie_ENABLE                    1

/* SUN_GISB_ARB :: BP_READ_1 :: arm [01:01] */
#define BCHP_SUN_GISB_ARB_BP_READ_1_arm_MASK                       0x00000002
#define BCHP_SUN_GISB_ARB_BP_READ_1_arm_SHIFT                      1
#define BCHP_SUN_GISB_ARB_BP_READ_1_arm_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_1_arm_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_1 :: ssp [00:00] */
#define BCHP_SUN_GISB_ARB_BP_READ_1_ssp_MASK                       0x00000001
#define BCHP_SUN_GISB_ARB_BP_READ_1_ssp_SHIFT                      0
#define BCHP_SUN_GISB_ARB_BP_READ_1_ssp_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_1_ssp_ENABLE                     1

/***************************************************************************
 *BP_WRITE_1 - GISB ARBITER Breakpoint Master Write Control 1 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_WRITE_1 :: reserved0 [31:12] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_reserved0_MASK                0xfffff000
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_reserved0_SHIFT               12

/* SUN_GISB_ARB :: BP_WRITE_1 :: trb [11:11] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_trb_MASK                      0x00000800
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_trb_SHIFT                     11
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_trb_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_trb_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_1 :: jtag [10:10] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_jtag_MASK                     0x00000400
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_jtag_SHIFT                    10
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_jtag_DISABLE                  0
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_jtag_ENABLE                   1

/* SUN_GISB_ARB :: BP_WRITE_1 :: reserved1 [09:08] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_reserved1_MASK                0x00000300
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_reserved1_SHIFT               8

/* SUN_GISB_ARB :: BP_WRITE_1 :: avd0 [07:07] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_avd0_MASK                     0x00000080
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_avd0_SHIFT                    7
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_avd0_DISABLE                  0
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_avd0_ENABLE                   1

/* SUN_GISB_ARB :: BP_WRITE_1 :: reserved2 [06:05] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_reserved2_MASK                0x00000060
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_reserved2_SHIFT               5

/* SUN_GISB_ARB :: BP_WRITE_1 :: bsp [04:04] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_bsp_MASK                      0x00000010
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_bsp_SHIFT                     4
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_bsp_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_bsp_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_1 :: cce [03:03] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_cce_MASK                      0x00000008
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_cce_SHIFT                     3
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_cce_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_cce_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_1 :: pcie [02:02] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_pcie_MASK                     0x00000004
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_pcie_SHIFT                    2
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_pcie_DISABLE                  0
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_pcie_ENABLE                   1

/* SUN_GISB_ARB :: BP_WRITE_1 :: arm [01:01] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_arm_MASK                      0x00000002
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_arm_SHIFT                     1
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_arm_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_arm_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_1 :: ssp [00:00] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_ssp_MASK                      0x00000001
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_ssp_SHIFT                     0
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_ssp_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_1_ssp_ENABLE                    1

/***************************************************************************
 *BP_ENABLE_1 - GISB ARBITER Breakpoint Enable 1 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_ENABLE_1 :: reserved0 [31:03] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_1_reserved0_MASK               0xfffffff8
#define BCHP_SUN_GISB_ARB_BP_ENABLE_1_reserved0_SHIFT              3

/* SUN_GISB_ARB :: BP_ENABLE_1 :: block [02:02] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_1_block_MASK                   0x00000004
#define BCHP_SUN_GISB_ARB_BP_ENABLE_1_block_SHIFT                  2
#define BCHP_SUN_GISB_ARB_BP_ENABLE_1_block_DISABLE                0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_1_block_ENABLE                 1

/* SUN_GISB_ARB :: BP_ENABLE_1 :: address [01:01] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_1_address_MASK                 0x00000002
#define BCHP_SUN_GISB_ARB_BP_ENABLE_1_address_SHIFT                1
#define BCHP_SUN_GISB_ARB_BP_ENABLE_1_address_DISABLE              0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_1_address_ENABLE               1

/* SUN_GISB_ARB :: BP_ENABLE_1 :: access [00:00] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_1_access_MASK                  0x00000001
#define BCHP_SUN_GISB_ARB_BP_ENABLE_1_access_SHIFT                 0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_1_access_DISABLE               0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_1_access_ENABLE                1

/***************************************************************************
 *BP_START_ADDR_2 - GISB ARBITER Breakpoint Start Address 2 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_START_ADDR_2 :: start [31:00] */
#define BCHP_SUN_GISB_ARB_BP_START_ADDR_2_start_MASK               0xffffffff
#define BCHP_SUN_GISB_ARB_BP_START_ADDR_2_start_SHIFT              0

/***************************************************************************
 *BP_END_ADDR_2 - GISB ARBITER Breakpoint End Address 2 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_END_ADDR_2 :: end [31:00] */
#define BCHP_SUN_GISB_ARB_BP_END_ADDR_2_end_MASK                   0xffffffff
#define BCHP_SUN_GISB_ARB_BP_END_ADDR_2_end_SHIFT                  0

/***************************************************************************
 *BP_READ_2 - GISB ARBITER Breakpoint Master Read Control 2 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_READ_2 :: reserved0 [31:12] */
#define BCHP_SUN_GISB_ARB_BP_READ_2_reserved0_MASK                 0xfffff000
#define BCHP_SUN_GISB_ARB_BP_READ_2_reserved0_SHIFT                12

/* SUN_GISB_ARB :: BP_READ_2 :: trb [11:11] */
#define BCHP_SUN_GISB_ARB_BP_READ_2_trb_MASK                       0x00000800
#define BCHP_SUN_GISB_ARB_BP_READ_2_trb_SHIFT                      11
#define BCHP_SUN_GISB_ARB_BP_READ_2_trb_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_2_trb_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_2 :: jtag [10:10] */
#define BCHP_SUN_GISB_ARB_BP_READ_2_jtag_MASK                      0x00000400
#define BCHP_SUN_GISB_ARB_BP_READ_2_jtag_SHIFT                     10
#define BCHP_SUN_GISB_ARB_BP_READ_2_jtag_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_READ_2_jtag_ENABLE                    1

/* SUN_GISB_ARB :: BP_READ_2 :: reserved1 [09:08] */
#define BCHP_SUN_GISB_ARB_BP_READ_2_reserved1_MASK                 0x00000300
#define BCHP_SUN_GISB_ARB_BP_READ_2_reserved1_SHIFT                8

/* SUN_GISB_ARB :: BP_READ_2 :: avd0 [07:07] */
#define BCHP_SUN_GISB_ARB_BP_READ_2_avd0_MASK                      0x00000080
#define BCHP_SUN_GISB_ARB_BP_READ_2_avd0_SHIFT                     7
#define BCHP_SUN_GISB_ARB_BP_READ_2_avd0_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_READ_2_avd0_ENABLE                    1

/* SUN_GISB_ARB :: BP_READ_2 :: reserved2 [06:05] */
#define BCHP_SUN_GISB_ARB_BP_READ_2_reserved2_MASK                 0x00000060
#define BCHP_SUN_GISB_ARB_BP_READ_2_reserved2_SHIFT                5

/* SUN_GISB_ARB :: BP_READ_2 :: bsp [04:04] */
#define BCHP_SUN_GISB_ARB_BP_READ_2_bsp_MASK                       0x00000010
#define BCHP_SUN_GISB_ARB_BP_READ_2_bsp_SHIFT                      4
#define BCHP_SUN_GISB_ARB_BP_READ_2_bsp_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_2_bsp_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_2 :: cce [03:03] */
#define BCHP_SUN_GISB_ARB_BP_READ_2_cce_MASK                       0x00000008
#define BCHP_SUN_GISB_ARB_BP_READ_2_cce_SHIFT                      3
#define BCHP_SUN_GISB_ARB_BP_READ_2_cce_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_2_cce_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_2 :: pcie [02:02] */
#define BCHP_SUN_GISB_ARB_BP_READ_2_pcie_MASK                      0x00000004
#define BCHP_SUN_GISB_ARB_BP_READ_2_pcie_SHIFT                     2
#define BCHP_SUN_GISB_ARB_BP_READ_2_pcie_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_READ_2_pcie_ENABLE                    1

/* SUN_GISB_ARB :: BP_READ_2 :: arm [01:01] */
#define BCHP_SUN_GISB_ARB_BP_READ_2_arm_MASK                       0x00000002
#define BCHP_SUN_GISB_ARB_BP_READ_2_arm_SHIFT                      1
#define BCHP_SUN_GISB_ARB_BP_READ_2_arm_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_2_arm_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_2 :: ssp [00:00] */
#define BCHP_SUN_GISB_ARB_BP_READ_2_ssp_MASK                       0x00000001
#define BCHP_SUN_GISB_ARB_BP_READ_2_ssp_SHIFT                      0
#define BCHP_SUN_GISB_ARB_BP_READ_2_ssp_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_2_ssp_ENABLE                     1

/***************************************************************************
 *BP_WRITE_2 - GISB ARBITER Breakpoint Master Write Control 2 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_WRITE_2 :: reserved0 [31:12] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_reserved0_MASK                0xfffff000
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_reserved0_SHIFT               12

/* SUN_GISB_ARB :: BP_WRITE_2 :: trb [11:11] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_trb_MASK                      0x00000800
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_trb_SHIFT                     11
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_trb_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_trb_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_2 :: jtag [10:10] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_jtag_MASK                     0x00000400
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_jtag_SHIFT                    10
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_jtag_DISABLE                  0
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_jtag_ENABLE                   1

/* SUN_GISB_ARB :: BP_WRITE_2 :: reserved1 [09:08] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_reserved1_MASK                0x00000300
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_reserved1_SHIFT               8

/* SUN_GISB_ARB :: BP_WRITE_2 :: avd0 [07:07] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_avd0_MASK                     0x00000080
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_avd0_SHIFT                    7
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_avd0_DISABLE                  0
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_avd0_ENABLE                   1

/* SUN_GISB_ARB :: BP_WRITE_2 :: reserved2 [06:05] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_reserved2_MASK                0x00000060
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_reserved2_SHIFT               5

/* SUN_GISB_ARB :: BP_WRITE_2 :: bsp [04:04] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_bsp_MASK                      0x00000010
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_bsp_SHIFT                     4
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_bsp_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_bsp_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_2 :: cce [03:03] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_cce_MASK                      0x00000008
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_cce_SHIFT                     3
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_cce_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_cce_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_2 :: pcie [02:02] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_pcie_MASK                     0x00000004
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_pcie_SHIFT                    2
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_pcie_DISABLE                  0
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_pcie_ENABLE                   1

/* SUN_GISB_ARB :: BP_WRITE_2 :: arm [01:01] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_arm_MASK                      0x00000002
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_arm_SHIFT                     1
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_arm_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_arm_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_2 :: ssp [00:00] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_ssp_MASK                      0x00000001
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_ssp_SHIFT                     0
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_ssp_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_2_ssp_ENABLE                    1

/***************************************************************************
 *BP_ENABLE_2 - GISB ARBITER Breakpoint Enable 2 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_ENABLE_2 :: reserved0 [31:03] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_2_reserved0_MASK               0xfffffff8
#define BCHP_SUN_GISB_ARB_BP_ENABLE_2_reserved0_SHIFT              3

/* SUN_GISB_ARB :: BP_ENABLE_2 :: block [02:02] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_2_block_MASK                   0x00000004
#define BCHP_SUN_GISB_ARB_BP_ENABLE_2_block_SHIFT                  2
#define BCHP_SUN_GISB_ARB_BP_ENABLE_2_block_DISABLE                0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_2_block_ENABLE                 1

/* SUN_GISB_ARB :: BP_ENABLE_2 :: address [01:01] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_2_address_MASK                 0x00000002
#define BCHP_SUN_GISB_ARB_BP_ENABLE_2_address_SHIFT                1
#define BCHP_SUN_GISB_ARB_BP_ENABLE_2_address_DISABLE              0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_2_address_ENABLE               1

/* SUN_GISB_ARB :: BP_ENABLE_2 :: access [00:00] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_2_access_MASK                  0x00000001
#define BCHP_SUN_GISB_ARB_BP_ENABLE_2_access_SHIFT                 0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_2_access_DISABLE               0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_2_access_ENABLE                1

/***************************************************************************
 *BP_START_ADDR_3 - GISB ARBITER Breakpoint Start Address 3 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_START_ADDR_3 :: start [31:00] */
#define BCHP_SUN_GISB_ARB_BP_START_ADDR_3_start_MASK               0xffffffff
#define BCHP_SUN_GISB_ARB_BP_START_ADDR_3_start_SHIFT              0

/***************************************************************************
 *BP_END_ADDR_3 - GISB ARBITER Breakpoint End Address 3 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_END_ADDR_3 :: end [31:00] */
#define BCHP_SUN_GISB_ARB_BP_END_ADDR_3_end_MASK                   0xffffffff
#define BCHP_SUN_GISB_ARB_BP_END_ADDR_3_end_SHIFT                  0

/***************************************************************************
 *BP_READ_3 - GISB ARBITER Breakpoint Master Read Control 3 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_READ_3 :: reserved0 [31:12] */
#define BCHP_SUN_GISB_ARB_BP_READ_3_reserved0_MASK                 0xfffff000
#define BCHP_SUN_GISB_ARB_BP_READ_3_reserved0_SHIFT                12

/* SUN_GISB_ARB :: BP_READ_3 :: trb [11:11] */
#define BCHP_SUN_GISB_ARB_BP_READ_3_trb_MASK                       0x00000800
#define BCHP_SUN_GISB_ARB_BP_READ_3_trb_SHIFT                      11
#define BCHP_SUN_GISB_ARB_BP_READ_3_trb_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_3_trb_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_3 :: jtag [10:10] */
#define BCHP_SUN_GISB_ARB_BP_READ_3_jtag_MASK                      0x00000400
#define BCHP_SUN_GISB_ARB_BP_READ_3_jtag_SHIFT                     10
#define BCHP_SUN_GISB_ARB_BP_READ_3_jtag_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_READ_3_jtag_ENABLE                    1

/* SUN_GISB_ARB :: BP_READ_3 :: reserved1 [09:08] */
#define BCHP_SUN_GISB_ARB_BP_READ_3_reserved1_MASK                 0x00000300
#define BCHP_SUN_GISB_ARB_BP_READ_3_reserved1_SHIFT                8

/* SUN_GISB_ARB :: BP_READ_3 :: avd0 [07:07] */
#define BCHP_SUN_GISB_ARB_BP_READ_3_avd0_MASK                      0x00000080
#define BCHP_SUN_GISB_ARB_BP_READ_3_avd0_SHIFT                     7
#define BCHP_SUN_GISB_ARB_BP_READ_3_avd0_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_READ_3_avd0_ENABLE                    1

/* SUN_GISB_ARB :: BP_READ_3 :: reserved2 [06:05] */
#define BCHP_SUN_GISB_ARB_BP_READ_3_reserved2_MASK                 0x00000060
#define BCHP_SUN_GISB_ARB_BP_READ_3_reserved2_SHIFT                5

/* SUN_GISB_ARB :: BP_READ_3 :: bsp [04:04] */
#define BCHP_SUN_GISB_ARB_BP_READ_3_bsp_MASK                       0x00000010
#define BCHP_SUN_GISB_ARB_BP_READ_3_bsp_SHIFT                      4
#define BCHP_SUN_GISB_ARB_BP_READ_3_bsp_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_3_bsp_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_3 :: cce [03:03] */
#define BCHP_SUN_GISB_ARB_BP_READ_3_cce_MASK                       0x00000008
#define BCHP_SUN_GISB_ARB_BP_READ_3_cce_SHIFT                      3
#define BCHP_SUN_GISB_ARB_BP_READ_3_cce_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_3_cce_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_3 :: pcie [02:02] */
#define BCHP_SUN_GISB_ARB_BP_READ_3_pcie_MASK                      0x00000004
#define BCHP_SUN_GISB_ARB_BP_READ_3_pcie_SHIFT                     2
#define BCHP_SUN_GISB_ARB_BP_READ_3_pcie_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_READ_3_pcie_ENABLE                    1

/* SUN_GISB_ARB :: BP_READ_3 :: arm [01:01] */
#define BCHP_SUN_GISB_ARB_BP_READ_3_arm_MASK                       0x00000002
#define BCHP_SUN_GISB_ARB_BP_READ_3_arm_SHIFT                      1
#define BCHP_SUN_GISB_ARB_BP_READ_3_arm_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_3_arm_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_3 :: ssp [00:00] */
#define BCHP_SUN_GISB_ARB_BP_READ_3_ssp_MASK                       0x00000001
#define BCHP_SUN_GISB_ARB_BP_READ_3_ssp_SHIFT                      0
#define BCHP_SUN_GISB_ARB_BP_READ_3_ssp_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_3_ssp_ENABLE                     1

/***************************************************************************
 *BP_WRITE_3 - GISB ARBITER Breakpoint Master Write Control 3 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_WRITE_3 :: reserved0 [31:12] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_reserved0_MASK                0xfffff000
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_reserved0_SHIFT               12

/* SUN_GISB_ARB :: BP_WRITE_3 :: trb [11:11] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_trb_MASK                      0x00000800
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_trb_SHIFT                     11
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_trb_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_trb_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_3 :: jtag [10:10] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_jtag_MASK                     0x00000400
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_jtag_SHIFT                    10
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_jtag_DISABLE                  0
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_jtag_ENABLE                   1

/* SUN_GISB_ARB :: BP_WRITE_3 :: reserved1 [09:08] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_reserved1_MASK                0x00000300
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_reserved1_SHIFT               8

/* SUN_GISB_ARB :: BP_WRITE_3 :: avd0 [07:07] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_avd0_MASK                     0x00000080
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_avd0_SHIFT                    7
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_avd0_DISABLE                  0
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_avd0_ENABLE                   1

/* SUN_GISB_ARB :: BP_WRITE_3 :: reserved2 [06:05] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_reserved2_MASK                0x00000060
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_reserved2_SHIFT               5

/* SUN_GISB_ARB :: BP_WRITE_3 :: bsp [04:04] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_bsp_MASK                      0x00000010
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_bsp_SHIFT                     4
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_bsp_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_bsp_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_3 :: cce [03:03] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_cce_MASK                      0x00000008
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_cce_SHIFT                     3
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_cce_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_cce_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_3 :: pcie [02:02] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_pcie_MASK                     0x00000004
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_pcie_SHIFT                    2
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_pcie_DISABLE                  0
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_pcie_ENABLE                   1

/* SUN_GISB_ARB :: BP_WRITE_3 :: arm [01:01] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_arm_MASK                      0x00000002
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_arm_SHIFT                     1
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_arm_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_arm_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_3 :: ssp [00:00] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_ssp_MASK                      0x00000001
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_ssp_SHIFT                     0
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_ssp_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_3_ssp_ENABLE                    1

/***************************************************************************
 *BP_ENABLE_3 - GISB ARBITER Breakpoint Enable 3 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_ENABLE_3 :: reserved0 [31:03] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_3_reserved0_MASK               0xfffffff8
#define BCHP_SUN_GISB_ARB_BP_ENABLE_3_reserved0_SHIFT              3

/* SUN_GISB_ARB :: BP_ENABLE_3 :: block [02:02] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_3_block_MASK                   0x00000004
#define BCHP_SUN_GISB_ARB_BP_ENABLE_3_block_SHIFT                  2
#define BCHP_SUN_GISB_ARB_BP_ENABLE_3_block_DISABLE                0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_3_block_ENABLE                 1

/* SUN_GISB_ARB :: BP_ENABLE_3 :: address [01:01] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_3_address_MASK                 0x00000002
#define BCHP_SUN_GISB_ARB_BP_ENABLE_3_address_SHIFT                1
#define BCHP_SUN_GISB_ARB_BP_ENABLE_3_address_DISABLE              0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_3_address_ENABLE               1

/* SUN_GISB_ARB :: BP_ENABLE_3 :: access [00:00] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_3_access_MASK                  0x00000001
#define BCHP_SUN_GISB_ARB_BP_ENABLE_3_access_SHIFT                 0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_3_access_DISABLE               0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_3_access_ENABLE                1

/***************************************************************************
 *BP_START_ADDR_4 - GISB ARBITER Breakpoint Start Address 4 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_START_ADDR_4 :: start [31:00] */
#define BCHP_SUN_GISB_ARB_BP_START_ADDR_4_start_MASK               0xffffffff
#define BCHP_SUN_GISB_ARB_BP_START_ADDR_4_start_SHIFT              0

/***************************************************************************
 *BP_END_ADDR_4 - GISB ARBITER Breakpoint End Address 4 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_END_ADDR_4 :: end [31:00] */
#define BCHP_SUN_GISB_ARB_BP_END_ADDR_4_end_MASK                   0xffffffff
#define BCHP_SUN_GISB_ARB_BP_END_ADDR_4_end_SHIFT                  0

/***************************************************************************
 *BP_READ_4 - GISB ARBITER Breakpoint Master Read Control 4 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_READ_4 :: reserved0 [31:12] */
#define BCHP_SUN_GISB_ARB_BP_READ_4_reserved0_MASK                 0xfffff000
#define BCHP_SUN_GISB_ARB_BP_READ_4_reserved0_SHIFT                12

/* SUN_GISB_ARB :: BP_READ_4 :: trb [11:11] */
#define BCHP_SUN_GISB_ARB_BP_READ_4_trb_MASK                       0x00000800
#define BCHP_SUN_GISB_ARB_BP_READ_4_trb_SHIFT                      11
#define BCHP_SUN_GISB_ARB_BP_READ_4_trb_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_4_trb_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_4 :: jtag [10:10] */
#define BCHP_SUN_GISB_ARB_BP_READ_4_jtag_MASK                      0x00000400
#define BCHP_SUN_GISB_ARB_BP_READ_4_jtag_SHIFT                     10
#define BCHP_SUN_GISB_ARB_BP_READ_4_jtag_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_READ_4_jtag_ENABLE                    1

/* SUN_GISB_ARB :: BP_READ_4 :: reserved1 [09:08] */
#define BCHP_SUN_GISB_ARB_BP_READ_4_reserved1_MASK                 0x00000300
#define BCHP_SUN_GISB_ARB_BP_READ_4_reserved1_SHIFT                8

/* SUN_GISB_ARB :: BP_READ_4 :: avd0 [07:07] */
#define BCHP_SUN_GISB_ARB_BP_READ_4_avd0_MASK                      0x00000080
#define BCHP_SUN_GISB_ARB_BP_READ_4_avd0_SHIFT                     7
#define BCHP_SUN_GISB_ARB_BP_READ_4_avd0_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_READ_4_avd0_ENABLE                    1

/* SUN_GISB_ARB :: BP_READ_4 :: reserved2 [06:05] */
#define BCHP_SUN_GISB_ARB_BP_READ_4_reserved2_MASK                 0x00000060
#define BCHP_SUN_GISB_ARB_BP_READ_4_reserved2_SHIFT                5

/* SUN_GISB_ARB :: BP_READ_4 :: bsp [04:04] */
#define BCHP_SUN_GISB_ARB_BP_READ_4_bsp_MASK                       0x00000010
#define BCHP_SUN_GISB_ARB_BP_READ_4_bsp_SHIFT                      4
#define BCHP_SUN_GISB_ARB_BP_READ_4_bsp_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_4_bsp_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_4 :: cce [03:03] */
#define BCHP_SUN_GISB_ARB_BP_READ_4_cce_MASK                       0x00000008
#define BCHP_SUN_GISB_ARB_BP_READ_4_cce_SHIFT                      3
#define BCHP_SUN_GISB_ARB_BP_READ_4_cce_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_4_cce_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_4 :: pcie [02:02] */
#define BCHP_SUN_GISB_ARB_BP_READ_4_pcie_MASK                      0x00000004
#define BCHP_SUN_GISB_ARB_BP_READ_4_pcie_SHIFT                     2
#define BCHP_SUN_GISB_ARB_BP_READ_4_pcie_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_READ_4_pcie_ENABLE                    1

/* SUN_GISB_ARB :: BP_READ_4 :: arm [01:01] */
#define BCHP_SUN_GISB_ARB_BP_READ_4_arm_MASK                       0x00000002
#define BCHP_SUN_GISB_ARB_BP_READ_4_arm_SHIFT                      1
#define BCHP_SUN_GISB_ARB_BP_READ_4_arm_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_4_arm_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_4 :: ssp [00:00] */
#define BCHP_SUN_GISB_ARB_BP_READ_4_ssp_MASK                       0x00000001
#define BCHP_SUN_GISB_ARB_BP_READ_4_ssp_SHIFT                      0
#define BCHP_SUN_GISB_ARB_BP_READ_4_ssp_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_4_ssp_ENABLE                     1

/***************************************************************************
 *BP_WRITE_4 - GISB ARBITER Breakpoint Master Write Control 4 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_WRITE_4 :: reserved0 [31:12] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_reserved0_MASK                0xfffff000
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_reserved0_SHIFT               12

/* SUN_GISB_ARB :: BP_WRITE_4 :: trb [11:11] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_trb_MASK                      0x00000800
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_trb_SHIFT                     11
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_trb_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_trb_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_4 :: jtag [10:10] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_jtag_MASK                     0x00000400
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_jtag_SHIFT                    10
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_jtag_DISABLE                  0
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_jtag_ENABLE                   1

/* SUN_GISB_ARB :: BP_WRITE_4 :: reserved1 [09:08] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_reserved1_MASK                0x00000300
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_reserved1_SHIFT               8

/* SUN_GISB_ARB :: BP_WRITE_4 :: avd0 [07:07] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_avd0_MASK                     0x00000080
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_avd0_SHIFT                    7
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_avd0_DISABLE                  0
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_avd0_ENABLE                   1

/* SUN_GISB_ARB :: BP_WRITE_4 :: reserved2 [06:05] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_reserved2_MASK                0x00000060
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_reserved2_SHIFT               5

/* SUN_GISB_ARB :: BP_WRITE_4 :: bsp [04:04] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_bsp_MASK                      0x00000010
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_bsp_SHIFT                     4
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_bsp_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_bsp_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_4 :: cce [03:03] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_cce_MASK                      0x00000008
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_cce_SHIFT                     3
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_cce_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_cce_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_4 :: pcie [02:02] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_pcie_MASK                     0x00000004
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_pcie_SHIFT                    2
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_pcie_DISABLE                  0
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_pcie_ENABLE                   1

/* SUN_GISB_ARB :: BP_WRITE_4 :: arm [01:01] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_arm_MASK                      0x00000002
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_arm_SHIFT                     1
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_arm_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_arm_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_4 :: ssp [00:00] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_ssp_MASK                      0x00000001
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_ssp_SHIFT                     0
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_ssp_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_4_ssp_ENABLE                    1

/***************************************************************************
 *BP_ENABLE_4 - GISB ARBITER Breakpoint Enable 4 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_ENABLE_4 :: reserved0 [31:03] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_4_reserved0_MASK               0xfffffff8
#define BCHP_SUN_GISB_ARB_BP_ENABLE_4_reserved0_SHIFT              3

/* SUN_GISB_ARB :: BP_ENABLE_4 :: block [02:02] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_4_block_MASK                   0x00000004
#define BCHP_SUN_GISB_ARB_BP_ENABLE_4_block_SHIFT                  2
#define BCHP_SUN_GISB_ARB_BP_ENABLE_4_block_DISABLE                0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_4_block_ENABLE                 1

/* SUN_GISB_ARB :: BP_ENABLE_4 :: address [01:01] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_4_address_MASK                 0x00000002
#define BCHP_SUN_GISB_ARB_BP_ENABLE_4_address_SHIFT                1
#define BCHP_SUN_GISB_ARB_BP_ENABLE_4_address_DISABLE              0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_4_address_ENABLE               1

/* SUN_GISB_ARB :: BP_ENABLE_4 :: access [00:00] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_4_access_MASK                  0x00000001
#define BCHP_SUN_GISB_ARB_BP_ENABLE_4_access_SHIFT                 0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_4_access_DISABLE               0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_4_access_ENABLE                1

/***************************************************************************
 *BP_START_ADDR_5 - GISB ARBITER Breakpoint Start Address 5 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_START_ADDR_5 :: start [31:00] */
#define BCHP_SUN_GISB_ARB_BP_START_ADDR_5_start_MASK               0xffffffff
#define BCHP_SUN_GISB_ARB_BP_START_ADDR_5_start_SHIFT              0

/***************************************************************************
 *BP_END_ADDR_5 - GISB ARBITER Breakpoint End Address 5 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_END_ADDR_5 :: end [31:00] */
#define BCHP_SUN_GISB_ARB_BP_END_ADDR_5_end_MASK                   0xffffffff
#define BCHP_SUN_GISB_ARB_BP_END_ADDR_5_end_SHIFT                  0

/***************************************************************************
 *BP_READ_5 - GISB ARBITER Breakpoint Master Read Control 5 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_READ_5 :: reserved0 [31:12] */
#define BCHP_SUN_GISB_ARB_BP_READ_5_reserved0_MASK                 0xfffff000
#define BCHP_SUN_GISB_ARB_BP_READ_5_reserved0_SHIFT                12

/* SUN_GISB_ARB :: BP_READ_5 :: trb [11:11] */
#define BCHP_SUN_GISB_ARB_BP_READ_5_trb_MASK                       0x00000800
#define BCHP_SUN_GISB_ARB_BP_READ_5_trb_SHIFT                      11
#define BCHP_SUN_GISB_ARB_BP_READ_5_trb_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_5_trb_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_5 :: jtag [10:10] */
#define BCHP_SUN_GISB_ARB_BP_READ_5_jtag_MASK                      0x00000400
#define BCHP_SUN_GISB_ARB_BP_READ_5_jtag_SHIFT                     10
#define BCHP_SUN_GISB_ARB_BP_READ_5_jtag_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_READ_5_jtag_ENABLE                    1

/* SUN_GISB_ARB :: BP_READ_5 :: reserved1 [09:08] */
#define BCHP_SUN_GISB_ARB_BP_READ_5_reserved1_MASK                 0x00000300
#define BCHP_SUN_GISB_ARB_BP_READ_5_reserved1_SHIFT                8

/* SUN_GISB_ARB :: BP_READ_5 :: avd0 [07:07] */
#define BCHP_SUN_GISB_ARB_BP_READ_5_avd0_MASK                      0x00000080
#define BCHP_SUN_GISB_ARB_BP_READ_5_avd0_SHIFT                     7
#define BCHP_SUN_GISB_ARB_BP_READ_5_avd0_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_READ_5_avd0_ENABLE                    1

/* SUN_GISB_ARB :: BP_READ_5 :: reserved2 [06:05] */
#define BCHP_SUN_GISB_ARB_BP_READ_5_reserved2_MASK                 0x00000060
#define BCHP_SUN_GISB_ARB_BP_READ_5_reserved2_SHIFT                5

/* SUN_GISB_ARB :: BP_READ_5 :: bsp [04:04] */
#define BCHP_SUN_GISB_ARB_BP_READ_5_bsp_MASK                       0x00000010
#define BCHP_SUN_GISB_ARB_BP_READ_5_bsp_SHIFT                      4
#define BCHP_SUN_GISB_ARB_BP_READ_5_bsp_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_5_bsp_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_5 :: cce [03:03] */
#define BCHP_SUN_GISB_ARB_BP_READ_5_cce_MASK                       0x00000008
#define BCHP_SUN_GISB_ARB_BP_READ_5_cce_SHIFT                      3
#define BCHP_SUN_GISB_ARB_BP_READ_5_cce_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_5_cce_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_5 :: pcie [02:02] */
#define BCHP_SUN_GISB_ARB_BP_READ_5_pcie_MASK                      0x00000004
#define BCHP_SUN_GISB_ARB_BP_READ_5_pcie_SHIFT                     2
#define BCHP_SUN_GISB_ARB_BP_READ_5_pcie_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_READ_5_pcie_ENABLE                    1

/* SUN_GISB_ARB :: BP_READ_5 :: arm [01:01] */
#define BCHP_SUN_GISB_ARB_BP_READ_5_arm_MASK                       0x00000002
#define BCHP_SUN_GISB_ARB_BP_READ_5_arm_SHIFT                      1
#define BCHP_SUN_GISB_ARB_BP_READ_5_arm_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_5_arm_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_5 :: ssp [00:00] */
#define BCHP_SUN_GISB_ARB_BP_READ_5_ssp_MASK                       0x00000001
#define BCHP_SUN_GISB_ARB_BP_READ_5_ssp_SHIFT                      0
#define BCHP_SUN_GISB_ARB_BP_READ_5_ssp_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_5_ssp_ENABLE                     1

/***************************************************************************
 *BP_WRITE_5 - GISB ARBITER Breakpoint Master Write Control 5 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_WRITE_5 :: reserved0 [31:12] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_reserved0_MASK                0xfffff000
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_reserved0_SHIFT               12

/* SUN_GISB_ARB :: BP_WRITE_5 :: trb [11:11] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_trb_MASK                      0x00000800
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_trb_SHIFT                     11
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_trb_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_trb_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_5 :: jtag [10:10] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_jtag_MASK                     0x00000400
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_jtag_SHIFT                    10
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_jtag_DISABLE                  0
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_jtag_ENABLE                   1

/* SUN_GISB_ARB :: BP_WRITE_5 :: reserved1 [09:08] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_reserved1_MASK                0x00000300
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_reserved1_SHIFT               8

/* SUN_GISB_ARB :: BP_WRITE_5 :: avd0 [07:07] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_avd0_MASK                     0x00000080
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_avd0_SHIFT                    7
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_avd0_DISABLE                  0
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_avd0_ENABLE                   1

/* SUN_GISB_ARB :: BP_WRITE_5 :: reserved2 [06:05] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_reserved2_MASK                0x00000060
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_reserved2_SHIFT               5

/* SUN_GISB_ARB :: BP_WRITE_5 :: bsp [04:04] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_bsp_MASK                      0x00000010
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_bsp_SHIFT                     4
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_bsp_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_bsp_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_5 :: cce [03:03] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_cce_MASK                      0x00000008
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_cce_SHIFT                     3
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_cce_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_cce_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_5 :: pcie [02:02] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_pcie_MASK                     0x00000004
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_pcie_SHIFT                    2
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_pcie_DISABLE                  0
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_pcie_ENABLE                   1

/* SUN_GISB_ARB :: BP_WRITE_5 :: arm [01:01] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_arm_MASK                      0x00000002
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_arm_SHIFT                     1
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_arm_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_arm_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_5 :: ssp [00:00] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_ssp_MASK                      0x00000001
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_ssp_SHIFT                     0
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_ssp_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_5_ssp_ENABLE                    1

/***************************************************************************
 *BP_ENABLE_5 - GISB ARBITER Breakpoint Enable 5 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_ENABLE_5 :: reserved0 [31:03] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_5_reserved0_MASK               0xfffffff8
#define BCHP_SUN_GISB_ARB_BP_ENABLE_5_reserved0_SHIFT              3

/* SUN_GISB_ARB :: BP_ENABLE_5 :: block [02:02] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_5_block_MASK                   0x00000004
#define BCHP_SUN_GISB_ARB_BP_ENABLE_5_block_SHIFT                  2
#define BCHP_SUN_GISB_ARB_BP_ENABLE_5_block_DISABLE                0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_5_block_ENABLE                 1

/* SUN_GISB_ARB :: BP_ENABLE_5 :: address [01:01] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_5_address_MASK                 0x00000002
#define BCHP_SUN_GISB_ARB_BP_ENABLE_5_address_SHIFT                1
#define BCHP_SUN_GISB_ARB_BP_ENABLE_5_address_DISABLE              0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_5_address_ENABLE               1

/* SUN_GISB_ARB :: BP_ENABLE_5 :: access [00:00] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_5_access_MASK                  0x00000001
#define BCHP_SUN_GISB_ARB_BP_ENABLE_5_access_SHIFT                 0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_5_access_DISABLE               0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_5_access_ENABLE                1

/***************************************************************************
 *BP_START_ADDR_6 - GISB ARBITER Breakpoint Start Address 6 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_START_ADDR_6 :: start [31:00] */
#define BCHP_SUN_GISB_ARB_BP_START_ADDR_6_start_MASK               0xffffffff
#define BCHP_SUN_GISB_ARB_BP_START_ADDR_6_start_SHIFT              0

/***************************************************************************
 *BP_END_ADDR_6 - GISB ARBITER Breakpoint End Address 6 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_END_ADDR_6 :: end [31:00] */
#define BCHP_SUN_GISB_ARB_BP_END_ADDR_6_end_MASK                   0xffffffff
#define BCHP_SUN_GISB_ARB_BP_END_ADDR_6_end_SHIFT                  0

/***************************************************************************
 *BP_READ_6 - GISB ARBITER Breakpoint Master Read Control 6 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_READ_6 :: reserved0 [31:12] */
#define BCHP_SUN_GISB_ARB_BP_READ_6_reserved0_MASK                 0xfffff000
#define BCHP_SUN_GISB_ARB_BP_READ_6_reserved0_SHIFT                12

/* SUN_GISB_ARB :: BP_READ_6 :: trb [11:11] */
#define BCHP_SUN_GISB_ARB_BP_READ_6_trb_MASK                       0x00000800
#define BCHP_SUN_GISB_ARB_BP_READ_6_trb_SHIFT                      11
#define BCHP_SUN_GISB_ARB_BP_READ_6_trb_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_6_trb_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_6 :: jtag [10:10] */
#define BCHP_SUN_GISB_ARB_BP_READ_6_jtag_MASK                      0x00000400
#define BCHP_SUN_GISB_ARB_BP_READ_6_jtag_SHIFT                     10
#define BCHP_SUN_GISB_ARB_BP_READ_6_jtag_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_READ_6_jtag_ENABLE                    1

/* SUN_GISB_ARB :: BP_READ_6 :: reserved1 [09:08] */
#define BCHP_SUN_GISB_ARB_BP_READ_6_reserved1_MASK                 0x00000300
#define BCHP_SUN_GISB_ARB_BP_READ_6_reserved1_SHIFT                8

/* SUN_GISB_ARB :: BP_READ_6 :: avd0 [07:07] */
#define BCHP_SUN_GISB_ARB_BP_READ_6_avd0_MASK                      0x00000080
#define BCHP_SUN_GISB_ARB_BP_READ_6_avd0_SHIFT                     7
#define BCHP_SUN_GISB_ARB_BP_READ_6_avd0_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_READ_6_avd0_ENABLE                    1

/* SUN_GISB_ARB :: BP_READ_6 :: reserved2 [06:05] */
#define BCHP_SUN_GISB_ARB_BP_READ_6_reserved2_MASK                 0x00000060
#define BCHP_SUN_GISB_ARB_BP_READ_6_reserved2_SHIFT                5

/* SUN_GISB_ARB :: BP_READ_6 :: bsp [04:04] */
#define BCHP_SUN_GISB_ARB_BP_READ_6_bsp_MASK                       0x00000010
#define BCHP_SUN_GISB_ARB_BP_READ_6_bsp_SHIFT                      4
#define BCHP_SUN_GISB_ARB_BP_READ_6_bsp_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_6_bsp_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_6 :: cce [03:03] */
#define BCHP_SUN_GISB_ARB_BP_READ_6_cce_MASK                       0x00000008
#define BCHP_SUN_GISB_ARB_BP_READ_6_cce_SHIFT                      3
#define BCHP_SUN_GISB_ARB_BP_READ_6_cce_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_6_cce_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_6 :: pcie [02:02] */
#define BCHP_SUN_GISB_ARB_BP_READ_6_pcie_MASK                      0x00000004
#define BCHP_SUN_GISB_ARB_BP_READ_6_pcie_SHIFT                     2
#define BCHP_SUN_GISB_ARB_BP_READ_6_pcie_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_READ_6_pcie_ENABLE                    1

/* SUN_GISB_ARB :: BP_READ_6 :: arm [01:01] */
#define BCHP_SUN_GISB_ARB_BP_READ_6_arm_MASK                       0x00000002
#define BCHP_SUN_GISB_ARB_BP_READ_6_arm_SHIFT                      1
#define BCHP_SUN_GISB_ARB_BP_READ_6_arm_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_6_arm_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_6 :: ssp [00:00] */
#define BCHP_SUN_GISB_ARB_BP_READ_6_ssp_MASK                       0x00000001
#define BCHP_SUN_GISB_ARB_BP_READ_6_ssp_SHIFT                      0
#define BCHP_SUN_GISB_ARB_BP_READ_6_ssp_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_6_ssp_ENABLE                     1

/***************************************************************************
 *BP_WRITE_6 - GISB ARBITER Breakpoint Master Write Control 6 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_WRITE_6 :: reserved0 [31:12] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_reserved0_MASK                0xfffff000
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_reserved0_SHIFT               12

/* SUN_GISB_ARB :: BP_WRITE_6 :: trb [11:11] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_trb_MASK                      0x00000800
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_trb_SHIFT                     11
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_trb_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_trb_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_6 :: jtag [10:10] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_jtag_MASK                     0x00000400
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_jtag_SHIFT                    10
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_jtag_DISABLE                  0
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_jtag_ENABLE                   1

/* SUN_GISB_ARB :: BP_WRITE_6 :: reserved1 [09:08] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_reserved1_MASK                0x00000300
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_reserved1_SHIFT               8

/* SUN_GISB_ARB :: BP_WRITE_6 :: avd0 [07:07] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_avd0_MASK                     0x00000080
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_avd0_SHIFT                    7
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_avd0_DISABLE                  0
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_avd0_ENABLE                   1

/* SUN_GISB_ARB :: BP_WRITE_6 :: reserved2 [06:05] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_reserved2_MASK                0x00000060
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_reserved2_SHIFT               5

/* SUN_GISB_ARB :: BP_WRITE_6 :: bsp [04:04] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_bsp_MASK                      0x00000010
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_bsp_SHIFT                     4
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_bsp_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_bsp_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_6 :: cce [03:03] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_cce_MASK                      0x00000008
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_cce_SHIFT                     3
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_cce_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_cce_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_6 :: pcie [02:02] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_pcie_MASK                     0x00000004
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_pcie_SHIFT                    2
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_pcie_DISABLE                  0
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_pcie_ENABLE                   1

/* SUN_GISB_ARB :: BP_WRITE_6 :: arm [01:01] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_arm_MASK                      0x00000002
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_arm_SHIFT                     1
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_arm_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_arm_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_6 :: ssp [00:00] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_ssp_MASK                      0x00000001
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_ssp_SHIFT                     0
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_ssp_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_6_ssp_ENABLE                    1

/***************************************************************************
 *BP_ENABLE_6 - GISB ARBITER Breakpoint Enable 6 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_ENABLE_6 :: reserved0 [31:03] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_6_reserved0_MASK               0xfffffff8
#define BCHP_SUN_GISB_ARB_BP_ENABLE_6_reserved0_SHIFT              3

/* SUN_GISB_ARB :: BP_ENABLE_6 :: block [02:02] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_6_block_MASK                   0x00000004
#define BCHP_SUN_GISB_ARB_BP_ENABLE_6_block_SHIFT                  2
#define BCHP_SUN_GISB_ARB_BP_ENABLE_6_block_DISABLE                0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_6_block_ENABLE                 1

/* SUN_GISB_ARB :: BP_ENABLE_6 :: address [01:01] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_6_address_MASK                 0x00000002
#define BCHP_SUN_GISB_ARB_BP_ENABLE_6_address_SHIFT                1
#define BCHP_SUN_GISB_ARB_BP_ENABLE_6_address_DISABLE              0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_6_address_ENABLE               1

/* SUN_GISB_ARB :: BP_ENABLE_6 :: access [00:00] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_6_access_MASK                  0x00000001
#define BCHP_SUN_GISB_ARB_BP_ENABLE_6_access_SHIFT                 0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_6_access_DISABLE               0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_6_access_ENABLE                1

/***************************************************************************
 *BP_START_ADDR_7 - GISB ARBITER Breakpoint Start Address 7 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_START_ADDR_7 :: start [31:00] */
#define BCHP_SUN_GISB_ARB_BP_START_ADDR_7_start_MASK               0xffffffff
#define BCHP_SUN_GISB_ARB_BP_START_ADDR_7_start_SHIFT              0

/***************************************************************************
 *BP_END_ADDR_7 - GISB ARBITER Breakpoint End Address 7 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_END_ADDR_7 :: end [31:00] */
#define BCHP_SUN_GISB_ARB_BP_END_ADDR_7_end_MASK                   0xffffffff
#define BCHP_SUN_GISB_ARB_BP_END_ADDR_7_end_SHIFT                  0

/***************************************************************************
 *BP_READ_7 - GISB ARBITER Breakpoint Master Read Control 7 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_READ_7 :: reserved0 [31:12] */
#define BCHP_SUN_GISB_ARB_BP_READ_7_reserved0_MASK                 0xfffff000
#define BCHP_SUN_GISB_ARB_BP_READ_7_reserved0_SHIFT                12

/* SUN_GISB_ARB :: BP_READ_7 :: trb [11:11] */
#define BCHP_SUN_GISB_ARB_BP_READ_7_trb_MASK                       0x00000800
#define BCHP_SUN_GISB_ARB_BP_READ_7_trb_SHIFT                      11
#define BCHP_SUN_GISB_ARB_BP_READ_7_trb_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_7_trb_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_7 :: jtag [10:10] */
#define BCHP_SUN_GISB_ARB_BP_READ_7_jtag_MASK                      0x00000400
#define BCHP_SUN_GISB_ARB_BP_READ_7_jtag_SHIFT                     10
#define BCHP_SUN_GISB_ARB_BP_READ_7_jtag_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_READ_7_jtag_ENABLE                    1

/* SUN_GISB_ARB :: BP_READ_7 :: reserved1 [09:08] */
#define BCHP_SUN_GISB_ARB_BP_READ_7_reserved1_MASK                 0x00000300
#define BCHP_SUN_GISB_ARB_BP_READ_7_reserved1_SHIFT                8

/* SUN_GISB_ARB :: BP_READ_7 :: avd0 [07:07] */
#define BCHP_SUN_GISB_ARB_BP_READ_7_avd0_MASK                      0x00000080
#define BCHP_SUN_GISB_ARB_BP_READ_7_avd0_SHIFT                     7
#define BCHP_SUN_GISB_ARB_BP_READ_7_avd0_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_READ_7_avd0_ENABLE                    1

/* SUN_GISB_ARB :: BP_READ_7 :: reserved2 [06:05] */
#define BCHP_SUN_GISB_ARB_BP_READ_7_reserved2_MASK                 0x00000060
#define BCHP_SUN_GISB_ARB_BP_READ_7_reserved2_SHIFT                5

/* SUN_GISB_ARB :: BP_READ_7 :: bsp [04:04] */
#define BCHP_SUN_GISB_ARB_BP_READ_7_bsp_MASK                       0x00000010
#define BCHP_SUN_GISB_ARB_BP_READ_7_bsp_SHIFT                      4
#define BCHP_SUN_GISB_ARB_BP_READ_7_bsp_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_7_bsp_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_7 :: cce [03:03] */
#define BCHP_SUN_GISB_ARB_BP_READ_7_cce_MASK                       0x00000008
#define BCHP_SUN_GISB_ARB_BP_READ_7_cce_SHIFT                      3
#define BCHP_SUN_GISB_ARB_BP_READ_7_cce_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_7_cce_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_7 :: pcie [02:02] */
#define BCHP_SUN_GISB_ARB_BP_READ_7_pcie_MASK                      0x00000004
#define BCHP_SUN_GISB_ARB_BP_READ_7_pcie_SHIFT                     2
#define BCHP_SUN_GISB_ARB_BP_READ_7_pcie_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_READ_7_pcie_ENABLE                    1

/* SUN_GISB_ARB :: BP_READ_7 :: arm [01:01] */
#define BCHP_SUN_GISB_ARB_BP_READ_7_arm_MASK                       0x00000002
#define BCHP_SUN_GISB_ARB_BP_READ_7_arm_SHIFT                      1
#define BCHP_SUN_GISB_ARB_BP_READ_7_arm_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_7_arm_ENABLE                     1

/* SUN_GISB_ARB :: BP_READ_7 :: ssp [00:00] */
#define BCHP_SUN_GISB_ARB_BP_READ_7_ssp_MASK                       0x00000001
#define BCHP_SUN_GISB_ARB_BP_READ_7_ssp_SHIFT                      0
#define BCHP_SUN_GISB_ARB_BP_READ_7_ssp_DISABLE                    0
#define BCHP_SUN_GISB_ARB_BP_READ_7_ssp_ENABLE                     1

/***************************************************************************
 *BP_WRITE_7 - GISB ARBITER Breakpoint Master Write Control 7 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_WRITE_7 :: reserved0 [31:12] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_reserved0_MASK                0xfffff000
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_reserved0_SHIFT               12

/* SUN_GISB_ARB :: BP_WRITE_7 :: trb [11:11] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_trb_MASK                      0x00000800
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_trb_SHIFT                     11
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_trb_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_trb_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_7 :: jtag [10:10] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_jtag_MASK                     0x00000400
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_jtag_SHIFT                    10
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_jtag_DISABLE                  0
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_jtag_ENABLE                   1

/* SUN_GISB_ARB :: BP_WRITE_7 :: reserved1 [09:08] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_reserved1_MASK                0x00000300
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_reserved1_SHIFT               8

/* SUN_GISB_ARB :: BP_WRITE_7 :: avd0 [07:07] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_avd0_MASK                     0x00000080
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_avd0_SHIFT                    7
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_avd0_DISABLE                  0
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_avd0_ENABLE                   1

/* SUN_GISB_ARB :: BP_WRITE_7 :: reserved2 [06:05] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_reserved2_MASK                0x00000060
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_reserved2_SHIFT               5

/* SUN_GISB_ARB :: BP_WRITE_7 :: bsp [04:04] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_bsp_MASK                      0x00000010
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_bsp_SHIFT                     4
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_bsp_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_bsp_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_7 :: cce [03:03] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_cce_MASK                      0x00000008
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_cce_SHIFT                     3
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_cce_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_cce_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_7 :: pcie [02:02] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_pcie_MASK                     0x00000004
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_pcie_SHIFT                    2
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_pcie_DISABLE                  0
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_pcie_ENABLE                   1

/* SUN_GISB_ARB :: BP_WRITE_7 :: arm [01:01] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_arm_MASK                      0x00000002
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_arm_SHIFT                     1
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_arm_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_arm_ENABLE                    1

/* SUN_GISB_ARB :: BP_WRITE_7 :: ssp [00:00] */
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_ssp_MASK                      0x00000001
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_ssp_SHIFT                     0
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_ssp_DISABLE                   0
#define BCHP_SUN_GISB_ARB_BP_WRITE_7_ssp_ENABLE                    1

/***************************************************************************
 *BP_ENABLE_7 - GISB ARBITER Breakpoint Enable 7 Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_ENABLE_7 :: reserved0 [31:03] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_7_reserved0_MASK               0xfffffff8
#define BCHP_SUN_GISB_ARB_BP_ENABLE_7_reserved0_SHIFT              3

/* SUN_GISB_ARB :: BP_ENABLE_7 :: block [02:02] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_7_block_MASK                   0x00000004
#define BCHP_SUN_GISB_ARB_BP_ENABLE_7_block_SHIFT                  2
#define BCHP_SUN_GISB_ARB_BP_ENABLE_7_block_DISABLE                0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_7_block_ENABLE                 1

/* SUN_GISB_ARB :: BP_ENABLE_7 :: address [01:01] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_7_address_MASK                 0x00000002
#define BCHP_SUN_GISB_ARB_BP_ENABLE_7_address_SHIFT                1
#define BCHP_SUN_GISB_ARB_BP_ENABLE_7_address_DISABLE              0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_7_address_ENABLE               1

/* SUN_GISB_ARB :: BP_ENABLE_7 :: access [00:00] */
#define BCHP_SUN_GISB_ARB_BP_ENABLE_7_access_MASK                  0x00000001
#define BCHP_SUN_GISB_ARB_BP_ENABLE_7_access_SHIFT                 0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_7_access_DISABLE               0
#define BCHP_SUN_GISB_ARB_BP_ENABLE_7_access_ENABLE                1

/***************************************************************************
 *BP_CAP_ADDR - GISB ARBITER Breakpoint Capture Address Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_CAP_ADDR :: address [31:00] */
#define BCHP_SUN_GISB_ARB_BP_CAP_ADDR_address_MASK                 0xffffffff
#define BCHP_SUN_GISB_ARB_BP_CAP_ADDR_address_SHIFT                0

/***************************************************************************
 *BP_CAP_DATA - GISB ARBITER Breakpoint Capture Data Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_CAP_DATA :: data [31:00] */
#define BCHP_SUN_GISB_ARB_BP_CAP_DATA_data_MASK                    0xffffffff
#define BCHP_SUN_GISB_ARB_BP_CAP_DATA_data_SHIFT                   0

/***************************************************************************
 *BP_CAP_STATUS - GISB ARBITER Breakpoint Capture Status Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_CAP_STATUS :: reserved0 [31:06] */
#define BCHP_SUN_GISB_ARB_BP_CAP_STATUS_reserved0_MASK             0xffffffc0
#define BCHP_SUN_GISB_ARB_BP_CAP_STATUS_reserved0_SHIFT            6

/* SUN_GISB_ARB :: BP_CAP_STATUS :: bs_b [05:02] */
#define BCHP_SUN_GISB_ARB_BP_CAP_STATUS_bs_b_MASK                  0x0000003c
#define BCHP_SUN_GISB_ARB_BP_CAP_STATUS_bs_b_SHIFT                 2

/* SUN_GISB_ARB :: BP_CAP_STATUS :: write [01:01] */
#define BCHP_SUN_GISB_ARB_BP_CAP_STATUS_write_MASK                 0x00000002
#define BCHP_SUN_GISB_ARB_BP_CAP_STATUS_write_SHIFT                1

/* SUN_GISB_ARB :: BP_CAP_STATUS :: valid [00:00] */
#define BCHP_SUN_GISB_ARB_BP_CAP_STATUS_valid_MASK                 0x00000001
#define BCHP_SUN_GISB_ARB_BP_CAP_STATUS_valid_SHIFT                0

/***************************************************************************
 *BP_CAP_MASTER - GISB ARBITER Breakpoint Capture GISB MASTER Register
 ***************************************************************************/
/* SUN_GISB_ARB :: BP_CAP_MASTER :: reserved0 [31:12] */
#define BCHP_SUN_GISB_ARB_BP_CAP_MASTER_reserved0_MASK             0xfffff000
#define BCHP_SUN_GISB_ARB_BP_CAP_MASTER_reserved0_SHIFT            12

/* SUN_GISB_ARB :: BP_CAP_MASTER :: trb [11:11] */
#define BCHP_SUN_GISB_ARB_BP_CAP_MASTER_trb_MASK                   0x00000800
#define BCHP_SUN_GISB_ARB_BP_CAP_MASTER_trb_SHIFT                  11

/* SUN_GISB_ARB :: BP_CAP_MASTER :: jtag [10:10] */
#define BCHP_SUN_GISB_ARB_BP_CAP_MASTER_jtag_MASK                  0x00000400
#define BCHP_SUN_GISB_ARB_BP_CAP_MASTER_jtag_SHIFT                 10

/* SUN_GISB_ARB :: BP_CAP_MASTER :: reserved1 [09:08] */
#define BCHP_SUN_GISB_ARB_BP_CAP_MASTER_reserved1_MASK             0x00000300
#define BCHP_SUN_GISB_ARB_BP_CAP_MASTER_reserved1_SHIFT            8

/* SUN_GISB_ARB :: BP_CAP_MASTER :: avd0 [07:07] */
#define BCHP_SUN_GISB_ARB_BP_CAP_MASTER_avd0_MASK                  0x00000080
#define BCHP_SUN_GISB_ARB_BP_CAP_MASTER_avd0_SHIFT                 7

/* SUN_GISB_ARB :: BP_CAP_MASTER :: reserved2 [06:05] */
#define BCHP_SUN_GISB_ARB_BP_CAP_MASTER_reserved2_MASK             0x00000060
#define BCHP_SUN_GISB_ARB_BP_CAP_MASTER_reserved2_SHIFT            5

/* SUN_GISB_ARB :: BP_CAP_MASTER :: bsp [04:04] */
#define BCHP_SUN_GISB_ARB_BP_CAP_MASTER_bsp_MASK                   0x00000010
#define BCHP_SUN_GISB_ARB_BP_CAP_MASTER_bsp_SHIFT                  4

/* SUN_GISB_ARB :: BP_CAP_MASTER :: cce [03:03] */
#define BCHP_SUN_GISB_ARB_BP_CAP_MASTER_cce_MASK                   0x00000008
#define BCHP_SUN_GISB_ARB_BP_CAP_MASTER_cce_SHIFT                  3

/* SUN_GISB_ARB :: BP_CAP_MASTER :: pcie [02:02] */
#define BCHP_SUN_GISB_ARB_BP_CAP_MASTER_pcie_MASK                  0x00000004
#define BCHP_SUN_GISB_ARB_BP_CAP_MASTER_pcie_SHIFT                 2

/* SUN_GISB_ARB :: BP_CAP_MASTER :: arm [01:01] */
#define BCHP_SUN_GISB_ARB_BP_CAP_MASTER_arm_MASK                   0x00000002
#define BCHP_SUN_GISB_ARB_BP_CAP_MASTER_arm_SHIFT                  1

/* SUN_GISB_ARB :: BP_CAP_MASTER :: ssp [00:00] */
#define BCHP_SUN_GISB_ARB_BP_CAP_MASTER_ssp_MASK                   0x00000001
#define BCHP_SUN_GISB_ARB_BP_CAP_MASTER_ssp_SHIFT                  0

/***************************************************************************
 *ERR_CAP_CLR - GISB ARBITER Error Capture Clear Register
 ***************************************************************************/
/* SUN_GISB_ARB :: ERR_CAP_CLR :: reserved0 [31:01] */
#define BCHP_SUN_GISB_ARB_ERR_CAP_CLR_reserved0_MASK               0xfffffffe
#define BCHP_SUN_GISB_ARB_ERR_CAP_CLR_reserved0_SHIFT              1

/* SUN_GISB_ARB :: ERR_CAP_CLR :: clear [00:00] */
#define BCHP_SUN_GISB_ARB_ERR_CAP_CLR_clear_MASK                   0x00000001
#define BCHP_SUN_GISB_ARB_ERR_CAP_CLR_clear_SHIFT                  0

/***************************************************************************
 *ERR_CAP_ADDR - GISB ARBITER Error Capture Address Register
 ***************************************************************************/
/* SUN_GISB_ARB :: ERR_CAP_ADDR :: address [31:00] */
#define BCHP_SUN_GISB_ARB_ERR_CAP_ADDR_address_MASK                0xffffffff
#define BCHP_SUN_GISB_ARB_ERR_CAP_ADDR_address_SHIFT               0

/***************************************************************************
 *ERR_CAP_DATA - GISB ARBITER Error Capture Data Register
 ***************************************************************************/
/* SUN_GISB_ARB :: ERR_CAP_DATA :: data [31:00] */
#define BCHP_SUN_GISB_ARB_ERR_CAP_DATA_data_MASK                   0xffffffff
#define BCHP_SUN_GISB_ARB_ERR_CAP_DATA_data_SHIFT                  0

/***************************************************************************
 *ERR_CAP_STATUS - GISB ARBITER Error Capture Status Register
 ***************************************************************************/
/* SUN_GISB_ARB :: ERR_CAP_STATUS :: reserved0 [31:13] */
#define BCHP_SUN_GISB_ARB_ERR_CAP_STATUS_reserved0_MASK            0xffffe000
#define BCHP_SUN_GISB_ARB_ERR_CAP_STATUS_reserved0_SHIFT           13

/* SUN_GISB_ARB :: ERR_CAP_STATUS :: timeout [12:12] */
#define BCHP_SUN_GISB_ARB_ERR_CAP_STATUS_timeout_MASK              0x00001000
#define BCHP_SUN_GISB_ARB_ERR_CAP_STATUS_timeout_SHIFT             12

/* SUN_GISB_ARB :: ERR_CAP_STATUS :: tea [11:11] */
#define BCHP_SUN_GISB_ARB_ERR_CAP_STATUS_tea_MASK                  0x00000800
#define BCHP_SUN_GISB_ARB_ERR_CAP_STATUS_tea_SHIFT                 11

/* SUN_GISB_ARB :: ERR_CAP_STATUS :: reserved1 [10:06] */
#define BCHP_SUN_GISB_ARB_ERR_CAP_STATUS_reserved1_MASK            0x000007c0
#define BCHP_SUN_GISB_ARB_ERR_CAP_STATUS_reserved1_SHIFT           6

/* SUN_GISB_ARB :: ERR_CAP_STATUS :: bs_b [05:02] */
#define BCHP_SUN_GISB_ARB_ERR_CAP_STATUS_bs_b_MASK                 0x0000003c
#define BCHP_SUN_GISB_ARB_ERR_CAP_STATUS_bs_b_SHIFT                2

/* SUN_GISB_ARB :: ERR_CAP_STATUS :: write [01:01] */
#define BCHP_SUN_GISB_ARB_ERR_CAP_STATUS_write_MASK                0x00000002
#define BCHP_SUN_GISB_ARB_ERR_CAP_STATUS_write_SHIFT               1

/* SUN_GISB_ARB :: ERR_CAP_STATUS :: valid [00:00] */
#define BCHP_SUN_GISB_ARB_ERR_CAP_STATUS_valid_MASK                0x00000001
#define BCHP_SUN_GISB_ARB_ERR_CAP_STATUS_valid_SHIFT               0

/***************************************************************************
 *ERR_CAP_MASTER - GISB ARBITER Error Capture GISB MASTER Register
 ***************************************************************************/
/* SUN_GISB_ARB :: ERR_CAP_MASTER :: reserved0 [31:12] */
#define BCHP_SUN_GISB_ARB_ERR_CAP_MASTER_reserved0_MASK            0xfffff000
#define BCHP_SUN_GISB_ARB_ERR_CAP_MASTER_reserved0_SHIFT           12

/* SUN_GISB_ARB :: ERR_CAP_MASTER :: trb [11:11] */
#define BCHP_SUN_GISB_ARB_ERR_CAP_MASTER_trb_MASK                  0x00000800
#define BCHP_SUN_GISB_ARB_ERR_CAP_MASTER_trb_SHIFT                 11

/* SUN_GISB_ARB :: ERR_CAP_MASTER :: jtag [10:10] */
#define BCHP_SUN_GISB_ARB_ERR_CAP_MASTER_jtag_MASK                 0x00000400
#define BCHP_SUN_GISB_ARB_ERR_CAP_MASTER_jtag_SHIFT                10

/* SUN_GISB_ARB :: ERR_CAP_MASTER :: reserved1 [09:08] */
#define BCHP_SUN_GISB_ARB_ERR_CAP_MASTER_reserved1_MASK            0x00000300
#define BCHP_SUN_GISB_ARB_ERR_CAP_MASTER_reserved1_SHIFT           8

/* SUN_GISB_ARB :: ERR_CAP_MASTER :: avd0 [07:07] */
#define BCHP_SUN_GISB_ARB_ERR_CAP_MASTER_avd0_MASK                 0x00000080
#define BCHP_SUN_GISB_ARB_ERR_CAP_MASTER_avd0_SHIFT                7

/* SUN_GISB_ARB :: ERR_CAP_MASTER :: reserved2 [06:05] */
#define BCHP_SUN_GISB_ARB_ERR_CAP_MASTER_reserved2_MASK            0x00000060
#define BCHP_SUN_GISB_ARB_ERR_CAP_MASTER_reserved2_SHIFT           5

/* SUN_GISB_ARB :: ERR_CAP_MASTER :: bsp [04:04] */
#define BCHP_SUN_GISB_ARB_ERR_CAP_MASTER_bsp_MASK                  0x00000010
#define BCHP_SUN_GISB_ARB_ERR_CAP_MASTER_bsp_SHIFT                 4

/* SUN_GISB_ARB :: ERR_CAP_MASTER :: cce [03:03] */
#define BCHP_SUN_GISB_ARB_ERR_CAP_MASTER_cce_MASK                  0x00000008
#define BCHP_SUN_GISB_ARB_ERR_CAP_MASTER_cce_SHIFT                 3

/* SUN_GISB_ARB :: ERR_CAP_MASTER :: pcie [02:02] */
#define BCHP_SUN_GISB_ARB_ERR_CAP_MASTER_pcie_MASK                 0x00000004
#define BCHP_SUN_GISB_ARB_ERR_CAP_MASTER_pcie_SHIFT                2

/* SUN_GISB_ARB :: ERR_CAP_MASTER :: arm [01:01] */
#define BCHP_SUN_GISB_ARB_ERR_CAP_MASTER_arm_MASK                  0x00000002
#define BCHP_SUN_GISB_ARB_ERR_CAP_MASTER_arm_SHIFT                 1

/* SUN_GISB_ARB :: ERR_CAP_MASTER :: ssp [00:00] */
#define BCHP_SUN_GISB_ARB_ERR_CAP_MASTER_ssp_MASK                  0x00000001
#define BCHP_SUN_GISB_ARB_ERR_CAP_MASTER_ssp_SHIFT                 0

#endif /* #ifndef BCHP_SUN_GISB_ARB_H__ */

/* End of File */
